/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.attachments;

import java.util.logging.Logger;
import ru.blok.common.ui.directories.FRCAsyncDirectoryViewer;
import ru.blok.common.ui.list.ObjectUIList;
import ru.blok.vms.ui.attachments.AttachmentsList;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.ExtendedDirectoryViewer;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.vms.AttachmentsSearchCriteria;
import ru.infor.ws.objects.vms.entities.Attachments;

public class AttachmentsDirectoryViewer<T>
extends FRCAsyncDirectoryViewer<T> {
    T buttonClear;
    AttachmentsList list;

    public Class getTableCellViewerClass() {
        return AttachmentsDirectoryCellViewer.class;
    }

    public AttachmentsDirectoryViewer(UIFactory<T> factory) {
        super(factory);
    }

    public void setContentClass(Class<?> cls) {
        super.setContentClass(Attachments.class);
    }

    public String objectToString(Object o) {
        if (o == null) {
            return super.objectToString(o);
        }
        Attachments a = (Attachments)o;
        return String.valueOf(a.getBrand()) + " " + a.getModel() + " " + a.getRegNum();
    }

    public CommonSearchCriteria updateSearchCriteria(CommonSearchCriteria sc, String value) {
        ((AttachmentsSearchCriteria)sc).setQuickSearch(value);
        return sc;
    }

    protected void initButton(T panel) {
        super.initButton(panel);
        BeanViewerAction<ViewerContext> dirClearButton = new BeanViewerAction<ViewerContext>(){

            public void actionPerformed(Object message) {
                AttachmentsDirectoryViewer.this.setValue(null);
            }
        };
        dirClearButton.setName("X");
        dirClearButton.setHint("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c");
        this.buttonClear = this.getFactory().getAction((BeanViewerAction)dirClearButton, this.buttonClear);
        this.getFactory().putObjectToContainer(this.buttonClear, panel, (Object)"width 22, height 22:22:22");
    }

    public void buttonActionPerfomed() {
        try {
            if (this.list == null) {
                this.list = new AttachmentsList();
            }
            this.getFactory().newPage(Attachments.class, AttachmentsList.class, (Object)this.list, this.getViewerContext(), "filterInList");
            Object o = this.getValue();
            ((ObjectUIList)this.list.getItems()).setSelection(o);
        }
        catch (Exception exception) {
            Logger.getLogger(ExtendedDirectoryViewer.class.getName()).severe("Can't create directory presentation " + this.getPresentationClass().getName());
        }
    }

    public static class AttachmentsDirectoryCellViewer<T>
    extends DefaultTableCellViewer<T> {
        public AttachmentsDirectoryCellViewer(UIFactory<T> factory) {
            super(factory);
        }

        public void setValue(Object object) {
            if (object == null) {
                super.setValue((Object)"");
            } else {
                Attachments a = (Attachments)object;
                super.setValue((Object)(String.valueOf(a.getBrand()) + " " + a.getModel() + " " + a.getRegNum()));
            }
        }
    }
}

