/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.building;

import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.buttons.OkWithSave;
import ru.blok.vms.ui.tracks.json.LoaderFromInternet;
import ru.blok.vms.ui.tracks.json.LoaderFromMapQuest;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.client.soap.proxy.vms.BuildingRegionWSProxy;
import ru.infor.client.soap.proxy.vms.BuildingStateWSProxy;
import ru.infor.ws.objects.core.DirectoriesSearchCriteria;
import ru.infor.ws.objects.vms.entities.BuildingRegion;
import ru.infor.ws.objects.vms.entities.BuildingState;
import ru.infor.ws.objects.vms.entities.ViewAddressADIS;
import ru.infor.ws.objects.vms.entities.ext.BuildingExt;

public class OkCheckAddressButton
extends OkWithSave {
    BuildingRegionWSProxy brWSProxy = (BuildingRegionWSProxy)CurrentProxyFactory.getProxy(BuildingRegion.class);
    BuildingStateWSProxy bsWSProxy = (BuildingStateWSProxy)CurrentProxyFactory.getProxy(BuildingState.class);

    public void actionPerformed(Object arg0) {
        ViewAddressADIS[] adr;
        ((PanelContext)this.getContext()).getPanel().stopCellEditor();
        ((PanelContext)this.getContext()).getPanel().updateMainObject();
        BuildingExt object = (BuildingExt)((Object)this.getObject());
        if (object.getLat() != null && object.getLon() != null && (adr = LoaderFromMapQuest.getAddress(InitializedVariable.context, object.getLat(), object.getLon(), LoaderFromInternet.MapQuest_API_KEY)) != null) {
            object.setPostcode(adr[0].getPostalCode());
            if (adr[0].getRegionName() != null && !adr[0].getRegionName().trim().equals("")) {
                BuildingRegion br = this.checkDirectoriesBR(adr[0].getRegionName());
                object.setRegion(br);
            }
            if (adr[0].getStateName() != null && !adr[0].getStateName().trim().equals("")) {
                BuildingState bs = this.checkDirectoriesBS(adr[0].getStateName());
                object.setState(bs);
            }
            if (object.getCityName() == null || object.getCityName().trim().equals("")) {
                object.setCityName(adr[0].getTownName());
            }
            if (object.getStreet() == null || object.getStreet().trim().equals("")) {
                object.setStreet(adr[0].getStreetName());
            }
            if (object.getPostcode() == null || object.getPostcode().trim().equals("")) {
                object.setPostcode(adr[0].getPostalCode());
            }
            ((PanelContext)this.getContext()).getPanel().updateMainObject();
            ((PanelContext)this.getContext()).getPanel().updateUI();
        }
    }

    public String getHint() {
        return "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0430\u0434\u0440\u0435\u0441\u0430 \u043f\u043e \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u0430\u043c";
    }

    public String getName() {
        return "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0430\u0434\u0440\u0435\u0441\u0430";
    }

    public BuildingRegion checkDirectoriesBR(String desc) {
        if (desc.toLowerCase().indexOf("\u0440\u0430\u0439\u043e\u043d") > -1) {
            desc = desc.substring(0, desc.toLowerCase().indexOf("\u0440\u0430\u0439\u043e\u043d")).trim();
        }
        DirectoriesSearchCriteria sc = new DirectoriesSearchCriteria();
        sc.setCode("*".concat(desc).concat("*"));
        BuildingRegionWSProxy.SearchResultListBuildingRegion sr = this.brWSProxy.getList(InitializedVariable.context, sc);
        if (!sr.isEmpty()) {
            return (BuildingRegion)sr.getObjList()[0];
        }
        BuildingRegion br = new BuildingRegion();
        br.setCode(desc);
        br.setDescription(desc);
        br = this.brWSProxy.save(InitializedVariable.context, br);
        return br;
    }

    public BuildingState checkDirectoriesBS(String desc) {
        if (desc.toLowerCase().indexOf("\u0440\u0430\u0439\u043e\u043d") > -1) {
            desc = desc.substring(0, desc.toLowerCase().indexOf("\u0440\u0430\u0439\u043e\u043d")).trim();
        }
        DirectoriesSearchCriteria sc = new DirectoriesSearchCriteria();
        sc.setCode("*".concat(desc).concat("*"));
        BuildingStateWSProxy.SearchResultListBuildingState sr = this.bsWSProxy.getList(InitializedVariable.context, sc);
        if (!sr.isEmpty()) {
            return (BuildingState)sr.getObjList()[0];
        }
        BuildingState br = new BuildingState();
        br.setCode(desc);
        br.setDescription(desc);
        br = this.bsWSProxy.save(InitializedVariable.context, br);
        return br;
    }
}

