/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.checkpoint;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.log4j.Logger;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.ExtractorSearchCrteria;
import ru.blok.common.ui.ManagerBD;
import ru.blok.common.ui.buttons.AdderButtonInAsyncList;
import ru.blok.common.ui.buttons.EditorButtonInAsyncList;
import ru.blok.common.ui.buttons.OKDirectoryListFilter;
import ru.blok.common.ui.buttons.RemoverButtonInAsyncList;
import ru.blok.common.ui.buttons.SearchButton;
import ru.blok.common.ui.list.ObjectUIList;
import ru.blok.vms.ui.checkpoint.CopyCheckPointButton;
import ru.blok.vms.ui.checkpoint.ImportCheckPointFromFile;
import ru.blok.vms.ui.checkpoint.josm.AddEditNewCheckPoint;
import ru.blok.vms.ui.checkpoint.josm.EditorCheckPointInJosm;
import ru.blok.vms.ui.josm.JosmMainApp;
import ru.blok.vms.ui.navigationdevice.UpdateGroupPriorityVMSButton;
import ru.blok.vms.ui.route.routegeom.OkCheckPoint;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Check;
import ru.infor.beanviewer.annotation.ClassView;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.UISetter;
import ru.infor.beanviewer.viewer.OKDirectoryList;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.client.soap.proxy.vms.CheckPointWSProxy;
import ru.infor.client.soap.proxy.vms.Route2CheckPointLinkWSProxy;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.vms.CheckPointSearchCriteria;
import ru.infor.ws.objects.vms.Route2CheckPointLinkSearchCriteria;
import ru.infor.ws.objects.vms.entities.CheckPoint;
import ru.infor.ws.objects.vms.entities.Route2CheckPointLink;
import ru.infor.ws.objects.vms.entities.ext.CheckPointExt;
import ru.infor.ws.objects.vms.entities.ext.Route2CheckPointLinkExt;
import ru.infor.ws.proxy.UniversalProxy;
import ru.infor.ws.proxy.interfaces.ISearchCriteria;
import ru.infor.ws.proxy.interfaces.InvocationContext;

@ListView(views={@View(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0442\u043e\u0447\u0435\u043a", actions={}, layoutKeys={"tabSplitPercentLayoutManager"}), @View(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0442\u043e\u0447\u0435\u043a", keyView="selectInBuildRoute", actions={@ActionViewer(clazz=OkCheckPoint.class), @ActionViewer(clazz=PanelContext.CancelButton.class)}, layoutKeys={"tabSplitPercentLayoutManager"}), @View(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0442\u043e\u0447\u0435\u043a", keyView="filterInList", actions={@ActionViewer(clazz=OKDirectoryList.class), @ActionViewer(clazz=PanelContext.CancelButton.class)}, layoutKeys={"tabSplitPercentLayoutManager"}), @View(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0442\u043e\u0447\u0435\u043a", keyView="filterInListForListId", actions={@ActionViewer(clazz=OKDirectoryListFilter.class), @ActionViewer(clazz=PanelContext.CancelButton.class)}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class CheckPointList {
    static Logger logger = Logger.getLogger(CheckPointList.class);
    private BufferedReader reader;
    private List<CheckPointExt> items;
    CheckPointWSProxy proxy = (CheckPointWSProxy)CurrentProxyFactory.getProxy(CheckPoint.class);
    Route2CheckPointLinkWSProxy linkWSProxy = (Route2CheckPointLinkWSProxy)CurrentProxyFactory.getProxy(Route2CheckPointLink.class);

    public CheckPointList() {
        this.items = new ObjectUIList(CheckPointExt.class);
    }

    @ListField(fields={@Field(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0442\u043e\u0447\u0435\u043a", viewer={ListViewer.class}, propertiesField={"className=ru.infor.ws.objects.vms.entities.ext.CheckPointExt"}, propertiesLayout="Split1/v/l/0.8", panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=Adder.class, checks={@Check(checkId="CheckPointWS:save")}), @ActionField(clazz=EditorButtonInAsyncList.class, doubleclick=true), @ActionField(clazz=RemoverButtonInAsyncList.class, checks={@Check(checkId="CheckPointWS:delete")}), @ActionField(clazz=AddEditNewCheckPoint.class, checks={@Check(checkId="CheckPointWS:save")}), @ActionField(clazz=EditorCheckPointInJosm.class, checks={@Check(checkId="CheckPointWS:save")}), @ActionField(clazz=CopyCheckPointButton.class, checks={@Check(checkId="CheckPointWS:save")}), @ActionField(clazz=ImportCheckPointFromFile.class, checks={@Check(checkId="CheckPointWS:techImportFromFile")}), @ActionField(clazz=SearchButton.class), @ActionField(clazz=UpdateGroupPriorityVMSButton.class, checks={@Check(checkId="UserWS:updateUser")})}), @PanelField(name="\u0424\u0438\u043b\u044c\u0442\u0440", order=30, classView={@ClassView(name="sc", clazz=CheckPointSearchCriteria.class, extractor=ExtractorSearchCrteria.class)})}, content=CheckPointExt.class), @Field(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0442\u043e\u0447\u0435\u043a", keyView="filterInListForListId", viewer={ListViewer.class}, propertiesField={"className=ru.infor.ws.objects.vms.entities.CheckPoint"}, propertiesLayout="Split1/v/l/0.8", panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=SearchButton.class)}), @PanelField(name="\u0424\u0438\u043b\u044c\u0442\u0440", order=30, classView={@ClassView(name="sc", clazz=CheckPointSearchCriteria.class, extractor=ExtractorSearchCrteria.class)})}, content=CheckPointExt.class), @Field(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0442\u043e\u0447\u0435\u043a", keyView="selectInBuildRoute", viewer={ListViewer.class}, propertiesField={"className=ru.infor.ws.objects.vms.entities.CheckPoint"}, propertiesLayout="Split1/v/l/0.8", panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=SearchButton.class)}), @PanelField(name="\u0424\u0438\u043b\u044c\u0442\u0440", order=30, classView={@ClassView(name="sc", clazz=CheckPointSearchCriteria.class, extractor=ExtractorSearchCrteria.class)})}, content=CheckPointExt.class), @Field(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0442\u043e\u0447\u0435\u043a", keyView="filterInList", order=10, propertiesField={"className=ru.infor.ws.objects.vms.entities.ext.CheckPointExt"}, viewer={ListViewer.class}, propertiesLayout="Split1/v/l/0.8", panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=Adder.class, checks={@Check(checkId="CheckPointWS:save")}), @ActionField(clazz=EditorButtonInAsyncList.class, doubleclick=true), @ActionField(clazz=RemoverButtonInAsyncList.class, checks={@Check(checkId="CheckPointWS:delete")}), @ActionField(clazz=AddEditNewCheckPoint.class, checks={@Check(checkId="CheckPointWS:save")}), @ActionField(clazz=EditorCheckPointInJosm.class, checks={@Check(checkId="CheckPointWS:save")}), @ActionField(clazz=SearchButton.class), @ActionField(clazz=UpdateGroupPriorityVMSButton.class, checks={@Check(checkId="UserWS:updateUser")})}), @PanelField(name="\u0424\u0438\u043b\u044c\u0442\u0440", order=30, classView={@ClassView(name="sc", clazz=CheckPointSearchCriteria.class, extractor=ExtractorSearchCrteria.class)})}, content=CheckPointExt.class)})
    public List<CheckPointExt> getItems() {
        return this.items;
    }

    public void setItems(List<CheckPointExt> items) {
        this.items = items;
    }

    public CheckPointExt createItems() {
        CheckPointExt checkPoint = new CheckPointExt();
        Long code = this.proxy.getNextCheckPointCode(InitializedVariable.context);
        if (code == null) {
            code = 1L;
        }
        checkPoint.setCode(code.toString());
        return checkPoint;
    }

    public CheckPointExt editItems(CheckPointExt checkPointExt) {
        checkPointExt = (CheckPointExt)this.proxy.getCurrentObject(InitializedVariable.context, checkPointExt.getId());
        ObjectUIList list = new ObjectUIList(Route2CheckPointLinkExt.class);
        list.setTotalFill(true);
        Route2CheckPointLinkSearchCriteria sc = (Route2CheckPointLinkSearchCriteria)list.getSearchCriteria();
        sc.setCheckPointIdList(new Long[]{checkPointExt.getId()});
        SortObject so = new SortObject();
        so.setDirection(SortObject.DIRECTION_ASC);
        so.setName("minOffsetInSec");
        sc.setListSort(new SortObject[]{so});
        sc.setCount(this.linkWSProxy._universalGetCount((InvocationContext)InitializedVariable.context, (ISearchCriteria)sc));
        checkPointExt.setLinks((List<Route2CheckPointLinkExt>)list);
        System.out.println("geom = " + checkPointExt.getGeom());
        return checkPointExt;
    }

    public void removeItems(CheckPointExt o) {
        ManagerBD.universalRemove((UniversalProxy)this.proxy, (Long)o.getId());
    }

    public void loadFromFile(File file) {
        try {
            String s;
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.getAbsolutePath()), "Cp1251"));
            String sEmpty = "";
            int count = 0;
            while ((s = this.reader.readLine()) != null) {
                CheckPoint cp;
                String[] params = s.split(";");
                if (params == null || params.length < 7) continue;
                CheckPointSearchCriteria cpSc = new CheckPointSearchCriteria();
                cpSc.setCode("*" + params[1] + "*");
                cpSc.setName("*" + params[2] + "*");
                CheckPointWSProxy.SearchResultListCheckPoint srList = this.proxy.getList(InitializedVariable.context, cpSc);
                if (srList != null && !srList.isEmpty()) {
                    cp = (CheckPoint)srList.getObjList()[0];
                } else {
                    cp = new CheckPoint();
                    cp.setCode(params[1]);
                    cp.setName(params[2]);
                }
                cp.setDescription(params[0]);
                if (sEmpty.equals(params[3])) {
                    cp.setShortName(params[2]);
                } else {
                    cp.setShortName(params[3]);
                }
                try {
                    cp.setLat(Double.valueOf(params[4]));
                    cp.setLon(Double.valueOf(params[5]));
                }
                catch (NumberFormatException e) {
                    logger.info((Object)(String.valueOf(cp.getCode()) + " - " + cp.getName() + " lat: " + params[4] + "  lot: " + params[5] + "   " + e.getMessage()));
                    continue;
                }
                try {
                    cp.setRadius(Integer.valueOf(params[6]));
                }
                catch (NumberFormatException e) {
                    logger.info((Object)(String.valueOf(cp.getCode()) + " - " + cp.getName() + " radius: " + params[6] + "   " + e.getMessage() + "  SET DEFAULT 30"));
                    cp.setRadius(Integer.valueOf(30));
                }
                if (params.length <= 7 || params.length > 7 && sEmpty.equals(params[7])) {
                    Main.pref = new Preferences();
                    GeometryFactory f = new GeometryFactory();
                    Way w2 = new Way();
                    try {
                        CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)JosmMainApp.wkt4326);
                        CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)JosmMainApp.wkt3395);
                        MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
                        MathTransform math2 = CRS.findMathTransform((CoordinateReferenceSystem)targetCRS, (CoordinateReferenceSystem)sourceCRS);
                        GeneralDirectPosition pt1 = new GeneralDirectPosition(cp.getLon().doubleValue(), cp.getLat().doubleValue());
                        DirectPosition pt2 = math.transform((DirectPosition)pt1, null);
                        Point p1 = f.createPoint(new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]));
                        Geometry buffer = p1.buffer((double)cp.getRadius().intValue());
                        if (buffer instanceof Polygon) {
                            Polygon p = (Polygon)buffer;
                            int i = 0;
                            while (i < p.getCoordinates().length - 1) {
                                Coordinate c = p.getCoordinates()[i];
                                GeneralDirectPosition pt11 = new GeneralDirectPosition(c.x, c.y);
                                DirectPosition pt22 = math2.transform((DirectPosition)pt11, null);
                                Node n2 = new Node(new LatLon(pt22.getCoordinate()[1], pt22.getCoordinate()[0]));
                                w2.addNode(n2);
                                ++i;
                            }
                            w2.addNode(w2.getNode(0));
                        }
                    }
                    catch (Exception e) {
                        logger.info((Object)(String.valueOf(cp.getCode()) + " - " + cp.getName() + "error geometry : " + e.getMessage()));
                    }
                    StringBuilder st = new StringBuilder("SRID=4326;");
                    st.append("POLYGON((");
                    int i = 0;
                    while (i < w2.getNodesCount()) {
                        Node n = w2.getNode(i);
                        double x = n.getCoor().lat();
                        double y = n.getCoor().lon();
                        if (i > 0) {
                            st.append(",");
                        }
                        st.append(y).append(" ").append(x);
                        ++i;
                    }
                    st.append("))");
                    cp.setGeom(st.toString());
                } else {
                    cp.setGeom(params[7]);
                }
                try {
                    this.proxy.save(InitializedVariable.context, cp);
                    ++count;
                }
                catch (Exception e) {
                    logger.info((Object)(String.valueOf(cp.getCode()) + " - " + cp.getName() + "  : " + e.getMessage()));
                }
            }
            logger.info((Object)("Add " + count + " Checkpoint."));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Adder
    extends AdderButtonInAsyncList {
        public void actionPerformed(Object arg0) {
            super.actionPerformed(arg0);
            UISetter panel = InitializedVariable.factory.getCurrentPanel(((ViewerContext)this.getContext()).getKeyPage());
            panel.getLayout().setFocusOnComponent(panel.getPresentatorForName("name"));
        }
    }
}

