/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.checkpoint.josm;

import java.sql.SQLException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.postgis.Point;
import org.postgis.Polygon;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.josm.CommonDataSet;
import ru.infor.client.soap.proxy.vms.CheckPointWSProxy;
import ru.infor.ws.objects.vms.entities.CheckPoint;

public class CheckPointDataSet
extends CommonDataSet {
    CheckPointWSProxy proxy = (CheckPointWSProxy)CurrentProxyFactory.getProxy(CheckPoint.class);
    CheckPoint pointExt;
    Node center;
    Integer radius;

    public CheckPointDataSet(CheckPoint checkPoint, String keyPage) throws SQLException {
        super(keyPage);
        this.pointExt = checkPoint.getId() != null ? this.proxy.getCurrentObject(InitializedVariable.context, checkPoint.getId()) : checkPoint;
        String geom = this.pointExt.getGeom();
        this.analysGeom(geom);
        this.center = new Node(new LatLon(this.pointExt.getLat().doubleValue(), this.pointExt.getLon().doubleValue()));
        this.center.put("center_point", "yes");
        this.radius = this.pointExt.getRadius();
        this.addPrimitive((OsmPrimitive)this.center);
    }

    @Override
    protected boolean isClosed() {
        return true;
    }

    public static boolean pointInPolygon(Polygon polygon, Node center) {
        boolean in = false;
        Point p1 = polygon.getPoint(0);
        int i = 1;
        while (i <= polygon.numPoints()) {
            Point p2 = i == polygon.numPoints() ? polygon.getPoint(0) : polygon.getPoint(i);
            if (center.getCoor().getX() > Math.min(p1.getX(), p2.getX()) && center.getCoor().getX() <= Math.max(p1.getX(), p2.getX()) && center.getCoor().getY() <= Math.max(p1.getY(), p2.getY()) && p1.getY() != p2.getY()) {
                double d = (center.getCoor().getX() - p1.getX()) * (p2.getY() - p1.getY()) / (p2.getX() - p1.getX()) + p1.getY();
                if (p1.getY() == p2.getY() || center.getCoor().getY() <= d) {
                    in = !in;
                }
            }
            p1 = p2;
            ++i;
        }
        return in;
    }

    @Override
    protected boolean saveObject(String geom) {
        if (geom.toLowerCase().indexOf("Polygon".toLowerCase()) > -1) {
            block4: {
                Polygon p = new Polygon(geom);
                if (CheckPointDataSet.pointInPolygon(p, this.center)) break block4;
                Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)"Selected zone is not close");
                JOptionPane.showMessageDialog(null, "\u0426\u0435\u043d\u0442\u0440 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0439 \u0442\u043e\u0447\u043a\u0438 \u043d\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0439 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                return false;
            }
            try {
                this.pointExt.setLat(Double.valueOf(this.center.getCoor().getY()));
                this.pointExt.setLon(Double.valueOf(this.center.getCoor().getX()));
                this.pointExt.setRadius(this.radius);
                this.pointExt.setGeom(geom);
                this.pointExt = this.proxy.save(InitializedVariable.context, this.pointExt);
                return true;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

