/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.checkpoint.schedule;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.configprop.ConfigProp;
import ru.blok.common.ui.configprop.ConfigProperties;
import ru.blok.vms.core.CommonMethods;
import ru.blok.vms.core.ResourceStrings;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.client.soap.proxy.vms.CheckPointWSProxy;
import ru.infor.ws.objects.vms.TransportArrivalTime;
import ru.infor.ws.objects.vms.TransportList;
import ru.infor.ws.objects.vms.TransportsByCheckPointSearchCriteria;
import ru.infor.ws.objects.vms.entities.CheckPoint;
import ru.infor.ws.objects.vms.entities.ext.CheckPointScheduleExt;

public class StartScheduleButton
extends PanelContext.OKButton {
    private static Logger logger = Logger.getLogger(StartScheduleButton.class);
    public static Boolean checkStatus = true;
    String path = "";
    Long currentCPS = 0L;
    HashMap<Long, CheckPointScheduleExt> data = new HashMap();
    SimpleDateFormat df = new SimpleDateFormat("HH:mm");
    List<?> list = null;
    Color background = Color.BLUE;
    Color text1 = Color.WHITE;
    Color text2 = Color.YELLOW;

    public void actionPerformed(Object arg0) {
        this.setList(((PanelContext)this.getContext()).getPanel().getSelectedItems());
        this.beginCheck();
    }

    public void beginCheck() {
        ConfigProperties cp = ConfigProperties.getInstance();
        int i = 0;
        while (i < cp.getListProp().size()) {
            ConfigProp cpr = (ConfigProp)cp.getListProp().get(i);
            if (cpr.getName().equalsIgnoreCase("rybinsk40.background.color")) {
                try {
                    this.background = Color.decode("#" + cpr.getValue());
                }
                catch (Exception exception) {}
            }
            if (cpr.getName().equalsIgnoreCase("rybinsk40.text1.color")) {
                try {
                    this.text1 = Color.decode("#" + cpr.getValue());
                }
                catch (Exception exception) {}
            }
            if (cpr.getName().equalsIgnoreCase("rybinsk40.text2.color")) {
                try {
                    this.text2 = Color.decode("#" + cpr.getValue());
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        this.currentCPS = 0L;
        if (this.list != null && !this.list.isEmpty()) {
            HashMap sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.getWorkplaceId((String)((PanelContext)this.getContext()).getKeyPage()));
            this.path = "c:/";
            if (sp.get("PathToRybinsk40ShowFiles") != null) {
                this.path = (String)sp.get("PathToRybinsk40ShowFiles");
            }
            checkStatus = true;
            Long cur = 0L;
            int i2 = 0;
            while (i2 < this.list.size()) {
                CheckPointScheduleExt cps = (CheckPointScheduleExt)((Object)this.list.get(i2));
                this.data.put(cur, cps);
                cur = cur + 1L;
                if (!checkStatus.booleanValue()) break;
                ++i2;
            }
            this.cycleCheck_new();
        }
    }

    public List<?> getList() {
        return this.list;
    }

    public void setList(List<?> list) {
        this.list = list;
    }

    private void cycleCheck_new() {
        CheckPointWSProxy proxy = (CheckPointWSProxy)CurrentProxyFactory.getProxy(CheckPoint.class);
        TransportsByCheckPointSearchCriteria sc = new TransportsByCheckPointSearchCriteria();
        CheckPointScheduleExt cps0 = this.data.get(0L);
        CheckPointScheduleExt cps1 = this.data.get(1L);
        if (cps0 != null && cps1 != null) {
            while (checkStatus.booleanValue()) {
                Date curDate = new Date();
                sc.setNow(curDate);
                sc.setCheckPointCode(cps0.getCheckPoint().getCode());
                TransportList tran0 = proxy.getTransportsByCheckPoint(InitializedVariable.context, sc);
                sc.setCheckPointCode(cps1.getCheckPoint().getCode());
                TransportList tran1 = proxy.getTransportsByCheckPoint(InitializedVariable.context, sc);
                if (tran0 != null && tran0.getArrivalTimes() != null && tran0.getArrivalTimes().length > 0 || tran1 != null && tran1.getArrivalTimes() != null && tran1.getArrivalTimes().length > 0) {
                    this.saveImage(tran0.getArrivalTimes(), tran1.getArrivalTimes(), cps0, curDate, this.path);
                } else {
                    this.deleteFile_new(cps0, this.path);
                }
                try {
                    Thread.sleep(Math.abs(cps0.getTimeCycle() * 60 * 1000));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String deleteFile_new(CheckPointScheduleExt cps, String path) {
        String realFileName = "";
        realFileName = String.valueOf(path) + File.separator + cps.getFileName();
        File file = new File(realFileName);
        if (file.exists()) {
            file.delete();
        }
        return realFileName;
    }

    synchronized Long getCurrentCPS() {
        Long temp = this.currentCPS;
        this.currentCPS = this.currentCPS + 1L;
        return temp;
    }

    public synchronized Boolean getCheckStatus() {
        return checkStatus;
    }

    public static synchronized void setCheckStatus(Boolean checkStatus) {
        StartScheduleButton.checkStatus = checkStatus;
    }

    public String getHint() {
        return "\u0421\u0442\u0430\u0440\u0442 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e \u043e\u0442\u043c\u0435\u0447\u0435\u043d\u043d\u044b\u043c \u041a\u0422";
    }

    public String getIcon() {
        return ResourceStrings.btPlayBlue;
    }

    public String getName() {
        return "\u0421\u0442\u0430\u0440\u0442";
    }

    public void saveImage(TransportArrivalTime[] at0, TransportArrivalTime[] at1, CheckPointScheduleExt cps0, Date curDate, String path) {
        String stt;
        Date showDate;
        Date arrDate;
        TransportArrivalTime tat;
        Arrays.sort(at0, this.compDate());
        Arrays.sort(at1, this.compDate());
        BufferedImage buff = new BufferedImage(253, 192, 5);
        Graphics g = buff.getGraphics();
        g.setColor(this.background);
        g.fillRect(0, 0, 253, 192);
        g.setColor(this.text1);
        g.setFont(new Font("Times New Roman", 0, 19));
        g.drawString("\u041e\u0422\u041f\u0420\u0410\u0412\u041b\u0415\u041d\u0418\u0415", 60, 15);
        g.setColor(this.text2);
        g.setFont(new Font("Times New Roman", 1, 18));
        g.drawString(this.df.format(curDate), 10, 32);
        g.setColor(this.text1);
        Polygon p = new Polygon();
        int x = 45;
        int y = 40;
        p.addPoint(x, y);
        p.addPoint(x + 20, y - 10);
        p.addPoint(x + 20, y - 5);
        p.addPoint(x + 70, y - 5);
        p.addPoint(x + 70, y + 5);
        p.addPoint(x + 20, y + 5);
        p.addPoint(x + 20, y + 10);
        p.addPoint(x, y);
        g.fillPolygon(p);
        Polygon p1 = new Polygon();
        x = 213;
        y = 40;
        p1.addPoint(x, y);
        p1.addPoint(x - 20, y + 10);
        p1.addPoint(x - 20, y + 5);
        p1.addPoint(x - 70, y + 5);
        p1.addPoint(x - 70, y - 5);
        p1.addPoint(x - 20, y - 5);
        p1.addPoint(x - 20, y - 10);
        p1.addPoint(x, y);
        g.fillPolygon(p1);
        g.setFont(new Font("Courier New", 1, 30));
        g.drawChars(new char[]{'\u2502'}, 0, 1, 119, 80);
        g.drawChars(new char[]{'\u2502'}, 0, 1, 119, 110);
        g.drawChars(new char[]{'\u2502'}, 0, 1, 119, 140);
        g.drawChars(new char[]{'\u2502'}, 0, 1, 119, 165);
        g.setFont(new Font("Times New Roman", 0, 12));
        g.drawString("\u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c", 90, 190);
        g.setFont(new Font("Courier New", 1, 16));
        y = 72;
        int dy = 17;
        int mpi = 0;
        int i = 0;
        while (i < at0.length) {
            tat = at0[i];
            arrDate = tat.getArrivalTime();
            if (!curDate.before(arrDate) && curDate.getTime() - arrDate.getTime() <= 900000L) {
                showDate = new Date(curDate.getTime() + curDate.getTime() - arrDate.getTime());
                stt = "\u0410 " + CommonMethods.spaceAfter(tat.getRoute().getNum().trim(), 4) + " " + this.df.format(showDate);
                g.drawString(stt, 3, y + mpi * dy);
                ++mpi;
            }
            ++i;
        }
        mpi = 0;
        i = 0;
        while (i < at1.length) {
            tat = at1[i];
            arrDate = tat.getArrivalTime();
            if (!curDate.before(arrDate) && curDate.getTime() - arrDate.getTime() <= 900000L) {
                showDate = new Date(curDate.getTime() + curDate.getTime() - arrDate.getTime());
                stt = "\u0410 " + CommonMethods.spaceAfter(tat.getRoute().getNum().trim(), 4) + " " + this.df.format(showDate);
                g.drawString(stt, 132, y + mpi * dy);
                ++mpi;
            }
            ++i;
        }
        File im = new File(String.valueOf(path) + File.separator + cps0.getFileName());
        try {
            ImageIO.write((RenderedImage)buff, "jpeg", im);
        }
        catch (IOException e) {
            logger.error((Object)("\u043d\u0435 \u043c\u043e\u0433\u0443 \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0438\u043b\u0438 \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0444\u0430\u0439\u043b " + im.getAbsolutePath()), (Throwable)e);
        }
    }

    private Comparator<TransportArrivalTime> compDate() {
        return new Comparator<TransportArrivalTime>(){

            @Override
            public int compare(TransportArrivalTime o1, TransportArrivalTime o2) {
                return o2.getArrivalTime().compareTo(o1.getArrivalTime());
            }
        };
    }
}

