/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.conductor.warrant;

import java.util.Date;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.buttons.OkWithSave;
import ru.blok.common.utils.MessagesUtils;
import ru.blok.vms.ui.conductor.warrant.CreateConductorWarrantForm;
import ru.blok.vms.ui.warrant.WarrantBuildingErrorInterpretation;
import ru.infor.beanviewer.dialog.ErrorMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.SOAPException;
import ru.infor.client.soap.proxy.vms.ConductorWarrantWSProxy;
import ru.infor.ws.objects.vms.WarrantBuildingError;
import ru.infor.ws.objects.vms.WarrantBuildingParamsByScheduleTemplate;
import ru.infor.ws.objects.vms.entities.ConductorWarrant;

public class OKCreateConductorWarrant
extends OkWithSave {
    public void actionPerformed(Object message) {
        ((PanelContext)this.getContext()).getPanel().stopCellEditor();
        ((PanelContext)this.getContext()).getPanel().updateMainObject();
        Date createDate = ((CreateConductorWarrantForm)this.getObject()).getCreateDate();
        if (createDate == null) {
            createDate = new Date();
        }
        int day = ((CreateConductorWarrantForm)this.getObject()).getDay();
        ConductorWarrantWSProxy proxy = (ConductorWarrantWSProxy)CurrentProxyFactory.getProxy(ConductorWarrant.class);
        WarrantBuildingParamsByScheduleTemplate params = new WarrantBuildingParamsByScheduleTemplate();
        params.setToDate(createDate);
        if (day > 0) {
            params.setToDayOfWeek(Integer.valueOf(day));
        }
        WarrantBuildingError[] list = null;
        try {
            list = proxy.buildWarrantsByScheduleTemplate(InitializedVariable.context, params);
        }
        catch (SOAPException se) {
            ((ViewerContext)((PanelContext)this.getContext()).getParentContext()).getPresentator().getViewer().getFactory().runMessageEx((Object)new ErrorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438", new String[]{MessagesUtils.formatMessage((String)se.getDetailMessage())}), new BeanViewerAction[]{new MessageOKButton()});
            ((PanelContext)this.getContext()).getPanel().updateUI();
            return;
        }
        if (list != null && list.length > 0) {
            String fileName = new String("warrant_" + new Date().getTime() + ".txt");
            System.out.println("\u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0430\u0440\u044f\u0434\u044b \u043d\u0435 \u0431\u044b\u043b\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u044b. \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u0435\u0435 \u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0432 " + fileName);
            WarrantBuildingErrorInterpretation wbei = new WarrantBuildingErrorInterpretation(list, fileName);
            wbei.printList();
        }
        ((PanelContext)((ViewerContext)((PanelContext)this.getContext()).getParentContext()).getParentContext()).getPanel().updateUI();
        this.close();
    }
}

