/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.conductor.waybill;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.buttons.OkWithSave;
import ru.blok.vms.core.ResourceStrings;
import ru.blok.vms.ui.HelpUtils;
import ru.blok.vms.ui.waybill.currentday.common.WaybillCommonActions;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.client.soap.proxy.vms.WaybillCalendarWSProxy;
import ru.infor.ws.objects.vms.WaybillCalendarSearchCriteria;
import ru.infor.ws.objects.vms.entities.WaybillCalendar;
import ru.infor.ws.objects.vms.entities.ext.ConductorWayBillExt;

public class CalculateConductorWaybill
extends OkWithSave {
    HashMap<String, String> sp = null;
    DateFormat df_date = new SimpleDateFormat("dd.MM.yyyy");
    WaybillCalendarWSProxy wbCalendarProxy = (WaybillCalendarWSProxy)CurrentProxyFactory.getProxy(WaybillCalendar.class);
    WaybillCalendarSearchCriteria wbCalendarSc = null;

    public String getIcon() {
        return ResourceStrings.btCalculation;
    }

    public String getHint() {
        return "\u0422\u0430\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0443\u0442\u0435\u0432\u043e\u0439 \u043b\u0438\u0441\u0442";
    }

    public String getName() {
        return "\u0422\u0430\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u0442\u044c";
    }

    public void actionPerformed(Object message) {
        this.sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.getWorkplaceId((String)((PanelContext)this.getContext()).getKeyPage()));
        ((PanelContext)this.getContext()).getPanel().stopCellEditor();
        ((PanelContext)this.getContext()).getPanel().updateMainObject();
        ConductorWayBillExt w = (ConductorWayBillExt)((Object)this.getObject());
        Integer countRun1 = 0;
        Double runDuration = 0.0;
        Double runDurationSub = 0.0;
        Double prepareTime1 = 0.0;
        Double prepareTime2 = 0.0;
        Double idleDuration = 0.0;
        Double reservDuration = 0.0;
        Double nightDuration = 0.0;
        Integer isStateHoliday = 0;
        Integer isReligiousHoliday = 0;
        Double sludgeDuration = 0.0;
        int countRouteIdList = 0;
        int currentRouteIdList = 0;
        if (w.getRuns() != null && w.getRuns().length > 0) {
            countRouteIdList += w.getRuns().length;
        }
        Long[] routeIdList = new Long[countRouteIdList];
        Calendar startAt = null;
        Calendar endAt = null;
        if (w.getRuns() != null) {
            if (this.sp.get("TimeToCheckConductorWaybillInMin") != null) {
                prepareTime1 = prepareTime1 + HelpUtils.getShareOfHoursFromMinute(new Integer(this.sp.get("TimeToCheckConductorWaybillInMin")));
            }
            int i = 0;
            while (i < w.getRuns().length) {
                int mult = 1;
                if (w.getRuns()[i] != null && w.getRuns()[i].getActualFlag() != null && w.getRuns()[i].getActualFlag() == 0 && w.getRuns()[i].getRun() != null && w.getRuns()[i].getRun().getRoute() != null && w.getRuns()[i].getRun().getRoute().getName() != null && w.getRuns()[i].getRun().getRoute().getOldID() != null) {
                    routeIdList[currentRouteIdList] = w.getRuns()[i].getRun().getRoute().getId();
                    ++currentRouteIdList;
                    if (w.getRuns()[i].getRun().getRunAt() != null) {
                        if (startAt == null) {
                            startAt = Calendar.getInstance();
                            startAt.setTime(w.getRuns()[i].getRun().getRunAt());
                        } else if (w.getRuns()[i].getRun().getRunAt().before(startAt.getTime())) {
                            startAt.setTime(w.getRuns()[i].getRun().getRunAt());
                        }
                    }
                    if (w.getRuns()[i].getRun().getReturnAt() != null) {
                        if (endAt == null) {
                            endAt = Calendar.getInstance();
                            endAt.setTime(w.getRuns()[i].getRun().getReturnAt());
                        } else if (w.getRuns()[i].getRun().getReturnAt().after(endAt.getTime())) {
                            endAt.setTime(w.getRuns()[i].getRun().getReturnAt());
                        }
                    }
                    if (w.getRuns()[i].getRun().getRoute().getName().equalsIgnoreCase("\u041f\u0440\u043e\u0441\u0442\u043e\u0439")) {
                        if (w.getRuns()[i].getRun().getReturnAt() != null) {
                            idleDuration = idleDuration + HelpUtils.getShareOfHoursFromDuration(w.getRuns()[i].getRun().getRunAt(), w.getRuns()[i].getRun().getReturnAt());
                        }
                    } else if (w.getRuns()[i].getRun().getRoute().getName().startsWith("\u0420\u0435\u0437\u0435\u0440\u0432")) {
                        if (w.getRuns()[i].getRun().getReturnAt() != null) {
                            reservDuration = reservDuration + HelpUtils.getShareOfHoursFromDuration(w.getRuns()[i].getRun().getRunAt(), w.getRuns()[i].getRun().getReturnAt());
                        }
                    } else {
                        if (new Integer(WaybillCommonActions.Flight).equals(w.getRuns()[i].getRun().getRunType()) || new Integer(WaybillCommonActions.RoundFlight).equals(w.getRuns()[i].getRun().getRunType())) {
                            countRun1 = countRun1 + 1;
                        } else if (new Integer(WaybillCommonActions.TwoFlight).equals(w.getRuns()[i].getRun().getRunType())) {
                            countRun1 = countRun1 + 2;
                            mult = 2;
                        }
                        if (w.getRuns()[i].getRun().getRoute().getRouteDurInMin() != null) {
                            runDuration = runDuration + HelpUtils.getShareOfHoursFromMinute(w.getRuns()[i].getRun().getRoute().getRouteDurInMin()) * (double)mult;
                        }
                        if (w.getRuns()[i].getRun().getRoute().getRouteDurInMinSub() != null) {
                            runDurationSub = runDurationSub + HelpUtils.getShareOfHoursFromMinute(w.getRuns()[i].getRun().getRoute().getRouteDurInMinSub()) * (double)mult;
                        }
                        if (w.getRuns()[i].getRun().getIdleTimeInMin() != null) {
                            sludgeDuration = sludgeDuration + HelpUtils.getShareOfHoursFromMinute(w.getRuns()[i].getRun().getIdleTimeInMin());
                        }
                    }
                }
                ++i;
            }
            if (countRun1 != null && countRun1 > 0) {
                if (this.sp.get("TimeToGetTickets") != null) {
                    prepareTime2 = prepareTime2 + HelpUtils.getShareOfHoursFromMinute(new Integer(this.sp.get("TimeToGetTickets")));
                    endAt.add(12, new Integer(this.sp.get("TimeToGetTickets")));
                }
                if (this.sp.get("TimeToCheckConductorWaybillInMin") != null) {
                    startAt.add(12, new Integer(this.sp.get("TimeToCheckConductorWaybillInMin")) * -1);
                }
                nightDuration = nightDuration + HelpUtils.getNigthShareOfHoursFromDuration(startAt.getTime(), endAt.getTime());
            }
            if (startAt == null) {
                prepareTime1 = 0.0;
                prepareTime2 = 0.0;
            }
            this.wbCalendarSc = new WaybillCalendarSearchCriteria();
            this.wbCalendarSc.setBeginCalDate(w.getWaybillDate());
            this.wbCalendarSc.setEndCalDate(w.getWaybillDate());
            this.wbCalendarSc.setRouteIdList(routeIdList);
            this.wbCalendarSc.setCount(Integer.valueOf(1));
            WaybillCalendarWSProxy.SearchResultListWaybillCalendar srList = this.wbCalendarProxy.getList(InitializedVariable.context, this.wbCalendarSc);
            if (srList != null && srList.getObjList() != null && srList.getObjList().length > 0) {
                isStateHoliday = ((WaybillCalendar)srList.getObjList()[0]).getIsStateHoliday();
                isReligiousHoliday = ((WaybillCalendar)srList.getObjList()[0]).getIsReligiousHoliday();
            }
        }
        w.setWorkTime(idleDuration + runDuration + runDurationSub + reservDuration + sludgeDuration + prepareTime1 + prepareTime2);
        w.setIdleDuration(idleDuration);
        w.setRunDuration(runDuration + runDurationSub);
        w.setReservDuration(reservDuration);
        w.setDuration112(sludgeDuration);
        w.setPrepareDuration(prepareTime1 + prepareTime2);
        w.setPrepareTime1(prepareTime1);
        w.setPrepareTime2(prepareTime2);
        w.setNightDuration(nightDuration);
        w.setIsStateHoliday(isStateHoliday);
        w.setIsReligiousHoliday(isReligiousHoliday);
        ((PanelContext)this.getContext()).getPanel().updateUI();
    }
}

