/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.conductor.waybill;

import java.math.BigDecimal;
import java.util.Date;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.HelpUtils;
import ru.blok.vms.ui.conductor.FIOViewer;
import ru.blok.vms.ui.conductor.TabNumViewer;
import ru.blok.vms.ui.conductor.statistic.OKButtonLocateUpdateUI;
import ru.blok.vms.ui.conductor.waybill.CodeTicketChange;
import ru.blok.vms.ui.conductor.waybill.CountRouteChange;
import ru.blok.vms.ui.conductor.waybill.EndNumberTicketChange;
import ru.blok.vms.ui.conductor.waybill.ViewStatisticTicketsButton;
import ru.blok.vms.ui.route.RouteDirectoryViewer;
import ru.blok.vms.ui.transport.GarageNumDirectoryViewer;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.UISetter;
import ru.infor.beanviewer.swing.viewers.SimpleTextViewer;
import ru.infor.beanviewer.swing.viewers.TimeFormatViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.vms.ConductorWarrantWSProxy;
import ru.infor.client.soap.proxy.vms.ConductorWayBillWSProxy;
import ru.infor.client.soap.proxy.vms.ConductorWaybillRunTicketStatisticWSProxy;
import ru.infor.client.soap.proxy.vms.WarrantWSProxy;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.vms.ConductorWarrantSearchCriteria;
import ru.infor.ws.objects.vms.ConductorWayBillSearchCriteria;
import ru.infor.ws.objects.vms.WarrantSearchCriteria;
import ru.infor.ws.objects.vms.entities.Conductor;
import ru.infor.ws.objects.vms.entities.ConductorWarrant;
import ru.infor.ws.objects.vms.entities.ConductorWayBill;
import ru.infor.ws.objects.vms.entities.ConductorWaybillRun;
import ru.infor.ws.objects.vms.entities.ConductorWaybillRunTicketStatistic;
import ru.infor.ws.objects.vms.entities.Driver;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.RouteScheduleRun;
import ru.infor.ws.objects.vms.entities.TicketRoll;
import ru.infor.ws.objects.vms.entities.TicketType;
import ru.infor.ws.objects.vms.entities.Transport;
import ru.infor.ws.objects.vms.entities.Warrant;
import ru.infor.ws.objects.vms.entities.ext.ConductorWayBillExt;

@ListView(views={@View(title="\u0412\u0432\u043e\u0434 \u0431\u0438\u043b\u0435\u0442\u043d\u043e-\u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u043b\u0438\u0441\u0442\u043e\u0432", transitionEnter=true, actions={@ActionViewer(clazz=ViewStatisticTicketsButton.class), @ActionViewer(clazz=OKButtonLocateUpdateUI.class)}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class EnterConductorWayBillForm {
    static final Integer ReserveCode = 600;
    static final Integer IdleCode = 601;
    static final Integer SludgeCode = 602;
    static final Integer StageCode = 603;
    static final Integer EmptyCode = 0;
    static final Integer InputNumberCWB = 1;
    static final Integer InputCountRoute = 2;
    static final Integer InputCodeTicket = 3;
    static final Integer InputEndNumberTicket = 4;
    private static Integer status;
    public static ConductorWayBill conductorWaybill;
    ConductorWayBillWSProxy cwbProxy = (ConductorWayBillWSProxy)CurrentProxyFactory.getProxy(ConductorWayBill.class);
    ConductorWayBillSearchCriteria cwbSC = null;
    ConductorWarrantWSProxy cwProxy = (ConductorWarrantWSProxy)CurrentProxyFactory.getProxy(ConductorWarrant.class);
    ConductorWarrantSearchCriteria cwSC = null;
    WarrantWSProxy wProxy = (WarrantWSProxy)CurrentProxyFactory.getProxy(Warrant.class);
    WarrantSearchCriteria wSC = null;
    private String numberCWB;
    private Date returnedDateCWB;
    private Date dateCWB;
    private Conductor conductor;
    private Transport transort;
    private Driver driver;
    private Date beginTime;
    private Date endTime;
    private Integer codeRoute;
    private Route route;
    private Date runAt;
    private Date returnAt;
    private String codeTicket;
    private TicketType ticket;
    private Integer beginNumberTicket;
    private Integer endNumberTicket;
    private String label;
    private String descriptionCodeTicket;
    private Integer countRoute;
    private ConductorWaybillRun[] runs;
    private Integer currentRun = 0;
    private TicketRoll[] ticketRoll;
    private TicketType currentTicketType = null;
    private Integer lastNumberTicket;

    public EnterConductorWayBillForm(PanelContext context) {
        EnterConductorWayBillForm.setStatus(EmptyCode);
        ConductorWayBillExt cwb = (ConductorWayBillExt)((Object)context.getObject());
        EnterConductorWayBillForm.setConductorWaybill(cwb);
        this.setNumberCWB(cwb.getWaybillNum());
        this.setTicketRoll(cwb.getRolls());
        this.setConductorTabNum(cwb.getConductor());
        this.setDateCWB(cwb.getWaybillDate());
        this.setReturnedDateCWB(cwb.getReturnedDate());
        this.cwSC = new ConductorWarrantSearchCriteria();
        this.cwSC.setWarrantDateFrom(CommonSearchCriteria.beginOfDay((Date)cwb.getReturnedDate()));
        this.cwSC.setWarrantDateTill(CommonSearchCriteria.endOfDay((Date)cwb.getReturnedDate()));
        this.cwSC.setConductorIdList(new Long[]{cwb.getConductor().getId()});
        ConductorWarrantWSProxy.SearchResultListConductorWarrant srList = this.cwProxy.getList(InitializedVariable.context, this.cwSC);
        if (!srList.isEmpty()) {
            this.wSC = new WarrantSearchCriteria();
            this.wSC.setRouteIdList(new Long[]{((ConductorWarrant)srList.getObjList()[0]).getRouteSchedule().getRoute().getId()});
            this.wSC.setRsTypeIdList(new Long[]{((ConductorWarrant)srList.getObjList()[0]).getRsType().getId()});
            this.wSC.setShiftTypeIdList(new Long[]{((ConductorWarrant)srList.getObjList()[0]).getShiftType().getId()});
            this.wSC.setWarrantDateFrom(CommonSearchCriteria.beginOfDay((Date)((ConductorWarrant)srList.getObjList()[0]).getWarrantDate()));
            this.wSC.setWarrantDateTill(CommonSearchCriteria.endOfDay((Date)((ConductorWarrant)srList.getObjList()[0]).getWarrantDate()));
            srList = this.wProxy.getList(InitializedVariable.context, this.wSC);
            if (!srList.isEmpty()) {
                this.setDriverTabNum(((Warrant)srList.getObjList()[0]).getDriver());
                this.setTransort(((Warrant)srList.getObjList()[0]).getTransport());
            }
            if (cwb.getRuns() != null && cwb.getRuns().length > 0) {
                this.setRuns(cwb.getRuns());
                this.setBeginTime(this.getBeginWorkDay());
                this.setEndTime(this.getEndWorkDay());
            }
        }
    }

    public static ConductorWayBill getConductorWaybill() {
        return conductorWaybill;
    }

    public static void setConductorWaybill(ConductorWayBill cwb) {
        conductorWaybill = cwb;
    }

    public static void setStatus(Integer status) {
        EnterConductorWayBillForm.status = status;
    }

    public static Integer getStatus() {
        return status;
    }

    public static void setStatus(Integer status, ViewerContext context) {
        EnterConductorWayBillForm.status = status;
        EnterConductorWayBillForm.viewFormFromStatus(context, status);
    }

    public void setTicketRoll(TicketRoll[] ticketRoll) {
        this.setCurrentTicketType(null);
        this.ticketRoll = ticketRoll;
    }

    public TicketRoll[] getTicketRoll() {
        return this.ticketRoll;
    }

    private void setCurrentTicketType(TicketType currentTicketType) {
        this.currentTicketType = currentTicketType;
    }

    private TicketType getCurrentTicketType() {
        return this.currentTicketType;
    }

    public void setLastNumberTicket(Integer lastNumberTicket) {
        this.lastNumberTicket = lastNumberTicket;
    }

    public Integer getLastNumberTicket() {
        return this.lastNumberTicket;
    }

    public Integer getFirstNumberTicketForCode(TicketType type) {
        Integer res = null;
        if (type != null) {
            if (type.equals((Object)this.getCurrentTicketType())) {
                res = this.getLastNumberTicket();
            } else if (this.ticketRoll != null && this.ticketRoll.length > 0) {
                int i = 0;
                while (i < this.ticketRoll.length && !type.equals((Object)this.ticketRoll[i].getType())) {
                    ++i;
                }
                if (i < this.ticketRoll.length && type.equals((Object)this.ticketRoll[i].getType())) {
                    res = this.ticketRoll[i].getFirstNum();
                }
            }
        }
        return res;
    }

    public Integer getLastNumberTicketForCode(TicketType type) {
        Integer res = null;
        if (type != null && this.ticketRoll != null && this.ticketRoll.length > 0) {
            int i = 0;
            while (i < this.ticketRoll.length && !type.equals((Object)this.ticketRoll[i].getType())) {
                ++i;
            }
            if (i < this.ticketRoll.length && type.equals((Object)this.ticketRoll[i].getType())) {
                res = this.ticketRoll[i].getLastNum();
            }
        }
        return res;
    }

    private boolean checkRoute(ConductorWaybillRun cwbr) {
        boolean res = false;
        if (cwbr.getRun() != null && cwbr.getRun().getRoute() != null && cwbr.getRun().getRoute().getOldID() != null) {
            res = !cwbr.getRun().getRoute().getOldID().equals(ReserveCode) && !cwbr.getRun().getRoute().getOldID().equals(IdleCode) && !cwbr.getRun().getRoute().getOldID().equals(SludgeCode) && !cwbr.getRun().getRoute().getOldID().equals(StageCode) && cwbr.getRun().getRoute().getOldID() <= 1000;
        }
        return res;
    }

    public Date getBeginWorkDay() {
        Date begin = null;
        if (this.runs != null && this.runs.length > 0) {
            int i = 0;
            while (i < this.runs.length) {
                if (begin == null && this.runs[i].getRun() != null && this.checkRoute(this.runs[i])) {
                    begin = this.runs[i].getRun().getRunAt();
                } else if (this.checkRoute(this.runs[i]) && HelpUtils.afterTime(begin, this.runs[i].getRun().getRunAt())) {
                    begin = this.runs[i].getRun().getRunAt();
                }
                ++i;
            }
        }
        return begin;
    }

    public Date getEndWorkDay() {
        Date end = null;
        if (this.runs != null && this.runs.length > 0) {
            int i = 0;
            while (i < this.runs.length) {
                if (end == null && this.runs[i].getRun() != null && this.checkRoute(this.runs[i])) {
                    end = this.runs[i].getRun().getReturnAt();
                } else if (this.checkRoute(this.runs[i]) && HelpUtils.beforeTime(end, this.runs[i].getRun().getReturnAt())) {
                    end = this.runs[i].getRun().getReturnAt();
                }
                ++i;
            }
        }
        return end;
    }

    private RouteScheduleRun copyConductorWaybillRun(ConductorWaybillRun temp) {
        RouteScheduleRun rsr = new RouteScheduleRun();
        if (temp != null && temp.getRun() != null) {
            rsr.setRunAt(temp.getRun().getRunAt());
            rsr.setReturnAt(temp.getRun().getReturnAt());
            rsr.setRoute(temp.getRun().getRoute());
        }
        return rsr;
    }

    public RouteScheduleRun getNextRun() {
        RouteScheduleRun rsr = null;
        if (this.runs != null && this.runs.length > 0 && this.currentRun < this.runs.length) {
            while (!(this.currentRun >= this.runs.length || this.checkRoute(this.runs[this.currentRun]) && new Integer(0).equals(this.runs[this.currentRun].getActualFlag()))) {
                this.currentRun = this.currentRun + 1;
            }
            if (this.currentRun < this.runs.length && this.checkRoute(this.runs[this.currentRun]) && new Integer(0).equals(this.runs[this.currentRun].getActualFlag())) {
                rsr = this.copyConductorWaybillRun(this.runs[this.currentRun]);
                this.currentRun = this.currentRun + 1;
            }
        }
        return rsr;
    }

    public RouteScheduleRun getNextRun(Integer countRun) {
        RouteScheduleRun rsr = null;
        if (this.runs != null && this.runs.length > 0 && this.currentRun < this.runs.length) {
            while (!(this.currentRun >= this.runs.length || this.checkRoute(this.runs[this.currentRun]) && new Integer(0).equals(this.runs[this.currentRun].getActualFlag()))) {
                this.currentRun = this.currentRun + 1;
            }
            if (this.currentRun < this.runs.length && this.checkRoute(this.runs[this.currentRun]) && new Integer(0).equals(this.runs[this.currentRun].getActualFlag())) {
                rsr = this.copyConductorWaybillRun(this.runs[this.currentRun]);
                int i = 1;
                while (this.currentRun < this.runs.length && i < countRun) {
                    if (this.checkRoute(this.runs[this.currentRun]) && new Integer(0).equals(this.runs[this.currentRun].getActualFlag())) {
                        ++i;
                    }
                    this.currentRun = this.currentRun + 1;
                }
                if (this.currentRun < this.runs.length && this.checkRoute(this.runs[this.currentRun]) && new Integer(0).equals(this.runs[this.currentRun].getActualFlag()) && this.runs[this.currentRun] != null && this.runs[this.currentRun].getRun() != null) {
                    rsr.setReturnAt(this.runs[this.currentRun].getRun().getReturnAt());
                }
                this.currentRun = this.currentRun + 1;
            }
        }
        return rsr;
    }

    @ListField(fields={@Field(title="\u041d\u043e\u043c\u0435\u0440 \u0431\u0438\u043b\u0435\u0442\u043d\u043e-\u0443\u0447\u0435\u0442\u043d\u043e\u0433\u043e \u043b\u0438\u0441\u0442\u0430", order=75, propertiesLayout="0#cell 1 0, w 120, grow 0# cell 0 0, w 200")})
    public String getNumberCWB() {
        return this.numberCWB;
    }

    public void setNumberCWB(String numberCWB) {
        this.numberCWB = numberCWB;
    }

    @ListField(fields={@Field(title="\u0411\u0438\u043b\u0435\u0442\u043d\u043e-\u0443\u0447\u0435\u0442\u043d\u044b\u0439 \u043b\u0438\u0441\u0442 \u043e\u0442\u0440\u0430\u0431\u043e\u0442\u0430\u043d", order=20, propertiesLayout="0#cell 1 1, w 120, grow 0# cell 0 1, w 200")})
    public Date getReturnedDateCWB() {
        return this.returnedDateCWB;
    }

    public void setReturnedDateCWB(Date returnedDateCWB) {
        this.returnedDateCWB = returnedDateCWB;
    }

    @ListField(fields={@Field(title="\u0411\u0438\u043b\u0435\u0442\u043d\u043e-\u0443\u0447\u0435\u0442\u043d\u044b\u0439 \u043b\u0438\u0441\u0442 \u0432\u044b\u043f\u0438\u0441\u0430\u043d", order=17, propertiesLayout="0#cell 3 0, w 120, grow 0# cell 2 0, w 200")})
    public Date getDateCWB() {
        return this.dateCWB;
    }

    public void setDateCWB(Date dateCWB) {
        this.dateCWB = dateCWB;
    }

    @ListField(fields={@Field(title="\u0422\u0430\u0431\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u0434\u0443\u043a\u0442\u043e\u0440\u0430", order=30, readOnly=true, viewer={TabNumViewer.class}, propertiesLayout="0#cell 3 1, w 120, grow 0# cell 2 1, w 200", content=Conductor.class)})
    public Conductor getConductorTabNum() {
        return this.conductor;
    }

    public void setConductorTabNum(Conductor conductor) {
        this.conductor = conductor;
    }

    @ListField(fields={@Field(title="\u0424\u0418\u041e \u043a\u043e\u043d\u0434\u0443\u043a\u0442\u043e\u0440\u0430", order=40, readOnly=true, viewer={FIOViewer.class}, propertiesLayout="0#cell 5 1, w 120, grow 0# cell 4 1, w 200", content=Conductor.class)})
    public Conductor getConductorFIO() {
        return this.conductor;
    }

    @ListField(fields={@Field(title="\u0413\u0430\u0440\u0430\u0436\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440", order=50, readOnly=true, viewer={GarageNumDirectoryViewer.class}, propertiesLayout="0#cell 1 2, w 120, grow 0# cell 0 2, w 200", content=Transport.class)})
    public Transport getTransort() {
        return this.transort;
    }

    public void setTransort(Transport transort) {
        this.transort = transort;
    }

    @ListField(fields={@Field(title="\u0422\u0430\u0431\u043b\u044c\u043d\u044b\u0439 \u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f", order=60, readOnly=true, viewer={ru.blok.vms.ui.driver.TabNumViewer.class}, propertiesLayout="0#cell 3 2, w 120, grow 0# cell 2 2, w 200", content=Driver.class)})
    public Driver getDriverTabNum() {
        return this.driver;
    }

    public void setDriverTabNum(Driver driver) {
        this.driver = driver;
    }

    @ListField(fields={@Field(title="\u0424\u0418\u041e \u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f", order=70, readOnly=true, viewer={ru.blok.vms.ui.driver.FIOViewer.class}, propertiesLayout="0#cell 5 2, w 120, grow 0# cell 4 2, w 200", content=Driver.class)})
    public Driver getDriverFIO() {
        return this.driver;
    }

    @ListField(fields={@Field(title="\u0412\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u0440\u0430\u0431\u043e\u0442\u044b", order=80, viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"}, propertiesLayout="0#cell 1 3, w 120, grow 0# cell 0 3, w 200")})
    public Date getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    @ListField(fields={@Field(title="\u0412\u0440\u0435\u043c\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0440\u0430\u0431\u043e\u0442\u044b", order=90, viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"}, propertiesLayout="0#cell 3 3, w 120, grow 0# cell 2 3, w 200")})
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @ListField(fields={@Field(title="\u041a\u043e\u0434 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430", order=100, propertiesLayout="0#cell 1 4, w 120, grow 0# cell 0 4, w 200")})
    public Integer getCodeRoute() {
        return this.codeRoute;
    }

    public void setCodeRoute(Integer codeRoute) {
        this.codeRoute = codeRoute;
    }

    @ListField(fields={@Field(title="\u041c\u0430\u0440\u0448\u0440\u0443\u0442", order=110, readOnly=true, viewer={RouteDirectoryViewer.class}, propertiesLayout="0#cell 3 4, w 120, grow 0# cell 2 4, w 200")})
    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    @ListField(fields={@Field(title="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0440\u0435\u0439\u0441\u043e\u0432", changeAction={CountRouteChange.class}, order=115, propertiesLayout="0#cell 1 5, w 120, grow 0# cell 0 5, w 200")})
    public Integer getCountRoute() {
        return this.countRoute;
    }

    public void setCountRoute(Integer countRoute) {
        this.countRoute = countRoute;
    }

    @ListField(fields={@Field(title="\u0412\u0432\u043e\u0434 ", readOnly=true, order=130, viewer={SimpleTextViewer.class}, propertiesLayout="0#cell 1 6, w 120, grow 0# cell 0 6, w 200")})
    public String getLabel() {
        return this.label;
    }

    @ListField(fields={@Field(title="\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u0445\u043e\u0434\u0430", order=150, viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"}, propertiesLayout="0#cell 1 7, w 120, grow 0# cell 0 7, w 200")})
    public Date getRunAt() {
        return this.runAt;
    }

    public void setRunAt(Date runAt) {
        this.runAt = runAt;
    }

    @ListField(fields={@Field(title="\u0412\u0440\u0435\u043c\u044f \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d\u0438\u044f", order=160, viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"}, propertiesLayout="0#cell 3 7, w 120, grow 0# cell 2 7, w 200")})
    public Date getReturnAt() {
        return this.returnAt;
    }

    public void setReturnAt(Date returnAt) {
        this.returnAt = returnAt;
    }

    @ListField(fields={@Field(title="\u041a\u043e\u0434 \u0431\u0438\u043b\u0435\u0442\u0430", order=180, changeAction={CodeTicketChange.class}, propertiesLayout="0#cell 1 8, w 120, grow 0# cell 0 8, w 200")})
    public String getCodeTicket() {
        return this.codeTicket;
    }

    public void setCodeTicket(String codeTicket) {
        this.codeTicket = codeTicket;
    }

    public TicketType getTicket() {
        return this.ticket;
    }

    public void setTicket(TicketType ticket) {
        this.ticket = ticket;
    }

    @ListField(fields={@Field(title="\u0411\u0438\u043b\u0435\u0442: ", readOnly=true, order=130, viewer={SimpleTextViewer.class}, propertiesLayout="0#cell 3 8, w 120, grow 0# cell 2 8, w 200")})
    public String getDescriptionCodeTicket() {
        return this.descriptionCodeTicket;
    }

    public void setDescriptionCodeTicket(String str) {
        this.descriptionCodeTicket = str;
    }

    @ListField(fields={@Field(title="\u041d\u043e\u043c\u0435\u0440 \u043d\u0430 \u043d\u0430\u0447\u0430\u043b\u043e \u0432\u044b\u0445\u043e\u0434\u0430", order=190, propertiesLayout="0#cell 1 9, w 120, grow 0# cell 0 9, w 200")})
    public Integer getBeginNumberTicket() {
        return this.beginNumberTicket;
    }

    public void setBeginNumberTicket(Integer beginNumberTicket) {
        this.beginNumberTicket = beginNumberTicket;
    }

    @ListField(fields={@Field(title="\u041d\u043e\u043c\u0435\u0440 \u043d\u0430 \u043a\u043e\u043d\u0435\u0446 \u0432\u044b\u0445\u043e\u0434\u0430", readOnly=false, order=200, changeAction={EndNumberTicketChange.class}, propertiesLayout="0#cell 3 9, w 120, grow 0# cell 2 9, w 200")})
    public Integer getEndNumberTicket() {
        return this.endNumberTicket;
    }

    public void setEndNumberTicket(Integer endNumberTicket) {
        this.endNumberTicket = endNumberTicket;
    }

    @ListField(fields={@Field(title="\u0421\u0443\u043c\u043c\u0430 \u043f\u043e \u043a\u0430\u0441\u0441\u0435", readOnly=true, order=250, propertiesField={"format=###,##0.00"}, propertiesLayout="0#cell 1 10, w 120, grow 0# cell 0 10, w 200", propertiesUI={"background=#FFFFBC"})})
    public BigDecimal getCalculatedAmount() {
        return ((ConductorWayBillExt)conductorWaybill).getCalculatedAmount();
    }

    @ListField(fields={@Field(title="\u0421\u0443\u043c\u043c\u0430 \u043f\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u043c \u0431\u0438\u043b\u0435\u0442\u0430\u043c", readOnly=true, order=260, propertiesField={"format=###,##0.00"}, propertiesLayout="0#cell 3 10, w 120, grow 0# cell 2 10, w 200", propertiesUI={"background=#FFFFBC"})})
    public BigDecimal getTicketsSold() {
        return ((ConductorWayBillExt)conductorWaybill).getTicketsSold();
    }

    public void setRuns(ConductorWaybillRun[] runs) {
        if (runs != null && runs.length > 0) {
            int curLen = 0;
            this.runs = new ConductorWaybillRun[runs.length];
            int i = 0;
            while (i < runs.length) {
                int j = 0;
                while (j < curLen && HelpUtils.afterTime(runs[i].getRun().getRunAt(), this.runs[j].getRun().getRunAt())) {
                    ++j;
                }
                if (j < curLen && HelpUtils.beforeTime(runs[i].getRun().getRunAt(), this.runs[j].getRun().getRunAt())) {
                    int k = curLen;
                    while (k > j) {
                        this.runs[k] = this.runs[k - 1];
                        --k;
                    }
                    this.runs[j] = runs[i];
                } else {
                    this.runs[curLen] = runs[i];
                }
                ++curLen;
                ++i;
            }
            this.currentRun = 0;
        }
    }

    public void setCurrentRunInStartWorkDay() {
        this.currentRun = 0;
    }

    public ConductorWaybillRun[] getRuns() {
        return this.runs;
    }

    private static void viewFormFromStatus(ViewerContext context, Integer status) {
        if (status != null) {
            UISetter panel = InitializedVariable.factory.getCurrentPanel(context.getKeyPage());
            FieldPresentation fLabel = panel.getPresentatorForName("label");
            String lab = "";
            if (status.equals(EmptyCode)) {
                lab = "";
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setNumberCWB(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setConductorTabNum(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setDateCWB(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setTransort(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setDriverTabNum(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setBeginTime(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setEndTime(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setRoute(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setCodeRoute(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setCountRoute(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setRunAt(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setReturnAt(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setCodeTicket("");
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setTicket(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setDescriptionCodeTicket("");
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setBeginNumberTicket(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setEndNumberTicket(null);
            } else if (status.equals(InputNumberCWB)) {
                lab = "";
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setNumberCWB(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setConductorTabNum(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setDateCWB(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setTransort(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setDriverTabNum(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setBeginTime(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setEndTime(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setRoute(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setCodeRoute(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setCountRoute(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setRunAt(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setReturnAt(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setCodeTicket("");
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setTicket(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setDescriptionCodeTicket("");
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setBeginNumberTicket(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setEndNumberTicket(null);
            } else if (status.equals(InputCountRoute)) {
                lab = "";
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setCountRoute(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setRunAt(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setReturnAt(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setCodeTicket("");
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setTicket(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setDescriptionCodeTicket("");
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setBeginNumberTicket(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setEndNumberTicket(null);
            } else if (status.equals(InputCodeTicket)) {
                lab = "";
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setCodeTicket("");
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setTicket(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setDescriptionCodeTicket("");
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setBeginNumberTicket(null);
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setEndNumberTicket(null);
            } else if (status.equals(InputEndNumberTicket)) {
                lab = "";
                ((EnterConductorWayBillForm)((PanelContext)context.getParentContext()).getObject()).setEndNumberTicket(null);
            }
            fLabel.getViewer().setValue((Object)lab);
        }
    }

    public static Integer saveConductorWaybillRunTickets(Transport transport, Route route, boolean descent, Date runAt, Date returnAt, Integer routeType, TicketType ticketType, Integer numInBegin, Integer numInEnd) {
        ConductorWayBillWSProxy cwbProxy = (ConductorWayBillWSProxy)CurrentProxyFactory.getProxy(ConductorWayBill.class);
        ConductorWaybillRunTicketStatisticWSProxy cwbrtsProxy = (ConductorWaybillRunTicketStatisticWSProxy)CurrentProxyFactory.getProxy(ConductorWaybillRunTicketStatistic.class);
        conductorWaybill.setTransport(transport);
        if (conductorWaybill != null && conductorWaybill.getId() == null) {
            conductorWaybill = cwbProxy.save(InitializedVariable.context, conductorWaybill);
            conductorWaybill = cwbProxy.getCurrentObject(InitializedVariable.context, conductorWaybill.getId());
        }
        ConductorWaybillRunTicketStatistic cwbrts = new ConductorWaybillRunTicketStatistic();
        if (conductorWaybill.getRuns() == null) {
            return new Integer(-1);
        }
        if (route != null) {
            int res = -1;
            int i = 0;
            while (i < conductorWaybill.getRuns().length) {
                if (HelpUtils.equalsTimeFromDate(conductorWaybill.getRuns()[i].getRun().getRunAt(), runAt) && conductorWaybill.getRuns()[i].getRun().getRoute().equals((Object)route)) {
                    res = i;
                }
                ++i;
            }
            if (res == -1) {
                return new Integer(-2);
            }
            cwbrts.setRun_id(conductorWaybill.getRuns()[res].getId());
            cwbrts.setNumInBegin(numInBegin);
            cwbrts.setNumInEnd(numInEnd);
            cwbrts.setType(ticketType);
            cwbrts.setWaybill_id(conductorWaybill.getId());
        }
        cwbrts = cwbrtsProxy.save(InitializedVariable.context, cwbrts);
        return new Integer(0);
    }
}

