/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.controlddh;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import edu.emory.mathcs.backport.java.util.Arrays;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import org.postgis.Polygon;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.controlddh.RoadInfo;
import ru.blok.vms.ui.controlddh.RoadJobInfo;
import ru.blok.vms.ui.controlddh.TransportInfo;
import ru.blok.vms.ui.controlddh.executedworks.ExecutedWorks;
import ru.blok.vms.ui.controlddh.map.MapValueTransport;
import ru.blok.vms.ui.controlddh.map.MapViewer;
import ru.blok.vms.ui.controlddh.map.PointData;
import ru.blok.vms.ui.controlddh.map.TransportToView;
import ru.blok.vms.ui.controlddh.prop.MapPropertiesUIControlDDh;
import ru.blok.vms.ui.controlddh.tree.FinderNode;
import ru.blok.vms.ui.controlddh.tree.GeoObjectGroupNode;
import ru.blok.vms.ui.controlddh.tree.RoadTreeNode;
import ru.blok.vms.ui.controlddh.tree.TransportTreeNode;
import ru.blok.vms.ui.controlddh.tree.TreeNodeViewer;
import ru.blok.vms.ui.controlddh.tree.TreeNodeViewerPGO;
import ru.blok.vms.ui.controlddh.tree.TreeNodeViewerRoad;
import ru.infor.beanviewer.annotation.ClassView;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.swing.viewers.SimpleTextViewer;
import ru.infor.beanviewer.swing.viewers.tree.TreeNode;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.core.SecurityWSProxy;
import ru.infor.client.soap.proxy.vms.GeoObjectGroupWSProxy;
import ru.infor.client.soap.proxy.vms.GeoObjectWSProxy;
import ru.infor.client.soap.proxy.vms.IconsListWSProxy;
import ru.infor.client.soap.proxy.vms.NDDataWSProxy;
import ru.infor.client.soap.proxy.vms.RoadWAUIWSProxy;
import ru.infor.client.soap.proxy.vms.RoadWAWSProxy;
import ru.infor.client.soap.proxy.vms.TransportUIWSProxy;
import ru.infor.client.soap.proxy.vms.TransportWSProxy;
import ru.infor.websocket.client.SessionClosed;
import ru.infor.websocket.client.SocketClientFactory;
import ru.infor.websocket.transport.SubscribingOptions;
import ru.infor.websocket.transport.UnsubscribingOptions;
import ru.infor.ws.business.vms.websocket.NDDataSocketIntf;
import ru.infor.ws.business.vms.websocket.objects.SubscribingOptions_SendListNDData;
import ru.infor.ws.objects.geo.GeoObjectGroupSearchCriteria;
import ru.infor.ws.objects.geo.GeoObjectSearchCriteria;
import ru.infor.ws.objects.geo.IconsListSearchCriteria;
import ru.infor.ws.objects.geo.entities.GeoObjectGroup;
import ru.infor.ws.objects.geo.entities.IconsList;
import ru.infor.ws.objects.geo.entities.ext.GeoObjectExt;
import ru.infor.ws.objects.geo.entities.ext.GeoObjectGroupExt;
import ru.infor.ws.objects.vms.NDDataSearchCriteria;
import ru.infor.ws.objects.vms.NDDataThin;
import ru.infor.ws.objects.vms.RoadJobKindWithWork;
import ru.infor.ws.objects.vms.RoadWASearchCriteria;
import ru.infor.ws.objects.vms.RoadWAUI;
import ru.infor.ws.objects.vms.TransportSearchCriteria;
import ru.infor.ws.objects.vms.TransportUI;
import ru.infor.ws.objects.vms.WorksOnMaintenanceOfRoads;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.RoadJobKind;
import ru.infor.ws.objects.vms.entities.RoadWA;
import ru.infor.ws.objects.vms.entities.Transport;

@ListView(views={@View(title="\u041c\u043e\u043d\u0438\u0442\u043e\u0440\u0438\u043d\u0433 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u0434\u043e\u0440\u043e\u0433", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class ControlDDH
extends CommonObjectWithKey
implements NDDataSocketIntf,
FinderNode.SelectFinder,
SessionClosed {
    protected Double[] coord;
    protected MapValueTransport value;
    protected HashMap<String, String> sp = null;
    protected boolean initT = false;
    protected boolean initR = false;
    protected boolean initG = false;
    Gson gson = new GsonBuilder().create();
    protected PanelContext pc;
    URI uri;
    List<Long> lissenDevice;
    public HashMap<Long, TransportToView> view = new HashMap();
    HashMap<Long, TransportToView> viewId = new HashMap();
    public HashMap<Long, TransportTreeNode> transportNode = new HashMap();
    protected List<Long> allDevice = new ArrayList<Long>();
    protected List<Long> allTransport = new ArrayList<Long>();
    String sid = null;
    TransportTreeNode node = new TransportTreeNode(TransportTreeNode.AllGroup);
    RoadTreeNode nodeRoad = new RoadTreeNode(RoadTreeNode.AllGroup);
    GeoObjectGroupNode nodePGO = new GeoObjectGroupNode(GeoObjectGroupNode.AllGroup);
    TransportUIWSProxy proxy = (TransportUIWSProxy)CurrentProxyFactory.getProxy(TransportUI.class);
    SecurityWSProxy securityWSProxy = new SecurityWSProxy(CurrentProxyFactory.getCurrentSOAPConnection());
    HashMap<String, URL> iconsM = new HashMap();
    HashMap<Long, RoadTreeNode> roadTNode = new HashMap();
    protected Timer mTimer;
    protected Timer mTimer2;
    TransportWSProxy transportWSProxy = (TransportWSProxy)CurrentProxyFactory.getProxy(Transport.class, (String)this.getKeyPage());
    BeanViewerAction<ViewerContext> extWork = new BeanViewerAction<ViewerContext>(){

        public String getName() {
            return "\u0420\u0430\u0441\u0447\u0435\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0430\u0431\u043e\u0442";
        }

        public void actionPerformed(Object message) {
            Long[] lots = (Long[])ControlDDH.this.nodeRoad.listChild.stream().filter(l -> ((RoadTreeNode)((Object)l)).isSelect()).map(ll -> ((RoadTreeNode)((Object)ll)).getLotid()).toArray(Long[]::new);
            ControlDDH.this.work.setLots(lots);
            InitializedVariable.factory.newPage(ExecutedWorks.class, ExecutedWorks.class, (Object)ControlDDH.this.work, (ViewerContext)this.getContext());
        }
    };
    ExecutedWorks work;
    DateFormat df = new SimpleDateFormat("dd.MM.yy HH:mm:ss");
    public boolean select = false;
    HashMap<Long, TransportToView> removeTransport = new HashMap();
    NDDataWSProxy ndDataWSProxy = (NDDataWSProxy)CurrentProxyFactory.getProxy(NDData.class);
    RoadWAWSProxy roadWAWSProxy = (RoadWAWSProxy)CurrentProxyFactory.getProxy(RoadWA.class);
    public HashMap<Long, RoadTreeNode> geoms = new HashMap();
    public HashMap<Long, GeoObjectExt> geomsG = new HashMap();
    boolean needconnected = false;

    public void sendList(List<NDData> datas) {
        this.acceptData(datas);
    }

    public ControlDDH(String keyPage) {
        super(keyPage);
        this.coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)keyPage));
        this.init();
    }

    protected void init() {
        this.value = new MapValueTransport(this.coord[0], this.coord[1], this.coord[2].intValue());
        this.value.setInformation(this);
        this.work = new ExecutedWorks(this.getKeyPage(), this.coord);
    }

    public void beforeShow(final PanelContext pc) {
        this.pc = pc;
        MapPropertiesUIControlDDh prop = (MapPropertiesUIControlDDh)((MapViewer)pc.getPanel().getPresentatorForName("value").getViewer()).getUIProperties();
        if (InitializedVariable.getWorkplaceId((String)this.getKeyPage()) != null) {
            String s;
            this.sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.getWorkplaceId((String)this.getKeyPage()));
            if (this.sp.get("control.ddh.TimeStop") != null) {
                s = this.sp.get("control.ddh.TimeStop");
                prop.setTimeStop(Integer.parseInt(s));
            }
            if (this.sp.get("control.ddh.TimeStopColor") != null) {
                s = this.sp.get("control.ddh.TimeStopColor");
                prop.setTimeStopColor(Color.decode(s).getRGB());
            }
            if (this.sp.get("control.ddh.TimeLengthTail") != null) {
                s = this.sp.get("control.ddh.TimeLengthTail");
                prop.setTimeLengthTail(Integer.parseInt(s));
            }
            if (this.sp.get("control.ddh.ArrowWidth") != null) {
                s = this.sp.get("control.ddh.ArrowWidth");
                prop.setArrowWidth(Integer.parseInt(s));
            }
            if (this.sp.get("control.ddh.DisplayTsOption") != null) {
                s = this.sp.get("control.ddh.DisplayTsOption");
                prop.setDisplayTsOption(Integer.parseInt(s));
            }
            if (this.sp.get("control.ddh.LifetimeTS") != null) {
                s = this.sp.get("control.ddh.LifetimeTS");
                prop.setLifetimeTS(Integer.parseInt(s));
            }
            if (this.sp.get("control.ddh.TypeDisappearanceTrack") != null) {
                s = this.sp.get("control.ddh.TypeDisappearanceTrack");
                prop.setTypeDisappearanceTrack(Integer.parseInt(s));
            }
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                ControlDDH.this.initTree();
                ControlDDH.this.connected();
                pc.getPanel().updateUIForPresentatorName("node");
                ControlDDH.this.initT = true;
                ControlDDH.this.mTimer2 = new Timer();
                ControlDDH.this.mTimer2.schedule((TimerTask)new TimerUpdateStateTask2(ControlDDH.this), 1000L, 1000L);
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                ControlDDH.this.initTreeRoad();
                pc.getPanel().updateUIForPresentatorName("nodeRoad");
                ControlDDH.this.initR = true;
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                ControlDDH.this.initTreePGO();
                pc.getPanel().updateUIForPresentatorName("nodePGO");
                ControlDDH.this.initG = true;
            }
        }).start();
        this.mTimer = new Timer();
        this.mTimer.schedule((TimerTask)new TimerUpdateStateTask(this), 15000L, 5000L);
    }

    public void connected() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("connected");
                    SubscribingOptions_SendListNDData options = new SubscribingOptions_SendListNDData();
                    options.setContext(InitializedVariable.getContext((String)ControlDDH.this.getKeyPage()));
                    options.setServiceName("NDDataWS");
                    options.setMethodName("sendList");
                    options.setDeviceIdList(ControlDDH.this.lissenDevice);
                    options.setSid(ControlDDH.this.sid);
                    if (ControlDDH.this.lissenDevice.size() > 0) {
                        ControlDDH.this.sid = SocketClientFactory.subscribe((Object)ControlDDH.this, (SubscribingOptions)options, (String)InitializedVariable.getAppShortName((String)ControlDDH.this.getKeyPage()));
                    } else if (ControlDDH.this.sid != null) {
                        ControlDDH.this.close();
                    }
                    ControlDDH.this.needconnected = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    protected String getMainGr(TransportUI t) {
        return t.getPrimaryGroupName();
    }

    public void initTree() {
        this.view.clear();
        this.viewId.clear();
        this.transportNode.clear();
        this.node.listChild.clear();
        this.allDevice.clear();
        this.allTransport.clear();
        TransportSearchCriteria sc = new TransportSearchCriteria();
        sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        HashMap<String, TransportTreeNode> prGroup = new HashMap<String, TransportTreeNode>();
        HashMap<String, TransportTreeNode> group = new HashMap<String, TransportTreeNode>();
        Object[] oo = this.proxy.getList(InitializedVariable.context, sc).getObjList();
        ArrayList<Long> lissenDevice = new ArrayList<Long>();
        Object[] objectArray = oo;
        int n = oo.length;
        int n2 = 0;
        while (n2 < n) {
            TransportTreeNode g;
            Object o = objectArray[n2];
            TransportUI s = (TransportUI)o;
            TransportTreeNode tn = new TransportTreeNode(TransportTreeNode.Transport);
            tn.setTransportUI(s);
            this.transportNode.put(s.getId(), tn);
            if (s.getDeviceId() != null) {
                this.allDevice.add(s.getDeviceId());
            }
            this.allTransport.add(s.getId());
            TransportTreeNode prg = (TransportTreeNode)((Object)prGroup.get(this.getMainGr(s)));
            if (prg == null) {
                prg = new TransportTreeNode(TransportTreeNode.GroupPr);
                prGroup.put(this.getMainGr(s), prg);
                prg.setGroup(this.getMainGr(s));
                this.node.listChild.add(prg);
                prg.setParent(this.node);
            }
            if ((g = (TransportTreeNode)((Object)group.get(String.valueOf(this.getMainGr(s)) + s.getGroupDescription()))) == null) {
                g = new TransportTreeNode(TransportTreeNode.Group);
                group.put(String.valueOf(this.getMainGr(s)) + s.getGroupDescription(), g);
                g.setGroup(s.getGroupDescription());
                prg.listChild.add(g);
                g.setParent(prg);
            }
            g.listChild.add(tn);
            tn.setParent(g);
            ++n2;
        }
        Collections.sort(this.node.listChild);
        prGroup.values().stream().forEach(t -> Collections.sort(t.listChild));
        group.values().stream().forEach(t -> Collections.sort(t.listChild));
        this.lissenDevice = lissenDevice;
    }

    protected TransportToView getNewInstance(Object uiProp, TransportUI w, URL url, TransportTreeNode node) {
        MapPropertiesUIControlDDh prop = (MapPropertiesUIControlDDh)uiProp;
        TransportToView wv = new TransportToView(w.getId(), w, this, url, prop.getArrowWidth(), prop.getDisplayTsOption());
        return wv;
    }

    public TransportToView initTransportToView(TransportTreeNode node) {
        TransportUI w = node.getTransportUI();
        TransportToView wv = this.view.get(w.getId());
        if (wv == null) {
            String icon = w.getTransportKindIcon();
            URL url = null;
            if (this.iconsM.containsKey(icon)) {
                url = this.iconsM.get(icon);
            } else {
                String urlStr = this.securityWSProxy.getURLForDownload(InitializedVariable.context, icon);
                try {
                    url = new URL(urlStr);
                }
                catch (MalformedURLException malformedURLException) {}
                this.iconsM.put(icon, url);
            }
            Object prop = this.value.mapViewer.getUIProperties();
            wv = this.getNewInstance(prop, w, url, node);
            this.view.put(wv.getId(), wv);
            this.viewId.put(w.getDeviceId(), wv);
        }
        return wv;
    }

    public void initTreeRoad() {
        Object[] oo;
        this.nodeRoad.listChild.clear();
        this.nodeRoad.setSelectWithoutChildren(false);
        RoadWAUIWSProxy proxy = (RoadWAUIWSProxy)CurrentProxyFactory.getProxy(RoadWAUI.class);
        RoadWASearchCriteria sc = new RoadWASearchCriteria();
        sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        HashMap<String, RoadTreeNode> prGroup = new HashMap<String, RoadTreeNode>();
        HashMap<String, RoadTreeNode> group = new HashMap<String, RoadTreeNode>();
        Object[] objectArray = oo = proxy.getList(InitializedVariable.context, sc).getObjList();
        int n = oo.length;
        int n2 = 0;
        while (n2 < n) {
            RoadTreeNode g;
            Object o = objectArray[n2];
            RoadWAUI s = (RoadWAUI)o;
            RoadTreeNode tn = new RoadTreeNode(RoadTreeNode.Road);
            tn.setSelectWithoutChildren(false);
            tn.setRoadWAUI(s);
            this.roadTNode.put(s.getId(), tn);
            RoadTreeNode prg = (RoadTreeNode)((Object)prGroup.get(s.getLotName()));
            if (prg == null) {
                prg = new RoadTreeNode(RoadTreeNode.LOT);
                prGroup.put(s.getLotName(), prg);
                prg.setSelectWithoutChildren(false);
                prg.setGroup(s.getLotName());
                prg.setLotid(s.getLotId());
                this.nodeRoad.listChild.add(prg);
                prg.setParent(this.nodeRoad);
            }
            if ((g = (RoadTreeNode)((Object)group.get(String.valueOf(s.getLotName()) + s.getOperationalGroup()))) == null) {
                g = new RoadTreeNode(RoadTreeNode.Group);
                group.put(String.valueOf(s.getLotName()) + s.getOperationalGroup(), g);
                g.setSelectWithoutChildren(false);
                g.setGroup(s.getOperationalGroup());
                prg.listChild.add(g);
                g.setParent(prg);
            }
            g.listChild.add(tn);
            tn.setParent(g);
            ++n2;
        }
    }

    public void initTreePGO() {
        this.nodePGO.listChild.clear();
        this.nodePGO.setSelectWithoutChildren(false);
        GeoObjectGroupWSProxy proxy = (GeoObjectGroupWSProxy)CurrentProxyFactory.getProxy(GeoObjectGroup.class);
        GeoObjectGroupSearchCriteria sc = new GeoObjectGroupSearchCriteria();
        sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        Object[] oo = proxy.getList(InitializedVariable.context, sc).getObjList();
        if (oo != null) {
            Object[] objectArray = oo;
            int n = oo.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                GeoObjectGroupExt s = (GeoObjectGroupExt)((Object)o);
                GeoObjectGroupNode prg = new GeoObjectGroupNode(GeoObjectGroupNode.Group);
                prg.setSelectWithoutChildren(false);
                prg.setGroup(s.getTitle());
                prg.setGroupExt(s);
                this.nodePGO.listChild.add(prg);
                prg.setParent(this.nodePGO);
                ++n2;
            }
        }
        Collections.sort(this.nodePGO.listChild);
    }

    public void acceptData(List<NDData> list) {
        Collections.sort(list, (Comparator)new Comparator<NDData>(){

            @Override
            public int compare(NDData o1, NDData o2) {
                return o1.getCreatedDateTime().compareTo(o2.getCreatedDateTime());
            }
        });
        for (NDData d : list) {
            TransportToView w = this.viewId.get(d.getDeviceId());
            if (w == null) continue;
            RoadJobKind[] job = this.calcWork(w.getId(), d);
            w.setData(new PointData(d, job));
        }
        this.value.change();
    }

    public RoadJobKind[] calcWork(Long transportId, NDData data) {
        RoadJobKindWithWork w = this.transportWSProxy.executionOfWorksByPoint(InitializedVariable.context, transportId, data);
        return w == null ? null : w.getJob();
    }

    @ListField(fields={@Field(title="", order=8, propertiesLayout="Split1/h/l/0.3:1/ins 0", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getExtWork() {
        return this.extWork;
    }

    @ListField(fields={@Field(title="", order=9, propertiesLayout="Split1/h/l/0.3:1#growx, w 400", viewer={SimpleTextViewer.class})})
    public String getTimeR() {
        return this.work != null && this.work.getDateR() != null ? "\u0412\u0440\u0435\u043c\u044f \u0440\u0430\u0441\u0447\u0435\u0442\u0430: " + this.df.format(this.work.getDateR()) : "\u0420\u0430\u0441\u0447\u0435\u0442\u0430 \u0432\u044b\u043f\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0430\u0431\u043e\u0442 \u043d\u0435 \u043f\u0440\u043e\u0432\u043e\u0434\u0438\u043b\u043e\u0441\u044c";
    }

    @ListField(fields={@Field(title="\u0422\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442", order=10, propertiesLayout="Split1/h/l/0.3:Tab1/\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435:Split2/v/l/0.5", viewer={TreeNodeViewer.class}, panels={@PanelField(classView={@ClassView(name="1", clazz=FinderNode.class)})})})
    public TransportTreeNode getNode() {
        return this.node;
    }

    @ListField(fields={@Field(title="\u0414\u043e\u0440\u043e\u0433\u0438", order=20, propertiesLayout="Split1/h/l/0.3:Tab1/\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435:Split2/v/r/0.5", viewer={TreeNodeViewerRoad.class}, panels={@PanelField(classView={@ClassView(name="1", clazz=FinderNode.class)})})})
    public RoadTreeNode getNodeRoad() {
        return this.nodeRoad;
    }

    @ListField(fields={@Field(title="\u041f\u0413\u041e", order=40, propertiesLayout="Split1/h/l/0.3:Tab1/\u041f\u0413\u041e", viewer={TreeNodeViewerPGO.class}, panels={@PanelField(classView={@ClassView(name="1", clazz=FinderNode.class)})})})
    public GeoObjectGroupNode getNodePGO() {
        return this.nodePGO;
    }

    @ListField(fields={@Field(title="", order=100, propertiesLayout="Split1/h/r/0.3", viewer={MapViewer.class})})
    public MapValueTransport getValue() {
        return this.value;
    }

    public void close() {
        UnsubscribingOptions o = new UnsubscribingOptions();
        o.setContext(InitializedVariable.getContext((String)this.getKeyPage()));
        o.setMethodName("sendList");
        o.setServiceName("NDDataWS");
        o.setSid(this.sid);
        try {
            if (this.sid != null) {
                SocketClientFactory.unsubscribe((UnsubscribingOptions)o, (String)InitializedVariable.getAppShortName((String)this.getKeyPage()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sid = null;
        }
    }

    public void beforeDestroy(PanelContext pc) {
        for (TransportToView w : this.view.values()) {
            w.dispose();
        }
        this.close();
    }

    public void setSelected(Long wId, TransportTreeNode tt) {
        TransportToView w = this.view.get(wId);
        if (w != null) {
            boolean newSel = true;
            if (w.isSelect()) {
                newSel = false;
            }
            for (TransportToView ww : this.view.values()) {
                ww.setSelect(false);
            }
            if (newSel) {
                w.setSelect(true);
            }
            this.select = true;
            if (tt == null) {
                tt = this.transportNode.get(wId);
                ((TreeNodeViewer)this.pc.getPanel().getPresentatorForName("node").getViewer()).setSelection((Object)tt);
                this.value.change();
                if (newSel) {
                    TransportInfo i = new TransportInfo();
                    i.setRegnum(tt.getTransportUI().getRegNum());
                    i.setType(tt.getTransportUI().getTransportTypeDescription());
                    i.setPrimaryGroup(tt.getTransportUI().getPrimaryGroupName());
                    i.setWorks(w.getData().getJob());
                    i.setTransport(tt.getTransportUI());
                    this.runTransportInfo(i, tt);
                } else {
                    this.closeTransportInfo(tt);
                }
            }
            this.value.change();
            this.select = false;
        }
    }

    public void closeTransportInfo(TransportTreeNode rtn) {
        InitializedVariable.factory.close(rtn.getKeyPage());
    }

    public void runTransportInfo(TransportInfo i, TransportTreeNode rtn) {
        if (this.work.getMaintenanceOfRoads() != null) {
            List<RoadJobInfo> l = Arrays.asList((Object[])this.work.getMaintenanceOfRoads()).stream().filter(ww -> ((WorksOnMaintenanceOfRoads)ww).getTransport() != null && rtn.getTransportUI().getId().equals(((WorksOnMaintenanceOfRoads)ww).getTransport().getId())).map(ww1 -> new RoadJobInfo((WorksOnMaintenanceOfRoads)ww1)).collect(Collectors.toList());
            i.setList(l);
        }
        ViewerContext vc = new ViewerContext();
        vc.setKeyPage("kp2" + i.getTransport().getId());
        InitializedVariable.factory.newWindow(i.getClass(), i.getClass(), (Object)i, vc, "", "kp2" + i.getTransport().getId(), true, true);
        rtn.setKeyPage(vc.getKeyPage());
    }

    public void setSelectedRoad(Long wId, RoadTreeNode tt) {
        boolean needSelectTree = false;
        if (tt == null) {
            tt = this.roadTNode.get(wId);
            needSelectTree = true;
        }
        for (RoadTreeNode t1 : this.roadTNode.values()) {
            t1.setSelectOnMap(false);
        }
        tt.setSelectOnMap(true);
        if (needSelectTree) {
            this.select = true;
            ((TreeNodeViewerRoad)this.pc.getPanel().getPresentatorForName("nodeRoad").getViewer()).setSelection((Object)tt);
            this.value.change();
            RoadInfo i = new RoadInfo();
            i.setName(tt.getRoadWAUI().getName());
            i.setLot(tt.getRoadWAUI().getLotName());
            i.setGroup(tt.getRoadWAUI().getOperationalGroup());
            i.setPrimaryGroup(tt.getRoadWAUI().getPrimaryGroupName());
            RoadTreeNode rtn = tt;
            if (this.work.getMaintenanceOfRoads() != null) {
                List<RoadJobInfo> l = Arrays.asList((Object[])this.work.getMaintenanceOfRoads()).stream().filter(w -> rtn.getRoadWAUI().getId().equals(((WorksOnMaintenanceOfRoads)w).getRoad().getId())).map(ww -> new RoadJobInfo((WorksOnMaintenanceOfRoads)ww)).collect(Collectors.toList());
                i.setList(l);
            }
            InitializedVariable.factory.newWindow(i.getClass(), i.getClass(), (Object)i, this.value.mapViewer.getViewerContext(), "", "kp" + i.getName(), true);
            this.select = false;
        } else if (tt.getCurrentPolygon() != null) {
            Point p = tt.getCurrentPolygon().getFirstPoint();
            this.value.center(new GeoPosition(p.getY(), p.getX()));
        }
    }

    public void off(TransportTreeNode node) {
        TransportToView w;
        if (node.isSelect() && node.getType() == TransportTreeNode.Transport && (w = node.getTransportToView()) != null) {
            this.removeTransport.put(w.getId(), w);
            this.view.remove(w.getId());
            this.lissenDevice.remove(w.getObject().getDeviceId());
            w.getComponent().setVisible(false);
            w.getComponentH().setVisible(false);
            w.getComponentH2().stream().forEach(o -> o.setVisible(false));
        }
        node.setSelectWithoutChildren(false);
        for (TreeNode n : node.listChild) {
            this.off((TransportTreeNode)n);
        }
    }

    public void prepareOn(TransportTreeNode node, TransportToView w) {
    }

    public void onn(TransportTreeNode node, List<Long> newIds) {
        if (!node.isSelect() && node.getType() == TransportTreeNode.Transport) {
            TransportToView w = node.getTransportToView();
            if (w != null) {
                this.removeTransport.remove(w.getId());
                this.view.put(w.getId(), w);
                this.lissenDevice.add(w.getObject().getDeviceId());
                this.prepareOn(node, w);
                w.getComponent().setVisible(true);
            } else if (node.getTransportUI().getDeviceId() != null) {
                this.lissenDevice.add(node.getTransportUI().getDeviceId());
                newIds.add(node.getTransportUI().getDeviceId());
                w = this.initTransportToView(node);
                this.prepareOn(node, w);
                node.setTransportToView(w);
            }
        }
        node.setSelectWithoutChildren(true);
        for (TreeNode n : node.listChild) {
            this.onn((TransportTreeNode)n, newIds);
        }
    }

    protected void findLastData(List<Long> newIds) {
        if (newIds.size() > 0) {
            NDDataThin[] list;
            NDDataSearchCriteria sc = new NDDataSearchCriteria();
            sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
            sc.setDeviceIdList(newIds.toArray(new Long[newIds.size()]));
            NDDataThin[] nDDataThinArray = list = this.ndDataWSProxy.getLastDataThin(InitializedVariable.context, sc);
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                NDDataThin dd = nDDataThinArray[n2];
                TransportToView w = this.viewId.get(dd.getDeviceId());
                if (w != null) {
                    NDData d = new NDData();
                    d.setId(dd.getId());
                    d.setDeviceId(dd.getDeviceId());
                    d.setLat(dd.getLat());
                    d.setLon(dd.getLon());
                    d.setSpeed(dd.getSpeed());
                    d.setCreatedDateTime(dd.getCreatedDateTime());
                    d.setDirection(dd.getNorthAngle());
                    RoadJobKind[] job = this.calcWork(w.getId(), d);
                    w.setData(new PointData(d, job));
                }
                ++n2;
            }
        }
    }

    public void onOff(TransportTreeNode node) {
        if (node.isSelect()) {
            this.off(node);
        } else {
            ArrayList<Long> newIds = new ArrayList<Long>();
            this.onn(node, newIds);
            this.findLastData(newIds);
        }
        this.pc.getPanel().updateUIForPresentatorName("value");
        this.connected();
    }

    public void positionOnFullList() {
        if (this.value != null && this.value.mapViewer != null) {
            this.value.mapViewer.zoomToTracks();
        }
    }

    public void positionOnselect() {
        TransportToView ws = null;
        for (TransportToView w : this.view.values()) {
            if (!w.isSelect()) continue;
            ws = w;
        }
        if (ws != null) {
            this.value.center(ws.getGeoposition());
        }
    }

    public void initListWarrant(TransportTreeNode node, List<TransportToView> list) {
        if (node.getType() == TransportTreeNode.Transport) {
            list.add(node.getTransportToView());
        }
        for (TreeNode n : node.listChild) {
            this.initListWarrant((TransportTreeNode)n, list);
        }
    }

    public void positionOnselectGroup(TransportTreeNode node) {
        ArrayList<TransportToView> list = new ArrayList<TransportToView>();
        this.initListWarrant(node, list);
        ArrayList<GeoPosition> gpl = new ArrayList<GeoPosition>();
        for (TransportToView ws : list) {
            if (ws == null || ws.getGeoposition() == null) continue;
            gpl.add(ws.getGeoposition());
        }
        this.value.init(gpl);
    }

    public void off(RoadTreeNode node) {
        if (node.isSelect() && node.getType() == RoadTreeNode.Road) {
            this.geoms.remove(node.getRoadWAUI().getId());
        }
        node.setSelectWithoutChildren(false);
        for (TreeNode n : node.listChild) {
            this.off((RoadTreeNode)n);
        }
    }

    public void onn(RoadTreeNode node) {
        if (!node.isSelect() && node.getType() == RoadTreeNode.Road) {
            if (node.getCurrentPolygon() == null) {
                RoadWA roadWA = this.roadWAWSProxy.getCurrentObject(InitializedVariable.context, node.getRoadWAUI().getId());
                if (roadWA.getOperationalGroup() != null) {
                    node.setColor(roadWA.getOperationalGroup().getColor());
                }
                try {
                    if (roadWA.getAreageom().contains("MULTIPOLYGON")) {
                        node.setCurrentPolygon((Geometry)new MultiPolygon(roadWA.getAreageom()));
                    } else {
                        node.setCurrentPolygon((Geometry)new Polygon(roadWA.getAreageom()));
                    }
                }
                catch (Exception exception) {}
            }
            if (node.getCurrentPolygon() != null) {
                this.geoms.put(node.getRoadWAUI().getId(), node);
            }
        }
        node.setSelectWithoutChildren(true);
        for (TreeNode n : node.listChild) {
            this.onn((RoadTreeNode)n);
        }
    }

    public void onOff(RoadTreeNode node) {
        if (node.isSelect()) {
            this.off(node);
            this.positionOnFullListRoad();
        } else {
            this.onn(node);
            this.positionOnselectGroupRoad(node);
        }
        this.pc.getPanel().updateUIForPresentatorName("value");
    }

    public void off(GeoObjectGroupNode node) {
        if (node.isSelect() && node.getType() == GeoObjectGroupNode.Group) {
            for (GeoObjectExt e : node.getListObject()) {
                this.geomsG.remove(e.getId());
            }
        }
        node.setSelectWithoutChildren(false);
        for (TreeNode n : node.listChild) {
            this.off((GeoObjectGroupNode)n);
        }
    }

    public void onn(GeoObjectGroupNode node) {
        if (!node.isSelect() && node.getType() == GeoObjectGroupNode.Group) {
            if (node.getListObject().size() == 0) {
                GeoObjectWSProxy proxy = (GeoObjectWSProxy)CurrentProxyFactory.getProxy(GeoObjectExt.class);
                GeoObjectSearchCriteria sc = new GeoObjectSearchCriteria();
                sc.setGeoGroupIdList(new Long[]{node.getGroupExt().getId()});
                sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
                sc.setLoadWithCurrentObject(Integer.valueOf(1));
                Object[] oo = proxy.getList(InitializedVariable.context, sc).getObjList();
                ArrayList icIds = new ArrayList();
                if (oo != null) {
                    Arrays.asList((Object[])oo).forEach(o -> {
                        GeoObjectExt g = (GeoObjectExt)((Object)((Object)o));
                        if (g.getType() == 0) {
                            try {
                                g.setCurrentPolygon((Geometry)new Point(g.getGeom()));
                            }
                            catch (Exception exception) {}
                        } else {
                            try {
                                if (g.getGeom().contains("MULTIPOLYGON")) {
                                    g.setCurrentPolygon((Geometry)new MultiPolygon(g.getGeom()));
                                } else {
                                    g.setCurrentPolygon((Geometry)new Polygon(g.getGeom()));
                                }
                            }
                            catch (Exception exception) {}
                        }
                        node.getListObject().add(g);
                        icIds.add(g.getIco().getId());
                    });
                }
                IconsListWSProxy proxy2 = (IconsListWSProxy)CurrentProxyFactory.getProxy(IconsList.class);
                IconsListSearchCriteria sc2 = new IconsListSearchCriteria();
                sc2.setIdList(icIds.toArray(new Long[icIds.size()]));
                Object[] o1 = proxy2.getListWithUrl(InitializedVariable.context, sc2).getObjList();
                if (o1 != null) {
                    Arrays.asList((Object[])o1).forEach(o2 -> {
                        IconsList i = (IconsList)o2;
                        node.getListObject().stream().filter(sg -> i.getId().equals(sg.getIco().getId())).forEach(g -> g.setIcon(i.getIconName()));
                    });
                }
            }
            for (GeoObjectExt e : node.getListObject()) {
                this.geomsG.put(e.getId(), e);
            }
        }
        node.setSelectWithoutChildren(true);
        for (TreeNode n : node.listChild) {
            this.onn((GeoObjectGroupNode)n);
        }
    }

    protected void addMinMaxPGO(GeoObjectExt n, Double[] latlon) {
        if (n.getCurrentPolygon() != null) {
            int i = 0;
            while (i < n.getCurrentPolygon().numPoints()) {
                Point d = n.getCurrentPolygon().getPoint(i);
                if (latlon[0] == null || d.getY() < latlon[0]) {
                    latlon[0] = d.getY();
                }
                if (latlon[1] == null || d.getY() > latlon[1]) {
                    latlon[1] = d.getY();
                }
                if (latlon[2] == null || d.getX() < latlon[2]) {
                    latlon[2] = d.getX();
                }
                if (latlon[3] == null || d.getX() > latlon[3]) {
                    latlon[3] = d.getX();
                }
                ++i;
            }
        }
    }

    public void getMinMaxPGOR(GeoObjectGroupNode node, Double[] latlon) {
        if (node.getType() == GeoObjectGroupNode.Group) {
            for (GeoObjectExt g : node.getListObject()) {
                if (!this.geomsG.containsKey(g.getId())) continue;
                this.addMinMaxPGO(g, latlon);
            }
        } else {
            for (TreeNode n : node.getChildrenFromPersistence()) {
                this.getMinMaxPGOR((GeoObjectGroupNode)n, latlon);
            }
        }
    }

    public Double[] getMinMaxPGO(GeoObjectGroupNode node) {
        if (!this.initG) {
            return null;
        }
        Double[] latlon = new Double[4];
        this.getMinMaxPGOR(node, latlon);
        if (latlon[0] == null) {
            return null;
        }
        return latlon;
    }

    public void positionOnFullListPGO() {
        if (this.value != null && this.value.mapViewer != null) {
            this.value.mapViewer.zoomToTracks(this.getMinMaxPGO(this.nodePGO));
        }
    }

    public void positionOnselectGroupPGO(GeoObjectGroupNode node) {
        if (this.value != null && this.value.mapViewer != null) {
            this.value.mapViewer.zoomToTracks(this.getMinMaxPGO(node));
        }
    }

    public void onOff(GeoObjectGroupNode node) {
        if (node.isSelect()) {
            this.off(node);
            this.positionOnFullListPGO();
        } else {
            this.onn(node);
            this.positionOnselectGroupPGO(node);
        }
        this.pc.getPanel().updateUIForPresentatorName("value");
    }

    protected void addMinMax(RoadTreeNode n, Double[] latlon) {
        if (n.getCurrentPolygon() != null) {
            int i = 0;
            while (i < n.getCurrentPolygon().numPoints()) {
                Point d = n.getCurrentPolygon().getPoint(i);
                if (latlon[0] == null || d.getY() < latlon[0]) {
                    latlon[0] = d.getY();
                }
                if (latlon[1] == null || d.getY() > latlon[1]) {
                    latlon[1] = d.getY();
                }
                if (latlon[2] == null || d.getX() < latlon[2]) {
                    latlon[2] = d.getX();
                }
                if (latlon[3] == null || d.getX() > latlon[3]) {
                    latlon[3] = d.getX();
                }
                ++i;
            }
        }
    }

    public void getMinMaxRoadR(RoadTreeNode node, Double[] latlon) {
        if (this.roadTNode.values().contains((Object)node)) {
            this.addMinMax(node, latlon);
        }
        for (TreeNode n : node.getChildrenFromPersistence()) {
            this.getMinMaxRoadR((RoadTreeNode)n, latlon);
        }
    }

    public Double[] getMinMaxRoad(RoadTreeNode node) {
        if (!this.initR) {
            return null;
        }
        Double[] latlon = new Double[4];
        this.getMinMaxRoadR(node, latlon);
        if (latlon[0] == null) {
            return null;
        }
        return latlon;
    }

    public void positionOnFullListRoad() {
        if (this.value != null && this.value.mapViewer != null) {
            this.value.mapViewer.zoomToTracks(this.getMinMaxRoad(this.nodeRoad));
        }
    }

    public void positionOnselectGroupRoad(RoadTreeNode node) {
        if (this.value != null && this.value.mapViewer != null) {
            this.value.mapViewer.zoomToTracks(this.getMinMaxRoad(node));
        }
    }

    @Override
    public boolean isSelect() {
        return this.select;
    }

    @Override
    public void setSelect(boolean select) {
        this.select = select;
    }

    public void onClose() {
        this.needconnected = true;
        System.out.println("onClose");
    }

    static class TimerUpdateStateTask
    extends TimerTask {
        ControlDDH i;

        public TimerUpdateStateTask(ControlDDH i) {
            this.i = i;
        }

        @Override
        public void run() {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            Long time = (long)(((MapPropertiesUIControlDDh)this.i.value.mapViewer.getUIProperties()).getTimeStop() * 60) * 1000L;
            Color color = new Color(((MapPropertiesUIControlDDh)this.i.value.mapViewer.getUIProperties()).getTimeStopColor());
            Integer dd = ((MapPropertiesUIControlDDh)this.i.value.mapViewer.getUIProperties()).getTypeDisappearanceTrack();
            Long tail = (long)(((MapPropertiesUIControlDDh)this.i.value.mapViewer.getUIProperties()).getTimeLengthTail() * 60) * 1000L;
            Integer lTS = ((MapPropertiesUIControlDDh)this.i.value.mapViewer.getUIProperties()).getLifetimeTS();
            Long lifetimeTS = 0L;
            if (lTS > 0) {
                lifetimeTS = (long)(lTS * 60) * 1000L;
            }
            for (TransportToView w : this.i.view.values()) {
                if (w.getData() != null && c.getTime().getTime() - w.getData().getData().getCreatedDateTime().getTime() > time && !w.longtimestop) {
                    w.longtimestop = true;
                    w.setColor(color);
                    this.i.value.change();
                }
                if (dd == 0) {
                    while (w.getOld().size() > 0 && c.getTime().getTime() - w.getOld().get(0).getData().getCreatedDateTime().getTime() > tail) {
                        w.getOld().remove(0);
                    }
                } else if (w.getOld().size() > 0 && c.getTime().getTime() - w.getOld().get(0).getData().getCreatedDateTime().getTime() > 2L * tail) {
                    while (w.getOld().size() > 0 && c.getTime().getTime() - w.getOld().get(0).getData().getCreatedDateTime().getTime() > tail) {
                        w.getOld().remove(0);
                    }
                }
                if (lifetimeTS <= 0L || w.getData() == null || c.getTime().getTime() - w.getData().getData().getCreatedDateTime().getTime() <= lifetimeTS) continue;
                TransportTreeNode tt = this.i.transportNode.get(w.getId());
                this.i.onOff(tt);
            }
        }
    }

    static class TimerUpdateStateTask2
    extends TimerTask {
        ControlDDH i;

        public TimerUpdateStateTask2(ControlDDH i) {
            this.i = i;
        }

        @Override
        public void run() {
            if (this.i.needconnected) {
                this.i.connected();
            }
        }
    }
}

