/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.controlddh;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.controlddh.CloseTrackAll;
import ru.blok.vms.ui.controlddh.executedworks.ExecutedWorks;
import ru.blok.vms.ui.controlddh.map.MapViewerWithOneTrackDDH;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.tracks.ChangeDeviceInTrackAll;
import ru.blok.vms.ui.tracks.TrackAll;
import ru.blok.vms.ui.transport.TransportDirectoryViewer;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.ActionCalculatedObject;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.RadioButtonViewer;
import ru.infor.client.soap.proxy.vms.TransportWSProxy;
import ru.infor.ws.objects.vms.NDDataSearchCriteria;
import ru.infor.ws.objects.vms.RoadJobKindWithWork;
import ru.infor.ws.objects.vms.TransportUI;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.RoadJobKind;
import ru.infor.ws.objects.vms.entities.Transport;

@ListView(views={@View(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0432\u0441\u0435\u0433\u043e \u043f\u0443\u0442\u0438", actions={@ActionViewer(clazz=CloseTrackAll.class)}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class TrackAllDDH
extends TrackAll {
    private String type = ExecutedWorks.Hour3;
    TransportWSProxy transportWSProxy = (TransportWSProxy)CurrentProxyFactory.getProxy(Transport.class, (String)this.getKeyPage());
    HashMap<Long, RoadJobKind[]> mapWorks = new HashMap();

    public TrackAllDDH(String keyPage, TransportUI transport) {
        super(keyPage);
        this.setTransportUI(transport);
        this.getValue().setMain((Object)this);
    }

    @ListField(fields={@Field(title="", order=5, viewer={TypeViewer.class}, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f:m/wrap 1:Tab2/\u041e\u0431\u0449\u0430\u044f:0/fillx/n/#spanx,wrap#spanx, wrap", changeAction={ChangeType.class})})
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    protected synchronized void loadData() {
        if (!ExecutedWorks.period.equals(this.type)) {
            this.dateTill = new Date();
            Calendar c = Calendar.getInstance();
            c.setTime(this.dateTill);
            int hour = -3;
            if (ExecutedWorks.Hour6.equals(this.type)) {
                hour = -6;
            } else if (ExecutedWorks.Hour9.equals(this.type)) {
                hour = -9;
            }
            c.add(11, hour);
            this.dateFrom = c.getTime();
        }
        super.loadData();
    }

    @Override
    @ListField(fields={@Field(title="", order=500, viewer={MapViewerWithOneTrackDDH.class}, propertiesLayout="Scroll1:Split1/h/r/0.2:Scroll1:Split1/v/l/0.8")})
    public MapValueWithTrack getValue() {
        return super.getValue();
    }

    @Override
    @ListField(fields={@Field(title="\u0422\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442 ", readOnly=true, content=Transport.class, order=50, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f:m:Tab2/\u041e\u0431\u0449\u0430\u044f:2///#w 300, wrap", viewer={TransportDirectoryViewer.class}, changeAction={ChangeDeviceInTrackAll.class})})
    public Transport getTransport() {
        return super.getTransport();
    }

    public HashMap<Long, RoadJobKind[]> getMapWorks() {
        return this.mapWorks;
    }

    @Override
    public synchronized void reload(List<AbstractNDData> list1) {
        super.reload(list1);
        this.mapWorks.clear();
        if (list1 != null && list1.size() > 0) {
            NDDataSearchCriteria sc = new NDDataSearchCriteria();
            sc.setTransportId(this.getTransport().getId());
            sc.setCreatedDateTimeFrom(list1.get(0).getCreatedDateTime());
            sc.setCreatedDateTimeTill(list1.get(list1.size() - 1).getCreatedDateTime());
            sc.setIdList((Long[])list1.stream().map(d -> d.getId()).toArray(Long[]::new));
            sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
            Object[] w = this.transportWSProxy.executionOfWorksOverPeriod(InitializedVariable.context, sc);
            if (w != null) {
                Arrays.asList((Object[])w).stream().forEach(t -> {
                    RoadJobKindWithWork w1 = (RoadJobKindWithWork)t;
                    this.mapWorks.put(w1.getNddataId(), w1.getJob());
                });
            }
        }
    }

    public static class ChangeType
    extends ActionCalculatedObject {
        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateField(((ViewerContext)this.getContext()).getPresentator());
            Object o = ((ViewerContext)this.getContext()).getPresentator().getViewer().getValue();
            boolean rt = true;
            if (ExecutedWorks.period.equals(o)) {
                rt = false;
            }
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("dateFrom").getViewer().setEditable(!rt);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("timeFrom").getViewer().setEditable(!rt);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("dateTill").getViewer().setEditable(!rt);
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getPresentatorForName("timeTill").getViewer().setEditable(!rt);
        }
    }

    public static class TypeViewer<T>
    extends RadioButtonViewer<T> {
        List<String> l;

        public TypeViewer(UIFactory<T> factory) {
            super(factory);
        }

        public List<?> getRadioElement() {
            this.l = new ArrayList<String>();
            this.l.add(ExecutedWorks.Hour3);
            this.l.add(ExecutedWorks.Hour6);
            this.l.add(ExecutedWorks.Hour9);
            this.l.add(ExecutedWorks.period);
            return this.l;
        }
    }
}

