/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.controlddh.executedworks;

import java.util.List;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.controlddh.executedworks.ExecutedWorks;
import ru.blok.vms.ui.controlddh.executedworks.MapViewer;
import ru.blok.vms.ui.mapviewer.MapValue;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;

public class MapValueWork
extends MapValue
implements IMapValue {
    public MapViewer mapViewer;
    ExecutedWorks information;

    public MapValueWork(double lat, double lon, int zoom) {
        super(lat, lon, zoom);
    }

    public ExecutedWorks getInformation() {
        return this.information;
    }

    public void setInformation(ExecutedWorks information) {
        this.information = information;
    }

    public void change() {
        if (this.mapViewer != null) {
            this.mapViewer.repaint();
        }
    }

    public void center(GeoPosition gp) {
        if (gp != null) {
            this.mapViewer.setCenterPosition(new double[]{gp.getLatitude(), gp.getLongitude()});
        }
    }

    public void init(List<GeoPosition> gpl) {
        if (gpl == null || gpl.size() == 0) {
            this.mapViewer.zoomToTracks();
        } else {
            Double minLat = null;
            Double maxLat = null;
            Double minLon = null;
            Double maxLon = null;
            for (GeoPosition d : gpl) {
                if (d == null) continue;
                if (minLat == null || d.getLatitude() < minLat) {
                    minLat = d.getLatitude();
                }
                if (maxLat == null || d.getLatitude() > maxLat) {
                    maxLat = d.getLatitude();
                }
                if (minLon == null || d.getLongitude() < minLon) {
                    minLon = d.getLongitude();
                }
                if (maxLon != null && !(d.getLongitude() > maxLon)) continue;
                maxLon = d.getLongitude();
            }
            if (minLat != null) {
                this.mapViewer.zoomToTracks(new Double[]{minLat, maxLat, minLon, maxLon});
            } else {
                this.mapViewer.zoomToTracks();
            }
        }
    }
}

