/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.controlddh.executedworks;

import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import org.postgis.Geometry;
import org.postgis.Point;
import ru.blok.vms.ui.controlddh.executedworks.MapPropertiesUIColor;
import ru.blok.vms.ui.controlddh.executedworks.MapValueWork;
import ru.blok.vms.ui.controlddh.executedworks.RoadPainter2;
import ru.blok.vms.ui.mapviewer.ui.DefaultProvider;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.ws.objects.vms.WorksOnMaintenanceOfRoads;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

public class MapViewer
extends ru.blok.vms.ui.mapviewer.MapViewer {
    RoadPainter2<JXMapViewer> painterRoads;
    MapValueWork value;
    MapPropertiesUIColor prop;

    public MapViewer(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    protected void init() {
        super.init();
        this.map.getMiniMap().setVisible(false);
        this.painterRoads = new RoadPainter2();
        this.painter.addPainter(this.painterRoads);
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    protected void addMinMax(Geometry n, Double[] latlon) {
        if (n != null) {
            int i = 0;
            while (i < n.numPoints()) {
                Point d = n.getPoint(i);
                if (latlon[0] == null || d.getY() < latlon[0]) {
                    latlon[0] = d.getY();
                }
                if (latlon[1] == null || d.getY() > latlon[1]) {
                    latlon[1] = d.getY();
                }
                if (latlon[2] == null || d.getX() < latlon[2]) {
                    latlon[2] = d.getX();
                }
                if (latlon[3] == null || d.getX() > latlon[3]) {
                    latlon[3] = d.getX();
                }
                ++i;
            }
        }
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.value != null && this.value.information.getMaintenanceOfRoads() != null) {
            WorksOnMaintenanceOfRoads[] worksOnMaintenanceOfRoadsArray = this.value.information.getMaintenanceOfRoads();
            int n = worksOnMaintenanceOfRoadsArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorksOnMaintenanceOfRoads p = worksOnMaintenanceOfRoadsArray[n2];
                Geometry g1 = ((RoadWAExt)p.getRoad()).getCurrentPolygon();
                Double[] d = new Double[4];
                this.addMinMax(g1, d);
                if (minLat == null || d[0] < minLat) {
                    minLat = d[0];
                }
                if (maxLat == null || d[1] > maxLat) {
                    maxLat = d[1];
                }
                if (minLon == null || d[2] < minLon) {
                    minLon = d[2];
                }
                if (maxLon == null || d[3] > maxLon) {
                    maxLon = d[3];
                }
                ++n2;
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            ((MapValueWork)value).mapViewer = this;
        }
        this.value = (MapValueWork)value;
        super.setValue(this.value);
        if (this.value != null) {
            this.painterRoads.setWorks(this.value.information);
        }
        this.zoomToTracks();
    }

    @Override
    public Object getUIProperties() {
        if (this.prop == null) {
            this.prop = new MapPropertiesUIColor();
            this.prop.setProvidersInfo(DefaultProvider.getDefaultProviderInfo());
        }
        return this.prop;
    }

    @Override
    public Class<?> getUIPropertiesClass() {
        return MapPropertiesUIColor.class;
    }

    @Override
    public void setUIProperties(Object viewerProperty) {
        if (viewerProperty instanceof MapPropertiesUIColor) {
            this.prop = (MapPropertiesUIColor)viewerProperty;
            super.setUIProperties(viewerProperty);
        }
    }
}

