/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.controlddh.map;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.net.URI;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import org.jxmapviewer.JXMapViewer;
import ru.blok.vms.ui.controlddh.map.MapValueTransport;
import ru.blok.vms.ui.controlddh.map.NewRoadPainter;
import ru.blok.vms.ui.controlddh.map.PGOPainter;
import ru.blok.vms.ui.controlddh.map.PainterData;
import ru.blok.vms.ui.controlddh.map.TransportToView;
import ru.blok.vms.ui.controlddh.prop.MapPropertiesUIControlDDh;
import ru.blok.vms.ui.controlddh.tree.RoadTreeNode;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.ui.DefaultProvider;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.ws.objects.geo.entities.ext.GeoObjectExt;
import ru.infor.ws.objects.vms.entities.NDData;

public class MapViewer
extends ru.blok.vms.ui.mapviewer.MapViewer {
    JInternalFrame f;
    protected MapViewPainter<JXMapViewer> painterData;
    NewRoadPainter<JXMapViewer> painterRoads;
    PGOPainter<JXMapViewer> pgoPainter;
    MapValueTransport value;
    MapPropertiesUIControlDDh prop;

    public MapViewer(UIFactory<JComponent> factory) {
        super(factory);
    }

    protected void initPainterData() {
        this.painterData = new PainterData<JXMapViewer>();
        this.painter.addPainter(this.painterData);
    }

    @Override
    protected void init() {
        super.init();
        this.initPainterData();
        this.map.getMiniMap().setVisible(false);
        this.painterRoads = new NewRoadPainter();
        this.painter.addPainter(this.painterRoads);
        this.pgoPainter = new PGOPainter();
        this.painter.addPainter(this.pgoPainter);
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MapViewer.this.mouseClickedOnMap(e);
            }
        });
        this.f = new JInternalFrame();
        this.f.setSize(new Dimension(500, 100));
        this.f.setClosable(true);
        this.f.setDefaultCloseOperation(1);
    }

    @Override
    protected void mouseMovedN(MouseEvent e) {
    }

    @Override
    protected void mouseWheelMovedN(MouseWheelEvent e) {
    }

    protected void mouseClickedOnMap(MouseEvent e) {
        if (e.getClickCount() == 1) {
            boolean b;
            Rectangle viewportBounds = this.map.getMainMap().getViewportBounds();
            int zoom = this.map.getMainMap().getZoom();
            Dimension sizeInTiles = this.map.getMainMap().getTileFactory().getMapSize(zoom);
            int tileSize = this.map.getMainMap().getTileFactory().getTileSize(zoom);
            Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
            double vpx = viewportBounds.getX();
            while (vpx < 0.0) {
                vpx += sizeInPixels.getWidth();
            }
            while (vpx > sizeInPixels.getWidth()) {
                vpx -= sizeInPixels.getWidth();
            }
            Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
            double x = this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - (double)(this.map.getMainMap().getWidth() / 2);
            double y = this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - (double)(this.map.getMainMap().getHeight() / 2);
            Point2D.Double pClick = new Point2D.Double(x - ((RectangularShape)vp2).getX(), y - ((RectangularShape)vp2).getY());
            Point2D.Double pClick2 = new Point2D.Double(x, y);
            for (RoadTreeNode roadTreeNode : this.value.getInformation().geoms.values()) {
                b = false;
                List<Shape> l = roadTreeNode.getListP();
                if (l == null) continue;
                for (Shape p : l) {
                    if (!p.contains(pClick)) continue;
                    b = true;
                }
                if (!b) continue;
                this.value.getInformation().setSelectedRoad(roadTreeNode.getRoadWAUI().getId(), null);
                break;
            }
            for (GeoObjectExt geoObjectExt : this.value.getInformation().geomsG.values()) {
                b = this.pgoPainter.include(pClick2, geoObjectExt, this.map.getMainMap());
                if (!b) continue;
                try {
                    if (geoObjectExt.getUrl() == null || "".equals(geoObjectExt.getUrl())) break;
                    Desktop.getDesktop().browse(new URI(geoObjectExt.getUrl()));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                break;
            }
        }
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.value != null) {
            for (TransportToView w : this.value.getInformation().view.values()) {
                if (w.getData() == null) continue;
                NDData d = w.getData().getData();
                if (minLat == null || d.getLat() < minLat) {
                    minLat = d.getLat();
                }
                if (maxLat == null || d.getLat() > maxLat) {
                    maxLat = d.getLat();
                }
                if (minLon == null || d.getLon() < minLon) {
                    minLon = d.getLon();
                }
                if (maxLon != null && !(d.getLon() > maxLon)) continue;
                maxLon = d.getLon();
            }
            Double[] d = this.value.getInformation().getMinMaxRoad(this.value.getInformation().getNodeRoad());
            if (d != null) {
                if (minLat != null && d[0] > minLat) {
                    d[0] = minLat;
                }
                if (maxLat != null && d[1] < maxLat) {
                    d[1] = maxLat;
                }
                if (minLon != null && d[2] > minLon) {
                    d[2] = minLon;
                }
                if (maxLon != null && d[3] < maxLon) {
                    d[3] = maxLon;
                }
                return d;
            }
            d = this.value.getInformation().getMinMaxPGO(this.value.getInformation().getNodePGO());
            if (d != null) {
                if (minLat != null && d[0] > minLat) {
                    d[0] = minLat;
                }
                if (maxLat != null && d[1] < maxLat) {
                    d[1] = maxLat;
                }
                if (minLon != null && d[2] > minLon) {
                    d[2] = minLon;
                }
                if (maxLon != null && d[3] < maxLon) {
                    d[3] = maxLon;
                }
                return d;
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (value != null) {
            ((MapValueTransport)value).mapViewer = this;
        }
        this.value = (MapValueTransport)value;
        super.setValue(this.value);
        this.painterData.setValue(this.value);
        if (this.value != null) {
            this.painterRoads.setControlDDh(this.value.information);
            this.pgoPainter.setControlDDh(this.value.information);
        }
        this.zoomToTracks();
    }

    @Override
    public Object getUIProperties() {
        if (this.prop == null) {
            this.prop = new MapPropertiesUIControlDDh();
            this.prop.setProvidersInfo(DefaultProvider.getDefaultProviderInfo());
        }
        return this.prop;
    }

    @Override
    public Class<?> getUIPropertiesClass() {
        return MapPropertiesUIControlDDh.class;
    }

    @Override
    public void setUIProperties(Object viewerProperty) {
        if (viewerProperty instanceof MapPropertiesUIControlDDh) {
            this.prop = (MapPropertiesUIControlDDh)viewerProperty;
        }
        super.setUIProperties(viewerProperty);
    }
}

