/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.controlddh.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.postgis.Geometry;
import ru.blok.vms.ui.controlddh.ControlDDH;
import ru.blok.vms.ui.controlddh.tree.RoadTreeNode;
import ru.blok.vms.ui.route.routegeom.NewRoutePainter;

public class NewRoadPainter<T extends JXMapViewer>
extends NewRoutePainter<JXMapViewer> {
    ControlDDH controlDDh;

    public void setControlDDh(ControlDDH controlDDh) {
        this.controlDDh = controlDDh;
    }

    @Override
    public void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.controlDDh != null && this.controlDDh.geoms.size() > 0) {
            for (RoadTreeNode p : this.controlDDh.geoms.values()) {
                Geometry g1 = p.getCurrentPolygon();
                Color c = Color.RED;
                if (p.getColor() != null) {
                    c = new Color(p.getColor());
                }
                int i = 150;
                if (p.isSelectOnMap()) {
                    i = 200;
                }
                List<Shape> listp = NewRoadPainter.paintPolygon(g1, map, g, (Rectangle2D)vp2, c, i);
                p.setListP(listp);
            }
        }
    }
}

