/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.controlddh.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jxmapviewer.JXMapViewer;
import ru.blok.vms.ui.controlddh.TrackAllDDH;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.NodePainterDataTraclAll;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.Utils;
import ru.blok.vms.ui.tracks.TrackInRealTime2;
import ru.infor.ws.objects.draw.entities.TrackLineUI;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.RoadJobKind;

public class NodePainterDataTraclAllDDH<T extends JXMapViewer>
extends NodePainterDataTraclAll<T> {
    protected void paint(Point2D pointFrom, Point2D point, JXMapViewer map, Graphics2D g, Rectangle2D vp2, RoadJobKind[] r) {
        if (r != null) {
            int p = 3;
            int n = r.length / 2 * p;
            BasicStroke s = new BasicStroke(2.0f, 1, 0, 10.0f, null, 0.0f);
            g.setStroke(s);
            int i = 0;
            while (i < r.length) {
                Color c = new Color(r[i].getColor());
                g.setColor(c);
                double y = point.getY() - pointFrom.getY();
                double x = point.getX() - pointFrom.getX();
                double sina = y / Math.sqrt(x * x + y * y);
                double a = Math.asin(sina);
                double dd = Math.abs(Math.sin(a) - Math.cos(a));
                if (dd < 0.2) {
                    double dd1 = Math.abs(Math.sin(a + 0.5235987755982988) - Math.cos(a + 0.5235987755982988));
                    a = dd1 > dd ? (a += 0.5235987755982988) : (a -= 0.5235987755982988);
                }
                g.drawLine((int)(point.getX() - vp2.getX() - (double)(n + i * p) * Math.sin(a)), (int)(point.getY() - vp2.getY() - (double)(n + i * p) * Math.cos(a)), (int)(pointFrom.getX() - vp2.getX() - (double)(n + i * p) * Math.sin(a)), (int)(pointFrom.getY() - vp2.getY() - (double)(n + i * p) * Math.cos(a)));
                ++i;
            }
        }
    }

    @Override
    protected Polygon paintLine(JXMapViewer map, Graphics2D g, TrackLineUI tUI, AbstractNDData data1, AbstractNDData data2, Point2D point1, Point2D point2, Rectangle2D vp, boolean select, boolean st) {
        Color c = new Color(Utils.getColorWithConditions(data1, data2, tUI.getColorConditions(), tUI.getColorLine()));
        float w = Utils.getFloatWithConditions(data1, data2, tUI.getWidthConditions(), tUI.getWidth()).floatValue();
        Float[] d = Utils.getFloatArrayWithConditions(data1, data2, tUI.getDashConditions(), tUI.getDash());
        Integer o = Utils.getIntegerWithConditions(data1, data2, tUI.getOpaqueConditions(), tUI.getOpaque());
        float[] ff = null;
        if (d != null) {
            ff = new float[d.length];
            int i = 0;
            while (i < d.length) {
                ff[i] = d[i].floatValue();
                ++i;
            }
        }
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue(), o);
        if (select) {
            cc = cc.darker().darker();
            w += 5.0f;
        }
        BasicStroke s = new BasicStroke(w, 1, 0, 10.0f, ff, 0.0f);
        g.setColor(cc);
        g.setStroke(s);
        TrackAllDDH ddh = (TrackAllDDH)((Object)this.value.getMain());
        RoadJobKind[] r = ddh.getMapWorks().get(data2.getId());
        if (r == null) {
            g.drawLine((int)(point1.getX() - vp.getX()), (int)(point1.getY() - vp.getY()), (int)(point2.getX() - vp.getX()), (int)(point2.getY() - vp.getY()));
        } else {
            this.paint(point1, point2, map, g, vp, r);
        }
        Polygon p1 = new Polygon();
        p1.addPoint((int)(point2.getX() - 5.0), (int)(point2.getY() + 5.0));
        p1.addPoint((int)(point2.getX() + 5.0), (int)(point2.getY() - 5.0));
        p1.addPoint((int)(point1.getX() + 5.0), (int)(point1.getY() - 5.0));
        p1.addPoint((int)(point1.getX() - 5.0), (int)(point1.getY() + 5.0));
        if (st) {
            Double angle = TrackInRealTime2.getAngle(data1, data2);
            this.paintS(g, point2, angle, cc, cc.darker().darker(), vp);
        }
        return p1;
    }
}

