/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.controlddh.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.Point;
import ru.blok.vms.ui.controlddh.ControlDDH;
import ru.blok.vms.ui.route.routegeom.NewRoutePainter;
import ru.infor.ws.objects.geo.entities.ext.GeoObjectExt;

public class PGOPainter<T extends JXMapViewer>
extends NewRoutePainter<JXMapViewer> {
    ControlDDH controlDDh;

    public void setControlDDh(ControlDDH controlDDh) {
        this.controlDDh = controlDDh;
    }

    @Override
    public void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        if (this.controlDDh != null && this.controlDDh.geomsG.size() > 0) {
            for (GeoObjectExt p : this.controlDDh.geomsG.values()) {
                Point2D point;
                if (p.getType() != 0) {
                    Geometry g1 = p.getCurrentPolygon();
                    Color c = Color.RED;
                    if (p.getFillColor() != null) {
                        c = new Color(p.getFillColor());
                    }
                    int i = 150;
                    if (g1 != null) {
                        PGOPainter.paintPolygon(g1, map, g, (Rectangle2D)vp2, c, i);
                    }
                }
                GeoPosition gp = null;
                if (p.getLat() != null) {
                    gp = new GeoPosition(p.getLat().doubleValue(), p.getLon().doubleValue());
                } else if (p.getCurrentPolygon() != null) {
                    Point pp = p.getCurrentPolygon().getFirstPoint();
                    gp = new GeoPosition(pp.getY(), pp.getX());
                }
                if (gp == null || !vp2.contains(point = map.getTileFactory().geoToPixel(gp, map.getZoom()))) continue;
                int x = (int)(point.getX() - ((RectangularShape)vp2).getX());
                int y = (int)(point.getY() - ((RectangularShape)vp2).getY());
                if (p.getImg1() != null) {
                    g.drawImage(p.getImg1(), x, y, (ImageObserver)map);
                } else {
                    try {
                        if (p.getIcon() != null) {
                            BufferedImage img1 = ImageIO.read(new URL(p.getIcon()));
                            g.drawImage((Image)img1, x, y, (ImageObserver)map);
                            p.setImg1(img1);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                g.setColor(Color.BLACK);
                g.drawString(p.getTitle(), x, y + (p.getImg1() == null ? 0 : p.getImg1().getHeight(null)) + 10);
            }
        }
    }

    public boolean include(Point2D pClick, GeoObjectExt p, JXMapViewer map) {
        GeoPosition gp = null;
        if (p.getLat() != null) {
            gp = new GeoPosition(p.getLat().doubleValue(), p.getLon().doubleValue());
        } else if (p.getCurrentPolygon() != null) {
            Point pp = p.getCurrentPolygon().getFirstPoint();
            gp = new GeoPosition(pp.getY(), pp.getX());
        }
        if (gp != null && p.getImg1() != null) {
            Point2D point = map.getTileFactory().geoToPixel(gp, map.getZoom());
            Point2D.Double p2 = new Point2D.Double(pClick.getX() - point.getX(), pClick.getY() - point.getY());
            if (((Point2D)p2).getX() < (double)p.getImg1().getWidth((ImageObserver)map) && ((Point2D)p2).getY() < (double)p.getImg1().getHeight((ImageObserver)map)) {
                return true;
            }
        }
        return false;
    }
}

