/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.controlddh.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.transcoder.TranscoderException;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.controlddh.map.MapValueTransport;
import ru.blok.vms.ui.controlddh.map.PointData;
import ru.blok.vms.ui.controlddh.map.TransportToView;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;

public class PainterData<T extends JXMapViewer>
extends MapViewPainter<T> {
    MapValueTransport value;

    protected void paint(Point2D pointFrom, Point2D point, T map, Graphics2D g, Rectangle2D vp2, PointData data) {
        if (data.getJob() != null) {
            int p = 4;
            int n = data.getJob().length / 2 * p;
            BasicStroke s = new BasicStroke(2.0f, 1, 0, 10.0f, null, 0.0f);
            g.setStroke(s);
            int i = 0;
            while (i < data.getJob().length) {
                Color c = new Color(data.getJob()[i].getColor());
                g.setColor(c);
                double y = point.getY() - pointFrom.getY();
                double x = point.getX() - pointFrom.getX();
                double sina = y / Math.sqrt(x * x + y * y);
                double a = Math.asin(sina);
                double dd = Math.abs(Math.sin(a) - Math.cos(a));
                if (dd < 0.2) {
                    double dd1 = Math.abs(Math.sin(a + 0.5235987755982988) - Math.cos(a + 0.5235987755982988));
                    a = dd1 > dd ? (a += 0.5235987755982988) : (a -= 0.5235987755982988);
                }
                g.drawLine((int)(point.getX() - vp2.getX() - (double)(n + i * p) * Math.sin(a)), (int)(point.getY() - vp2.getY() - (double)(n + i * p) * Math.cos(a)), (int)(pointFrom.getX() - vp2.getX() - (double)(n + i * p) * Math.sin(a)), (int)(pointFrom.getY() - vp2.getY() - (double)(n + i * p) * Math.cos(a)));
                ++i;
            }
        }
    }

    private void paintTrack(List<PointData> list, T map, Graphics2D g, Rectangle2D vp2) {
        if (list != null && list.size() > 0) {
            int from = 0;
            Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(list.get(from).getData().getLat().doubleValue(), list.get(from).getData().getLon().doubleValue()), map.getZoom());
            int i = 1;
            while (i < list.size()) {
                Point2D pointTo = map.getTileFactory().geoToPixel(new GeoPosition(list.get(i).getData().getLat().doubleValue(), list.get(i).getData().getLon().doubleValue()), map.getZoom());
                this.paint(pointFrom, pointTo, map, g, vp2, list.get(i));
                from = i++;
                pointFrom = pointTo;
            }
        }
    }

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        TransportToView wsel = null;
        if (this.value != null) {
            for (TransportToView w : this.value.getInformation().view.values()) {
                if (w.isSelect()) {
                    wsel = w;
                    continue;
                }
                if (w.getData() == null) continue;
                try {
                    if (w.getComponent().getParent() == null) {
                        map.add((Component)w.getComponent());
                        if (w.getData() != null && w.getData().getData().getDirection() != null) {
                            w.setAngle(w.getData().getData().getDirection());
                        }
                    }
                    this.paintTrack(w.old, map, g, vp2);
                    this.paintImage(g, map, w, w.getH(), w.getW(), vp2);
                }
                catch (TranscoderException e) {
                    e.printStackTrace();
                }
            }
        }
        if (wsel != null && wsel.getData() != null) {
            try {
                if (wsel.getComponent().getParent() == null) {
                    map.add((Component)wsel.getComponent());
                    if (wsel.getData() != null && wsel.getData().getData().getDirection() != null) {
                        wsel.setAngle(wsel.getData().getData().getDirection());
                    }
                }
                if (wsel.getComponentH().getParent() == null) {
                    map.add((Component)wsel.getComponentH());
                }
                this.paintTrack(wsel.old, map, g, vp2);
                this.paintImage(g, map, wsel, wsel.getH(), wsel.getW(), vp2);
            }
            catch (TranscoderException e) {
                e.printStackTrace();
            }
        }
    }

    public void paintImage(Graphics2D g, T map, TransportToView wv, int h, int w, Rectangle2D vp2) throws TranscoderException {
        GeoPosition gp = wv.getGeoposition();
        Point2D point = map.getTileFactory().geoToPixel(gp, map.getZoom());
        int x = (int)(point.getX() - vp2.getX());
        int y = (int)(point.getY() - vp2.getY());
        JSVGCanvas canvas = (JSVGCanvas)wv.getComponent();
        Dimension2D d = canvas.getSVGDocumentSize();
        if (d == null) {
            d = canvas.getSize();
        }
        wv.resize();
        Point pt = new Point(x - (int)d.getWidth() / 2, y - (int)d.getHeight() / 2);
        map.setComponentZOrder((Component)canvas, map.getComponentCount() - 1);
        canvas.setLocation(pt);
        JSVGCanvas canvas2 = (JSVGCanvas)wv.getComponentH();
        if (wv.isSelect()) {
            wv.resize2();
            pt = new Point(x - wv.getComponent().getWidth() / 2, y - wv.getComponentH().getHeight() + 20);
            map.setComponentZOrder((Component)canvas, 0);
            map.setComponentZOrder((Component)canvas2, 1);
            canvas2.setLocation(pt);
            canvas2.setVisible(true);
        } else {
            canvas2.setVisible(false);
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.value = (MapValueTransport)mapValueWithTrack;
    }
}

