/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.controlddh.map;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.batik.dom.GenericText;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherAdapter;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jxmapviewer.viewer.GeoPosition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;
import ru.blok.vms.ui.controlddh.ControlDDH;
import ru.blok.vms.ui.controlddh.map.PointData;
import ru.blok.vms.ui.schoolbus.ControlBus;
import ru.infor.common.SysProperties;
import ru.infor.ws.objects.vms.TransportUI;
import ru.infor.ws.objects.vms.entities.Request4PlannedRerouting;
import ru.infor.ws.objects.vms.entities.ext.RouteExt;

public class TransportToView {
    public static String svgPrefix = "";
    public static String prefix = "/data";
    static String image;
    static String imageH;
    static String imageG;
    protected Long id;
    protected TransportUI object;
    protected SVGDocument doc;
    protected SVGDocument docH;
    protected List<SVGDocument> docH2 = new ArrayList<SVGDocument>();
    protected int h = 30;
    protected int w = 20;
    protected boolean show = true;
    protected boolean select = false;
    protected JSVGCanvas canvas;
    protected JSVGCanvas canvasH;
    protected List<JSVGCanvas> canvasH2 = new ArrayList<JSVGCanvas>();
    protected RunnableQueue queue;
    protected RunnableQueue queue2;
    protected boolean onClickWasSet = false;
    protected ControlDDH controlDDH;
    public boolean longtimestop = false;
    protected int sizeR = 20;
    PointData data;
    boolean arrow = true;
    List<PointData> old = new ArrayList<PointData>();
    public DecimalFormat defs = new DecimalFormat("###0.##");
    String icon;
    Integer size;
    Integer typev = 0;
    List<GeoPosition> target = new ArrayList<GeoPosition>();
    static DateFormat df;
    static String parser;
    static SAXSVGDocumentFactory f;
    Long routeId;
    RouteExt route;

    static {
        String cacheDataFolder = SysProperties.getProperty((String)"path.resource", (String)"");
        if (!cacheDataFolder.trim().equals("")) {
            cacheDataFolder = String.valueOf(cacheDataFolder) + File.separator;
        }
        svgPrefix = cacheDataFolder;
        image = "";
        imageH = "/iconssvg/hint.svg";
        imageG = "/iconssvg/hintG.svg";
        df = new SimpleDateFormat("dd.MM.yy");
        parser = XMLResourceDescriptor.getXMLParserClassName();
        f = new SAXSVGDocumentFactory(parser);
    }

    public TransportUI getObject() {
        return this.object;
    }

    public void setObject(TransportUI object) {
        this.object = object;
    }

    public boolean isSelect() {
        return this.select;
    }

    public void dispose() {
        this.canvas.dispose();
        if (this.canvas.getParent() != null) {
            this.canvas.getParent().remove((Component)this.canvas);
        }
        this.canvasH.dispose();
        if (this.canvasH.getParent() != null) {
            this.canvasH.getParent().remove((Component)this.canvasH);
        }
        this.canvasH2.stream().forEach(o -> {
            o.dispose();
            if (o.getParent() != null) {
                o.getParent().remove((Component)o);
            }
        });
    }

    public void setSelect(boolean select) {
        this.select = select;
    }

    public Long getId() {
        return this.id;
    }

    public void setImage() {
        image = "/iconssvg/tr.svg";
        imageH = "/iconssvg/hint.svg";
    }

    public void initIcon() {
        this.initIcon(this.getObject(), this.doc);
    }

    public void updateSize(Integer size) {
    }

    public void setColor(Color c) {
        Color c2 = c.darker().darker();
        Element e = this.doc.getElementById("arrow");
        Element e2 = this.doc.getElementById("circle");
        TransportToView.changeColorLine(c2.getRGB(), e);
        TransportToView.changeColorFill(c.getRGB(), e, null);
        TransportToView.changeColorLine(c2.getRGB(), e2);
        TransportToView.changeColorFill(c.getRGB(), e2, null);
        Element arrow = this.doc.getElementById("arrow");
        Element arrow2 = this.doc.getElementById("arrow2");
        Element im = this.doc.getElementById("icon");
        boolean showSt = this.typev == 0 || this.typev == 2;
        TransportToView.setopacity1(arrow, showSt);
        TransportToView.setopacity1(arrow2, showSt);
        boolean showI = this.typev == 0 || this.typev == 1;
        TransportToView.setopacity1(im, showI);
    }

    public void setColor2(final Color c) {
        if (this.queue != null) {
            this.queue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TransportToView.this.setColor(c);
                }
            });
        }
    }

    public void initIcon(TransportUI t, SVGDocument doc) {
        if (this.controlDDH instanceof ControlBus) {
            this.controlDDH.prepareOn(this.controlDDH.transportNode.get(t.getId()), this);
        } else {
            Color c = Color.RED;
            if (t.getGroupColor() != null) {
                c = new Color(t.getGroupColor());
            }
            this.setColor(c);
        }
    }

    public void initangle() {
        if (this.data != null && this.data.getData().getDirection() != null) {
            this.setAngle(this.data.getData().getDirection());
        }
    }

    public void setAngle(final double angle) {
        try {
            if (this.queue != null) {
                this.queue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Element gar = TransportToView.this.doc.getElementById("gar");
                        gar.setAttribute("transform", "rotate(" + angle + ",20,20)");
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PointData getData() {
        return this.data;
    }

    public List<PointData> getOld() {
        return this.old;
    }

    public void setData(final PointData data) {
        boolean a;
        if (!(this.controlDDH instanceof ControlBus)) {
            this.old.add(data);
        }
        this.data = data;
        if (this.doc != null && !this.arrow == (a = data.getData().getDirection() != null && data.getData().getSpeed() > 0.0) && this.queue != null) {
            this.queue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean showSt;
                    TransportToView.this.arrow = a;
                    Element arrow = TransportToView.this.doc.getElementById("arrow");
                    Element circle = TransportToView.this.doc.getElementById("circle");
                    Element arrow2 = TransportToView.this.doc.getElementById("arrow2");
                    Element circle2 = TransportToView.this.doc.getElementById("circle2");
                    Element im = TransportToView.this.doc.getElementById("icon");
                    boolean bl = showSt = TransportToView.this.typev == 0 || TransportToView.this.typev == 2;
                    if (data.getData().getDirection() != null && data.getData().getSpeed() > 0.0) {
                        TransportToView.setopacity1(arrow, showSt);
                        TransportToView.setopacity1(arrow2, showSt);
                        TransportToView.setopacity1(circle, false);
                        TransportToView.setopacity1(circle2, false);
                    } else {
                        TransportToView.setopacity1(arrow, false);
                        TransportToView.setopacity1(arrow2, false);
                        TransportToView.setopacity1(circle, showSt);
                        TransportToView.setopacity1(circle2, showSt);
                    }
                    boolean showI = TransportToView.this.typev == 0 || TransportToView.this.typev == 1;
                    TransportToView.setopacity1(im, showI);
                    if (TransportToView.this.longtimestop) {
                        TransportToView.this.longtimestop = false;
                        TransportToView.this.initIcon(TransportToView.this.getObject(), TransportToView.this.doc);
                    }
                }
            });
        }
        if (data != null && data.getData().getDirection() != null) {
            this.setAngle(data.getData().getDirection());
        }
        this.setterHint();
    }

    public void select(long id) {
        this.controlDDH.setSelected(id, null);
    }

    public void setterHint() {
        if (this.queue2 != null) {
            this.queue2.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TransportToView.this.setterhint2();
                }
            });
        } else {
            this.setterhint2();
        }
    }

    public void setterhint2() {
        if (this.docH != null) {
            String s;
            GenericText e = (GenericText)this.docH.getElementById("num").getFirstChild();
            if (e != null) {
                e.setNodeValue(this.getObject().getRegNum());
            }
            if ((e = (GenericText)this.docH.getElementById("callsign").getFirstChild()) != null) {
                e.setNodeValue(this.getObject().getGarageNum());
            }
            if ((e = (GenericText)this.docH.getElementById("speed").getFirstChild()) != null) {
                s = "";
                if (this.getData() != null && this.getData().getData().getSpeed() != null) {
                    s = String.valueOf(this.defs.format(this.getData().getData().getSpeed())) + " \u043a\u043c/\u0447";
                }
                e.setNodeValue(s);
            }
            if ((e = (GenericText)this.docH.getElementById("task").getFirstChild()) != null) {
                s = this.getObject().getDeviceCode();
                e.setNodeValue(s);
            }
        }
    }

    public GeoPosition getGeoposition() {
        if (this.data == null) {
            return null;
        }
        GeoPosition gp = new GeoPosition(this.getData().getData().getLat().doubleValue(), this.getData().getData().getLon().doubleValue());
        return gp;
    }

    public TransportToView(final Long id, TransportUI object, ControlDDH controlDDH, URL url, Integer size, Integer typev) {
        this.typev = typev;
        this.controlDDH = controlDDH;
        this.id = id;
        this.object = object;
        this.setImage();
        this.loadImage();
        this.initIcon();
        if (url != null) {
            this.changeIcon(url.toString());
        }
        final Double cSize = size / 30;
        this.h = (int)((double)this.h * cSize);
        this.w = (int)((double)this.w * cSize);
        String ww = this.doc.getRootElement().getAttribute("width");
        String hh = this.doc.getRootElement().getAttribute("height");
        int w1 = (int)((double)Integer.parseInt(ww.replaceAll("px", "")) * cSize);
        int h1 = (int)((double)Integer.parseInt(hh.replaceAll("px", "")) * cSize);
        this.doc.getRootElement().setAttribute("width", Integer.toString(w1));
        this.doc.getRootElement().setAttribute("height", Integer.toString(h1));
        this.canvas = new JSVGCanvas();
        this.canvas.setDocumentState(1);
        this.canvas.setDocument((Document)this.doc);
        this.canvas.setSize(w1, h1);
        this.sizeR = w1 / 2;
        this.canvasH = new JSVGCanvas();
        this.canvasH.setDocumentState(1);
        this.canvasH.setDocument((Document)this.docH);
        ww = this.docH.getRootElement().getAttribute("width");
        hh = this.docH.getRootElement().getAttribute("height");
        this.canvasH.setSize(Integer.parseInt(ww.replaceAll("px", "")), Integer.parseInt(hh.replaceAll("px", "")));
        this.canvas.setBackground(new Color(0, 0, 0, 0));
        this.canvasH.setBackground(new Color(0, 0, 0, 0));
        DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
        unusualSymbols.setDecimalSeparator('.');
        final DecimalFormat df1 = new DecimalFormat("0.0", unusualSymbols);
        this.canvas.addSVGLoadEventDispatcherListener((SVGLoadEventDispatcherListener)new SVGLoadEventDispatcherAdapter(){

            public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent e) {
                TransportToView.this.queue = TransportToView.this.canvas.getUpdateManager().getUpdateRunnableQueue();
                if (!TransportToView.this.onClickWasSet) {
                    Element elt = TransportToView.this.canvas.getSVGDocument().getElementById("gMainGroup");
                    elt.setAttribute("transform", "scale(" + df1.format(cSize) + "," + df1.format(cSize) + ")");
                    EventTarget t = (EventTarget)((Object)elt);
                    if (t != null && id != null) {
                        t.addEventListener("click", new OnClickAction(id), false);
                        TransportToView.this.onClickWasSet = true;
                    }
                }
            }
        });
        this.canvasH.addSVGLoadEventDispatcherListener((SVGLoadEventDispatcherListener)new SVGLoadEventDispatcherAdapter(){

            public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent e) {
                TransportToView.this.queue2 = TransportToView.this.canvasH.getUpdateManager().getUpdateRunnableQueue();
            }
        });
    }

    public List<GeoPosition> getTarget() {
        return this.target;
    }

    public void setTarget(List<GeoPosition> target) {
        this.target = target;
    }

    public static void initTargetR(Request4PlannedRerouting r, List<SVGDocument> docH2, List<JSVGCanvas> canvasH2, List<GeoPosition> target) {
        SVGDocument d = TransportToView.loadImage(imageG);
        docH2.add(d);
        JSVGCanvas c = new JSVGCanvas();
        canvasH2.add(c);
        c.setDocumentState(1);
        c.setDocument((Document)d);
        String ww = d.getRootElement().getAttribute("width");
        String hh = d.getRootElement().getAttribute("height");
        c.setSize(Integer.parseInt(ww.replaceAll("px", "")), Integer.parseInt(hh.replaceAll("px", "")));
        c.setBackground(new Color(0, 0, 0, 0));
        GeoPosition t = new GeoPosition(r.getLatTarget().doubleValue(), r.getLonTarget().doubleValue());
        target.add(t);
        if (d != null) {
            StringBuilder st;
            GenericText e = (GenericText)d.getElementById("num").getFirstChild();
            if (e != null) {
                st = new StringBuilder();
                st.append(r.getBeginDate() == null ? "??" : df.format(r.getBeginDate())).append("-");
                st.append(r.getEndDate() == null ? "??" : df.format(r.getEndDate()));
                e.setNodeValue(st.toString());
            }
            if ((e = (GenericText)d.getElementById("callsign").getFirstChild()) != null) {
                e.setNodeValue(r.getGoalTrip());
            }
            if ((e = (GenericText)d.getElementById("speed").getFirstChild()) != null) {
                e.setNodeValue(r.getGoalTripAdress());
            }
            if ((e = (GenericText)d.getElementById("task").getFirstChild()) != null) {
                st = new StringBuilder("");
                if (r.getTransportingChildren() == 1) {
                    st.append("\u0414\u0435\u0442\u0438").append(";");
                }
                if (r.getNeedSupport() == 1) {
                    st.append("\u0421\u043e\u043f\u0440\u043e\u0432\u043e\u0436\u0434\u0435\u043d\u0438\u0435");
                }
                e.setNodeValue(st.toString());
            }
        }
    }

    public void initTarget(List<Request4PlannedRerouting> req) {
        req.stream().forEach(r -> {
            if (r.getLatTarget() != null) {
                TransportToView.initTargetR(r, this.docH2, this.canvasH2, this.target);
            }
        });
    }

    public void changeIcon(String icon) {
        Element e1 = this.doc.getElementById("icon");
        e1.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", icon);
    }

    public JComponent getComponent() {
        return this.canvas;
    }

    public JComponent getComponentH() {
        return this.canvasH;
    }

    public List<JSVGCanvas> getComponentH2() {
        return this.canvasH2;
    }

    public SVGDocument getDoc() {
        return this.doc;
    }

    public void setDoc(SVGDocument doc) {
        this.doc = doc;
    }

    public int getH() {
        return this.h;
    }

    public void setH(int h) {
        this.h = h;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    public void reload() {
        this.canvas.setDocument((Document)this.doc);
        this.canvas.repaint();
        this.canvasH.setDocument((Document)this.docH);
        this.canvasH.repaint();
        this.setterHint();
    }

    public static SVGDocument loadImage(String image) {
        File file = svgPrefix.equals("") ? new File(TransportToView.class.getResource(String.valueOf(prefix) + image).getFile()) : new File(String.valueOf(svgPrefix) + image);
        try {
            SVGDocument doc = f.createSVGDocument(file.toURI().toString());
            return doc;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void loadImage() {
        this.doc = TransportToView.loadImage(image);
        this.docH = TransportToView.loadImage(imageH);
    }

    public static void changeColorFill(Integer color, Element e, Double opacity) {
        if (e != null) {
            String s = e.getAttribute("style");
            int k = s.indexOf("fill:#");
            StringBuilder r = new StringBuilder();
            if (k > 0) {
                r.append(s.substring(0, k));
            }
            r.append("fill:#").append(Integer.toHexString(color).substring(2)).append(s.substring(k + 12));
            s = r.toString();
            if (opacity != null) {
                k = s.indexOf("opacity:");
                r = new StringBuilder();
                if (k > 0) {
                    r.append(s.substring(0, k));
                }
                r.append("opacity:").append(opacity).append(s.substring(k + 9));
            }
            e.setAttribute("style", r.toString());
        }
    }

    public static void changeColorLine(Integer color, Element e) {
        if (e != null) {
            String s = e.getAttribute("style");
            int k = s.indexOf("stroke:#");
            StringBuilder r = new StringBuilder();
            if (k > 0) {
                r.append(s.substring(0, k));
            }
            r.append("stroke:#").append(Integer.toHexString(color).substring(2)).append(s.substring(k + 14));
            e.setAttribute("style", r.toString());
        }
    }

    public static void setopacity1(Element e1, boolean opacity) {
        if (opacity) {
            e1.setAttribute("style", e1.getAttribute("style").replace("stroke-opacity:0", "stroke-opacity:1"));
            e1.setAttribute("style", e1.getAttribute("style").replace("fill-opacity:0", "fill-opacity:1"));
            e1.setAttribute("style", e1.getAttribute("style").replace("opacity:0", "opacity:1"));
        } else {
            e1.setAttribute("style", e1.getAttribute("style").replace("stroke-opacity:1", "stroke-opacity:0"));
            e1.setAttribute("style", e1.getAttribute("style").replace("fill-opacity:1", "fill-opacity:0"));
            e1.setAttribute("style", e1.getAttribute("style").replace("opacity:1", "opacity:0"));
        }
    }

    public SVGDocument getDocH() {
        return this.docH;
    }

    public void setDocH(SVGDocument docH) {
        this.docH = docH;
    }

    public Long getRouteId() {
        return this.routeId;
    }

    public void setRouteId(Long routeId) {
        this.routeId = routeId;
    }

    public RouteExt getRoute() {
        return this.route;
    }

    public void setRoute(RouteExt route) {
        this.route = route;
    }

    public void resize2() {
        String ww = this.docH.getRootElement().getAttribute("width");
        String hh = this.docH.getRootElement().getAttribute("height");
        this.canvasH.setSize(Integer.parseInt(ww.replaceAll("px", "")), Integer.parseInt(hh.replaceAll("px", "")));
    }

    public void resize() {
        String ww = this.doc.getRootElement().getAttribute("width");
        String hh = this.doc.getRootElement().getAttribute("height");
        this.canvas.setSize(Integer.parseInt(ww.replaceAll("px", "")), Integer.parseInt(hh.replaceAll("px", "")));
    }

    public void resize3() {
        int i = 0;
        while (i < this.getTarget().size()) {
            JSVGCanvas canvas3 = this.getComponentH2().get(i);
            String ww = this.docH2.get(i).getRootElement().getAttribute("width");
            String hh = this.docH2.get(i).getRootElement().getAttribute("height");
            canvas3.setSize(Integer.parseInt(ww.replaceAll("px", "")), Integer.parseInt(hh.replaceAll("px", "")));
            ++i;
        }
    }

    public class OnClickAction
    implements EventListener {
        private long id;

        public OnClickAction(long id) {
            this.id = id;
        }

        @Override
        public void handleEvent(Event evt) {
            TransportToView.this.select(this.id);
        }
    }
}

