/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.controlddh.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import ru.blok.vms.ui.controlddh.ControlDDH;
import ru.blok.vms.ui.controlddh.tree.RoadTreeNode;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.viewers.tree.TreeViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;

public class TreeNodeViewerRoad
extends TreeViewer {
    public TreeNodeViewerRoad(UIFactory<JComponent> factory) {
        super(factory);
        this.dndEnable(false);
        ((JTree)this.tree.getTreeComponent()).setCellRenderer(new CheckRenderer());
        final JTree tt = (JTree)this.tree.getTreeComponent();
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath selPath = tt.getPathForLocation(e.getX(), e.getY());
                int selRow = tt.getRowForPath(selPath);
                if (selRow != -1) {
                    if (e.getClickCount() == 1) {
                        Rectangle pathBounds = tt.getPathBounds(selPath);
                        int x = e.getX() - pathBounds.x;
                        if (x < 15) {
                            TreeNodeViewerRoad.this.actionOnOff();
                        } else {
                            TreeNodeViewerRoad.this.actionOnSelect2();
                        }
                    } else if (e.getClickCount() == 2) {
                        TreeNodeViewerRoad.this.actionOnSelect2();
                    }
                }
            }
        };
        tt.addMouseListener(ml);
    }

    public void actionOnOff() {
        List l = this.getSelectedItems();
        if (l != null && l.size() > 0) {
            RoadTreeNode n = (RoadTreeNode)((Object)l.get(0));
            ControlDDH t = (ControlDDH)((PanelContext)this.getViewerContext().getParentContext()).getObject();
            t.onOff(n);
            ((JComponent)this.tree.getTreeComponent()).repaint();
        }
    }

    public void setBValue(final Object value) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = value;
                synchronized (object) {
                    TreeNodeViewerRoad.super.setBValue(value);
                }
            }
        }).start();
    }

    protected void actionOnSelect2() {
        super.actionOnSelect();
        List l = this.getSelectedItems();
        ControlDDH t = (ControlDDH)((PanelContext)this.getViewerContext().getParentContext()).getObject();
        if (!t.select) {
            t.select = true;
            if (l != null && l.size() > 0) {
                RoadTreeNode n = (RoadTreeNode)((Object)l.get(0));
                if (n.getType() == RoadTreeNode.Road) {
                    t.setSelectedRoad(n.getRoadWAUI().getId(), n);
                } else if (n.getType() == RoadTreeNode.AllGroup) {
                    t.positionOnFullListRoad();
                } else {
                    t.positionOnselectGroupRoad(n);
                }
            }
            t.select = false;
        }
    }

    public static class CheckRenderer
    extends JPanel
    implements TreeCellRenderer {
        private static final long serialVersionUID = 7199225866735224272L;
        protected JCheckBox check;
        protected TreeLabel label;

        public CheckRenderer() {
            this.setLayout(null);
            this.check = new JCheckBox();
            this.add(this.check);
            this.label = new TreeLabel();
            this.add(this.label);
            this.check.setBackground(UIManager.getColor("Tree.textBackground"));
            this.label.setForeground(UIManager.getColor("Tree.textForeground"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
            this.setEnabled(tree.isEnabled());
            if (value instanceof RoadTreeNode) {
                boolean select = ((RoadTreeNode)((Object)value)).isSelect();
                this.check.setSelected(select);
            }
            this.label.setFont(tree.getFont());
            this.label.setText(stringValue);
            this.label.setSelected(isSelected);
            this.label.setFocus(hasFocus);
            if (leaf) {
                this.label.setIcon(UIManager.getIcon("Tree.leafIcon"));
            } else if (expanded) {
                this.label.setIcon(UIManager.getIcon("Tree.openIcon"));
            } else {
                this.label.setIcon(UIManager.getIcon("Tree.closedIcon"));
            }
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d_check = this.check.getPreferredSize();
            Dimension d_label = this.label.getPreferredSize();
            return new Dimension(d_check.width + d_label.width, d_check.height < d_label.height ? d_label.height : d_check.height);
        }

        @Override
        public void doLayout() {
            Dimension d_check = this.check.getPreferredSize();
            Dimension d_label = this.label.getPreferredSize();
            int y_check = 0;
            int y_label = 0;
            if (d_check.height < d_label.height) {
                y_check = (d_label.height - d_check.height) / 2;
            } else {
                y_label = (d_check.height - d_label.height) / 2;
            }
            this.check.setLocation(0, y_check);
            this.check.setBounds(0, y_check, d_check.width, d_check.height);
            this.label.setLocation(d_check.width, y_label);
            this.label.setBounds(d_check.width, y_label, d_label.width, d_label.height);
        }

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        @Override
        public void setForeground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setForeground(color);
        }

        public class TreeLabel
        extends JLabel {
            private static final long serialVersionUID = 4529894209364732567L;
            boolean isSelected;
            boolean hasFocus;

            @Override
            public void setBackground(Color color) {
                if (color instanceof ColorUIResource) {
                    color = null;
                }
                super.setBackground(color);
            }

            @Override
            public void paint(Graphics g) {
                String str = this.getText();
                if (str != null && str.length() > 0) {
                    if (this.isSelected) {
                        this.setForeground(UIManager.getColor("Tree.selectionForeground"));
                        g.setColor(UIManager.getColor("Tree.selectionBackground"));
                    } else {
                        this.setForeground(UIManager.getColor("Tree.textForeground"));
                        g.setColor(UIManager.getColor("Tree.textBackground"));
                    }
                    Dimension d = this.getPreferredSize();
                    int imageOffset = 0;
                    Icon currentI = this.getIcon();
                    if (currentI != null) {
                        imageOffset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                    }
                    g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
                    if (this.hasFocus) {
                        g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                        g.drawRect(imageOffset, 0, d.width - 1 - imageOffset, d.height - 1);
                    }
                }
                super.paint(g);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension retDimension = super.getPreferredSize();
                if (retDimension != null) {
                    retDimension = new Dimension(retDimension.width + 3, retDimension.height);
                }
                return retDimension;
            }

            public void setSelected(boolean isSelected) {
                this.isSelected = isSelected;
            }

            public void setFocus(boolean hasFocus) {
                this.hasFocus = hasFocus;
            }
        }
    }
}

