/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.curator.tracklist;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.ExceptionInConstructor;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.core.PeriodDateClass;
import ru.blok.common.ui.longTask.ComponentTask.ViewerStateProgressBar;
import ru.blok.common.ui.longTask.StateTask;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.curator.tracklist.Note;
import ru.blok.vms.ui.curator.tracklist.buttons.AddDataFromServer;
import ru.blok.vms.ui.curator.tracklist.buttons.AdderRoute;
import ru.blok.vms.ui.curator.tracklist.buttons.EditDataCurator;
import ru.blok.vms.ui.curator.tracklist.buttons.ImportTrack;
import ru.blok.vms.ui.curator.tracklist.buttons.PlayNote;
import ru.blok.vms.ui.curator.tracklist.buttons.SaveDataCurator;
import ru.blok.vms.ui.curator.tracklist.map.MapValueWithTrackCurator;
import ru.blok.vms.ui.curator.tracklist.map.MapViewerDataCurator;
import ru.blok.vms.ui.curator.tracklist.parsing.FileTrk;
import ru.blok.vms.ui.curator.tracklist.parsing.MetaData;
import ru.blok.vms.ui.curator.tracklist.parsing.Nddata;
import ru.blok.vms.ui.curator.tracklist.parsing.OnlyExt;
import ru.blok.vms.ui.curator.tracklist.parsing.PointData;
import ru.blok.vms.ui.curator.tracklist.viewers.ListViewerDataCurator;
import ru.blok.vms.ui.curator.tracklist.viewers.ListViewerNotes;
import ru.blok.vms.ui.mapviewer.newmapviewer.MapValueWithTrackNew;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.ClassView;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.ActionCalculatedObject;
import ru.infor.beanviewer.core.Extractor;
import ru.infor.beanviewer.core.ResourceString;
import ru.infor.beanviewer.dialog.ErrorMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.QuestionMessage;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.swing.viewers.TimeFormatViewer;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.beanviewer.viewer.simple.date.DateWithoutButton;
import ru.infor.client.soap.proxy.core.SecurityWSProxy;
import ru.infor.client.soap.proxy.core.SystemParameterListWSProxy;
import ru.infor.client.soap.proxy.core.UserWSProxy;
import ru.infor.client.soap.proxy.vms.DataCuratorWSProxy;
import ru.infor.ws.objects.core.UserSearchCriteria;
import ru.infor.ws.objects.core.entities.SystemParameterList;
import ru.infor.ws.objects.core.entities.User;
import ru.infor.ws.objects.vms.DataCuratorSearchCriteria;
import ru.infor.ws.objects.vms.entities.DataCurator;
import ru.infor.ws.objects.vms.entities.NoteRoute;
import ru.infor.ws.objects.vms.entities.RouteData;

@ListView(views={@View(title="", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class CuratorTrackList
extends CommonObjectWithKey {
    public static SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private static SimpleDateFormat dfSource = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static SimpleDateFormat dfSource1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSS'Z'");
    public static SimpleDateFormat dfYMD = new SimpleDateFormat("yyyyMMdd_HHmmss");
    public static SimpleDateFormat dfYMDS = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
    public static SecurityWSProxy securityProxy = new SecurityWSProxy(CurrentProxyFactory.getCurrentSOAPConnection());
    public static DataCuratorWSProxy dataCuratorWSProxy = (DataCuratorWSProxy)CurrentProxyFactory.getProxy(DataCurator.class);
    public static SystemParameterListWSProxy systemParameterListWSProxy = (SystemParameterListWSProxy)CurrentProxyFactory.getProxy(SystemParameterList.class);
    MapValueWithTrackCurator mapValueWithTrackNew;
    String pathSource;
    String mess = "";
    HashMap<String, String> sp = null;
    HashMap<String, List<String>> listFiles = new HashMap();
    public static String localPath = null;
    public static String pathToData = null;
    public static String currentPathToData;
    boolean toAsk = false;
    Double[] coord;
    static Logger logger;
    private Date dateFrom;
    private Date dateTill;
    BeanViewerAction<ViewerContext> btLoadDataFromServer = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            DataCuratorSearchCriteria sc = (DataCuratorSearchCriteria)dataCuratorWSProxy._getSearchCriteriaTemplate();
            sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
            sc.setDateFrom(CuratorTrackList.this.dateFrom);
            sc.setDateTill(CuratorTrackList.this.dateTill);
            Object[] oo = dataCuratorWSProxy.getList(InitializedVariable.context, sc).getObjList();
            CuratorTrackList.this.listDataCurator.clear();
            if (oo != null) {
                Object[] objectArray = oo;
                int n = oo.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    DataCurator d = (DataCurator)o;
                    CuratorTrackList.this.listDataCurator.add(d);
                    ++n2;
                }
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    CuratorTrackList.this.runUpdate((PanelContext)((ViewerContext)this.getContext()).getParentContext(), null);
                }
            }).start();
        }

        public String getIcon() {
            return ResourceString.btLoadfromDBImage;
        }

        public String getHint() {
            return "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430";
        }

        public String getName() {
            return "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430";
        }
    };
    ShowTrack showTrack = new ShowTrack();
    List<DataCurator> listDataCurator = new ArrayList<DataCurator>();
    DataCurator selectDataCurator;
    List<Note> listNotes = new ArrayList<Note>();
    private Note selectNote;
    Date maxDate;
    Date minDate;
    StateTask stateTask;
    MessageOKButton okSavePath = new MessageOKButton(){

        public void actionPerformed(Object message) {
            String param = "PathToDataOnTablet&divider&".concat(CuratorTrackList.getCurrentPathToData());
            systemParameterListWSProxy.saveOneParameter(InitializedVariable.context, InitializedVariable.getWorkplaceId((String)CuratorTrackList.this.getKeyPage()), param);
            CuratorTrackList.this.setPathSource(CuratorTrackList.getCurrentPathToData());
        }
    };

    static {
        logger = Logger.getLogger(CuratorTrackList.class);
    }

    public CuratorTrackList(String keyPage) throws ExceptionInConstructor {
        super(keyPage);
        if (InitializedVariable.getWorkplaceId((String)keyPage) != null) {
            this.sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.getWorkplaceId((String)keyPage));
            try {
                localPath = Files.createTempDirectory("tmp", new FileAttribute[0]).toAbsolutePath().toUri().getPath();
            }
            catch (IOException iOException) {
                localPath = System.getProperty("java.io.tmpdir");
            }
            if (this.sp.get("PathToDataOnTablet") != null) {
                pathToData = this.sp.get("PathToDataOnTablet");
            }
            if (this.sp.get("ShowTrackCurator") != null) {
                Integer showT = Integer.parseInt(this.sp.get("ShowTrackCurator"));
                this.getShowTrack().setShow(showT == 1);
            }
            this.coord = CoordinatesDownTown.getCoordinatesDownTown(this.sp);
        } else {
            this.coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)keyPage));
        }
        if (localPath == null) {
            InitializedVariable.factory.runMessageEx((Object)new ErrorMessage("\u041e\u0448\u0438\u0431\u043a\u0430", new String[]{" \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 LocalPath4DataCurators\n\u041f\u0443\u0442\u044c \u0432 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u0444\u0430\u0439\u043b\u043e\u0432\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u043a\u0443\u0440\u0430\u0442\u043e\u0440\u0430"}), new BeanViewerAction[]{new MessageOKButton()});
            throw new ExceptionInConstructor();
        }
        PeriodDateClass pd = new PeriodDateClass(this.sp);
        this.dateFrom = pd.getFirstDate();
        this.dateTill = pd.getLastDate();
        this.mapValueWithTrackNew = new MapValueWithTrackCurator(this.coord[0], this.coord[1], this.coord[2].intValue());
        this.mapValueWithTrackNew.setCuratorTrackList(this);
        this.setPathSource(pathToData);
    }

    @ListField(fields={@Field(title="\u0421  ", order=10, viewer={DateWithoutButton.class}, propertiesLayout="Split1/h/l/0.3:m1:0/fillx, ins 0/n/wrap,spanx# w 100", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    @ListField(fields={@Field(title="", order=20, viewer={TimeFormatViewer.class}, propertiesLayout="Split1/h/l/0.3:m1:0#w 105,wrap", propertiesUI={"format=HH:mm:ss"})})
    public Date getTimeFrom() {
        return this.dateFrom;
    }

    public void setTimeFrom(Date dateFrom) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDateFrom());
        c2.setTime(dateFrom);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.dateFrom = c1.getTime();
    }

    @ListField(fields={@Field(title="\u043f\u043e ", order=30, viewer={DateWithoutButton.class}, propertiesLayout="Split1/h/l/0.3:m1:0#w 100", propertiesUI={"format=dd.MM.yyyy"})})
    public Date getDateTill() {
        return this.dateTill;
    }

    public void setDateTill(Date dateTill) {
        this.dateTill = dateTill;
    }

    @ListField(fields={@Field(title="", order=40, viewer={TimeFormatViewer.class}, propertiesLayout="Split1/h/l/0.3:m1:0# w 105,wrap", propertiesUI={"format=HH:mm:ss"})})
    public Date getTimeTill() {
        return this.dateTill;
    }

    public void setTimeTill(Date dateTill) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(this.getDateTill());
        c2.setTime(dateTill);
        c1.set(11, c2.get(11));
        c1.set(12, c2.get(12));
        c1.set(13, c2.get(13));
        this.dateTill = c1.getTime();
    }

    @ListField(fields={@Field(title="", order=50, propertiesLayout="Split1/h/l/0.3:m1:0#spanx", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getBtLoadDataFromServer() {
        return this.btLoadDataFromServer;
    }

    public void updateUIState(PanelContext pc) {
        pc.getPanel().updateUIForPresentatorName("stateTask");
    }

    public void updateMap(PanelContext pc) {
        pc.getPanel().updateUIForPresentatorName("value");
        pc.getPanel().updateUIForPresentatorName("listNotes");
    }

    public void updateList(PanelContext pc) {
        pc.getPanel().updateUIForPresentatorName("listDataCurator");
    }

    private void runTask(int max, String mess, PanelContext pc) {
        this.stateTask = new StateTask();
        this.stateTask.setMaxProgress(Integer.valueOf(max));
        this.stateTask.setCurrent(Integer.valueOf(0));
        this.stateTask.setState(StateTask.run);
        this.setMess(mess);
        pc.getPanel().updateUIForPresentatorName("mess");
        this.updateUIState(pc);
    }

    private void finishTask(PanelContext pc) {
        this.stateTask.setState(StateTask.stop);
        this.updateUIState(pc);
        this.setMess("");
        pc.getPanel().updateUIForPresentatorName("mess");
    }

    public void runUpdate(PanelContext pc, List<DataCurator> newlist) {
        if (this.listDataCurator != null) {
            this.runTask(newlist == null ? this.listDataCurator.size() : newlist.size(), "\u0418\u0434\u0435\u0442 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445", pc);
            int i = 0;
            while (i < this.listDataCurator.size()) {
                boolean update = true;
                if (newlist != null && !newlist.contains(this.listDataCurator.get(i))) {
                    update = false;
                }
                if (update) {
                    if (this.listDataCurator.get(i).getId() != null) {
                        DataCurator dc = dataCuratorWSProxy.getCurrentObject(InitializedVariable.context, this.listDataCurator.get(i).getId());
                        this.listDataCurator.set(i, dc);
                        this.refreshInfoPoint();
                    }
                    this.stateTask.incCurrent();
                    this.updateUIState(pc);
                    this.updateMap(pc);
                }
                ++i;
            }
            this.finishTask(pc);
        }
        pc.getPanel().updateUI();
    }

    public ShowTrack getShowTrack() {
        return this.showTrack;
    }

    @ListField(fields={@Field(title="", order=1000, viewer={ListViewerDataCurator.class}, propertiesLayout="Split1/h/l/0.3:m1#spanx 2,wrap#wrap", content=DataCurator.class, panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=EditDataCurator.class), @ActionField(clazz=AdderRoute.class), @ActionField(clazz=ImportTrack.class), @ActionField(clazz=SaveDataCurator.class), @ActionField(clazz=AddDataFromServer.class)}, classView={@ClassView(name="showTrack", order=100, clazz=ShowTrack.class, extractor=ExtractorShowButton.class)})})})
    public List<DataCurator> getListDataCurator() {
        return this.listDataCurator;
    }

    public DataCurator getSelectDataCurator() {
        return this.selectDataCurator;
    }

    public void setSelectDataCurator(DataCurator selectDataCurator) {
        this.selectDataCurator = selectDataCurator;
    }

    public void setSelectDataCurator(DataCurator selectDataCurator, PanelContext pc) {
        this.setSelectDataCurator(selectDataCurator);
        if (selectDataCurator == null) {
            ((ListViewer)pc.getPanel().getPresentatorForName("listDataCurator").getViewer()).getTM().clearSelection();
        } else {
            ((ListViewer)pc.getPanel().getPresentatorForName("listDataCurator").getViewer()).getTM().setSelectedRows(new int[]{this.getListDataCurator().indexOf(selectDataCurator)});
        }
    }

    @ListField(fields={@Field(title="", order=1100, viewer={ListViewerNotes.class}, propertiesLayout="Split1/h/l/0.3:m1#spanx 2,wrap#wrap", content=Note.class, panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=PlayNote.class, doubleclick=true)})})})
    public List<Note> getListNotes() {
        return this.listNotes;
    }

    public Note getSelectNote() {
        return this.selectNote;
    }

    public void setSelectNote(Note selectNote) {
        this.selectNote = selectNote;
    }

    public void setSelectNote(Note selectNote, PanelContext pc) {
        this.setSelectNote(selectNote);
        if (selectNote == null) {
            ((ListViewer)pc.getPanel().getPresentatorForName("listNotes").getViewer()).getTM().clearSelection();
        } else {
            ((ListViewer)pc.getPanel().getPresentatorForName("listNotes").getViewer()).getTM().setSelectedRows(new int[]{this.getListNotes().indexOf(selectNote)});
        }
    }

    public void refreshInfoPoint() {
        this.listNotes.clear();
        if (this.listDataCurator != null) {
            for (DataCurator dc : this.listDataCurator) {
                if (dc.getData() == null) continue;
                RouteData[] routeDataArray = dc.getData();
                int n = routeDataArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RouteData rd = routeDataArray[n2];
                    if (rd.getNotes() != null) {
                        NoteRoute[] noteRouteArray = rd.getNotes();
                        int n3 = noteRouteArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            NoteRoute n5 = noteRouteArray[n4];
                            this.listNotes.add(new Note(dc, rd, n5));
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public void readRouteFromFile(File f) {
        try {
            this.maxDate = df.parse("01-01-2001 00:00:00");
            this.minDate = df.parse("01-01-2022 00:00:00");
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        this.listFiles.clear();
        File sourceFile = new File(f.getParent());
        this.readRouteFile(f, sourceFile);
        this.refreshInfoPoint();
    }

    private String setNotesFile(String type, PointData pd, String destinationDir) {
        return String.valueOf(destinationDir) + File.separator + type + File.separator + pd.getName();
    }

    private void setNotesFiles(RouteData d, Nddata nd, String destinationDir) {
        NoteRoute r;
        ArrayList<NoteRoute> ll = new ArrayList<NoteRoute>();
        if (nd.getAudio() != null) {
            r = new NoteRoute();
            r.setType("audio");
            r.setPath(this.setNotesFile("audio", nd.getAudio(), destinationDir));
            r.setEdited(true);
            ll.add(r);
        }
        if (nd.getVideo() != null) {
            r = new NoteRoute();
            r.setType("video");
            r.setPath(this.setNotesFile("video", nd.getVideo(), destinationDir));
            r.setEdited(true);
            ll.add(r);
        }
        if (nd.getImage() != null) {
            r = new NoteRoute();
            r.setType("image");
            r.setPath(this.setNotesFile("image", nd.getImage(), destinationDir));
            r.setEdited(true);
            ll.add(r);
        }
        if (nd.getText() != null) {
            r = new NoteRoute();
            r.setType("text");
            r.setPath(this.setNotesFile("text", nd.getText(), destinationDir));
            r.setEdited(true);
            ll.add(r);
        }
        d.setNotes(ll.toArray(new NoteRoute[0]));
    }

    public DataCurator runUpload(DataCurator dc) {
        if (dc == null || dc.getData() == null) {
            return dc;
        }
        String urlString = securityProxy.getUploadURL(InitializedVariable.context);
        int i = 0;
        while (i < dc.getData().length) {
            if (dc.getData()[i].getNotes() != null) {
                int j = 0;
                while (j < dc.getData()[i].getNotes().length) {
                    NoteRoute nr = dc.getData()[i].getNotes()[j];
                    if (nr.isEdited()) {
                        String name = nr.getPath().substring(nr.getPath().lastIndexOf(File.separator) + 1);
                        name = name.indexOf(".") > -1 ? String.valueOf(name.substring(0, name.indexOf("."))) + "___" + dfYMDS.format(new Date()) + name.substring(name.indexOf("."), name.length()) : String.valueOf(name) + "___" + dfYMDS.format(new Date());
                        String urlStr = String.valueOf(urlString) + "/?name=" + name;
                        File file2 = CuratorTrackList.filePath(nr.getPath());
                        try {
                            URL url = new URL(urlStr);
                            HttpURLConnection conn = (HttpURLConnection)InitializedVariable.getCurrentConnection((URL)url);
                            conn.setRequestMethod("PUT");
                            conn.setDoInput(true);
                            conn.setDoOutput(true);
                            conn.connect();
                            OutputStream out = conn.getOutputStream();
                            ru.infor.common.FileUtils.copy((File)file2.getAbsoluteFile(), (OutputStream)new BufferedOutputStream(out));
                            conn.getInputStream();
                            conn.disconnect();
                            String dest = String.valueOf(file2.getAbsoluteFile().getPath().substring(0, file2.getAbsoluteFile().getPath().lastIndexOf(File.separator) + 1)) + name;
                            file2.renameTo(new File(dest));
                            nr.setPath(name);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return dc;
    }

    public static File filePath(String path) {
        File file = new File(path);
        String destinationDir = file.getAbsolutePath();
        int s = destinationDir.indexOf("\\.");
        if (s >= 0) {
            destinationDir = String.valueOf(destinationDir.substring(0, s + 1)) + destinationDir.substring(s + 2);
        }
        File file2 = new File(destinationDir);
        return file2;
    }

    private String uploadFile(String key, PointData pd, String destinationDir) {
        File file = new File(String.valueOf(destinationDir) + File.separator + key + File.separator + pd.getName());
        String dfts = dfYMDS.format(new Date());
        String urlStr = securityProxy.getUploadURL(InitializedVariable.context);
        String name = String.valueOf(pd.getName()) + "___" + dfts;
        if (pd.getName().indexOf(".") > -1) {
            name = String.valueOf(pd.getName().substring(0, pd.getName().indexOf("."))) + "___" + dfts + pd.getName().substring(pd.getName().indexOf("."), pd.getName().length());
        }
        urlStr = String.valueOf(urlStr) + "/?name=" + name;
        try {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)InitializedVariable.getCurrentConnection((URL)url);
            conn.setRequestMethod("PUT");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.connect();
            OutputStream out = conn.getOutputStream();
            ru.infor.common.FileUtils.copy((File)file.getAbsoluteFile(), (OutputStream)new BufferedOutputStream(out));
            conn.getInputStream();
            return name;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void uploadFiles(RouteData d, Nddata nd, String destinationDir) {
        NoteRoute r;
        ArrayList<NoteRoute> ll = new ArrayList<NoteRoute>();
        if (nd.getAudio() != null) {
            r = new NoteRoute();
            r.setType("audio");
            r.setPath(this.uploadFile("audio", nd.getAudio(), destinationDir));
            ll.add(r);
        }
        if (nd.getVideo() != null) {
            r = new NoteRoute();
            r.setType("video");
            r.setPath(this.uploadFile("video", nd.getVideo(), destinationDir));
            ll.add(r);
        }
        if (nd.getImage() != null) {
            r = new NoteRoute();
            r.setType("image");
            r.setPath(this.uploadFile("image", nd.getImage(), destinationDir));
            ll.add(r);
        }
        if (nd.getText() != null) {
            r = new NoteRoute();
            r.setType("text");
            r.setPath(this.uploadFile("text", nd.getText(), destinationDir));
            ll.add(r);
        }
        d.setNotes(ll.toArray(new NoteRoute[0]));
    }

    /*
     * WARNING - void declaration
     */
    public void readRouteFile(File f, File sourceFile) {
        FileTrk trks = null;
        List<String> listXml = this.listFiles.get("xml");
        if (listXml == null) {
            listXml = new ArrayList<String>();
        }
        listXml.add(f.getName());
        this.listFiles.put("xml", listXml);
        try {
            User owner;
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{FileTrk.class});
            Unmarshaller u = jc.createUnmarshaller();
            trks = (FileTrk)u.unmarshal(f);
            if (trks.getMetaData() == null || trks.getMetaData().getCurator() == null) {
                MetaData metadata = new MetaData();
                metadata.setCurator(InitializedVariable.user.getName());
                trks.setMetaData(metadata);
            }
            if ((owner = this.findOwner(trks.getMetaData().getCurator().trim())) == null) {
                InitializedVariable.factory.runMessageEx((Object)new ErrorMessage("\u041e\u0448\u0438\u0431\u043a\u0430", new String[]{" \u041a\u0443\u0440\u0430\u0442\u043e\u0440  \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '" + trks.getMetaData().getCurator().trim() + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435."}), new BeanViewerAction[]{new MessageOKButton()});
                return;
            }
            CuratorTrackList.setCurrentPathToData(sourceFile.getAbsolutePath());
            if (this.getPathSource() == null) {
                this.setToAsk(false);
            }
            if (!CuratorTrackList.getCurrentPathToData().equals(this.getPathSource())) {
                if (this.isToAsk()) {
                    InitializedVariable.factory.runMessageEx((Object)new QuestionMessage("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435", new String[]{" \u041f\u0443\u0442\u044c \u043a \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c\u043e\u043c\u0443 \u0444\u0430\u0439\u043b\u0443 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430\n" + CuratorTrackList.getCurrentPathToData() + "\n" + " \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u043c \u043f\u043e \u0443\u043c\u043e\u043b\u044f\u0430\u043d\u0438\u044e\n" + this.getPathSource() + ".\n" + "\u0421\u0434\u0435\u043b\u0430\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u0443\u0442\u044c \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e?"}), new BeanViewerAction[]{this.okSavePath, new PanelContext.CancelButton()});
                } else {
                    this.okSavePath.actionPerformed(null);
                }
            }
            HashMap<RouteData, Nddata> hm = new HashMap<RouteData, Nddata>();
            if (trks != null && trks.getTrack() != null) {
                void var10_14;
                DataCurator data = new DataCurator();
                Date date = new Date();
                Date minDatet = new Date();
                try {
                    Date date2 = df.parse("01-01-2001 00:00:00");
                    minDatet = df.parse("01-01-2022 00:00:00");
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                ArrayList<RouteData> list = new ArrayList<RouteData>();
                int j = 0;
                while (j < trks.getTrack().getNddata().size()) {
                    List<String> listData;
                    Nddata n = trks.getTrack().getNddata().get(j);
                    Date dat = new Date();
                    try {
                        dat = dfSource.parse(n.getNav_datetime());
                    }
                    catch (ParseException parseException) {
                        try {
                            dat = dfSource1.parse(n.getNav_datetime());
                        }
                        catch (ParseException e2) {
                            logger.error((Object)("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0440\u0430\u0441\u043f\u043e\u0437\u043d\u0430\u0442\u044c \u0434\u0430\u0442\u0443 " + n.getNav_datetime() + " \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 " + dfSource.toPattern() + ";" + dfSource1.toPattern()), (Throwable)e2);
                        }
                    }
                    if (dat.before(this.minDate)) {
                        this.minDate = dat;
                    }
                    if (dat.after(this.maxDate)) {
                        this.maxDate = dat;
                    }
                    if (dat.before(minDatet)) {
                        minDatet = dat;
                    }
                    if (dat.after((Date)var10_14)) {
                        Date date3 = dat;
                    }
                    RouteData rd = new RouteData();
                    rd.setAlt(Double.valueOf(n.getAlt()));
                    rd.setCreatedDateTime(dat);
                    rd.setHdop(Double.valueOf(n.getHdop()));
                    rd.setLat(Double.valueOf(n.getNav_lat()));
                    rd.setLon(Double.valueOf(n.getNav_lon()));
                    rd.setSpeed(Double.valueOf(n.getNav_speed()));
                    if (n.getAudio() != null) {
                        listData = this.listFiles.get("audio");
                        if (listData == null) {
                            listData = new ArrayList<String>();
                        }
                        listData.add(sourceFile + File.separator + "audio" + File.separator + n.getAudio().getName());
                        this.listFiles.put("audio", listData);
                        hm.put(rd, n);
                    }
                    if (n.getImage() != null) {
                        listData = this.listFiles.get("image");
                        if (listData == null) {
                            listData = new ArrayList<String>();
                        }
                        listData.add(sourceFile + File.separator + "image" + File.separator + n.getImage().getName());
                        this.listFiles.put("image", listData);
                        if (!hm.containsKey(rd)) {
                            hm.put(rd, n);
                        }
                    }
                    if (n.getVideo() != null) {
                        listData = this.listFiles.get("video");
                        if (listData == null) {
                            listData = new ArrayList<String>();
                        }
                        listData.add(sourceFile + File.separator + "video" + File.separator + n.getVideo().getName());
                        this.listFiles.put("video", listData);
                        if (!hm.containsKey(rd)) {
                            hm.put(rd, n);
                        }
                    }
                    if (n.getText() != null) {
                        listData = this.listFiles.get("text");
                        if (listData == null) {
                            listData = new ArrayList<String>();
                        }
                        listData.add(sourceFile + File.separator + "text" + File.separator + n.getText().getName());
                        this.listFiles.put("text", listData);
                        if (!hm.containsKey(rd)) {
                            hm.put(rd, n);
                        }
                    }
                    list.add(rd);
                    ++j;
                }
                data.setData(list.toArray(new RouteData[0]));
                data.setOwner(owner);
                data.setStartDate(minDatet);
                data.setFinishDate((Date)var10_14);
                data.setName(String.valueOf(df.format(minDatet)) + " - " + df.format((Date)var10_14));
                this.listDataCurator.add(data);
                if (this.dateFrom.after(minDatet)) {
                    this.setDateFrom(minDatet);
                }
                if (this.dateTill.before((Date)var10_14)) {
                    this.setDateTill((Date)var10_14);
                }
            }
            String destinationDir = String.valueOf(localPath) + File.separator + String.valueOf(InitializedVariable.user.getId()).trim() + File.separator + dfYMD.format(this.minDate) + "-" + dfYMD.format(this.maxDate);
            try {
                FileUtils.copyFileToDirectory((File)f, (File)new File(destinationDir));
                if (f.exists()) {
                    f.delete();
                }
                for (String string : this.listFiles.keySet()) {
                    if (string.equalsIgnoreCase("xml")) continue;
                    String destinationSubDir = String.valueOf(destinationDir) + File.separator + string;
                    List<String> listData = this.listFiles.get(string);
                    int j = 0;
                    while (j < listData.size()) {
                        File file = new File(listData.get(j));
                        FileUtils.copyFileToDirectory((File)file, (File)new File(destinationSubDir));
                        if (file.exists()) {
                            file.delete();
                        }
                        ++j;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (hm.size() > 0) {
                for (Map.Entry entry : hm.entrySet()) {
                    this.setNotesFiles((RouteData)entry.getKey(), (Nddata)entry.getValue(), destinationDir);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private User findOwner(String name) {
        User owner = null;
        UserWSProxy userWSProxy = (UserWSProxy)CurrentProxyFactory.getProxy(User.class);
        UserSearchCriteria userSC = new UserSearchCriteria();
        userSC.setName("*" + name + "*");
        UserWSProxy.SearchResultListUser sr = userWSProxy.getUsers(InitializedVariable.context, userSC);
        if (!sr.isEmpty()) {
            owner = (User)sr.getObjList()[0];
        }
        return owner;
    }

    @ListField(fields={@Field(title="", propertiesUI={"background=#d4d0c8"}, readOnly=true, propertiesLayout="Split1/h/l/0.3:m1/#spanx 2,wrap#spanx 2, wrap", order=300)})
    public String getMess() {
        return this.mess;
    }

    public void setMess(String mess) {
        this.mess = mess;
    }

    @ListField(fields={@Field(title="", propertiesLayout="Split1/h/l/0.3:m1/#spanx 2,wrap#wrap", order=400, viewer={ViewerStateProgressBar.class})})
    public StateTask getStateTask() {
        if (this.stateTask == null) {
            this.stateTask = new StateTask();
            this.stateTask.setCurrent(Integer.valueOf(0));
            this.stateTask.setMaxProgress(Integer.valueOf(0));
            this.stateTask.setState(StateTask.stop);
        }
        return this.stateTask;
    }

    @ListField(fields={@Field(title="", readOnly=true, order=1500, viewer={MapViewerDataCurator.class}, propertiesLayout="Split1/h/r/0.7")})
    public MapValueWithTrackNew getValue() {
        return this.mapValueWithTrackNew;
    }

    protected synchronized void checkWaitFile(final PanelContext pc) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                File flag = new File(String.valueOf(CuratorTrackList.this.getPathSource().trim()) + File.separator + "wait_for.data.txt");
                CuratorTrackList.this.runTask(10000, "\u0416\u0434\u0435\u043c \u0440\u0435\u0430\u043a\u0446\u0438\u0438 \u043e\u0442 \u043f\u043b\u0430\u043d\u0448\u0435\u0442\u0430...", pc);
                while (flag.exists()) {
                    try {
                        CuratorTrackList.this.stateTask.incCurrent();
                        CuratorTrackList.this.updateUIState(pc);
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                CuratorTrackList.this.finishTask(pc);
            }
        }).start();
    }

    private void runImport(String[] files, File sourceFile, Date lastFileDate, PanelContext pc) {
        this.runTask(files.length, "\u0418\u0434\u0435\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445", pc);
        int i = 0;
        while (i < files.length) {
            String filename = sourceFile + File.separator + files[i];
            File xmlFile = new File(filename);
            if (xmlFile.lastModified() <= lastFileDate.getTime()) {
                this.readRouteFile(xmlFile, sourceFile);
                this.refreshInfoPoint();
                this.stateTask.incCurrent();
                this.updateUIState(pc);
                this.updateList(pc);
                this.updateMap(pc);
            }
            ++i;
        }
        this.finishTask(pc);
        pc.getPanel().updateUI();
    }

    public void importData(final PanelContext pc) {
        if (this.getPathSource() == null) {
            InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435", new String[]{" \u041d\u0435 \u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d \u043f\u0443\u0442\u044c \u043a \u0444\u0430\u0439\u043b\u0430\u043c \u043f\u043b\u0430\u043d\u0448\u0435\u0442\u0430.\n \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0445\u043e\u0442\u044f \u0431\u044b \u043e\u0434\u0438\u043d \u0440\u0430\u0437\n\u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e '\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043c\u0430\u0440\u0448\u0440\u0443\u0442 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430'."}), new BeanViewerAction[]{new MessageOKButton()});
            return;
        }
        File flag = new File(String.valueOf(this.getPathSource()) + File.separator + "wait_for.data.txt");
        Date lastFileDate = new Date();
        try {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(flag));
            dos.close();
            lastFileDate = new Date();
            this.checkWaitFile(pc);
            this.maxDate = new Date();
            this.minDate = new Date();
            try {
                this.maxDate = df.parse("01-01-2001 00:00:00");
                this.minDate = df.parse("01-01-2022 00:00:00");
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            this.listFiles.clear();
            final File sourceFile = new File(this.getPathSource());
            final String[] files = sourceFile.list(new OnlyExt("xml"));
            final Date lastFileDate1 = lastFileDate;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    CuratorTrackList.this.runImport(files, sourceFile, lastFileDate1, pc);
                }
            }).start();
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                System.out.println(e.getLocalizedMessage());
            } else {
                e.printStackTrace();
            }
            InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435", new String[]{" \u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0440\u0430\u043d\u0435\u0435 \n\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u043d\u043e\u043c\u0443 \u043f\u0443\u0442\u0438 \u043a \u0444\u0430\u0439\u043b\u0430\u043c \u043f\u043b\u0430\u043d\u0448\u0435\u0442\u0430.\n \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e \n'\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043c\u0430\u0440\u0448\u0440\u0443\u0442 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430'."}), new BeanViewerAction[]{new MessageOKButton()});
        }
    }

    public void clearData() {
        this.mapValueWithTrackNew.getListPoint().clear();
        this.mapValueWithTrackNew.getTracksData().clear();
        if (this.mapValueWithTrackNew.mapViewerWithTrack != null) {
            this.mapValueWithTrackNew.mapViewerWithTrack.change();
        }
    }

    public String getPathSource() {
        return this.pathSource;
    }

    public void setPathSource(String pathSource) {
        this.pathSource = pathSource;
    }

    public static String getCurrentPathToData() {
        return currentPathToData;
    }

    public static void setCurrentPathToData(String currentPathToData) {
        CuratorTrackList.currentPathToData = currentPathToData;
    }

    public static void main(String[] args) {
        SimpleDateFormat dfYMDS = new SimpleDateFormat("_ssSSS");
        System.out.println(dfYMDS.format(new Date()));
    }

    public boolean isToAsk() {
        return this.toAsk;
    }

    public void setToAsk(boolean toAsk) {
        this.toAsk = toAsk;
    }

    public String convCurrentTime() {
        return "";
    }

    public static class ChangeAction
    extends ActionCalculatedObject {
        public void actionPerformed(Object message) {
            if (!initializing) {
                ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
                ((PanelContext)((ViewerContext)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getParentContext()).getParentContext()).getPanel().updateUIForPresentatorName("value");
            }
        }
    }

    public static class ExtractorShowButton
    extends Extractor {
        public Object extract(Object value, Class<?> clManager) {
            return ((CuratorTrackList)((Object)((PanelContext)((ViewerContext)this.getPanelContextManager().getParentContext()).getParentContext()).getObject())).getShowTrack();
        }
    }

    @ListView(views={@View(title="")})
    public static class ShowTrack {
        boolean show = true;

        @ListField(fields={@Field(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u043f\u0443\u0442\u044c", order=0, showInManagerPanel=true, changeAction={ChangeAction.class})})
        public boolean isShow() {
            return this.show;
        }

        public void setShow(boolean show) {
            this.show = show;
        }
    }
}

