/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.curator.tracklist;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.buttons.Cancel;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.curator.tracklist.CuratorTrackList;
import ru.blok.vms.ui.curator.tracklist.buttons.AdderNote;
import ru.blok.vms.ui.curator.tracklist.buttons.CopyNote;
import ru.blok.vms.ui.curator.tracklist.buttons.OkSave;
import ru.blok.vms.ui.curator.tracklist.buttons.PasteNote;
import ru.blok.vms.ui.curator.tracklist.buttons.PlayNoteEditor;
import ru.blok.vms.ui.curator.tracklist.buttons.Remover;
import ru.blok.vms.ui.curator.tracklist.map.MapValueWithTrackCuratorEditor;
import ru.blok.vms.ui.curator.tracklist.map.MapViewerDataCuratorEditor;
import ru.blok.vms.ui.curator.tracklist.viewers.ListViewerNoteRoute;
import ru.blok.vms.ui.curator.tracklist.viewers.ListViewerRouteData;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.common.FileUtils;
import ru.infor.ws.objects.vms.entities.DataCurator;
import ru.infor.ws.objects.vms.entities.NoteRoute;
import ru.infor.ws.objects.vms.entities.RouteData;

@ListView(views={@View(title="", actions={@ActionViewer(clazz=OkSave.class), @ActionViewer(clazz=Cancel.class)}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class DataCuratorEditor
extends CommonObjectWithKey {
    DataCurator dataCurator;
    MapValueWithTrackCuratorEditor value;
    SimpleDateFormat dfsS = new SimpleDateFormat("_ssSSS");
    private NoteRoute copy;
    RouteData selectRoute;
    private NoteRoute selectNote;

    public DataCuratorEditor(String keyPage, DataCurator dataCurator) {
        super(keyPage);
        this.dataCurator = dataCurator;
        Double[] coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)keyPage));
        this.value = new MapValueWithTrackCuratorEditor(coord[0], coord[1], coord[2].intValue());
        this.value.setDataCuratorEditor(this);
    }

    public DataCurator getDataCurator() {
        return this.dataCurator;
    }

    public void setDataCurator(DataCurator dataCurator) {
        this.dataCurator = dataCurator;
    }

    @ListField(fields={@Field(title="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", order=10, propertiesLayout="Split1/h/l/0.3:m1#wrap")})
    public String getName() {
        return this.dataCurator.getName();
    }

    public void setName(String name) {
        this.dataCurator.setName(name);
    }

    @ListField(fields={@Field(title="\u0410\u0432\u0442\u043e\u0440", readOnly=true, order=20, propertiesLayout="Split1/h/l/0.3:m1#wrap")})
    public String getOwner() {
        return this.dataCurator.getOwner().getName();
    }

    @ListField(fields={@Field(title="", order=100, viewer={ListViewerRouteData.class}, propertiesLayout="Split1/h/l/0.3:m1#spanx 2,wrap#spanx 2,wrap", content=RouteData.class, panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=Remover.class)})})})
    public RouteData[] getRouteData() {
        return this.dataCurator.getData();
    }

    public void removeRouteData(RouteData data) {
        ArrayList<RouteData> l = new ArrayList<RouteData>();
        if (this.getRouteData() != null) {
            RouteData[] routeDataArray = this.getRouteData();
            int n = routeDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                RouteData r = routeDataArray[n2];
                l.add(r);
                ++n2;
            }
        }
        l.remove(data);
        this.dataCurator.setData(l.toArray(new RouteData[0]));
    }

    @ListField(fields={@Field(title="", order=200, viewer={ListViewerNoteRoute.class}, propertiesLayout="Split1/h/l/0.3:m1#spanx 2,wrap#spanx 2,wrap", content=NoteRoute.class, panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=PlayNoteEditor.class), @ActionField(clazz=CopyNote.class), @ActionField(clazz=PasteNote.class), @ActionField(clazz=AdderNote.class), @ActionField(clazz=Remover.class)})})})
    public NoteRoute[] getNoteRoutes() {
        if (this.selectRoute == null) {
            return null;
        }
        return this.selectRoute.getNotes();
    }

    public void removeNoteRoutes(NoteRoute data) {
        ArrayList<NoteRoute> l = new ArrayList<NoteRoute>();
        if (this.getNoteRoutes() != null) {
            NoteRoute[] noteRouteArray = this.getNoteRoutes();
            int n = noteRouteArray.length;
            int n2 = 0;
            while (n2 < n) {
                NoteRoute r = noteRouteArray[n2];
                l.add(r);
                ++n2;
            }
        }
        l.remove(data);
        this.getSelectRoute().setNotes(l.toArray(new NoteRoute[0]));
    }

    public NoteRoute getCopy() {
        return this.copy;
    }

    public void setCopy(NoteRoute copy) {
        this.copy = copy;
    }

    public void insertNote(NoteRoute nr) {
        ArrayList<NoteRoute> l = new ArrayList<NoteRoute>();
        if (this.getNoteRoutes() != null) {
            NoteRoute[] noteRouteArray = this.getNoteRoutes();
            int n = noteRouteArray.length;
            int n2 = 0;
            while (n2 < n) {
                NoteRoute r = noteRouteArray[n2];
                l.add(r);
                ++n2;
            }
        }
        nr.setEdited(true);
        l.add(nr);
        this.getSelectRoute().setNotes(l.toArray(new NoteRoute[0]));
        this.selectNote = nr;
    }

    public boolean pasteNote() {
        if (this.copy != null && this.getSelectRoute() != null) {
            NoteRoute nr = new NoteRoute();
            String name = this.copy.getPath().substring(this.copy.getPath().lastIndexOf("\\") + 1);
            String pathSource = this.copy.getPath().substring(0, this.copy.getPath().lastIndexOf("\\"));
            String nameNew = String.valueOf(name) + this.dfsS.format(new Date());
            if (name.indexOf(".") > -1) {
                nameNew = String.valueOf(name.substring(0, name.indexOf("."))) + this.dfsS.format(new Date()) + name.substring(name.indexOf("."), name.length());
            }
            File fileSource = CuratorTrackList.filePath(this.copy.getPath());
            String dest = String.valueOf(fileSource.getAbsoluteFile().getPath().substring(0, fileSource.getAbsoluteFile().getPath().lastIndexOf("\\") + 1)) + nameNew;
            try {
                DataOutputStream out = new DataOutputStream(new FileOutputStream(new File(dest)));
                FileUtils.copy((File)fileSource, (OutputStream)new BufferedOutputStream(out));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            nr.setPath(String.valueOf(pathSource) + File.separator + nameNew);
            nr.setType(this.copy.getType());
            this.insertNote(nr);
            return true;
        }
        return false;
    }

    public RouteData getSelectRoute() {
        return this.selectRoute;
    }

    public void setSelectRoute(RouteData selectRoute) {
        this.selectRoute = selectRoute;
        this.selectNote = null;
        if (selectRoute != null && selectRoute.getNotes() != null && selectRoute.getNotes().length > 0) {
            this.setSelectNote(selectRoute.getNotes()[0]);
        }
    }

    public NoteRoute getSelectNote() {
        return this.selectNote;
    }

    public void setSelectNote(NoteRoute selectNote) {
        this.selectNote = selectNote;
    }

    public void beforeShow(PanelContext pc) {
        BeanViewerAction a;
        FieldPresentation fp = pc.getPanel().getPresentatorForName("noteRoutes");
        BigContentViewer v = (BigContentViewer)fp.getViewer();
        pc.getPanel().setVisibleToAction(OkSave.class, true);
        for (Object bva : v.getActions()) {
            a = (BeanViewerAction)bva;
            v.getFactory().setVisibleObject(v.getActionsMap().get(a), true);
            a.setVisible(true);
        }
        if (this.dataCurator != null && this.dataCurator.getId() != null) {
            pc.getPanel().setVisibleToAction(OkSave.class, false);
            for (Object bva : v.getActions()) {
                if (bva instanceof PlayNoteEditor) continue;
                a = (BeanViewerAction)bva;
                v.getFactory().setVisibleObject(v.getActionsMap().get(a), false);
                a.setVisible(false);
            }
        }
        ((MapViewerDataCuratorEditor)pc.getPanel().getPresentatorForName("value").getViewer()).zoomToTracks();
    }

    public void selectInListNotes(PanelContext pc) {
        if (this.selectNote != null) {
            int k = 0;
            while (k < this.getNoteRoutes().length && this.getNoteRoutes()[k] != this.selectNote) {
                ++k;
            }
            if (k < this.getNoteRoutes().length) {
                ((ListViewer)pc.getPanel().getPresentatorForName("noteRoutes").getViewer()).getTM().setSelectedRows(new int[]{k});
            }
        } else {
            ((ListViewer)pc.getPanel().getPresentatorForName("noteRoutes").getViewer()).getTM().clearSelection();
        }
    }

    public void selectedInListRoute(PanelContext pc) {
        if (this.selectRoute == null) {
            ((ListViewer)pc.getPanel().getPresentatorForName("routeData").getViewer()).getTM().clearSelection();
        } else {
            int k = 0;
            while (k < this.getRouteData().length && this.getRouteData()[k] != this.selectRoute) {
                ++k;
            }
            if (k < this.getRouteData().length) {
                ((ListViewer)pc.getPanel().getPresentatorForName("routeData").getViewer()).getTM().setSelectedRows(new int[]{k});
            }
            this.selectInListNotes(pc);
        }
    }

    public void setSelectNote(NoteRoute selectNote, PanelContext pc) {
        this.setSelectNote(selectNote);
        this.selectRoute = null;
        if (selectNote != null) {
            RouteData[] routeDataArray = this.getRouteData();
            int n = routeDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                RouteData rd = routeDataArray[n2];
                if (rd.getNotes() != null) {
                    NoteRoute[] noteRouteArray = rd.getNotes();
                    int n3 = noteRouteArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        NoteRoute nr = noteRouteArray[n4];
                        if (nr == selectNote) {
                            this.selectRoute = rd;
                            break;
                        }
                        ++n4;
                    }
                }
                if (this.selectRoute != null) break;
                ++n2;
            }
        }
        this.selectedInListRoute(pc);
    }

    @ListField(fields={@Field(title="", readOnly=true, order=1500, viewer={MapViewerDataCuratorEditor.class}, propertiesLayout="Split1/h/r/0.7")})
    public MapValueWithTrackCuratorEditor getValue() {
        return this.value;
    }
}

