/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.curator.tracklist.buttons;

import java.awt.Desktop;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.core.ResourceStrings;
import ru.blok.vms.ui.curator.tracklist.CuratorTrackList;
import ru.blok.vms.ui.curator.tracklist.Note;
import ru.blok.vms.ui.curator.tracklist.map.MapViewerDataCurator;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.core.SecurityWSProxy;
import ru.infor.common.FileUtils;
import ru.infor.ws.objects.vms.entities.DataCurator;
import ru.infor.ws.objects.vms.entities.NoteRoute;
import ru.infor.ws.objects.vms.entities.RouteData;

public class PlayNote
extends BeanViewerAction<ViewerContext> {
    static SecurityWSProxy proxy = new SecurityWSProxy(CurrentProxyFactory.getCurrentSOAPConnection());

    public boolean isNotEnableWithEmptySelection() {
        return true;
    }

    public String getHint() {
        return "\u041e\u0442\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u044c \u0437\u0430\u043c\u0435\u0442\u043a\u0443";
    }

    public String getName() {
        return "\u041e\u0442\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u044c \u0437\u0430\u043c\u0435\u0442\u043a\u0443";
    }

    public String getIcon() {
        return ResourceStrings.btPlayBlue;
    }

    private static void loadDataFromServer(NoteRoute noteRoute, File dest) {
        try {
            String urlStr = proxy.getURLForDownload(InitializedVariable.context, noteRoute.getPath());
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)InitializedVariable.getCurrentConnection((URL)url);
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.connect();
            InputStream input = conn.getInputStream();
            FileUtils.copy((InputStream)input, (File)dest.getAbsoluteFile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File getFileName(NoteRoute n, DataCurator dc) {
        File desc = null;
        String destinationDir = String.valueOf(CuratorTrackList.localPath) + String.valueOf(InitializedVariable.user.getId()).trim() + File.separator + CuratorTrackList.dfYMD.format(dc.getStartDate()) + "-" + CuratorTrackList.dfYMD.format(dc.getFinishDate());
        destinationDir = String.valueOf(destinationDir) + File.separator + n.getType();
        if (dc.getId() != null) {
            desc = new File(String.valueOf(destinationDir) + File.separator + n.getPath());
            desc.getParentFile().mkdirs();
        } else {
            desc = new File(String.valueOf(destinationDir) + File.separator + n.getPath().substring(n.getPath().lastIndexOf(File.separator) + 1));
        }
        return desc;
    }

    public static File getNotesFile(NoteRoute n, DataCurator dc) {
        File desc = PlayNote.getFileName(n, dc);
        if (dc.getId() != null) {
            PlayNote.loadDataFromServer(n, desc);
        }
        return desc;
    }

    public static void runNote(NoteRoute n, RouteData rd, DataCurator dc, PanelContext pc) {
        try {
            File desc = PlayNote.getNotesFile(n, dc);
            String destinationDir = desc.getAbsolutePath();
            int s = destinationDir.indexOf("\\.");
            if (s >= 0) {
                destinationDir = String.valueOf(destinationDir.substring(0, s + 1)) + destinationDir.substring(s + 2);
            }
            desc = new File(destinationDir);
            if ("text".equals(n.getType())) {
                ((MapViewerDataCurator)pc.getPanel().getPresentatorForName("value").getViewer()).runTextNotes(n, rd, desc);
            } else {
                Desktop.getDesktop().open(desc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(Object message) {
        BigContentViewer bg = (BigContentViewer)((ViewerContext)this.getContext()).getPresentator().getViewer();
        try {
            Object o = bg.getEditInstance();
            if (o != null) {
                Note note = (Note)o;
                NoteRoute n = note.getNode();
                DataCurator dc = note.getCurator();
                RouteData rd = note.getRouteData();
                PlayNote.runNote(n, rd, dc, (PanelContext)((ViewerContext)this.getContext()).getParentContext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

