/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.curator.tracklist.map;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.curator.tracklist.CuratorTrackList;
import ru.blok.vms.ui.curator.tracklist.DataCuratorEditor;
import ru.blok.vms.ui.curator.tracklist.Note;
import ru.blok.vms.ui.curator.tracklist.buttons.AdderNote;
import ru.blok.vms.ui.curator.tracklist.buttons.PlayNote;
import ru.blok.vms.ui.curator.tracklist.map.MapValueWithTrackCurator;
import ru.blok.vms.ui.curator.tracklist.map.PainterDataCurator;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.newmapviewer.MapViewerWithTrackNew;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.ws.objects.vms.entities.DataCurator;
import ru.infor.ws.objects.vms.entities.NoteRoute;
import ru.infor.ws.objects.vms.entities.RouteData;

public class MapViewerDataCurator
extends MapViewerWithTrackNew {
    JInternalFrame f;
    JTextPane textPane;
    JLayeredPane pane;
    public static SimpleDateFormat dfYMD = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    NoteRoute noteRoute;
    File desc;

    public MapViewerDataCurator(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    protected void init() {
        super.init();
        this.f = new JInternalFrame();
        this.f.setSize(new Dimension(250, 150));
        this.f.setClosable(true);
        this.f.setDefaultCloseOperation(1);
        this.textPane = new JTextPane();
        this.f.getContentPane().add(new JScrollPane(this.textPane));
        JPanel p = new JPanel(new FlowLayout());
        JButton save = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapViewerDataCurator.this.saveNote();
            }
        });
        JButton cansel = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        cansel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapViewerDataCurator.this.f.setVisible(false);
            }
        });
        p.add(save);
        p.add(cansel);
        this.f.getContentPane().add((Component)p, "South");
        this.pane = new JDesktopPane();
        this.pane.add((Component)this.main, JLayeredPane.DEFAULT_LAYER);
        this.pane.add((Component)this.f, JLayeredPane.PALETTE_LAYER);
        this.pane.setVisible(true);
        this.pane.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                MapViewerDataCurator.this.main.setSize(MapViewerDataCurator.this.pane.getSize());
                MapViewerDataCurator.this.main.revalidate();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    @Override
    public JComponent getComponent(boolean arg0, boolean arg1) {
        return this.pane;
    }

    @Override
    protected MapViewPainter<JXMapViewer> getPainter() {
        this.nodepd = new PainterDataCurator<JXMapViewer>();
        return this.nodepd;
    }

    public void zoomToTracksDataCurator(DataCurator dc) {
        Double[] dd = this.getMinMax(dc);
        this.zoomToTracks(dd);
    }

    protected Double[] getMinMax(DataCurator dc) {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (dc != null && dc.getData() != null) {
            RouteData[] routeDataArray = dc.getData();
            int n = routeDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                RouteData d = routeDataArray[n2];
                if (minLat == null || d.getLat() < minLat) {
                    minLat = d.getLat();
                }
                if (maxLat == null || d.getLat() > maxLat) {
                    maxLat = d.getLat();
                }
                if (minLon == null || d.getLon() < minLon) {
                    minLon = d.getLon();
                }
                if (maxLon == null || d.getLon() > maxLon) {
                    maxLon = d.getLon();
                }
                ++n2;
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        if (this.mapValueWithTrack != null && ((MapValueWithTrackCurator)this.mapValueWithTrack).getCuratorTrackList() != null && ((MapValueWithTrackCurator)this.mapValueWithTrack).getCuratorTrackList().getListDataCurator() != null) {
            for (DataCurator dc : ((MapValueWithTrackCurator)this.mapValueWithTrack).getCuratorTrackList().getListDataCurator()) {
                if (dc.getData() == null) continue;
                RouteData[] routeDataArray = dc.getData();
                int n = routeDataArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RouteData d = routeDataArray[n2];
                    if (minLat == null || d.getLat() < minLat) {
                        minLat = d.getLat();
                    }
                    if (maxLat == null || d.getLat() > maxLat) {
                        maxLat = d.getLat();
                    }
                    if (minLon == null || d.getLon() < minLon) {
                        minLon = d.getLon();
                    }
                    if (maxLon == null || d.getLon() > maxLon) {
                        maxLon = d.getLon();
                    }
                    ++n2;
                }
            }
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    @Override
    public void setValue(Object arg0) {
        super.setValue(arg0);
        this.zoomToTracks();
    }

    protected int[] getCoord(double lat, double lon) {
        Rectangle viewportBounds = this.map.getMainMap().getViewportBounds();
        int zoom = this.map.getMainMap().getZoom();
        Dimension sizeInTiles = this.map.getMainMap().getTileFactory().getMapSize(zoom);
        int tileSize = this.map.getMainMap().getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Point2D point = this.map.getMainMap().getTileFactory().geoToPixel(new GeoPosition(lat, lon), this.map.getMainMap().getZoom());
        int x0 = (int)(point.getX() - ((RectangularShape)vp2).getX());
        int y0 = (int)(point.getY() - ((RectangularShape)vp2).getY());
        if (x0 > this.map.getMainMap().getWidth()) {
            x0 = this.map.getMainMap().getWidth() - 250;
        }
        if (x0 < 0) {
            x0 = 0;
        }
        if (y0 > this.map.getMainMap().getHeight()) {
            y0 = this.map.getMainMap().getHeight() - 250;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        return new int[]{x0, y0};
    }

    protected void saveNote() {
        try {
            Object obj = ((PanelContext)this.getViewerContext().getParentContext()).getObject();
            DataCurator dc = null;
            dc = obj instanceof DataCuratorEditor ? ((DataCuratorEditor)((Object)obj)).getDataCurator() : ((CuratorTrackList)((Object)obj)).getSelectDataCurator();
            if (dc != null && dc.getId() == null) {
                PrintWriter out = new PrintWriter(this.desc.getAbsoluteFile());
                out.print(this.textPane.getText());
                out.close();
                AdderNote.uploadFile(this.desc, this.noteRoute.getPath());
            }
            this.f.setVisible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runTextNotes(NoteRoute noteRoute, RouteData data, File desc) {
        block14: {
            this.f.setTitle(dfYMD.format(data.getCreatedDateTime()));
            this.noteRoute = noteRoute;
            this.desc = desc;
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(desc)));
                    String s = reader.readLine();
                    StringBuilder st = new StringBuilder();
                    if (s != null) {
                        st.append(s);
                        while ((s = reader.readLine()) != null) {
                            st.append("\n").append(s);
                        }
                    }
                    this.textPane.setText(st.toString());
                    int[] coord = this.getCoord(data.getLat(), data.getLon());
                    this.f.setLocation(coord[0], coord[1]);
                    this.f.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (reader == null) break block14;
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    protected void mouseClickedOnMap(MouseEvent e) {
        Object tt;
        double y;
        double x;
        Point2D.Double pClick;
        Note n;
        if (e.getClickCount() == 1) {
            double y2;
            double x2 = this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - (double)(this.map.getMainMap().getWidth() / 2);
            Point2D.Double pClick2 = new Point2D.Double(x2, y2 = this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - (double)(this.map.getMainMap().getHeight() / 2));
            Note n2 = ((PainterDataCurator)this.nodepd).includNote(pClick2);
            if (n2 != null) {
                Object tt2 = ((PanelContext)this.getViewerContext().getParentContext()).getObject();
                if (tt2 instanceof CuratorTrackList) {
                    ((CuratorTrackList)((Object)tt2)).setSelectNote(n2, (PanelContext)this.getViewerContext().getParentContext());
                    this.repaint();
                    return;
                }
            } else if (((MapValueWithTrackCurator)this.mapValueWithTrack).getCuratorTrackList().getListDataCurator() != null) {
                for (DataCurator t : ((MapValueWithTrackCurator)this.mapValueWithTrack).getCuratorTrackList().getListDataCurator()) {
                    Object tt3;
                    boolean c = ((PainterDataCurator)this.nodepd).include(t, pClick2);
                    if (!c || !((tt3 = ((PanelContext)this.getViewerContext().getParentContext()).getObject()) instanceof CuratorTrackList)) continue;
                    ((CuratorTrackList)((Object)tt3)).setSelectDataCurator(t, (PanelContext)this.getViewerContext().getParentContext());
                    this.repaint();
                    return;
                }
            }
        } else if (e.getClickCount() == 2 && (n = ((PainterDataCurator)this.nodepd).includNote(pClick = new Point2D.Double(x = this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - (double)(this.map.getMainMap().getWidth() / 2), y = this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - (double)(this.map.getMainMap().getHeight() / 2)))) != null && (tt = ((PanelContext)this.getViewerContext().getParentContext()).getObject()) instanceof CuratorTrackList) {
            ((CuratorTrackList)((Object)tt)).setSelectNote(n, (PanelContext)this.getViewerContext().getParentContext());
            this.repaint();
            PlayNote.runNote(n.getNode(), n.getRouteData(), n.getCurator(), (PanelContext)this.getViewerContext().getParentContext());
        }
    }
}

