/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.curator.tracklist.map;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.core.ResourceStrings;
import ru.blok.vms.ui.curator.tracklist.Note;
import ru.blok.vms.ui.curator.tracklist.map.MapValueWithTrackCurator;
import ru.blok.vms.ui.mapviewer.newmapviewer.NewPainterData;
import ru.infor.ws.objects.vms.entities.DataCurator;
import ru.infor.ws.objects.vms.entities.RouteData;

public class PainterDataCurator<T extends JXMapViewer>
extends NewPainterData<T> {
    public static Stroke defaultStroke = new BasicStroke(2.0f, 1, 1);
    private List<RouteData> routesWithNodes = new ArrayList<RouteData>();
    GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
    private HashMap<Date, Geometry> mapTrack = new HashMap();
    protected HashMap<Note, Polygon> mapV = new HashMap();
    static HashMap<String, String> typesIcon = new HashMap();

    static {
        typesIcon.put("text", ResourceStrings.textIcon);
        typesIcon.put("image", ResourceStrings.imageIcon);
        typesIcon.put("audio", ResourceStrings.audioIcon);
        typesIcon.put("video", ResourceStrings.videoIcon);
    }

    @Override
    protected void paintTracks(Graphics2D g, T map, Rectangle2D vp2, Rectangle2D vp3) {
        this.mapTrack.clear();
        this.mapV.clear();
        MapValueWithTrackCurator value = (MapValueWithTrackCurator)this.mapValueWithTrackNew;
        if (value != null && value.getCuratorTrackList() != null && value.getCuratorTrackList().getListDataCurator() != null) {
            List<DataCurator> ld = value.getCuratorTrackList().getListDataCurator();
            if (value.getCuratorTrackList().getShowTrack().isShow()) {
                int i = 0;
                while (i < ld.size()) {
                    if (value.getCuratorTrackList().getSelectDataCurator() != ld.get(i)) {
                        this.paintTrackCurator(ld.get(i), map, g, vp2, vp3, Color.BLUE, false, true);
                    }
                    ++i;
                }
                if (value.getCuratorTrackList().getSelectDataCurator() != null) {
                    this.paintTrackCurator(value.getCuratorTrackList().getSelectDataCurator(), map, g, vp2, vp3, Color.RED, true, true);
                }
            }
        }
        if (value != null && value.getCuratorTrackList() != null && value.getCuratorTrackList().getListNotes() != null) {
            this.paintIcons2(g, map, vp2, vp3, value.getCuratorTrackList().getListNotes(), value.getCuratorTrackList().getSelectNote());
        }
    }

    public static synchronized Double getAngle(RouteData prev, RouteData last) {
        Double angle = null;
        Double len = Math.sqrt((last.getLon() - prev.getLon()) * (last.getLon() - prev.getLon()) + (last.getLat() - prev.getLat()) * (last.getLat() - prev.getLat()));
        if (len > 1.0E-10) {
            angle = Math.asin((last.getLat() - prev.getLat()) / len);
            angle = 90.0 - 180.0 * angle / Math.PI;
            if (last.getLon() - prev.getLon() > 0.0) {
                angle = 360.0 - angle;
            }
            angle = 360.0 - angle;
        }
        return angle;
    }

    protected void paintTrackCurator(DataCurator dc, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, Color c, boolean select, boolean withGeom) {
        if (dc.getData() != null) {
            int s = dc.getData().length;
            Coordinate[] coords = new Coordinate[s];
            int from = 0;
            Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(dc.getData()[from].getLat().doubleValue(), dc.getData()[from].getLon().doubleValue()), map.getZoom());
            if (withGeom) {
                coords[0] = new Coordinate(pointFrom.getX(), pointFrom.getY());
            }
            if (dc.getData()[from].getNotes() != null && dc.getData()[from].getNotes().length > 0) {
                this.routesWithNodes.add(dc.getData()[from]);
            }
            if (!select) {
                g.setColor(c);
                g.fillOval((int)(pointFrom.getX() - vp2.getX()) - 2, (int)(pointFrom.getY() - vp2.getY()) - 2, 5, 5);
            }
            int k = 5;
            int i = 1;
            while (i < s) {
                Point2D pointTo = map.getTileFactory().geoToPixel(new GeoPosition(dc.getData()[i].getLat().doubleValue(), dc.getData()[i].getLon().doubleValue()), map.getZoom());
                if (withGeom) {
                    coords[i] = new Coordinate(pointTo.getX(), pointTo.getY());
                }
                pointFrom.distance(pointTo);
                this.paint(pointFrom, pointTo, map, g, vp2, vp3, c, defaultStroke);
                if (select && ++k % 7 == 0) {
                    Double angle = PainterDataCurator.getAngle(dc.getData()[i - 1], dc.getData()[i]);
                    this.paintS(g, vp2, vp3, dc.getData()[i], pointTo, angle, c);
                }
                from = i;
                pointFrom = pointTo;
                if (dc.getData()[from].getNotes() != null && dc.getData()[from].getNotes().length > 0) {
                    this.routesWithNodes.add(dc.getData()[from]);
                }
                ++i;
            }
            if (!select) {
                g.setColor(c);
                g.fillOval((int)(pointFrom.getX() - vp2.getX()) - 2, (int)(pointFrom.getY() - vp2.getY()) - 2, 5, 5);
            } else {
                i = s - 1;
                Double angle = PainterDataCurator.getAngle(dc.getData()[i - 1], dc.getData()[i]);
                this.paintS(g, vp2, vp3, dc.getData()[i], pointFrom, angle, c);
            }
            if (withGeom) {
                LineString l = this.geometryFactory.createLineString(coords);
                this.mapTrack.put(dc.getStartDate(), (Geometry)l);
            }
        }
    }

    public Note includNote(Point2D pClick) {
        for (Note p : this.mapV.keySet()) {
            if (this.mapV.get(p) == null || !this.mapV.get(p).contains(pClick)) continue;
            return p;
        }
        return null;
    }

    public boolean include(DataCurator d, Point2D pClick) {
        Coordinate c;
        Point point;
        Geometry l = this.mapTrack.get(d.getStartDate());
        return l != null && l.distance((Geometry)(point = this.geometryFactory.createPoint(c = new Coordinate(pClick.getX(), pClick.getY())))) < 5.0;
    }

    protected void paintS(Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, RouteData point, Point2D point2, Double angle, Color c) {
        if (angle != null && angle > 0.0) {
            if (vp2.contains(point2)) {
                int x = (int)(point2.getX() - vp2.getX());
                int y = (int)(point2.getY() - vp2.getY());
                g.translate(x, y);
                g.rotate(Math.toRadians(angle + 180.0));
                Polygon p = new Polygon();
                p.addPoint(0, 8);
                p.addPoint(-5, -2);
                p.addPoint(0, 0);
                p.addPoint(5, -2);
                p.addPoint(0, 8);
                g.setColor(c);
                g.fillPolygon(p);
                g.rotate(-Math.toRadians(angle + 180.0));
                g.translate(-x, -y);
            } else if (vp3.contains(point2)) {
                int x = (int)(point2.getX() - vp3.getX());
                int y = (int)(point2.getY() - vp3.getY());
                g.translate(x, y);
                g.rotate(Math.toRadians(angle + 180.0));
                Polygon p = new Polygon();
                p.addPoint(0, 8);
                p.addPoint(-5, -2);
                p.addPoint(0, 0);
                p.addPoint(5, -2);
                p.addPoint(0, 8);
                g.setColor(c);
                g.rotate(-Math.toRadians(angle + 180.0));
                g.translate(-x, -y);
            }
        }
    }

    protected void paintIcons2(Graphics2D g, T map, Rectangle2D vp2, Rectangle2D vp3, List<Note> list, Note selectNote) {
        this.mapV.clear();
        for (Note p : list) {
            if (selectNote == p) continue;
            this.mapV.put(p, this.paintIcon(typesIcon.get(p.getNode().getType()), p.getRouteData().getLat(), p.getRouteData().getLon(), map, g, vp2, vp3, false));
        }
        if (selectNote != null) {
            this.mapV.put(selectNote, this.paintIcon(typesIcon.get(selectNote.getNode().getType()), selectNote.getRouteData().getLat(), selectNote.getRouteData().getLon(), map, g, vp2, vp3, true));
        }
    }
}

