/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.emergancycallcard;

import java.awt.Color;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.buttons.Cancel;
import ru.blok.common.ui.directories.FRCBaseDirectoryViewer;
import ru.blok.common.ui.longTask.StateTask;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapViewerWithOneTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.NodeType;
import ru.blok.vms.ui.tracks.GraphicsViewer;
import ru.blok.vms.ui.tracks.TrackAll;
import ru.blok.vms.ui.tracks.cache.CacheData;
import ru.blok.vms.ui.tracks.cache.CacheForTrackAll;
import ru.blok.vms.ui.tracks.parameterdevice.ParameterViewer;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.BeanPanel;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.swing.viewers.TimeFormatViewer;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.PSValue;
import ru.infor.client.soap.proxy.vms.Transport2DeviceLinkWSProxy;
import ru.infor.ws.objects.vms.Transport2DeviceLinkSearchCriteria;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.Crew;
import ru.infor.ws.objects.vms.entities.EmergancyCallCard;
import ru.infor.ws.objects.vms.entities.NavigationDevice;
import ru.infor.ws.objects.vms.entities.Transport;
import ru.infor.ws.objects.vms.entities.Transport2DeviceLink;

@ListView(views={@View(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438 \u0432\u044b\u0437\u043e\u0432\u0430", actions={@ActionViewer(clazz=Cancel.class)}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class ViewEmergancyCallCardOnMapForm
extends TrackAll {
    private EmergancyCallCard ecc;
    private CacheData cache = new CacheForTrackAll(this.getKeyPage());
    MapValueWithTrack value;
    Date[] times = new Date[8];
    Color[] colors = new Color[]{Color.BLACK, Color.WHITE, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.BLUE, Color.RED, Color.MAGENTA};
    PanelContext pc;
    Double latMax = null;
    Double latMin = null;
    Double lonMax = null;
    Double lonMin = null;

    @Override
    public void setState(int i, boolean g) {
    }

    public ViewEmergancyCallCardOnMapForm(EmergancyCallCard ecc) {
        super("");
        this.ecc = ecc;
        this.value = new MapValueWithTrack();
        this.times[0] = ecc.getStartCallingCards();
        this.times[1] = ecc.getCallAt();
        this.times[2] = ecc.getLeaveBaseAt();
        this.times[3] = ecc.getArriveAddressAt();
        this.times[4] = ecc.getTransportationStartAt();
        this.times[5] = ecc.getArraiveHospitalAt();
        this.times[6] = ecc.getEndAt();
        this.times[7] = ecc.getReturnBaseAt();
        int cur = 0;
        while (cur < this.times.length && this.times[cur] == null) {
            ++cur;
        }
        if (cur >= this.times.length) {
            return;
        }
        Date tMin = this.times[cur];
        Date tMax = this.times[cur];
        int i = cur + 1;
        while (i < this.times.length) {
            if (this.times[i] != null) {
                if (tMin.after(this.times[i])) {
                    tMin = this.times[i];
                }
                if (tMax.before(this.times[i])) {
                    tMax = this.times[i];
                }
            }
            ++i;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(tMin);
        c.add(5, 1);
        if (tMax.after(c.getTime())) {
            tMax = c.getTime();
        }
        this.setDateFrom(tMin);
        this.setDateTill(tMax);
        this.setTransport(ecc.getTransport());
        this.loadData();
    }

    @Override
    public synchronized void reload(List<AbstractNDData> list) {
        this.list = list;
        this.value.getTracksNDData().clear();
        if (list != null && list.size() > 0) {
            Double[] dd;
            this.printTrack();
            if (this.value.mapViewerWithTrack != null && (dd = this.getMinMax()) != null && dd.length == 4) {
                this.value.setCenterPosition(new double[]{(dd[0] + dd[1]) / 2.0, (dd[2] + dd[3]) / 2.0});
                this.value.setZoomValue(this.value.mapViewerWithTrack.getZoom(dd) + 1);
            }
            this.grap = new Object[]{this.getParameter(), list};
            if (this.pc != null) {
                this.pc.getPanel().updateUIForPresentatorName("graphics");
            }
        }
    }

    @Override
    public Double[] getMinMax() {
        if (this.latMin != null && this.latMax != null && this.lonMin != null && this.lonMax != null) {
            return new Double[]{this.latMin, this.latMax, this.lonMin, this.lonMax};
        }
        return null;
    }

    private void printTrack() {
        Integer[] indexs = new Integer[8];
        int i = 0;
        while (i < 8) {
            indexs[i] = -1;
            ++i;
        }
        int cur = 0;
        indexs[0] = 0;
        int i2 = 1;
        while (i2 < 8) {
            if (this.times[i2] != null) {
                while (cur < this.list.size() && ((AbstractNDData)this.list.get(cur)).getCreatedDateTime().before(this.times[i2])) {
                    ++cur;
                }
                indexs[i2] = cur - 1;
            }
            ++i2;
        }
        this.value.setShowHint(true);
        boolean first = false;
        int i3 = 0;
        while (i3 < 7) {
            if (indexs[i3] > -1) {
                int k = i3 + 1;
                while (k < 8 && indexs[k] == -1) {
                    ++k;
                }
                if (k < 8) {
                    if (!first) {
                        this.latMin = Math.min(((AbstractNDData)this.list.get(0)).getLat(), ((AbstractNDData)this.list.get(indexs[k])).getLat());
                        this.latMax = Math.max(((AbstractNDData)this.list.get(0)).getLat(), ((AbstractNDData)this.list.get(indexs[k])).getLat());
                        this.lonMin = Math.min(((AbstractNDData)this.list.get(0)).getLon(), ((AbstractNDData)this.list.get(indexs[k])).getLon());
                        this.lonMax = Math.max(((AbstractNDData)this.list.get(0)).getLon(), ((AbstractNDData)this.list.get(indexs[k])).getLon());
                        this.value.eventAll(Integer.valueOf(15).longValue(), this.list, 0, 1, false, null, NodeType.DEFAULT, this.colors[0]);
                        this.value.getTrackNDData(Integer.valueOf(15).longValue()).setHints(new String[]{String.valueOf(1)});
                        first = true;
                    }
                    this.value.eventAll(Integer.valueOf(i3).longValue(), this.list, indexs[i3], indexs[k], false, null, NodeType.DEFAULT, this.colors[i3]);
                    this.value.getTrackNDData(Integer.valueOf(i3).longValue()).setHints(new String[]{String.valueOf(k + 1)});
                    this.latMin = Math.min(this.latMin, ((AbstractNDData)this.list.get(indexs[k])).getLat());
                    this.latMax = Math.max(this.latMax, ((AbstractNDData)this.list.get(indexs[k])).getLat());
                    this.lonMin = Math.min(this.lonMin, ((AbstractNDData)this.list.get(indexs[k])).getLon());
                    this.lonMax = Math.max(this.lonMax, ((AbstractNDData)this.list.get(indexs[k])).getLon());
                }
            }
            ++i3;
        }
    }

    @Override
    protected synchronized void loadData() {
        if (this.getLinkT2D() == null) {
            return;
        }
        if (this.getLinkT2D().getObjList() == null) {
            return;
        }
        if (this.getLinkT2D().getObjList().length == 0) {
            return;
        }
        this.getProgressAccel().setValue(0);
        this.list.clear();
        this.value.clear();
        this.grap = new Object[2];
        boolean b = false;
        if (this.ecc.getTransport() != null) {
            b = true;
        }
        if (b) {
            this.setTransport(this.ecc.getTransport());
            Transport2DeviceLinkWSProxy t2deviceProxy = (Transport2DeviceLinkWSProxy)CurrentProxyFactory.getProxy(Transport2DeviceLink.class);
            Transport2DeviceLinkSearchCriteria t2delSC = new Transport2DeviceLinkSearchCriteria();
            t2delSC.setTransportIdList(new Long[]{this.ecc.getTransport().getId()});
            Date dateFrom = this.ecc.getStartCallingCards();
            if (dateFrom == null) {
                dateFrom = new Date();
            }
            t2delSC.setActiveOnDate(dateFrom);
            Transport2DeviceLinkWSProxy.SearchResultListTransport2DeviceLink sr = t2deviceProxy.getList(InitializedVariable.context, t2delSC);
            NavigationDevice d = null;
            if (!sr.isEmpty()) {
                d = ((Transport2DeviceLink)sr.getObjList()[0]).getDevice();
            }
            this.setDevice(d);
        }
        if (this.pc != null) {
            FieldPresentation pp = this.pc.getPanel().getPresentatorForName("parameter");
            FieldPresentation sg = this.pc.getPanel().getPresentatorForName("showGraphics");
            ((BeanPanel)this.pc.getPanel()).setVisibleToField(pp, b);
            ((BeanPanel)this.pc.getPanel()).setVisibleToField(sg, b);
            ((ParameterViewer)pp.getViewer()).updateItems();
            this.pc.getPanel().updateUIForPresentatorName("parameter");
            this.pc.getPanel().updateUIForPresentatorName("graphics");
        }
        this.cache.getWayLong(this.getDateFrom(), this.getDateTill(), this.getLinkT2D().getObjList(), this);
        this.cache.getData(this.getDateFrom(), this.getDateTill(), this.getLinkT2D().getObjList(), this);
    }

    @Override
    public void updateUI() {
    }

    @Override
    public void updateUI2(int current) {
        if (this.pc != null) {
            ((GraphicsViewer)this.pc.getPanel().getPresentatorForName("graphics").getViewer()).setStateLine(current);
        }
    }

    @Override
    @ListField(fields={@Field(title="", order=500, viewer={MapViewerWithOneTrack.class}, propertiesLayout="Scroll1:Split1/h/r/0.2:Scroll1:Split1/v/l/0.8")})
    public MapValueWithTrack getValue() {
        return this.value;
    }

    @ListField(fields={@Field(title="\u041d\u043e\u043c\u0435\u0440", readOnly=true, order=20, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1/ins 0, hidemode 1,wrap 2/n/spanx# w 200")})
    public Integer getNum() {
        if (this.ecc != null) {
            return this.ecc.getNum();
        }
        return null;
    }

    @ListField(fields={@Field(title="\u0414\u0430\u0442\u0430", readOnly=true, order=25, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200")})
    public Date getCreatedDateTime() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getCreatedDateTime();
    }

    @ListField(fields={@Field(title="\u0413\u043e\u0441.\u043d\u043e\u043c\u0435\u0440 \u0422\u0421", readOnly=true, order=30, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200")})
    public String getRegnum() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getRegnum();
    }

    @ListField(fields={@Field(title="\u0411\u0440\u0438\u0433\u0430\u0434\u0430", readOnly=true, viewer={FRCBaseDirectoryViewer.class}, order=40, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200")})
    public Crew getCrew() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getCrew();
    }

    @ListField(fields={@Field(title="\u0410\u0434\u0440\u0435\u0441", readOnly=true, order=50, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200")})
    public String getAddress() {
        if (this.ecc != null) {
            return this.ecc.getAddress();
        }
        return null;
    }

    @ListField(fields={@Field(title="\u041f\u0440\u0438\u0447\u0438\u043d\u0430", readOnly=true, order=60, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200")})
    public String getReasonname() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getReasonname();
    }

    @ListField(fields={@Field(title="\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u043d\u0435\u0441\u0447\u0430\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u043b\u0443\u0447\u0430\u044f", readOnly=true, order=70, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200")})
    public String getAccidentCauseName() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getAccidentCauseName();
    }

    @ListField(fields={@Field(title="1. \u0412\u0440\u0435\u043c\u044f \u0432\u044b\u0437\u043e\u0432\u0430", readOnly=true, order=80, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200", viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"})})
    public Date getStartCallingCards() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getStartCallingCards();
    }

    @ListField(fields={@Field(title="2. \u0412\u0440\u0435\u043c\u044f \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0438 \u0432\u044b\u0437\u043e\u0432\u0430", readOnly=true, order=90, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200", viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"})})
    public Date getCallAt() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getCallAt();
    }

    @ListField(fields={@Field(title="3. \u0412\u0440\u0435\u043c\u044f \u0432\u044b\u0435\u0437\u0434\u0430", readOnly=true, order=100, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200", viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"})})
    public Date getLeaveBaseAt() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getLeaveBaseAt();
    }

    @ListField(fields={@Field(title="4. \u0412\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u0435\u0437\u0434\u0430", readOnly=true, order=110, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200", viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"})})
    public Date getArriveAddressAt() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getArriveAddressAt();
    }

    @ListField(fields={@Field(title="5. \u0412\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438", readOnly=true, order=120, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200", viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"})})
    public Date getTransportationStartAt() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getTransportationStartAt();
    }

    @ListField(fields={@Field(title="6. \u0412\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f \u0432 \u041b\u041f\u0423", readOnly=true, order=130, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200", viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"})})
    public Date getArraiveHospitalAt() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getArraiveHospitalAt();
    }

    @ListField(fields={@Field(title="7. \u0412\u0440\u0435\u043c\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u0432\u044b\u0437\u043e\u0432\u0430", readOnly=true, order=140, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200", viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"})})
    public Date getEndAt() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getEndAt();
    }

    @ListField(fields={@Field(title="8. \u0412\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f \u043d\u0430 \u0431\u0430\u0437\u0443", readOnly=true, order=150, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200", viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"})})
    public Date getReturnBaseAt() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getReturnBaseAt();
    }

    @ListField(fields={@Field(title="\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u0435\u0437\u0434\u0430", readOnly=true, order=160, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0413\u043b\u043e\u043d\u0430\u0441\u0441:m:1:1/ins 0, hidemode 1,wrap 2/n/spanx# w 200", viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"})})
    public Date getLeaveBaseAt_byG() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getLeaveBaseAt_byG();
    }

    @ListField(fields={@Field(title="\u0412\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u0435\u0437\u0434\u0430", readOnly=true, order=170, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0413\u043b\u043e\u043d\u0430\u0441\u0441:m:1:1# w 200", viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"})})
    public Date getArriveAddressAt_byG() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getArriveAddressAt_byG();
    }

    @ListField(fields={@Field(title="\u0412\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438", readOnly=true, order=180, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0413\u043b\u043e\u043d\u0430\u0441\u0441:m:1:1# w 200", viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"})})
    public Date getTransportationStartAt_byG() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getTransportationStartAt_byG();
    }

    @ListField(fields={@Field(title="\u0412\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f \u0432 \u041b\u041f\u0423", readOnly=true, order=190, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0413\u043b\u043e\u043d\u0430\u0441\u0441:m:1:1# w 200", viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"})})
    public Date getArraiveHospitalAt_byG() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getArraiveHospitalAt_byG();
    }

    @ListField(fields={@Field(title="\u0412\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f \u043d\u0430 \u0411\u0430\u0437\u0443", readOnly=true, order=200, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0413\u043b\u043e\u043d\u0430\u0441\u0441:m:1:1# w 200", viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"})})
    public Date getReturnBaseAt_byG() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getReturnBaseAt_byG();
    }

    @ListField(fields={@Field(title="\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u0432\u044b\u0437\u043e\u0432\u0430", readOnly=true, order=210, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0413\u043b\u043e\u043d\u0430\u0441\u0441:m:1:1# w 200", viewer={TimeFormatViewer.class}, propertiesField={"format=HH:mm"})})
    public Date getEndAt_byG() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getEndAt_byG();
    }

    @Column(length=2048)
    @ListField(fields={@Field(title="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", readOnly=true, order=220, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200")})
    public String getDescription() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getDescription();
    }

    public Integer getSentMessage() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getSentMessage();
    }

    public Integer getSentStatus() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getSentStatus();
    }

    public Integer getMethodTransmittingCall() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getMethodTransmittingCall();
    }

    @ListField(fields={@Field(title="\u0412\u0438\u0434 \u0432\u044b\u0437\u043e\u0432\u0430", readOnly=true, order=260, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200")})
    public Integer getTypeOfCall() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getTypeOfCall();
    }

    @ListField(fields={@Field(title="\u041d\u043e\u043c\u0435\u0440 \u0441\u043c\u0435\u043d\u044b", readOnly=true, order=270, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200")})
    public Integer getNumberShift() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getNumberShift();
    }

    public Double getLat() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getLat();
    }

    public Double getLon() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getLon();
    }

    public String getOgrnEmergancy() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getOgrnEmergancy();
    }

    public String getOgrnHospital() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getOgrnHospital();
    }

    public String getExternalCardNum() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getExternalCardNum();
    }

    @ListField(fields={@Field(title="\u0413\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0430\u0434\u0440\u0435\u0441\u0430 (\u0430\u0432\u0442)", readOnly=true, order=330, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430:m:1:1# w 200")})
    public Integer getAutoGeocodingAddress() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getAutoGeocodingAddress();
    }

    @Override
    public Transport getTransport() {
        if (this.ecc == null) {
            return null;
        }
        return this.ecc.getTransport();
    }

    @Override
    public BeanViewerAction<ViewerContext> getExportDataToOSM() {
        return super.getExportDataToOSM();
    }

    @Override
    public String getCountPoint() {
        return "";
    }

    @Override
    public void setPlayStopButton(PanelContext context, boolean playEditable, boolean pauseEditable) {
    }

    @Override
    public String getLastTime() {
        return super.getLastTime();
    }

    @Override
    public Double getSpeed() {
        return super.getSpeed();
    }

    @Override
    public String getLongway() {
        return super.getLongway();
    }

    @Override
    public String getFuelConsumption() {
        return super.getFuelConsumption();
    }

    @Override
    public String getFuelOn100Kilometers() {
        return super.getFuelOn100Kilometers();
    }

    @Override
    public List<BeanViewerAction<ViewerContext>> getListEasyBt() {
        return super.getListEasyBt();
    }

    @Override
    public Date getDateFrom() {
        return super.getDateFrom();
    }

    @Override
    public Date getTimeFrom() {
        return super.getTimeFrom();
    }

    @Override
    public Date getDateTill() {
        return super.getDateTill();
    }

    @Override
    public Date getTimeTill() {
        return super.getTimeTill();
    }

    @Override
    public Long[] getListZoneID() {
        return super.getListZoneID();
    }

    @Override
    public boolean isWithDeviation() {
        return super.isWithDeviation();
    }

    @Override
    public BeanViewerAction<ViewerContext> getLoadData() {
        return super.getLoadData();
    }

    @Override
    public StateTask getStateTask() {
        return super.getStateTask();
    }

    @Override
    public BeanViewerAction<ViewerContext> getFieldButtonViewAll() {
        return super.getFieldButtonViewAll();
    }

    @Override
    public Integer getAccel() {
        return super.getAccel();
    }

    @Override
    public BeanViewerAction<ViewerContext> getFieldButtonViewWithAcceleration() {
        return super.getFieldButtonViewWithAcceleration();
    }

    @Override
    public BeanViewerAction<ViewerContext> getFieldButtonViewWithAccelerationStop() {
        return super.getFieldButtonViewWithAccelerationStop();
    }

    @Override
    public PSValue getProgressAccel() {
        return super.getProgressAccel();
    }

    @Override
    public Object getImage() {
        return super.getImage();
    }

    @Override
    public void beforeShow(PanelContext pc) {
        this.pc = pc;
        super.beforeShow(pc);
    }
}

