/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.event;

import edu.emory.mathcs.backport.java.util.Arrays;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.list.ObjectUIList;
import ru.infor.beanviewer.viewer.list.AsyncListIndexes;
import ru.infor.beanviewer.viewer.list.DataChangedListener;
import ru.infor.beanviewer.viewer.list.ListWithAutoRefresh;
import ru.infor.client.soap.proxy.vms.EventUIWSProxy;
import ru.infor.websocket.client.SocketClientFactory;
import ru.infor.websocket.transport.SubscribingOptions;
import ru.infor.websocket.transport.UnsubscribingOptions;
import ru.infor.ws.business.vms.websocket.EventSocketIntf;
import ru.infor.ws.business.vms.websocket.objects.SubscribingOptions_SendEventUI;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.events.EventSearchCriteria;
import ru.infor.ws.objects.events.EventUI;

public class ObjectUIListWithAutoRefresh<T>
extends ObjectUIList<T>
implements ListWithAutoRefresh,
EventSocketIntf {
    boolean autoRefresh;
    private long timeMillis;
    private EventUIWSProxy proxy;
    private EventSearchCriteria scs;
    long start;
    EventSearchCriteria sc;
    int sizeOld;
    String sid = null;
    String keyPage;

    public ObjectUIListWithAutoRefresh(Class<T> cls, String keyPage) {
        super(cls, keyPage);
    }

    private boolean equals(Long[] s1, Long[] s2) {
        if (s1 == null || s2 == null) {
            return true;
        }
        if (s1 != null && s2 == null || s1 == null && s2 != null) {
            return false;
        }
        if (s1.length != s2.length) {
            return false;
        }
        int i = 0;
        while (i < s1.length) {
            if (s1[i] != null && s2[i] == null || s1[i] == null && s2[i] != null) {
                return false;
            }
            if (!s1[i].equals(s2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean equalsSC(EventSearchCriteria sc1, EventSearchCriteria sc2) {
        if (sc1 == null || sc2 == null) {
            return false;
        }
        if (sc1.getEventDateFrom() != null && !sc1.getEventDateFrom().equals(sc2.getEventDateFrom())) {
            return false;
        }
        if (sc1.getEventDateTill() != null && !sc1.getEventDateTill().equals(sc2.getEventDateTill())) {
            return false;
        }
        if (!this.equals(sc1.getInitiatorIdList(), sc2.getInitiatorIdList())) {
            return false;
        }
        if (sc1.getNotLocked() != null && !sc1.getNotLocked().equals(sc2.getNotLocked())) {
            return false;
        }
        if (!this.equals(sc1.getImportanceEventIdList(), sc2.getImportanceEventIdList())) {
            return false;
        }
        if (sc1.getMessage() != null && !sc1.getMessage().equals(sc2.getMessage())) {
            return false;
        }
        if (!this.equals(sc1.getImportanceEventIdList(), sc2.getImportanceEventIdList())) {
            return false;
        }
        if (sc1.getMessage() != null && !sc1.getMessage().equals(sc2.getMessage())) {
            return false;
        }
        if (!this.equals(sc1.getNddataIdList(), sc2.getNddataIdList())) {
            return false;
        }
        if (sc1.getQuickSearch() != null && !sc1.getQuickSearch().equals(sc2.getQuickSearch())) {
            return false;
        }
        if (sc1.getReactionDateFrom() != null && !sc1.getReactionDateFrom().equals(sc2.getReactionDateFrom())) {
            return false;
        }
        if (sc1.getReactionDateTill() != null && !sc1.getReactionDateTill().equals(sc2.getReactionDateTill())) {
            return false;
        }
        if (!this.equals(sc1.getReactionRezultIdList(), sc2.getReactionRezultIdList())) {
            return false;
        }
        if (!this.equals(sc1.getReactionTypeIdList(), sc2.getReactionTypeIdList())) {
            return false;
        }
        return sc1.getShowAll() == null || sc1.getShowAll().equals(sc2.getShowAll());
    }

    private void copySC(EventSearchCriteria scs, EventSearchCriteria sc) {
        sc.setEventDateFrom(scs.getEventDateFrom());
        sc.setEventDateTill(scs.getEventDateTill());
        sc.setInitiatorIdList(scs.getInitiatorIdList());
        sc.setNotLocked(scs.getNotLocked());
        sc.setImportanceEventIdList(scs.getImportanceEventIdList());
        sc.setMessage(scs.getMessage());
        sc.setNddataIdList(scs.getNddataIdList());
        sc.setQuickSearch(scs.getQuickSearch());
        sc.setReactionDateFrom(scs.getReactionDateFrom());
        sc.setReactionDateTill(scs.getReactionDateTill());
        sc.setReactionRezultIdList(scs.getReactionRezultIdList());
        sc.setReactionTypeIdList(scs.getReactionTypeIdList());
        sc.setShowAll(scs.getShowAll());
    }

    public void startAutoRefresh(final long timeMillis, final EventUIWSProxy proxy, EventSearchCriteria scs) {
        this.timeMillis = timeMillis;
        this.proxy = proxy;
        this.scs = scs;
        this.start = System.currentTimeMillis();
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(timeMillis);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                long startMy = ObjectUIListWithAutoRefresh.this.start;
                ObjectUIListWithAutoRefresh.this.sc = (EventSearchCriteria)proxy._getSearchCriteriaTemplate();
                ObjectUIListWithAutoRefresh.this.copySC(ObjectUIListWithAutoRefresh.this.scs, ObjectUIListWithAutoRefresh.this.sc);
                ObjectUIListWithAutoRefresh.this.sc.appendSorting(SortObject.getInstance((String)"createdDateTime", (String)SortObject.DIRECTION_DESC));
                ObjectUIListWithAutoRefresh.this.sizeOld = ObjectUIListWithAutoRefresh.this.size();
                ObjectUIListWithAutoRefresh.this.setAutoRefresh(true);
                while (ObjectUIListWithAutoRefresh.this.isAutoRefresh() && startMy == ObjectUIListWithAutoRefresh.this.start) {
                    ObjectUIListWithAutoRefresh.this.getNewsData();
                    try {
                        Thread.sleep(timeMillis);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    public void startAutoRefresh2(String keyPage, EventSearchCriteria scs) {
        this.keyPage = keyPage;
        SubscribingOptions_SendEventUI options = new SubscribingOptions_SendEventUI();
        options.setContext(InitializedVariable.getContext((String)keyPage));
        options.setServiceName("EventWS");
        options.setMethodName("sendEvent");
        options.setDeviceIdList(Arrays.asList((Object[])scs.getInitiatorIdList()));
        options.setSid(this.sid);
        try {
            this.sid = SocketClientFactory.subscribe((Object)((Object)this), (SubscribingOptions)options, (String)InitializedVariable.getAppShortName((String)keyPage));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getNewsData() {
        if (this.scs != null && this.sc != null && !this.equalsSC(this.scs, this.sc)) {
            this.copySC(this.scs, this.sc);
            this.sizeOld = this.size();
        }
        this.updateSize();
        if (this.sizeOld < this.size()) {
            this.indxs.setDead(true);
            this.setFilling(false);
            this.setFullList(false);
            this.indxs = new AsyncListIndexes();
            this.get(0);
            for (DataChangedListener changedListener : this.listeners) {
                changedListener.dataChanged(null);
            }
        }
        this.sizeOld = this.size();
    }

    public synchronized void compromateAllData() {
        if (this.isAutoRefresh()) {
            this.stopAutoRefresh();
            super.compromateAllData();
            this.startAutoRefresh(this.timeMillis, this.proxy, this.scs);
        } else {
            super.compromateAllData();
        }
    }

    public void stopAutoRefresh() {
        this.setAutoRefresh(false);
        if (this.sid != null) {
            UnsubscribingOptions optionsU = new UnsubscribingOptions();
            optionsU.setContext(InitializedVariable.getContext((String)this.keyPage));
            optionsU.setServiceName("EventWS");
            optionsU.setMethodName("sendEvent");
            optionsU.setSid(this.sid);
            try {
                SocketClientFactory.unsubscribe((UnsubscribingOptions)optionsU, (String)InitializedVariable.getAppShortName((String)this.keyPage));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public void sendEvent(List<EventUI> list) {
        HashMap<Integer, Object> newInd = new HashMap<Integer, Object>();
        int i = list.size() - 1;
        while (i >= 0) {
            newInd.put(i, list.get(i));
            --i;
        }
        Map oldInd = this.indxs.getIndexes();
        ArrayList key = new ArrayList(oldInd.keySet());
        Collections.sort(key);
        int s = 0;
        for (Integer i2 : key) {
            int j = i2 + s;
            while (newInd.containsKey(j)) {
                ++j;
                ++s;
            }
            newInd.put(j, oldInd.get(i2));
        }
        this.indxs.clearPlan();
        this.indxs.setIndexes(newInd);
        this.size += list.size();
        for (DataChangedListener changedListener : this.listeners) {
            changedListener.dataChanged(list);
        }
    }
}

