/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.geo;

import com.vividsolutions.jts.densify.Densifier;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jxmapviewer.viewer.GeoPosition;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import ru.blok.vms.ui.geo.GeometryFunctions;

public class GeoUtils {
    static GeodeticCalculator gc = new GeodeticCalculator();
    public static String wkt4326 = "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]";
    public static String wkt3395 = "PROJCS[\"WGS 84 / World Mercator\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Mercator_1SP\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"3395\"]]";
    public static String wkt3576 = "PROJCS[\"WGS 84 / North Pole LAEA Russia\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"latitude_of_center\",90],PARAMETER[\"longitude_of_center\",90],PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3576\"]]";

    public static Geometry buildGeometryFromString(String geom) {
        Object p = null;
        if (geom != null) {
            try {
                p = geom.toLowerCase().indexOf("MultiPolygon".toLowerCase()) > -1 ? new MultiPolygon(geom) : (geom.toLowerCase().indexOf("MULTILINESTRING".toLowerCase()) > -1 ? new MultiLineString(geom) : (geom.toLowerCase().indexOf("LINESTRING".toLowerCase()) > -1 ? new LineString(geom) : new org.postgis.Polygon(geom)));
            }
            catch (Exception exception) {}
        }
        return p;
    }

    public static Double buildLength(GeoPosition gp1, GeoPosition gp2) {
        Double mi = 0.0;
        gc.setStartingGeographicPoint(gp1.getLongitude(), gp1.getLatitude());
        gc.setDestinationGeographicPoint(gp2.getLongitude(), gp2.getLatitude());
        mi = mi + gc.getOrthodromicDistance();
        return mi / 1000.0;
    }

    public static Double buildLengthFromGeometry(Geometry p) {
        Double mi = 0.0;
        if (p instanceof MultiPolygon) {
            org.postgis.Polygon[] polygonArray = ((MultiPolygon)p).getPolygons();
            int n = polygonArray.length;
            int n2 = 0;
            while (n2 < n) {
                org.postgis.Polygon pol = polygonArray[n2];
                mi = mi + GeoUtils.fromPolygon(pol);
                ++n2;
            }
        } else if (p instanceof MultiLineString) {
            LineString[] lineStringArray = ((MultiLineString)p).getLines();
            int n = lineStringArray.length;
            int n3 = 0;
            while (n3 < n) {
                LineString pol = lineStringArray[n3];
                mi = mi + GeoUtils.fromGeometry(pol.getPoints());
                ++n3;
            }
        } else if (p instanceof org.postgis.Polygon) {
            mi = mi + GeoUtils.fromPolygon((org.postgis.Polygon)p);
        } else if (p instanceof LineString) {
            mi = mi + GeoUtils.fromGeometry(((LineString)p).getPoints());
        }
        return mi;
    }

    private static Double fromGeometry(Point[] points) {
        Double mi = 0.0;
        int i = 1;
        while (i < points.length) {
            gc.setStartingGeographicPoint(points[i - 1].getX(), points[i - 1].getY());
            gc.setDestinationGeographicPoint(points[i].getX(), points[i].getY());
            mi = mi + gc.getOrthodromicDistance();
            ++i;
        }
        return mi / 1000.0;
    }

    private static Double fromPolygon(org.postgis.Polygon pol) {
        Double mi = 0.0;
        int i = 0;
        while (i < pol.getDimension()) {
            org.postgis.LinearRing lr = pol.getRing(i);
            mi = mi + GeoUtils.fromGeometry(lr.getPoints());
            ++i;
        }
        return mi;
    }

    public static Point[] getAllPoints(Geometry p) {
        ArrayList<Point> list = new ArrayList<Point>();
        if (p instanceof MultiPolygon) {
            org.postgis.Polygon[] polygonArray = ((MultiPolygon)p).getPolygons();
            int n = polygonArray.length;
            int n2 = 0;
            while (n2 < n) {
                org.postgis.Polygon pol = polygonArray[n2];
                list.addAll(GeoUtils.pointsFromPolygon(pol));
                ++n2;
            }
        } else if (p instanceof MultiLineString) {
            LineString[] lineStringArray = ((MultiLineString)p).getLines();
            int n = lineStringArray.length;
            int n3 = 0;
            while (n3 < n) {
                LineString pol = lineStringArray[n3];
                list.addAll(GeoUtils.pointsFromGeometry(pol.getPoints()));
                ++n3;
            }
        } else if (p instanceof org.postgis.Polygon) {
            list.addAll(GeoUtils.pointsFromPolygon((org.postgis.Polygon)p));
        } else if (p instanceof LineString) {
            list.addAll(GeoUtils.pointsFromGeometry(((LineString)p).getPoints()));
        }
        return list.toArray(new Point[list.size()]);
    }

    private static List<Point> pointsFromGeometry(Point[] points) {
        ArrayList<Point> list = new ArrayList<Point>();
        int i = 0;
        while (i < points.length) {
            list.add(points[i]);
            ++i;
        }
        return list;
    }

    private static List<Point> pointsFromPolygon(org.postgis.Polygon pol) {
        ArrayList<Point> list = new ArrayList<Point>();
        int i = 0;
        while (i < pol.getDimension()) {
            org.postgis.LinearRing lr = pol.getRing(i);
            if (lr != null) {
                list.addAll(GeoUtils.pointsFromGeometry(lr.getPoints()));
            }
            ++i;
        }
        return list;
    }

    public static String createAreaRoute(String geom, Double wRoute) {
        Object[] oo;
        block6: {
            Geometry geometry = GeoUtils.buildGeometryFromString(geom);
            if (geometry == null) {
                return null;
            }
            Point[] points = GeoUtils.getAllPoints(geometry);
            Double widthRoute = 20.0;
            if (wRoute != null && wRoute > 0.0) {
                widthRoute = wRoute;
            }
            GeometryFactory f = new GeometryFactory();
            try {
                CoordinateReferenceSystem sourceCRS = CRS.parseWKT((String)wkt4326);
                CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)wkt3395);
                MathTransform math = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
                MathTransform math2 = CRS.findMathTransform((CoordinateReferenceSystem)targetCRS, (CoordinateReferenceSystem)sourceCRS);
                Coordinate[] cc = new Coordinate[points.length];
                GeneralDirectPosition pt1 = null;
                DirectPosition pt2 = null;
                Coordinate c = null;
                int i = 0;
                while (i < points.length) {
                    pt1 = new GeneralDirectPosition(points[i].getX(), points[i].getY());
                    pt2 = math.transform((DirectPosition)pt1, null);
                    cc[i] = c = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                    ++i;
                }
                oo = GeoUtils.createPolygonByCoordinate3395(cc, f, math2, widthRoute);
                if (oo != null) break block6;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return ((Geometry)oo[0]).toString();
    }

    public static Object[] createPolygonByCoordinate3395(Coordinate[] cc, GeometryFactory f, MathTransform math2, Double width) throws MismatchedDimensionException, TransformException {
        com.vividsolutions.jts.geom.LineString s = f.createLineString(cc);
        com.vividsolutions.jts.geom.Geometry buffer = s.buffer(width.doubleValue());
        if (buffer instanceof Polygon) {
            Polygon p = (Polygon)buffer;
            Coordinate[] cc1 = new Coordinate[p.getCoordinates().length];
            int i = 0;
            while (i < p.getCoordinates().length) {
                Coordinate c = p.getCoordinates()[i];
                GeneralDirectPosition pt1 = new GeneralDirectPosition(c.x, c.y);
                DirectPosition pt2 = math2.transform((DirectPosition)pt1, null);
                cc1[i] = new Coordinate(pt2.getCoordinate()[0], pt2.getCoordinate()[1]);
                ++i;
            }
            try {
                Polygon p2 = f.createPolygon(f.createLinearRing(cc1), null);
                org.postgis.Polygon currentPolygon = new org.postgis.Polygon(p2.toString());
                currentPolygon.setSrid(4326);
                return new Object[]{currentPolygon, p2};
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static double getArea(String geom) {
        Geometry geometry = GeoUtils.buildGeometryFromString(geom);
        if (geometry == null) {
            return 0.0;
        }
        Point[] points = GeoUtils.getAllPoints(geometry);
        Coordinate[] cc = new Coordinate[points.length + 1];
        int i = 0;
        while (i < points.length) {
            cc[i] = new Coordinate(points[i].getX(), points[i].getY());
            ++i;
        }
        cc[points.length] = cc[0];
        return GeoUtils.getArea(cc);
    }

    public static double getArea(Coordinate[] coords) {
        try {
            GeometryFactory geomFactory = new GeometryFactory();
            LinearRing polygonBoundary = geomFactory.createLinearRing(coords);
            LinearRing[] polygonHoles = null;
            Polygon polygon = geomFactory.createPolygon(polygonBoundary, polygonHoles);
            double vertexSpacing = polygon.getLength() / 1000.0;
            com.vividsolutions.jts.geom.Geometry densePolygon = Densifier.densify((com.vividsolutions.jts.geom.Geometry)polygon, (double)vertexSpacing);
            CoordinateReferenceSystem equalAreaCRS = CRS.parseWKT((String)wkt3576);
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)equalAreaCRS, (boolean)true);
            com.vividsolutions.jts.geom.Geometry transformedPolygon = JTS.transform((com.vividsolutions.jts.geom.Geometry)densePolygon, (MathTransform)transform);
            return transformedPolygon.getArea();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static com.vividsolutions.jts.geom.Geometry geometryPG2GT(String geom) {
        Geometry geometry = GeoUtils.buildGeometryFromString(geom);
        if (geometry == null) {
            return null;
        }
        Point[] points = GeoUtils.getAllPoints(geometry);
        Coordinate[] cc = new Coordinate[points.length];
        int i = 0;
        while (i < points.length) {
            cc[i] = new Coordinate(points[i].getX(), points[i].getY());
            ++i;
        }
        GeometryFactory geomFactory = new GeometryFactory();
        try {
            if (geom.toLowerCase().indexOf("MultiPolygon".toLowerCase()) <= -1 && geom.toLowerCase().indexOf("MULTILINESTRING".toLowerCase()) <= -1) {
                if (geom.toLowerCase().indexOf("LINESTRING".toLowerCase()) > -1) {
                    return geomFactory.createLineString(cc);
                }
                LinearRing polygonBoundary = geomFactory.createLinearRing(cc);
                LinearRing[] polygonHoles = null;
                Polygon polygon = geomFactory.createPolygon(polygonBoundary, polygonHoles);
                return polygon;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String unionGeometry(String geom1, String geom2) {
        com.vividsolutions.jts.geom.Geometry gg1 = GeoUtils.geometryPG2GT(geom1);
        if (gg1 == null) {
            return null;
        }
        com.vividsolutions.jts.geom.Geometry gg2 = GeoUtils.geometryPG2GT(geom2);
        if (gg2 == null) {
            return null;
        }
        if (!gg1.intersects(gg2)) {
            return null;
        }
        return gg1.union(gg2).toString();
    }

    public static void main(String[] args) {
        String geom1 = "POLYGON ((38.859770833918 58.048852514679, 38.862066804835 58.048863869991, 38.862495958278 58.047308158586,38.859448968836 58.047728320896, 38.859770833918 58.048852514679))";
        String geom2 = "POLYGON((38.8543008757216 58.0497606214343,38.8560088295434 58.0494408181309,38.8560093809287 58.0494407143514,38.8562269342353 58.0493995557219,38.8564624103422 58.0493622721002,38.8564723071685 58.0493605378004,38.8578803071685 58.049089538482,38.8578840899704 58.0490887847646,38.8606440811392 58.0485199940895,38.8612920676577 58.0483911958588,38.8613003648247 58.0483894205013,38.8627993648247 58.048045421346,38.8628316155208 58.0480358207339,38.8628594749739 58.048022922066,38.8628817624957 58.0480072719868,38.8628975335374 58.0479895337462,38.8629061197195 58.0479704590911,38.8629071571583 58.0479508564071,38.8629006018869 58.047931556459,38.8628867317189 58.0479133771831,38.8628499534327 58.0478765988515,38.8621925077729 58.0471703419984,38.8620638070792 58.0470188710123,38.862045176843 58.0470018803248,38.862034176843 58.0469938803122,38.8620107385892 58.0469799413569,38.8619826219896 58.0469686947141,38.8619509075494 58.0469605725886,38.8619168140369 58.0469558871114,38.8618816516465 58.046954818344,38.8618467716492 58.046957407359,38.8618135144638 58.0469635546612,38.8617831581452 58.0469730240115,38.8617568692697 58.0469854515055,38.861735658104 58.0470003595588,38.8617203397815 58.0470171752606,38.8617115029765 58.0470352523906,38.8617094872827 58.0470538962536,38.8617143701618 58.047072390376,38.8617259639678 58.0470900240398,38.861743823157 58.047106119595,38.8617438463865 58.0471061364892,38.8618661929208 58.0472501287722,38.861868892252 58.0472531619302,38.8624811310396 58.0479108545047,38.861161742057 58.0482136368087,38.8605169323423 58.0483418042365,38.8605149100296 58.0483422135906,38.8577557934364 58.0489108268703,38.8563545937802 58.0491805186778,38.8561195896578 58.0492177277589,38.8561106190713 58.0492192853123,38.8558888946049 58.0492612332901,38.8541801704567 58.0495811824455,38.8541780827436 58.0495815810613,38.8534690827436 58.049719581408,38.8534373691851 58.0497277038718,38.8534092538064 58.049738950501,38.8533858170656 58.0497528890913,38.8533679596235 58.0497689839875,38.8533563677317 58.0497866166694,38.85335148686 58.0498051095212,38.8533535045776 58.0498237518722,38.8533623433448 58.0498418273075,38.8533776634926 58.0498586411998,38.8533988762765 58.0498735474027,38.8534251665009 58.0498859730821,38.8534555238473 58.0498954407287,38.8534887817 58.0499015865088,38.8535236619782 58.0499041742452,38.8535588242526 58.0499031044934,38.8535929172564 58.0498984183631,38.8543008757216 58.0497606214343))";
        com.vividsolutions.jts.geom.Geometry gg1 = GeoUtils.geometryPG2GT(geom1);
        com.vividsolutions.jts.geom.Geometry gg2 = GeoUtils.geometryPG2GT(geom2);
        com.vividsolutions.jts.geom.Geometry ggL2 = GeometryFunctions.intersection(gg1, gg2);
        System.out.println(ggL2.toText());
    }
}

