/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.geoobject;

import java.util.logging.Logger;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.directories.FRCAsyncDirectoryViewer;
import ru.blok.vms.ui.geoobject.GeoObjectList;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.simple.ExtendedDirectoryViewer;
import ru.infor.client.soap.proxy.vms.GeoObjectWSProxy;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.geo.GeoObjectSearchCriteria;
import ru.infor.ws.objects.geo.entities.GeoObject;
import ru.infor.ws.proxy.interfaces.InvocationContext;

public class GeoObjectDirectoryViewer<T>
extends FRCAsyncDirectoryViewer<T> {
    private Long[] lID;

    public Class getTableCellViewerClass() {
        return GeoObjectDirectoryCellViewer.class;
    }

    public GeoObjectDirectoryViewer(UIFactory<T> factory) {
        super(factory);
    }

    public CommonSearchCriteria updateSearchCriteria(CommonSearchCriteria sc, String value) {
        ((GeoObjectSearchCriteria)sc).setQuickSearch(value);
        return sc;
    }

    public void setContentClass(Class<?> cls) {
        super.setContentClass(GeoObject.class);
    }

    public Object getValue() {
        Object o = super.getValue();
        if (o instanceof GeoObject) {
            this.lID = new Long[]{((GeoObject)o).getId()};
        }
        return this.lID;
    }

    public void setValue(Object object) {
        this.lID = object instanceof GeoObject ? new Long[]{((GeoObject)object).getId()} : (Long[])object;
        super.setValue((Object)this.valueToString(object));
    }

    public String valueToString(Object value) {
        if (this.lID == null) {
            return "";
        }
        if (this.lID.length == 1) {
            GeoObjectWSProxy proxy = (GeoObjectWSProxy)CurrentProxyFactory.getProxy(GeoObject.class);
            GeoObject cont = (GeoObject)proxy._universalGetCurrentObject((InvocationContext)InitializedVariable.context, this.lID[0]);
            if (cont != null) {
                return this.objectToString(cont);
            }
            return "";
        }
        return "\u0424\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u044f \u043f\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u043c \u043e\u0431\u044a\u0435\u043a\u0442\u0430\u043c (" + this.lID.length + " \u0448\u0442.)";
    }

    public String objectToString(Object o) {
        if (o == null) {
            return "";
        }
        return ((GeoObject)o).getTitle();
    }

    public void buttonActionPerfomed() {
        try {
            GeoObjectList list = new GeoObjectList();
            this.getFactory().newPage(GeoObject.class, GeoObjectList.class, (Object)list, this.getViewerContext(), "filterInList");
        }
        catch (Exception exception) {
            Logger.getLogger(ExtendedDirectoryViewer.class.getName()).severe("Can't create directory presentation " + this.getPresentationClass().getName());
        }
    }

    public static class GeoObjectDirectoryCellViewer<T>
    extends DefaultTableCellViewer<T> {
        public GeoObjectDirectoryCellViewer(UIFactory<T> factory) {
            super(factory);
        }

        public void setValue(Object object) {
            super.setValue((Object)(object == null ? "" : ((GeoObject)object).getTitle()));
        }
    }
}

