/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.help;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import ru.blok.common.core.CommonMethods;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.core.ResourceStrings;
import ru.blok.vms.calltransport.SystemCall;
import ru.infor.client.soap.proxy.vms.BackgroundInfoWSProxy;
import ru.infor.client.soap.proxy.vms.ReferenceFieldsWSProxy;
import ru.infor.client.soap.proxy.vms.WindowTypeWSProxy;
import ru.infor.ws.objects.vms.BackgroundInfoSearchCriteria;
import ru.infor.ws.objects.vms.ReferenceFieldsSearchCriteria;
import ru.infor.ws.objects.vms.entities.BackgroundInfo;
import ru.infor.ws.objects.vms.entities.ReferenceFields;
import ru.infor.ws.objects.vms.entities.WindowType;
import ru.infor.ws.proxy.UniversalListProxy;

public class InformationWindow {
    String key = "<??????????????????>";
    BackgroundInfoWSProxy proxy = (BackgroundInfoWSProxy)CurrentProxyFactory.getProxy(BackgroundInfo.class);
    BackgroundInfoSearchCriteria scBackgroundInfo = new BackgroundInfoSearchCriteria();
    WindowTypeWSProxy windowTypeWSProxy = (WindowTypeWSProxy)CurrentProxyFactory.getProxy(WindowType.class);
    ReferenceFieldsWSProxy referenceFieldsWSProxy = (ReferenceFieldsWSProxy)CurrentProxyFactory.getProxy(ReferenceFields.class);
    ReferenceFieldsSearchCriteria scReferenceFields = new ReferenceFieldsSearchCriteria();
    HashMap<Integer, Style> mapStyle = new HashMap();
    HashMap<String, ReferenceFields> mapFields = new HashMap();
    HashMap<String, String> mapValue = new HashMap();
    List<Data> datas = new ArrayList<Data>();
    HashMap<Integer, JButton> mapButton = new HashMap();
    static List<String> template = new ArrayList<String>();

    static {
        template.add("_tel_");
    }

    public InformationWindow() {
    }

    public InformationWindow(String key) {
        this();
        this.key = key;
        this.getInfo(key, new Object[0]);
    }

    public InformationWindow(String key, Object ... objects) {
        this();
        this.key = key;
        this.getInfo(key, objects);
    }

    private void getInfo(String key, Object ... objects) {
        this.scBackgroundInfo.setKey("*" + key.trim() + "*");
        BackgroundInfoWSProxy.SearchResultListBackgroundInfo sr = this.proxy.getList(InitializedVariable.context, this.scBackgroundInfo);
        BackgroundInfo bi = null;
        String title = " \u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f! ";
        if (!sr.isEmpty()) {
            bi = (BackgroundInfo)sr.getObjList()[0];
            title = bi.getTitle();
        } else {
            WindowType cfr_ignored_0 = (WindowType)CommonMethods.checkDirectories((String)"Error", (UniversalListProxy)this.windowTypeWSProxy, (String)"");
        }
        JFrame f = new JFrame(title);
        StyleContext sc = new StyleContext();
        DefaultStyledDocument doc = new DefaultStyledDocument(sc);
        JTextPane pane = new JTextPane(doc);
        Style defaultStyle = sc.getStyle("default");
        Style mainStyle = sc.addStyle("MainStyle", defaultStyle);
        StyleConstants.setLeftIndent(mainStyle, 16.0f);
        StyleConstants.setRightIndent(mainStyle, 16.0f);
        StyleConstants.setFirstLineIndent(mainStyle, 16.0f);
        StyleConstants.setFontFamily(mainStyle, "serif");
        StyleConstants.setFontSize(mainStyle, 12);
        StyleConstants.setBackground(mainStyle, Color.decode(ResourceStrings.clLightGreen));
        Style heading2Style = sc.addStyle("Heading2", null);
        StyleConstants.setLeftIndent(heading2Style, 8.0f);
        StyleConstants.setFirstLineIndent(heading2Style, 0.0f);
        StyleConstants.setFontFamily(heading2Style, "serif");
        StyleConstants.setFontSize(heading2Style, 16);
        StyleConstants.setBackground(heading2Style, Color.decode(ResourceStrings.clLightGreen));
        StyleConstants.setForeground(heading2Style, Color.red);
        StyleConstants.setBold(heading2Style, true);
        String txt = "";
        try {
            doc.setLogicalStyle(0, mainStyle);
            txt = bi == null ? " \u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u0434\u043b\u044f \u043a\u043b\u044e\u0447\u0430 \n " + key : this.calcText(bi.getDescription(), objects, sc);
            doc.insertString(0, txt, null);
            int i = 0;
            while (i < this.datas.size()) {
                doc.setCharacterAttributes(this.datas.get(i).getOffset(), this.datas.get(i).getLength(), this.mapStyle.get(this.datas.get(i).getColor()), false);
                ++i;
            }
            doc.setParagraphAttributes(0, 1, heading2Style, false);
            if (this.mapButton.size() > 0) {
                for (Integer i2 : this.mapButton.keySet()) {
                    pane.setCaretPosition(i2);
                    pane.insertComponent(this.mapButton.get(i2));
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        int maxLength = 0;
        int countRow = 0;
        int len = 0;
        char[] bb = txt.toCharArray();
        int i = 0;
        while (i < bb.length) {
            if (bb[i] != '\n') {
                ++len;
            } else {
                ++countRow;
                if (maxLength < len) {
                    maxLength = len;
                }
                len = 0;
            }
            ++i;
        }
        f.getContentPane().add(new JScrollPane(pane));
        f.setSize((maxLength + 1) * 9, (countRow + 1) * 30);
        f.setVisible(true);
    }

    private static String conversionTel(String tel) {
        String rez = tel.substring(5);
        int i = 0;
        if (rez.length() < 10) {
            return rez;
        }
        if (rez.substring(0, 1).equals("+")) {
            i = 1;
        }
        String rezult = " ".concat(rez.substring(0, 1 + i)).concat("(").concat(rez.substring(1 + i, 4 + i)).concat(")").concat(rez.substring(4 + i, 7 + i)).concat("-").concat(rez.substring(7 + i, 9 + i)).concat("-").concat(rez.substring(9 + i, 11 + i));
        return rezult;
    }

    private String killSpace(String str) {
        String rez = "";
        int i = 0;
        while (i < str.length()) {
            if (str.codePointAt(i) != 160 && str.codePointAt(i) != 32) {
                rez = rez.concat(str.substring(i, i + 1));
            }
            ++i;
        }
        return rez;
    }

    private JButton createButtonCall(final String tel) {
        JButton buttoncall = new JButton(new ImageIcon(this.getClass().getResource(SystemCall.CallAction)));
        buttoncall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemCall.call(null, tel);
            }
        });
        return buttoncall;
    }

    private String calcText(String description, Object[] objects, StyleContext sc) {
        int k1;
        this.datas.clear();
        this.mapStyle.clear();
        this.mapFields.clear();
        this.mapValue.clear();
        this.mapButton.clear();
        int k = 0;
        while ((k1 = description.indexOf("_p_", k)) >= 0 && (k = description.indexOf(" ", k1)) >= 0) {
            block10: {
                int bk;
                String val;
                ReferenceFields rf;
                String fi;
                block9: {
                    fi = description.substring(k1, k).trim();
                    rf = this.mapFields.get(fi);
                    if (rf != null) break block9;
                    Long idFi = Long.valueOf(fi.substring(3));
                    this.scReferenceFields.setIdList(new Long[]{idFi});
                    ReferenceFieldsWSProxy.SearchResultListReferenceFields sr = this.referenceFieldsWSProxy.getList(InitializedVariable.context, this.scReferenceFields);
                    if (sr.isEmpty()) break block10;
                    rf = (ReferenceFields)sr.getObjList()[0];
                    this.mapFields.put(fi, rf);
                    if (this.mapStyle.get(rf.getColor()) == null) {
                        this.mapStyle.put(rf.getColor(), this.createStyle(rf.getColor(), sc));
                    }
                }
                if ((val = this.mapValue.get(fi)) == null) {
                    val = this.findValue(fi, objects);
                    this.mapValue.put(fi, val);
                }
                if ((bk = k1 - 10) < 0) {
                    bk = 0;
                }
                Data dt = this.calcPlaceAnd(k1, description.substring(bk, k1), val.length(), rf.getColor());
                description = description.replaceFirst(fi, val);
                this.datas.add(dt);
            }
            if (k > 0) continue;
        }
        k = 0;
        while ((k1 = description.indexOf("_tel_", k)) >= 0 && (k = description.indexOf(" ", k1)) >= 0) {
            String tel = this.killSpace(description.substring(k1, k).trim());
            if (tel.length() > 10) {
                this.mapButton.put(k1, this.createButtonCall(tel.substring(5)));
            }
            String tel0 = InformationWindow.conversionTel(tel);
            tel = tel.replaceAll("\\+", "\\\\+");
            tel0 = tel0.replaceAll("\\+", "\\\\+");
            description = description.replaceFirst(tel, tel0);
            if (k > 0) continue;
        }
        return description;
    }

    private Data calcPlaceAnd(int k1, String str, int length, Integer color) {
        Data rez = new Data(k1, length, color);
        if (str == null || str.trim().equals("")) {
            return rez;
        }
        int i = 0;
        while (i < template.size()) {
            if (str.indexOf(template.get(i)) > -1) {
                int newK1 = k1 - template.get(i).length();
                if (newK1 < 0) {
                    newK1 = 0;
                }
                if (template.get(i).equals("_tel_")) {
                    length += 5;
                }
                rez = new Data(newK1, length, color);
                break;
            }
            ++i;
        }
        return rez;
    }

    private int calcPlace(int k1, String str) {
        int rez = k1;
        if (str == null || str.trim().equals("")) {
            return rez;
        }
        int i = 0;
        while (i < template.size()) {
            if (str.indexOf(template.get(i)) > -1) {
                rez = k1 - template.get(i).length();
                if (rez >= 0) break;
                rez = 0;
                break;
            }
            ++i;
        }
        return rez;
    }

    private String findValue(String fi, Object[] objects) {
        if (this.mapFields.get(fi) == null) {
            return "";
        }
        ReferenceFields rf = this.mapFields.get(fi);
        if (rf.getMeta() == null || rf.getMeta().getClassName() == null || rf.getMeta().getClassName().trim().equals("")) {
            return "";
        }
        String className = rf.getMeta().getClassName();
        String val = "";
        int i = 0;
        while (i < objects.length) {
            String objName;
            Object obj = objects[i];
            if (obj != null && className.equals(objName = obj.getClass().getName())) {
                val = this.calcValue(rf, obj);
                break;
            }
            ++i;
        }
        return val;
    }

    private String calcValue(ReferenceFields rf, Object obj) {
        try {
            String name = rf.getFieldMeta().getName();
            Method methodND = obj.getClass().getMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
            Object val = methodND.invoke(obj, new Object[0]);
            if (val instanceof String) {
                return (String)val;
            }
            if (val instanceof Date) {
                return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format((Date)val);
            }
        }
        catch (Exception exception) {
            return "";
        }
        return "";
    }

    private Style createStyle(Integer color, StyleContext sc) {
        Color colText = color == null ? Color.decode(ResourceStrings.clRed) : new Color(color);
        Style cwStyle = sc.addStyle("ConstantWidth", null);
        StyleConstants.setFontFamily(cwStyle, "monospaced");
        StyleConstants.setForeground(cwStyle, colText);
        return cwStyle;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public static void main(String[] args) {
        String tel = "_call:89187701312";
        System.out.println(InformationWindow.conversionTel(tel));
    }

    public class Data {
        int offset;
        int length;
        Integer color;

        public Data(int k1, int k, Integer color2) {
            this.offset = k1;
            this.length = k;
            this.color = color2;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public Integer getColor() {
            return this.color;
        }

        public void setColor(Integer color) {
            this.color = color;
        }
    }
}

