/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.importbusstop;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.importbusstop.BusRoute;
import ru.blok.vms.ui.importbusstop.Station;
import ru.blok.vms.ui.importbusstop.StationDirection;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.client.soap.proxy.vms.CheckPointWSProxy;
import ru.infor.client.soap.proxy.vms.Route2CheckPointLinkWSProxy;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.client.soap.proxy.vms.TransportStopWSProxy;
import ru.infor.ws.objects.core.DirectoriesSearchCriteria;
import ru.infor.ws.objects.vms.CheckPointSearchCriteria;
import ru.infor.ws.objects.vms.Route2CheckPointLinkSearchCriteria;
import ru.infor.ws.objects.vms.RouteSearchCriteria;
import ru.infor.ws.objects.vms.entities.CheckPoint;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.Route2CheckPointLink;
import ru.infor.ws.objects.vms.entities.TransportStop;
import ru.infor.ws.proxy.interfaces.InvocationContext;

public class BusRouteImporterDB
extends BeanViewerAction<PanelContext> {
    static TransportStopWSProxy transportStopWSProxy = (TransportStopWSProxy)CurrentProxyFactory.getProxy(TransportStop.class);
    static DirectoriesSearchCriteria transportStopSearchCriteria = (DirectoriesSearchCriteria)transportStopWSProxy._getSearchCriteriaTemplate();
    static CheckPointWSProxy checkPointWSProxy = (CheckPointWSProxy)CurrentProxyFactory.getProxy(CheckPoint.class);
    static CheckPointSearchCriteria checkPointSearchCriteria = (CheckPointSearchCriteria)checkPointWSProxy._getSearchCriteriaTemplate();
    static Route2CheckPointLinkWSProxy checkPointLinkWSProxy = (Route2CheckPointLinkWSProxy)CurrentProxyFactory.getProxy(Route2CheckPointLink.class);
    static Route2CheckPointLinkSearchCriteria linkSearchCriteria = (Route2CheckPointLinkSearchCriteria)checkPointLinkWSProxy._getSearchCriteriaTemplate();
    static RouteWSProxy routeWSProxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);
    static RouteSearchCriteria routeSearchCriteria = (RouteSearchCriteria)routeWSProxy._getSearchCriteriaTemplate();
    private static List<BusRoute> routes = new ArrayList<BusRoute>();
    static Connection connection = null;

    public String getName() {
        return "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0438\u043c\u043f\u043e\u0440\u0442";
    }

    public void actionPerformed(Object message) {
        try {
            BusRouteImporterDB.getConnection();
            BusRouteImporterDB.runImport();
            BusRouteImporterDB.addDataInVMS();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addDataInVMS() {
        for (BusRoute br : routes) {
            for (Station s : br.getStations()) {
                transportStopSearchCriteria.setDescription(s.getName());
                TransportStop ts = null;
                Object[] l = transportStopWSProxy.getList(InitializedVariable.context, transportStopSearchCriteria).getObjList();
                if (l != null && l.length > 0) {
                    ts = (TransportStop)l[0];
                } else {
                    ts = new TransportStop();
                    ts.setDescription(s.getName());
                    ts.setCode(s.getName());
                    ts = (TransportStop)transportStopWSProxy._universalSave((InvocationContext)InitializedVariable.context, (Object)ts);
                }
                CheckPoint cp = null;
                int i = 1;
                while (cp == null) {
                    checkPointSearchCriteria.setName(String.valueOf(s.getName()) + " (" + i + ")");
                    CheckPointWSProxy.SearchResultListCheckPoint srl = checkPointWSProxy.getList(InitializedVariable.context, checkPointSearchCriteria);
                    if (!srl.isEmpty()) {
                        CheckPoint cp1 = (CheckPoint)srl.getObjList()[0];
                        if (cp1.getLat().doubleValue() == s.getLat() && cp1.getLon().doubleValue() == s.getLon()) {
                            cp = cp1;
                        }
                    } else {
                        cp = new CheckPoint();
                        cp.setLat(Double.valueOf(s.getLat()));
                        cp.setLon(Double.valueOf(s.getLon()));
                        cp.setName(String.valueOf(s.getName()) + " (" + i + ")");
                        cp = checkPointWSProxy.save(InitializedVariable.context, cp);
                    }
                    ++i;
                }
                Route route = null;
                routeSearchCriteria.setNum(br.getName());
                RouteWSProxy.SearchResultListRoute srl1 = routeWSProxy.getList(InitializedVariable.context, routeSearchCriteria);
                if (srl1.isEmpty()) {
                    System.out.println(br.getName());
                } else {
                    route = (Route)srl1.getObjList()[0];
                }
                if (route == null) continue;
                linkSearchCriteria.setCheckPointIdList(new Long[]{cp.getId()});
                linkSearchCriteria.setStopIdList(new Long[]{ts.getId()});
                linkSearchCriteria.setDirection(s.getDirection());
                linkSearchCriteria.setRouteIdList(new Long[]{route.getId()});
                Route2CheckPointLinkWSProxy.SearchResultListRoute2CheckPointLink srl2 = checkPointLinkWSProxy.getList(InitializedVariable.context, linkSearchCriteria);
                if (!srl2.isEmpty()) continue;
                Route2CheckPointLink link = new Route2CheckPointLink();
                link.setDirection(s.getDirection());
                link.setPoint(cp);
                link.setPointIndex(Integer.valueOf(s.getOrder()));
                link.setRoute(route);
                link.setStop(ts);
                link = checkPointLinkWSProxy.save(InitializedVariable.context, link);
            }
        }
    }

    private static void importBusRoute() throws SQLException {
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery(" select * from relations where id in (select relation_id from relation_tags where k = 'operator' and v like '\u041f\u0410\u0422\u041f \u21161')");
        while (rs.next()) {
            long rel_id = rs.getLong("id");
            BusRoute br = new BusRoute();
            Statement stmt1 = connection.createStatement();
            ResultSet rs1 = stmt1.executeQuery(" select * from relation_tags where k = 'ref' and relation_id = " + rel_id);
            if (rs1.next()) {
                br.setName(rs1.getString("v"));
            } else {
                rs1 = stmt1.executeQuery(" select * from relation_tags where k = 'name' and relation_id = " + rel_id);
                if (rs1.next()) {
                    br.setName(rs1.getString("v"));
                }
            }
            rs1 = stmt1.executeQuery("  select  * from relation_members where relation_id = " + rel_id);
            while (rs1.next()) {
                long member_id = rs1.getLong("member_id");
                String member_type = rs1.getString("member_type");
                String member_role = rs1.getString("member_role");
                Integer sequence_id = rs1.getInt("sequence_id");
                if (!"N".equals(member_type)) continue;
                Statement stmt2 = connection.createStatement();
                ResultSet rs2 = stmt2.executeQuery("select ST_X(geom) as lon, ST_Y(geom) as lat from nodes where id = " + member_id);
                double lat = 0.0;
                double lon = 0.0;
                if (rs2.next()) {
                    lat = rs2.getDouble("lat");
                    lon = rs2.getDouble("lon");
                }
                String name = null;
                rs2 = stmt2.executeQuery(" select * from node_tags where k = 'name' and node_id = " + member_id);
                if (rs2.next()) {
                    name = rs2.getString("V");
                }
                Integer direction = "forward:stop".equals(member_role) ? Integer.valueOf(StationDirection.Forward) : ("backward:stop".equals(member_role) ? Integer.valueOf(StationDirection.Backward) : Integer.valueOf(StationDirection.Unidirection));
                Station station = new Station(lat, lon, name, direction);
                station.setId(member_id);
                station.setOrder(sequence_id);
                br.addStation(station);
            }
            routes.add(br);
        }
    }

    private static void runImport() throws SQLException {
        routes.clear();
        BusRouteImporterDB.importBusRoute();
    }

    private static void getConnection() throws Exception {
        Class.forName("org.postgresql.Driver");
        connection = DriverManager.getConnection("jdbc:postgresql://power-server/osm_simple", "openstreetmap", "openstreetmap");
    }
}

