/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.importutils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import ru.blok.common.ui.importutils.CellData;
import ru.blok.common.ui.importutils.ImportUtils;

public class ExcelRead {
    public static CellData[][] readFileXLS(String fileNameXLS, int cellCount, int numCheckField) throws IOException {
        FileInputStream in = new FileInputStream(fileNameXLS);
        HSSFWorkbook wb = new HSSFWorkbook((InputStream)in);
        HSSFSheet sheet = wb.getSheetAt(0);
        ArrayList<CellData[]> list = new ArrayList<CellData[]>();
        boolean exit = true;
        int j = 1;
        int rowCount = 0;
        try {
            do {
                ImportUtils.CellType cellType = ImportUtils.CellType.ctNone;
                HSSFRow row = sheet.getRow(j);
                if (row == null) {
                    break;
                }
                HSSFCell c0 = row.getCell(numCheckField);
                if (c0 == null || c0.toString() == null) break;
                if (c0.toString().isEmpty()) {
                    break;
                }
                list.add(new CellData[cellCount]);
                CellData[] array = (CellData[])list.get(rowCount);
                int i = 0;
                while (i < cellCount) {
                    HSSFCell cell = row.getCell(i);
                    if (cell != null) {
                        String stringCellValue;
                        try {
                            switch (cell.getCellType()) {
                                case 0: {
                                    double dblNumber = cell.getNumericCellValue();
                                    int intNumber = (int)dblNumber;
                                    stringCellValue = Math.abs(dblNumber - (double)intNumber) < 1.0E-5 ? Integer.toString(intNumber) : Double.toString(dblNumber);
                                    cellType = ImportUtils.CellType.ctNumeric;
                                    break;
                                }
                                case 1: {
                                    stringCellValue = cell.getStringCellValue();
                                    cellType = ImportUtils.CellType.ctString;
                                    break;
                                }
                                default: {
                                    stringCellValue = "";
                                    break;
                                }
                            }
                        }
                        catch (Exception exception) {
                            stringCellValue = "";
                        }
                        array[i].setValue(stringCellValue);
                        array[i].setType(cellType);
                    }
                    ++i;
                }
                ++rowCount;
                ++j;
            } while (exit);
        }
        finally {
            if (wb != null) {
                wb.close();
            }
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        return (CellData[][])list.toArray((T[])new CellData[list.size()][cellCount]);
    }

    public static CellData[][] readFileXLSX(String fileNameXLS, int cellCount, int numCheckField) throws IOException {
        FileInputStream in = new FileInputStream(fileNameXLS);
        XSSFWorkbook wb = new XSSFWorkbook((InputStream)in);
        XSSFSheet sheet = wb.getSheetAt(0);
        ArrayList<CellData[]> list = new ArrayList<CellData[]>();
        boolean exit = true;
        int j = 1;
        int rowCount = 0;
        try {
            do {
                ImportUtils.CellType cellType = ImportUtils.CellType.ctNone;
                XSSFRow row = sheet.getRow(j);
                if (row == null) {
                    break;
                }
                XSSFCell c0 = row.getCell(numCheckField);
                if (c0 == null || c0.toString() == null) break;
                if (c0.toString().isEmpty()) {
                    break;
                }
                list.add(new CellData[cellCount]);
                CellData[] array = (CellData[])list.get(rowCount);
                int i = 0;
                while (i < cellCount) {
                    XSSFCell cell = row.getCell(i);
                    if (cell != null) {
                        String stringCellValue;
                        try {
                            switch (cell.getCellType()) {
                                case 0: {
                                    double dblNumber = cell.getNumericCellValue();
                                    int intNumber = (int)dblNumber;
                                    stringCellValue = Math.abs(dblNumber - (double)intNumber) < 1.0E-5 ? Integer.toString(intNumber) : Double.toString(dblNumber);
                                    cellType = ImportUtils.CellType.ctNumeric;
                                    break;
                                }
                                case 1: {
                                    stringCellValue = cell.getStringCellValue();
                                    cellType = ImportUtils.CellType.ctString;
                                    break;
                                }
                                default: {
                                    stringCellValue = "";
                                    break;
                                }
                            }
                        }
                        catch (Exception exception) {
                            stringCellValue = "";
                        }
                        array[i] = new CellData(stringCellValue, cellType);
                    } else {
                        array[i] = new CellData(null, ImportUtils.CellType.ctNone);
                    }
                    ++i;
                }
                ++rowCount;
                ++j;
            } while (exit);
        }
        finally {
            if (wb != null) {
                wb.close();
            }
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        return (CellData[][])list.toArray((T[])new CellData[list.size()][cellCount]);
    }

    public static CellData[][] processFileExcel(String fileNameExcell, int cellCount, int numCheckField) {
        int index = fileNameExcell.lastIndexOf(46);
        String fileExt = index > 0 ? fileNameExcell.substring(index) : "";
        CellData[][] array = null;
        try {
            if (".xls".equalsIgnoreCase(fileExt)) {
                array = ExcelRead.readFileXLS(fileNameExcell, cellCount, numCheckField);
            }
            if (".xlsx".equalsIgnoreCase(fileExt)) {
                array = ExcelRead.readFileXLSX(fileNameExcell, cellCount, numCheckField);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return array;
    }
}

