/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.josm;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.MultiPolygon;
import org.postgis.Point;
import org.postgis.Polygon;

public abstract class CommonDataSet
extends DataSet {
    protected static int WAY = 1;
    protected static int NODE = 0;
    protected static int ANY = 2;
    protected static int PolyOrLine = 3;
    protected int typeObject = WAY;
    protected LatLon crdObject;
    protected Way track;
    Node st_point;
    String keyPage;
    ArrayList<Way> col = new ArrayList();
    ArrayList<Node> colNode = new ArrayList();

    public CommonDataSet(String keyPage) {
        this.keyPage = keyPage;
    }

    public int getTypeObject() {
        return this.typeObject;
    }

    public void setTypeObject(int typeObject) {
        this.typeObject = typeObject;
    }

    public LatLon getCrdObject() {
        return this.crdObject;
    }

    protected OsmPrimitive addgeom(Geometry p) {
        if (this.getTypeObject() == WAY) {
            this.track = new Way();
            int i = 0;
            while (i < p.numPoints() - 1) {
                Point pp = p.getPoint(i);
                Node trackNode = new Node(new LatLon(pp.getY(), pp.getX()));
                this.addPrimitive((OsmPrimitive)trackNode);
                this.track.addNode(trackNode);
                ++i;
            }
            Point pp = p.getPoint(p.numPoints() - 1);
            if (pp.equals(p.getPoint(0))) {
                this.track.addNode(this.track.getNode(0));
            } else {
                Node trackNode = new Node(new LatLon(pp.getY(), pp.getX()));
                this.addPrimitive((OsmPrimitive)trackNode);
                this.track.addNode(trackNode);
            }
            if (this.isClosed() || p instanceof Polygon) {
                this.track.put("area", "yes");
            }
            this.addPrimitive((OsmPrimitive)this.track);
            return this.track;
        }
        if (this.getTypeObject() == NODE) {
            Point pp = p.getFirstPoint();
            this.st_point = new Node(new LatLon(pp.getY(), pp.getX()));
            this.st_point.put("point", "yes");
            this.addPrimitive((OsmPrimitive)this.st_point);
            return this.st_point;
        }
        if (this.getTypeObject() == PolyOrLine) {
            this.track = new Way();
            int i = 0;
            while (i < p.numPoints() - 1) {
                Point pp = p.getPoint(i);
                Node trackNode = new Node(new LatLon(pp.getY(), pp.getX()));
                this.addPrimitive((OsmPrimitive)trackNode);
                this.track.addNode(trackNode);
                ++i;
            }
            Point pp = p.getPoint(p.numPoints() - 1);
            if (pp.equals(p.getPoint(0))) {
                this.track.addNode(this.track.getNode(0));
            } else {
                Node trackNode = new Node(new LatLon(pp.getY(), pp.getX()));
                this.addPrimitive((OsmPrimitive)trackNode);
                this.track.addNode(trackNode);
            }
            if (this.isClosed() || p instanceof Polygon) {
                this.track.put("area", "yes");
            }
            this.addPrimitive((OsmPrimitive)this.track);
            return this.track;
        }
        if (p instanceof Point) {
            Point pp = p.getFirstPoint();
            this.st_point = new Node(new LatLon(pp.getY(), pp.getX()));
            this.st_point.put("point", "yes");
            this.addPrimitive((OsmPrimitive)this.st_point);
            return this.st_point;
        }
        this.track = new Way();
        int i = 0;
        while (i < p.numPoints() - 1) {
            Point pp = p.getPoint(i);
            Node trackNode = new Node(new LatLon(pp.getY(), pp.getX()));
            this.addPrimitive((OsmPrimitive)trackNode);
            this.track.addNode(trackNode);
            ++i;
        }
        Point pp = p.getPoint(p.numPoints() - 1);
        if (pp.equals(p.getPoint(0))) {
            this.track.addNode(this.track.getNode(0));
        } else {
            Node trackNode = new Node(new LatLon(pp.getY(), pp.getX()));
            this.addPrimitive((OsmPrimitive)trackNode);
            this.track.addNode(trackNode);
        }
        if (this.isClosed() || p instanceof Polygon) {
            this.track.put("area", "yes");
        }
        this.addPrimitive((OsmPrimitive)this.track);
        return this.track;
    }

    public void analysGeom(String geom) {
        this.analysGeom(geom, true);
    }

    public void analysGeom(String geom, boolean select) {
        if (geom != null) {
            Object p = null;
            if (geom.toUpperCase().indexOf("POINT".toUpperCase()) == -1) {
                try {
                    p = geom.toLowerCase().indexOf("MultiPolygon".toLowerCase()) > -1 ? new MultiPolygon(geom) : (geom.toLowerCase().indexOf("MULTILINESTRING".toLowerCase()) > -1 ? new MultiLineString(geom) : (geom.toLowerCase().indexOf("LINESTRING".toLowerCase()) > -1 ? new LineString(geom) : new Polygon(geom)));
                }
                catch (Exception exception) {}
                if (select) {
                    this.col.clear();
                }
                if (p instanceof MultiPolygon) {
                    Polygon[] polygonArray = ((MultiPolygon)p).getPolygons();
                    int n = polygonArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Polygon pol = polygonArray[n2];
                        OsmPrimitive pr = this.addgeom((Geometry)pol);
                        if (select) {
                            this.col.add((Way)pr);
                        }
                        ++n2;
                    }
                } else if (p instanceof MultiLineString) {
                    LineString[] lineStringArray = ((MultiLineString)p).getLines();
                    int n = lineStringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        LineString pol = lineStringArray[n3];
                        OsmPrimitive pr = this.addgeom((Geometry)pol);
                        if (select) {
                            this.col.add((Way)pr);
                        }
                        ++n3;
                    }
                } else {
                    OsmPrimitive pr = this.addgeom((Geometry)p);
                    if (select) {
                        this.col.add((Way)pr);
                    }
                }
                if (select) {
                    this.setSelected(this.col);
                }
            } else {
                try {
                    p = new Point(geom);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                OsmPrimitive pr = this.addgeom((Geometry)p);
                if (select) {
                    this.colNode.clear();
                    this.colNode.add((Node)pr);
                    this.setSelected(this.colNode);
                }
            }
        }
    }

    public Collection<Way> getWays() {
        return this.col;
    }

    public Collection<Node> getNodes1() {
        return this.colNode;
    }

    public Way getWay() {
        if (this.col.isEmpty()) {
            return null;
        }
        return this.col.get(0);
    }

    protected boolean isClosed() {
        return false;
    }

    protected abstract boolean saveObject(String var1);

    protected String getSRID() {
        return "SRID=4326;";
    }

    public void save() {
        if (this.getTypeObject() == WAY) {
            Way[] tracks = null;
            if (this.getSelectedWays().size() == 0) {
                Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)"Selected ways is null");
            } else {
                tracks = this.getSelectedWays().toArray(new Way[0]);
                this.track = tracks[0];
            }
            if (tracks == null) {
                JOptionPane.showMessageDialog(null, "\u041d\u0438 \u043e\u0434\u043d\u0430 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044f \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0430", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
            } else {
                boolean ok = true;
                if (this.isClosed()) {
                    Way[] wayArray = tracks;
                    int n = tracks.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Way w = wayArray[n2];
                        if (!w.isClosed()) {
                            Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)"Selected zone is not close");
                            JOptionPane.showMessageDialog(null, "\u041e\u0434\u043d\u0430 \u0438\u0437 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u0437\u043e\u043d \u043d\u0435 \u0437\u0430\u043c\u043a\u043d\u0443\u0442\u0430\u044f", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                            ok = false;
                            break;
                        }
                        ++n2;
                    }
                }
                if (ok) {
                    StringBuilder st;
                    if (tracks.length == 1) {
                        st = new StringBuilder(this.getSRID());
                        if (this.isClosed()) {
                            st.append("POLYGON((");
                        } else {
                            st.append("MULTILINESTRING((");
                        }
                        int i = 0;
                        while (i < this.track.getNodesCount()) {
                            Node n = this.track.getNode(i);
                            double x = n.getCoor().lat();
                            double y = n.getCoor().lon();
                            if (i > 0) {
                                st.append(",");
                            }
                            st.append(y).append(" ").append(x);
                            ++i;
                        }
                        st.append("))");
                        if (this.track != null && this.track.getNodesCount() > 0) {
                            this.crdObject = this.track.getNode(0).getCoor();
                        }
                        if (ok = this.saveObject(st.toString())) {
                            JOptionPane.showMessageDialog(null, "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430", 1);
                        }
                    } else {
                        st = new StringBuilder(this.getSRID());
                        if (this.isClosed()) {
                            st.append("MULTIPOLYGON(");
                        } else {
                            st.append("MULTILINESTRING(");
                        }
                        boolean z = false;
                        Way[] y = tracks;
                        int n = tracks.length;
                        int x = 0;
                        while (x < n) {
                            Way ww = y[x];
                            if (z) {
                                st.append(",");
                            } else {
                                z = true;
                            }
                            if (this.isClosed()) {
                                st.append("((");
                            } else {
                                st.append("(");
                            }
                            boolean zz = false;
                            int i = 0;
                            while (i < ww.getNodesCount()) {
                                Node n3 = ww.getNode(i);
                                double x2 = n3.getCoor().lat();
                                double y2 = n3.getCoor().lon();
                                if (zz) {
                                    st.append(",");
                                } else {
                                    zz = true;
                                }
                                st.append(y2).append(" ").append(x2);
                                ++i;
                            }
                            if (this.isClosed()) {
                                st.append("))");
                            } else {
                                st.append(")");
                            }
                            ++x;
                        }
                        st.append(")");
                        if (tracks != null && tracks.length > 0 && tracks[0].getNodesCount() > 0) {
                            this.crdObject = tracks[0].getNode(0).getCoor();
                        }
                        if (ok = this.saveObject(st.toString())) {
                            JOptionPane.showMessageDialog(null, "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430", 1);
                        }
                    }
                }
            }
        } else if (this.getTypeObject() == NODE) {
            Node[] nodes = null;
            if (this.getSelectedNodes().size() == 0) {
                Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)"Selected nodes is null");
            } else {
                nodes = this.getSelectedNodes().toArray(new Node[0]);
                this.st_point = nodes[0];
            }
            if (nodes == null) {
                JOptionPane.showMessageDialog(null, "\u041d\u0438 \u043e\u0434\u043d\u0430 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044f \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0430", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
            } else {
                StringBuilder st = new StringBuilder(this.getSRID());
                st.append("POINT(");
                double x = this.st_point.getCoor().lat();
                double y = this.st_point.getCoor().lon();
                st.append(y).append(" ").append(x);
                st.append(")");
                this.crdObject = new LatLon(x, y);
                boolean ok = this.saveObject(st.toString());
                if (ok) {
                    JOptionPane.showMessageDialog(null, "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430", 1);
                }
            }
        } else if (this.getTypeObject() == PolyOrLine) {
            Way[] tracks = null;
            this.track = null;
            if (this.getSelectedWays().size() == 0) {
                Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)"Selected ways is null");
            } else {
                tracks = this.getSelectedWays().toArray(new Way[0]);
                this.track = tracks[0];
            }
            if (this.track == null) {
                JOptionPane.showMessageDialog(null, "\u041d\u0438 \u043e\u0434\u043d\u0430 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044f \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0430", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
            } else {
                boolean ok = true;
                StringBuilder st = new StringBuilder(this.getSRID());
                if (this.track.getNode(0).equals((Object)this.track.getNode(this.track.getNodesCount() - 1))) {
                    st.append("POLYGON((");
                    int i = 0;
                    while (i < this.track.getNodesCount()) {
                        Node n = this.track.getNode(i);
                        double x = n.getCoor().lat();
                        double y = n.getCoor().lon();
                        if (i > 0) {
                            st.append(",");
                        }
                        st.append(y).append(" ").append(x);
                        ++i;
                    }
                    st.append("))");
                } else {
                    st.append("LINESTRING(");
                    int i = 0;
                    while (i < this.track.getNodesCount()) {
                        Node n = this.track.getNode(i);
                        double x = n.getCoor().lat();
                        double y = n.getCoor().lon();
                        if (i > 0) {
                            st.append(",");
                        }
                        st.append(y).append(" ").append(x);
                        ++i;
                    }
                    st.append(")");
                }
                if (this.track != null && this.track.getNodesCount() > 0) {
                    this.crdObject = this.track.getNode(0).getCoor();
                }
                if (ok = this.saveObject(st.toString())) {
                    JOptionPane.showMessageDialog(null, "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430", 1);
                }
            }
        } else {
            Way[] tracks = null;
            Node[] nodes = null;
            this.track = null;
            this.st_point = null;
            if (this.getSelectedWays().size() == 0 && this.getSelectedNodes().size() == 0) {
                Logger.getLogger(((Object)((Object)this)).getClass()).debug((Object)"Selected ways is null");
            } else if (this.getSelectedWays().size() != 0) {
                tracks = this.getSelectedWays().toArray(new Way[0]);
                this.track = tracks[0];
            } else {
                nodes = this.getSelectedNodes().toArray(new Node[0]);
                this.st_point = nodes[0];
            }
            if (this.track == null && nodes == null) {
                JOptionPane.showMessageDialog(null, "\u041d\u0438 \u043e\u0434\u043d\u0430 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044f \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0430", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
            } else {
                boolean ok = true;
                if (this.track != null) {
                    StringBuilder st = new StringBuilder(this.getSRID());
                    if (this.track.getNode(0).equals((Object)this.track.getNode(this.track.getNodesCount() - 1))) {
                        st.append("POLYGON((");
                        int i = 0;
                        while (i < this.track.getNodesCount()) {
                            Node n = this.track.getNode(i);
                            double x = n.getCoor().lat();
                            double y = n.getCoor().lon();
                            if (i > 0) {
                                st.append(",");
                            }
                            st.append(y).append(" ").append(x);
                            ++i;
                        }
                        st.append("))");
                    } else {
                        st.append("LINESTRING(");
                        int i = 0;
                        while (i < this.track.getNodesCount()) {
                            Node n = this.track.getNode(i);
                            double x = n.getCoor().lat();
                            double y = n.getCoor().lon();
                            if (i > 0) {
                                st.append(",");
                            }
                            st.append(y).append(" ").append(x);
                            ++i;
                        }
                        st.append(")");
                    }
                    if (this.track != null && this.track.getNodesCount() > 0) {
                        this.crdObject = this.track.getNode(0).getCoor();
                    }
                    if (ok = this.saveObject(st.toString())) {
                        JOptionPane.showMessageDialog(null, "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430", 1);
                    }
                } else {
                    nodes = this.getSelectedNodes().toArray(new Node[0]);
                    this.st_point = nodes[0];
                    StringBuilder st = new StringBuilder(this.getSRID());
                    st.append("POINT(");
                    double x = this.st_point.getCoor().lat();
                    double y = this.st_point.getCoor().lon();
                    st.append(y).append(" ").append(x);
                    st.append(")");
                    this.crdObject = new LatLon(x, y);
                    ok = this.saveObject(st.toString());
                    if (ok) {
                        JOptionPane.showMessageDialog(null, "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430", 1);
                    }
                }
            }
        }
    }
}

