/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.josm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.xml.bind.JAXBException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.GettingStarted;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.josm.CommonDataSet;
import ru.blok.vms.ui.josm.WMSLayer;
import ru.blok.vms.ui.mapviewer.ui.DefaultProvider;
import ru.blok.vms.ui.mapviewer.ui.ProviderInfo;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.PropertyManager;
import ru.infor.beanviewer.dialog.CommonMessage;
import ru.infor.beanviewer.dialog.MessageCancelButton;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.client.soap.proxy.vms.NDDataWSProxy;
import ru.infor.ws.objects.core.SortObject;
import ru.infor.ws.objects.vms.NDDataSearchCriteria;
import ru.infor.ws.objects.vms.entities.NDData;

public class JosmMainApp
extends Main {
    public static String wkt4326 = "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]";
    public static String wkt3395 = "PROJCS[\"WGS 84 / World Mercator\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Mercator_1SP\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"3395\"]]";
    public static WMSLayer layer2;
    protected static CommonDataSet ds;
    private static NDDataWSProxy nddataWSProxy;
    protected static JosmMainApp main_josm;

    static {
        nddataWSProxy = (NDDataWSProxy)CurrentProxyFactory.getProxy(NDData.class);
    }

    protected void initMenu(JMenu sysmenu) {
        JMenuItem mi2 = new JMenuItem("\u0412\u044b\u0431\u043e\u0440 \u043a\u0430\u0440\u0442\u044b");
        mi2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingMap m = new SettingMap();
                m.setProvidersInfo((ProviderInfo)layer2.getUIProperties());
                MessageOKButton b = new MessageOKButton(){

                    public void actionPerformed(Object message) {
                        ((PanelContext)this.getContext()).getPanel().updateMainObject();
                        ProviderInfo p = ((SettingMap)((Object)((PanelContext)this.getContext()).getPanel().getObject())).getProvidersInfo();
                        if (layer2 != null) {
                            layer2.setUIProperties(p);
                            Main.map.repaint();
                        }
                        if (PropertyManager.getSaver() != null) {
                            try {
                                String key = String.valueOf(WMSLayer.class.toString()) + "maps";
                                PropertyManager.getSaver().save(key, PropertyManager.propertiesToXML((Object)layer2.getUIProperties()));
                            }
                            catch (JAXBException e) {
                                e.printStackTrace();
                            }
                        }
                        super.actionPerformed(message);
                    }
                };
                InitializedVariable.factory.runMessageEx((Object)m, new BeanViewerAction[]{b, new MessageCancelButton()});
            }
        });
        sysmenu.add(mi2);
    }

    public JosmMainApp(final JFrame mainFrame) {
        Component[] componentArray = panel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof GettingStarted) {
                panel.remove(component);
            }
            ++n2;
        }
        this.menu.remove((Component)this.menu.fileMenu);
        this.menu.remove((Component)this.menu.audioMenu);
        this.menu.remove((Component)this.menu.presetsMenu);
        this.menu.remove((Component)this.menu.helpMenu);
        JMenu sysmenu = this.menu.addMenu("\u0421\u0438\u0441\u0442\u0435\u043c\u0430", 83, 0, null);
        this.initMenu(sysmenu);
        JMenuItem mi1 = new JMenuItem("\u0412\u044b\u0445\u043e\u0434");
        mi1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mainFrame.setVisible(false);
            }
        });
        sysmenu.add(mi1);
        toolbar.refreshToolbarControl();
    }

    private Object[] getTRack() {
        Calendar c = Calendar.getInstance();
        c.set(1, 2010);
        c.set(2, 5);
        c.set(5, 17);
        c.set(11, 7);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        NDDataSearchCriteria sco = (NDDataSearchCriteria)nddataWSProxy._getSearchCriteriaTemplate();
        sco.setCreatedDateTimeFrom(c.getTime());
        c.set(11, 10);
        sco.setCreatedDateTimeTill(c.getTime());
        sco.setDeviceIdList(new Long[]{2220158L});
        sco.appendSorting(SortObject.getInstance((String)"deviceId", (String)SortObject.DIRECTION_ASC));
        sco.appendSorting(SortObject.getInstance((String)"createdDateTime", (String)SortObject.DIRECTION_ASC));
        sco.setCount(Integer.valueOf(1000000));
        NDDataWSProxy.SearchResultListNDData data = nddataWSProxy.getList(InitializedVariable.context, sco);
        return data.getObjList();
    }

    public static void initCommon(JFrame m) {
        Main.pref = new Preferences();
        I18n.init();
        Main.determinePlatformHook();
        Main.pref.init(false);
        Main.pref.updateSystemProperties();
        MainApplication.preConstructorInit(new HashMap());
        Main.parent = m;
        Main.addListener();
    }

    public static void initFinal(JFrame m) {
        MainApplication.toolbar.refreshToolbarControl();
        m.setContentPane(contentPanePrivate);
        m.setJMenuBar((JMenuBar)JosmMainApp.main_josm.menu);
        if (!m.isVisible()) {
            m.setVisible(true);
        } else {
            m.validate();
            m.toFront();
        }
        m.setExtendedState(6);
    }

    public static void init(JFrame m) {
        if (main_josm == null) {
            JosmMainApp.initCommon(m);
            main_josm = new JosmMainApp(m);
        }
        JosmMainApp.initFinal(m);
    }

    public static void initLayer(String name, Object o, CommonDataSet ds, String keyPage) {
        Layer current = null;
        Layer osm = null;
        if (main_josm != null && map != null && JosmMainApp.map.mapView != null && JosmMainApp.map.mapView.getAllLayers() != null) {
            for (Layer layer : JosmMainApp.map.mapView.getAllLayers()) {
                if (layer.getName().equals(name)) {
                    current = layer;
                }
                if (!(layer instanceof WMSLayer)) continue;
                osm = layer;
            }
        }
        if (current != null) {
            main_josm.removeLayer(current);
        }
        main_josm.addLayer((Layer)new OsmDataLayer((DataSet)ds, name, null));
        if (osm == null) {
            layer2 = new WMSLayer();
            main_josm.addLayer(layer2);
        }
        if (ds.getWay() != null) {
            main_josm.getCurrentDataSet().setSelected(ds.getWays());
            JosmMainApp.map.mapView.zoomTo(ds.getWay().getNode(0).getCoor());
        } else if (ds.getNodes1() != null && ds.getNodes1().size() > 0) {
            main_josm.getCurrentDataSet().setSelected(ds.getNodes1());
            if (ds.getNodes().size() > 0) {
                JosmMainApp.map.mapView.zoomTo(ds.getNodes1().iterator().next().getCoor());
            }
        } else if (ds.getNodes() != null && ds.getNodes().size() > 0) {
            JosmMainApp.map.mapView.zoomTo(((Node)ds.getNodes().iterator().next()).getCoor());
        } else {
            Double[] coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)keyPage));
            Node n = new Node(new LatLon(coord[0].doubleValue(), coord[1].doubleValue()));
            ds.addPrimitive((OsmPrimitive)n);
            JosmMainApp.map.mapView.zoomTo(n.getCoor());
            main_josm.getCurrentDataSet().setSelected(new PrimitiveId[]{n});
        }
    }

    @ListView(views={@View(title="", layoutKeys={"dialogLayoutManager"})})
    public static class SettingMap
    extends CommonMessage {
        ProviderInfo providersInfo;

        @ListField(fields={@Field(order=10, title="\u041f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f", viewer={DefaultProvider.AbstractDefaultProvidersViewer.class})})
        public ProviderInfo getProvidersInfo() {
            return this.providersInfo;
        }

        public void setProvidersInfo(ProviderInfo providersInfo) {
            this.providersInfo = providersInfo;
        }
    }
}

