/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.josm;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.Action;
import javax.swing.Icon;
import javax.xml.bind.JAXBException;
import org.jxmapviewer.viewer.AbstractTileFactory;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.Tile;
import org.jxmapviewer.viewer.TileCache;
import org.jxmapviewer.viewer.TileListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.ImageProvider;
import ru.blok.vms.ui.mapviewer.cache.TileCacheFile;
import ru.blok.vms.ui.mapviewer.ui.DefaultProvider;
import ru.blok.vms.ui.mapviewer.ui.ProviderInfo;
import ru.infor.beanviewer.core.PropertyManager;

public class WMSLayer
extends Layer {
    protected static final Point[] move = new Point[]{new Point(1, 0), new Point(0, 1), new Point(-1, 0), new Point(0, -1)};
    protected static final Icon icon = null;
    protected MapView mv;
    protected DefaultProvider providers;
    public AbstractTileFactory tf;
    ProviderInfo providerInfo;
    double[] dlonOfZoom;
    private TileListener tileLoadListener = new TileListener(){

        public void tileLoaded(Tile tile) {
            WMSLayer.this.mv.repaint();
        }
    };

    public ZOOM getZoom(Rectangle r) {
        double dlon;
        int size = this.getTileFactory().getTileSize(0);
        Bounds b = this.mv.getLatLonBounds(new Rectangle(r.x, r.y, size, size));
        double dlontileinpixel = dlon = b.getMax().lon() - b.getMin().lon();
        int z = this.getTileFactory().getInfo().getMinimumZoomLevel();
        while (this.dlonOfZoom[z] < dlontileinpixel && z < this.getTileFactory().getInfo().getMaximumZoomLevel()) {
            ++z;
        }
        double ind = this.dlonOfZoom[z] / dlontileinpixel;
        if (z == this.getTileFactory().getInfo().getMinimumZoomLevel() && this.dlonOfZoom[z] > dlontileinpixel) {
            ind = this.dlonOfZoom[z] / dlontileinpixel;
        } else if (ind < 0.3) {
            ind = this.dlonOfZoom[++z] / dlontileinpixel;
        }
        return new ZOOM(z, ind);
    }

    public AbstractTileFactory getTileFactory() {
        return this.tf;
    }

    public WMSLayer() {
        super("osm");
        this.setBackgroundLayer(true);
        this.mv = Main.map.mapView;
        String key = String.valueOf(WMSLayer.class.toString()) + "maps";
        String property = PropertyManager.getSaver().load(key);
        if (property != null && !"".equals(property)) {
            try {
                this.setUIProperties(PropertyManager.xmlToProperties(this.getUIPropertiesClass(), (String)property));
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        } else {
            ProviderInfo osm = DefaultProvider.getOSMProviderInfo();
            this.setUIProperties(osm);
        }
    }

    public Class<?> getUIPropertiesClass() {
        return ProviderInfo.class;
    }

    public Object getUIProperties() {
        return this.providerInfo;
    }

    public void setUIProperties(Object osm) {
        this.providerInfo = (ProviderInfo)osm;
        this.providers = new DefaultProvider(this.providerInfo);
        this.tf = this.providers.getTileFactory();
        this.tf.setTileCache((TileCache)new TileCacheFile("data/TileCacheFile/"));
        this.tf.addTileListener(this.tileLoadListener);
        this.dlonOfZoom = new double[this.tf.getInfo().getTotalMapZoom() + 1];
        int k = 1;
        int z = this.tf.getInfo().getTotalMapZoom();
        while (z >= this.tf.getInfo().getMinimumZoomLevel()) {
            this.dlonOfZoom[z] = 360.0 / (double)k;
            k *= 2;
            --z;
        }
    }

    public Point2D convertGeoPositionToPoint(GeoPosition pos, int zoom) {
        Point2D pt = this.getTileFactory().geoToPixel(pos, zoom);
        return pt;
    }

    public GeoPosition convertPointToGeoPosition(Point2D pos, int zoom) {
        GeoPosition p = this.getTileFactory().pixelToGeo(pos, zoom);
        return p;
    }

    public Rectangle getViewportBounds() {
        ProjectionBounds bb = this.mv.getProjectionBounds();
        Point center = this.mv.getPoint(bb.getCenter());
        Insets insets = this.mv.getInsets();
        int viewportWidth = this.mv.getWidth() - insets.left - insets.right;
        int viewportHeight = this.mv.getHeight() - insets.top - insets.bottom;
        double viewportX = center.getX() - (double)(viewportWidth / 2);
        double viewportY = center.getY() - (double)(viewportHeight / 2);
        return new Rectangle((int)viewportX, (int)viewportY, viewportWidth, viewportHeight);
    }

    public void paint(Graphics2D g, MapView mv, Bounds b) {
        Rectangle viewportBounds = this.getViewportBounds();
        ZOOM zoom = this.getZoom(viewportBounds);
        int size = this.getTileFactory().getTileSize(zoom.getOsmZoom());
        int numWide = viewportBounds.width / size + 3;
        int numHigh = viewportBounds.height / size + 3;
        Bounds bn = mv.getLatLonBounds(viewportBounds);
        LatLon l = bn.getMin();
        LatLon l2 = bn.getMax();
        GeoPosition po = new GeoPosition(l2.lat(), l.lon());
        Point2D p = this.convertGeoPositionToPoint(po, zoom.getOsmZoom());
        int tpxp = (int)Math.floor(p.getX() / (double)size);
        int tpyp = (int)Math.floor(p.getY() / (double)size);
        int tpxpd = (int)(p.getX() - (double)(tpxp * size));
        int tpypd = (int)(p.getY() - (double)(tpyp * size));
        AffineTransform t = AffineTransform.getScaleInstance(zoom.getInd(), zoom.getInd());
        AffineTransform t2 = null;
        try {
            t2 = t.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        g.transform(t);
        int x = 0;
        while (x <= numWide) {
            int y = 0;
            while (y <= numHigh) {
                int itpx = x + tpxp;
                int itpy = y + tpyp;
                Tile tile = this.getTileFactory().getTile(itpx, itpy, zoom.getOsmZoom());
                int ox = (int)((double)(x * size) - (double)viewportBounds.x - (double)tpxpd);
                int oy = (int)((double)(y * size) - (double)viewportBounds.y - (double)tpypd);
                g.drawImage((Image)tile.getImage(), ox, oy, null);
                if (tile.isLoaded()) {
                    g.drawImage((Image)tile.getImage(), ox, oy, null);
                } else {
                    g.setColor(Color.GRAY);
                    g.fillRect(ox, oy, (int)((double)size * zoom.getInd()), (int)((double)size * zoom.getInd()));
                }
                ++y;
            }
            ++x;
        }
        g.transform(t2);
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"osmdata_small");
    }

    public Object getInfoComponent() {
        return null;
    }

    public Action[] getMenuEntries() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public boolean isMergable(Layer arg0) {
        return false;
    }

    public void mergeFrom(Layer arg0) {
    }

    public void visitBoundingBox(BoundingXYVisitor arg0) {
    }

    static class ZOOM {
        int osmZoom;
        double ind;

        public int getOsmZoom() {
            return this.osmZoom;
        }

        public void setOsmZoom(int osmZoom) {
            this.osmZoom = osmZoom;
        }

        public double getInd() {
            return this.ind;
        }

        public void setInd(double ind) {
            this.ind = ind;
        }

        public ZOOM(int osmZoom, double ind) {
            this.osmZoom = osmZoom;
            this.ind = ind;
        }
    }
}

