/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.josm.roadwa;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.Point;
import org.xml.sax.SAXParseException;
import ru.blok.common.core.CommonMethods;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.josm.roadwa.RoadWAList;
import ru.infor.beanviewer.dialog.InfoMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.vms.OperationalGroupWSProxy;
import ru.infor.client.soap.proxy.vms.RoadWAWSProxy;
import ru.infor.client.soap.proxy.vms.WatchAreaTypeWSProxy;
import ru.infor.gpx.GpxRoad;
import ru.infor.gpx.TrkRoad;
import ru.infor.gpx.Trkpt;
import ru.infor.ws.objects.vms.RoadWASearchCriteria;
import ru.infor.ws.objects.vms.entities.OperationalGroup;
import ru.infor.ws.objects.vms.entities.RoadWA;
import ru.infor.ws.objects.vms.entities.WatchAreaType;
import ru.infor.ws.proxy.UniversalListProxy;
import ru.infor.ws.proxy.interfaces.InvocationContext;

public class AddRoadFromGpx
extends BeanViewerAction<ViewerContext> {
    WatchAreaTypeWSProxy watchAreaTypeWSProxy = (WatchAreaTypeWSProxy)CurrentProxyFactory.getProxy(WatchAreaType.class);
    OperationalGroupWSProxy operationalGroupWSProxy = (OperationalGroupWSProxy)CurrentProxyFactory.getProxy(OperationalGroup.class);
    PrintStream output = null;
    static Logger logger = Logger.getLogger(AddRoadFromGpx.class);
    String filesDir = null;
    FileFilter ff = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(".gpx");
        }

        @Override
        public String getDescription() {
            return null;
        }
    };

    public void actionPerformed(Object message) {
        this.createLogFileName();
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
        Integer srid = ((RoadWAList)((Object)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getObject())).getSrid();
        RoadWAWSProxy roadWAWSProxy = (RoadWAWSProxy)CurrentProxyFactory.getProxy(RoadWA.class);
        JFileChooser jfc = new JFileChooser();
        if (this.getFilesDir() != null) {
            jfc.setCurrentDirectory(new File(this.getFilesDir()));
        }
        jfc.setMultiSelectionEnabled(true);
        jfc.setDialogType(0);
        jfc.setFileSelectionMode(2);
        jfc.setFileFilter(this.ff);
        int j = jfc.showOpenDialog(null);
        if (j != 0) {
            return;
        }
        File[] fileList = jfc.getSelectedFiles();
        int cou = 0;
        int couE = 0;
        String fList = "";
        int f = 0;
        while (f < fileList.length) {
            String filename = fileList[f].getAbsolutePath();
            this.setFilesDir(fileList[f].getParent());
            if (!filename.endsWith(".gpx")) {
                filename = String.valueOf(filename) + ".gpx";
            }
            String str = filename;
            RoadWA roadWA = new RoadWA();
            GpxRoad vrd = null;
            try {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{GpxRoad.class});
                Unmarshaller u = jc.createUnmarshaller();
                vrd = (GpxRoad)u.unmarshal(new File(filename));
                List<TrkRoad> trk = vrd.getTrk();
                LineString[] listLS = new LineString[trk.size()];
                int k = 0;
                while (k < trk.size()) {
                    TrkRoad trkRoad = trk.get(k);
                    int len = trkRoad.getTrkseg().getTrkpt().size();
                    Point[] points = new Point[len];
                    int i = 0;
                    while (i < len) {
                        Trkpt trkpt = trkRoad.getTrkseg().getTrkpt().get(i);
                        points[i] = new Point(trkpt.getLon(), trkpt.getLat());
                        ++i;
                    }
                    listLS[k] = new LineString(points);
                    ++k;
                }
                MultiLineString multiLineString = new MultiLineString(listLS);
                String roadName = vrd.getMetadata().getRe_meta().getName();
                String roadType = vrd.getMetadata().getRe_meta().getList();
                WatchAreaType type = this.checkTypeRoad(vrd.getMetadata().getRe_meta().getDistrict());
                OperationalGroup opGr = this.checkOperationalGroup(roadType);
                RoadWASearchCriteria sc = new RoadWASearchCriteria();
                sc.setName(roadName);
                sc.setTypeRoad("*" + roadType + "*");
                sc.setTypeIdList(new Long[]{type.getId()});
                RoadWAWSProxy.SearchResultListRoadWA sr = roadWAWSProxy.getList(InitializedVariable.context, sc);
                if (sr.isEmpty()) {
                    roadWA.setAreageom(multiLineString.toString());
                    roadWA.setName(roadName);
                    roadWA.setInvNum(vrd.getMetadata().getRe_meta().getNumber());
                    roadWA.setType(type);
                    roadWA.setOperationalGroup(opGr);
                    roadWA.setRoadgeom(multiLineString.toString());
                    roadWA.setTypeRoad(roadType);
                    roadWA.setRoadType(AddRoadFromGpx.calcRoadType(roadType));
                    roadWA = roadWAWSProxy.buildAreaAroundTheRoad(InitializedVariable.context, roadWA, srid);
                    str = str.concat(" - save OK");
                    logger.debug((Object)(String.valueOf(roadName) + " - " + roadWA.getInvNum() + " - save OK"));
                } else {
                    roadWA = (RoadWA)sr.getObjList()[0];
                    str = str.concat(" - previously saved:" + roadWA.getName());
                    logger.debug((Object)(String.valueOf(roadWA.getName()) + " - " + roadWA.getInvNum() + " - previously saved"));
                    ++couE;
                }
            }
            catch (Exception e) {
                SAXParseException se = null;
                if (e instanceof UnmarshalException) {
                    se = (SAXParseException)((UnmarshalException)e).getLinkedException();
                }
                String error = "";
                error = se != null ? "line:" + se.getLineNumber() + " column:" + se.getColumnNumber() + " => " + se.getMessage() : (e instanceof NullPointerException ? e.getStackTrace()[0].getFileName().concat(":").concat(String.valueOf(e.getStackTrace()[0].getLineNumber())) : e.getMessage());
                str = str.concat(" ------------------> error: ").concat(error);
            }
            if (roadWA.getId() != null) {
                ++cou;
            } else {
                fList = fList.concat(filename).concat("\n");
            }
            this.appendLogFile(str);
            ++f;
        }
        String existRoad = "";
        if (couE > 0) {
            existRoad = "\n ( " + couE + " - \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b \u0440\u0430\u043d\u0435\u0435)";
        }
        fList = fList.length() > 0 ? ", \u043a\u0440\u043e\u043c\u0435\n".concat(fList) : ".";
        InitializedVariable.factory.runMessageEx((Object)new InfoMessage("\u0412 '\u0421\u043f\u0438\u0441\u043a\u0435 \u0434\u043e\u0440\u043e\u0433' \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 " + (cou - couE) + " \u0444\u0430\u0439\u043b\u043e\u0432" + existRoad + fList), new BeanViewerAction[]{new MessageOKButton()});
        this.output.close();
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
    }

    private OperationalGroup checkOperationalGroup(String roadType) {
        OperationalGroup operationalGroup;
        if (roadType == null || roadType == "") {
            roadType = "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439";
        }
        if ((operationalGroup = (OperationalGroup)CommonMethods.checkDirectories((String)roadType, (UniversalListProxy)this.operationalGroupWSProxy, (String)"")) == null) {
            operationalGroup = new OperationalGroup();
            operationalGroup.setCode(roadType);
            operationalGroup.setDescription(roadType);
            operationalGroup = (OperationalGroup)this.operationalGroupWSProxy._universalSave((InvocationContext)InitializedVariable.context, (Object)operationalGroup);
        }
        return operationalGroup;
    }

    private WatchAreaType checkTypeRoad(String district) {
        WatchAreaType watchAreaType;
        if (district == null || district == "") {
            district = "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439";
        }
        if ((watchAreaType = (WatchAreaType)CommonMethods.checkDirectories((String)district, (UniversalListProxy)this.watchAreaTypeWSProxy, (String)"")) == null) {
            watchAreaType = new WatchAreaType();
            watchAreaType.setCode(district);
            watchAreaType.setDescription(district);
            watchAreaType = (WatchAreaType)this.watchAreaTypeWSProxy._universalSave((InvocationContext)InitializedVariable.context, (Object)watchAreaType);
        }
        return watchAreaType;
    }

    public static Integer calcRoadType(String t) {
        Integer rez = 4;
        if (t == null) {
            return rez;
        }
        if (t.equals("IA")) {
            return 1;
        }
        if (t.equals("I\u0411")) {
            return 1;
        }
        if (t.equals("I\u0412")) {
            return 1;
        }
        if (t.equals("I")) {
            return 1;
        }
        if (t.equals("II")) {
            return 2;
        }
        if (t.equals("III")) {
            return 3;
        }
        if (t.equals("V")) {
            return 5;
        }
        if (t.equals("VI")) {
            return 6;
        }
        if (t.equals("\u0431/\u043a")) {
            return 7;
        }
        if (t.equals("1")) {
            return 1;
        }
        if (t.equals("2")) {
            return 2;
        }
        if (t.equals("3")) {
            return 3;
        }
        if (t.equals("\u0410")) {
            return 1;
        }
        if (t.equals("\u0411")) {
            return 2;
        }
        if (t.equals("\u0412-1")) {
            return 3;
        }
        if (t.equals("\u0412-2")) {
            return 4;
        }
        if (t.equals("\u0413-1")) {
            return 5;
        }
        if (t.equals("\u0413-2")) {
            return 6;
        }
        return rez;
    }

    public String getHint() {
        return "\u0418\u043c\u043f\u043e\u0440\u0442 \u0434\u043e\u0440\u043e\u0433 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 GPX";
    }

    public String getName() {
        return "\u0418\u043c\u043f\u043e\u0440\u0442 \u0434\u043e\u0440\u043e\u0433";
    }

    public String getFilesDir() {
        return this.filesDir;
    }

    public void setFilesDir(String filesDir) {
        this.filesDir = filesDir;
    }

    private void appendLogFile(String value) {
        this.output.println(value);
        this.output.checkError();
    }

    public boolean createLogFileName() {
        SimpleDateFormat df = new SimpleDateFormat("_yyyyMMdd");
        File fn = new File("ImportRoad".concat(df.format(new Date())).concat(".log"));
        try {
            this.output = new PrintStream(new BufferedOutputStream(new FileOutputStream(fn, true)));
            return true;
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
            return false;
        }
    }
}

