/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.josm.roadwa.exportroads;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.WKTReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.List;
import org.postgis.MultiPolygon;
import org.postgis.Polygon;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.josm.roadwa.exportroads.ExportPanel;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.vms.RoadWAWSProxy;
import ru.infor.client.soap.proxy.vms.StationingWSProxy;
import ru.infor.ws.objects.vms.RoadWAUI;
import ru.infor.ws.objects.vms.StationingSearchCriteria;
import ru.infor.ws.objects.vms.entities.RoadWA;
import ru.infor.ws.objects.vms.entities.Stationing;
import ru.infor.ws.objects.vms.entities.ext.RoadWAExt;

public class ExportRoad
extends BeanViewerAction<ViewerContext> {
    GeometryFactory f = new GeometryFactory();
    WKTReader reader = new WKTReader(this.f);
    StationingWSProxy stationingWSProxy = (StationingWSProxy)CurrentProxyFactory.getProxy(Stationing.class);
    RoadWAWSProxy proxy = (RoadWAWSProxy)CurrentProxyFactory.getProxy(RoadWA.class);

    public String getName() {
        return "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u044d\u043a\u0441\u043f\u043e\u0440\u0442 \u0434\u043e\u0440\u043e\u0433";
    }

    public void actionPerformed(Object message) {
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
        ExportPanel p = (ExportPanel)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().getObject();
        if ("".equals(p.getFileName())) {
            InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0438\u043c\u044f \u0444\u0430\u0439\u043b\u0430 \u0434\u043b\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430"), new BeanViewerAction[]{new MessageOKButton()});
            return;
        }
        List listObject = ((BigContentViewer)((ViewerContext)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getParentContext()).getPresentator().getViewer()).getSelectedItems();
        if (listObject != null && listObject.size() > 0) {
            int k = this.exportData(p.getFileName(), p.getEncode(), listObject);
            InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d.\n \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0434\u043b\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430: " + listObject.size() + "\n \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432: " + k), new BeanViewerAction[]{new MessageOKButton()});
        } else {
            InitializedVariable.factory.runMessageEx((Object)new WarningMessage("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0433\u0438 \u0434\u043b\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430"), new BeanViewerAction[]{new MessageOKButton()});
        }
    }

    private boolean putRoad(RoadWAExt road, PrintWriter mid, PrintWriter mif) throws SQLException {
        if (road.getAreageom() == null) {
            return false;
        }
        mid.println(this.getProperty(road));
        Object line = null;
        line = road.getAreageom().indexOf("MULTIPOLYGON") >= 0 ? new MultiPolygon(road.getAreageom()) : new Polygon(road.getAreageom());
        mif.println("Region  1");
        mif.println(line.numPoints());
        int i = 0;
        while (i < line.numPoints()) {
            mif.println(String.valueOf(line.getPoint(i).getX()) + " " + line.getPoint(i).getY());
            ++i;
        }
        StationingSearchCriteria sc = new StationingSearchCriteria();
        sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
        sc.setRoadIdList(new Long[]{road.getId()});
        Object[] oo = this.stationingWSProxy.getList(InitializedVariable.context, sc).getObjList();
        if (oo != null && oo.length > 0) {
            Object[] objectArray = oo;
            int n = oo.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Stationing s = (Stationing)o;
                mid.println(this.getProperty(s));
                mif.println("Point " + s.getLon() + " " + s.getLat());
                ++n2;
            }
        }
        return true;
    }

    public int exportData(String nameFile, String encode, List<Object> listObject) {
        PrintWriter[] mm = this.InitMifMid(nameFile, encode);
        PrintWriter mif = mm[0];
        PrintWriter mid = mm[1];
        this.InitColumn(mif, mid);
        int k = 0;
        for (Object o : listObject) {
            RoadWAUI w = (RoadWAUI)o;
            RoadWAExt r = (RoadWAExt)this.proxy.getCurrentObject(InitializedVariable.context, w.getId());
            try {
                if (!this.putRoad(r, mid, mif)) continue;
                ++k;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        mif.close();
        mid.close();
        return k;
    }

    private String getProperty(RoadWAExt road) {
        StringBuilder st = new StringBuilder();
        st.append(road.getId()).append(";");
        st.append('\"').append("ddh").append('\"').append(";");
        st.append('\"').append(road.getTypeRoad()).append('\"').append(";");
        st.append(0).append(";");
        st.append('\"').append(road.getName()).append('\"').append(";");
        st.append('\"').append(road.getType() == null ? "" : road.getType().getDescription()).append('\"').append(";");
        st.append('\"').append('\"').append(";");
        return st.toString();
    }

    private String getProperty(Stationing s) {
        StringBuilder st = new StringBuilder();
        st.append(s.getId()).append(";");
        st.append('\"').append("milestone").append('\"').append(";");
        st.append('\"').append('\"').append(";");
        st.append(";");
        st.append('\"').append(s.getNum()).append('\"').append(";");
        st.append('\"').append('\"').append(";");
        st.append('\"').append(s.getNum()).append('\"').append(";");
        return st.toString();
    }

    public void InitColumn(PrintWriter mif, PrintWriter mid) {
        mif.println("Columns 7");
        mif.println("osm_id Integer");
        mif.println("highway Char(255)");
        mif.println("layer Char(255)");
        mif.println("z_order Integer");
        mif.println("name Char(255)");
        mif.println("district Char(255)");
        mif.println("ref Char(255)");
        mif.println("Data");
    }

    public PrintWriter[] InitMifMid(String nameFile, String encode) {
        try {
            if (nameFile.indexOf(".") > 0) {
                nameFile = nameFile.substring(0, nameFile.indexOf("."));
            }
            PrintWriter mif = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(String.valueOf(nameFile) + ".MIF").getAbsoluteFile()), encode));
            PrintWriter mid = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(String.valueOf(nameFile) + ".MID").getAbsoluteFile()), encode));
            mif.println("Version 300");
            mif.println("Charset \"WindowsCyrillic\"");
            mif.println("Delimiter \";\"");
            mif.println("CoordSys Earth Projection 1,0");
            return new PrintWriter[]{mif, mid};
        }
        catch (Exception exception) {
            return null;
        }
    }
}

