/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.loadtileselectarea;

import java.awt.geom.Point2D;
import org.jxmapviewer.viewer.AbstractTileFactory;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.Tile;
import org.jxmapviewer.viewer.TileCache;
import org.jxmapviewer.viewer.TileFactoryInfo;
import org.jxmapviewer.viewer.util.GeoUtil;
import ru.blok.common.ui.longTask.ComponentTask.ViewerStateProgressBar;
import ru.blok.common.ui.longTask.StateTask;
import ru.blok.vms.ui.mapviewer.cache.TileCacheFile;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapPropertiesUItrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapViewerWithRectangle;
import ru.blok.vms.ui.mapviewer.ui.DefaultProvider;
import ru.blok.vms.ui.mapviewer.ui.ProviderInfo;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.dialog.ErrorMessage;
import ru.infor.beanviewer.dialog.InfoMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;

@ListView(views={@View(title="\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u043a\u0430\u0440\u0442\u044b \u0432 \u041a\u042d\u0428", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class LoadTileSelectArea {
    MapValueWithTrack value;
    BeanViewerAction<ViewerContext> fieldButtonAction = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            GeoPosition p1 = ((MapViewerWithRectangle)LoadTileSelectArea.this.value.mapViewerWithTrack).getPoint1();
            GeoPosition p2 = ((MapViewerWithRectangle)LoadTileSelectArea.this.value.mapViewerWithTrack).getPoint2();
            if (p1 != null && p2 != null) {
                double c;
                double x1 = p1.getLatitude();
                double y1 = p1.getLongitude();
                double x2 = p2.getLatitude();
                double y2 = p2.getLongitude();
                if (x1 < x2) {
                    c = x1;
                    x1 = x2;
                    x2 = c;
                }
                if (y1 > y2) {
                    c = y1;
                    y1 = y2;
                    y2 = c;
                }
                final GeoPosition gpLT = new GeoPosition(x1, y1);
                final GeoPosition gpRB = new GeoPosition(x2, y2);
                ((ViewerContext)this.getContext()).getPresentator().getViewer().getFactory().runMessageEx((Object)new InfoMessage("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0430\u0439\u043b\u043e\u0432 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u0437\u0430\u0439\u043c\u0435\u0442 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043c\u0438\u043d\u0443\u0442."), new BeanViewerAction[]{new MessageOKButton()});
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        LoadTileSelectArea.this.saveCache(gpLT, gpRB, (ViewerContext)this.getContext());
                    }
                }).start();
            } else {
                ((ViewerContext)this.getContext()).getPresentator().getViewer().getFactory().runMessageEx((Object)new ErrorMessage("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043d\u0430\u0436\u0430\u0442\u0438\u0435\u043c \u043c\u044b\u0448\u0438, \u0443\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044f Ctrl"), new BeanViewerAction[]{new MessageOKButton()});
            }
        }

        public String getName() {
            return "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043e\u0431\u043b\u0430\u0441\u0442\u044c";
        }
    };
    private int countTile = 0;
    private int currentTile = 0;
    private StateTask stateTask = new StateTask();

    public LoadTileSelectArea() {
        this.value = new MapValueWithTrack();
    }

    @ListField(fields={@Field(title="", order=500, viewer={MapViewerWithRectangle.class}, propertiesLayout="Split1/h/r/0.2:Split1/h/r/0.80")})
    public MapValueWithTrack getValue() {
        return this.value;
    }

    @ListField(fields={@Field(title="", order=10, propertiesLayout="Split1/h/l/0.2:0/fillx//", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getFieldButtonAction() {
        return this.fieldButtonAction;
    }

    public void saveCache(GeoPosition p21, GeoPosition p22, ViewerContext viewerContext) {
        Point2D.Double pStart;
        long yt;
        long xt;
        int dyt;
        int dxt;
        Point2D p2;
        Point2D p1;
        FieldPresentation fp = ((PanelContext)viewerContext.getParentContext()).getPanel().getPresentatorForName("value");
        Object properties = fp.getViewer().getUIProperties();
        ProviderInfo osm = null;
        osm = properties == null ? DefaultProvider.getOSMProviderInfo() : ((MapPropertiesUItrack)properties).getProvidersInfo();
        DefaultProvider providers = new DefaultProvider(osm);
        AbstractTileFactory tf = providers.getTileFactory();
        tf.setTileCache((TileCache)new TileCacheFile("data/TileCacheFile/"));
        GeoPosition gpLT = p21;
        GeoPosition gpRB = p22;
        this.countTile = 0;
        this.currentTile = 0;
        int zoom = 0;
        while (zoom < 16) {
            p1 = null;
            p2 = null;
            dxt = 0;
            dyt = 0;
            xt = 0L;
            yt = 0L;
            p1 = GeoUtil.getBitmapCoordinate((double)gpLT.getLatitude(), (double)gpLT.getLongitude(), (int)zoom, (TileFactoryInfo)tf.getInfo());
            p2 = GeoUtil.getBitmapCoordinate((double)gpRB.getLatitude(), (double)gpRB.getLongitude(), (int)zoom, (TileFactoryInfo)tf.getInfo());
            xt = (int)(p1.getX() / (double)tf.getTileSize(zoom));
            yt = (int)(p1.getY() / (double)tf.getTileSize(zoom));
            pStart = new Point2D.Double((long)tf.getInfo().getTileSize(zoom) * xt, (long)tf.getInfo().getTileSize(zoom) * yt);
            dxt = (int)Math.abs(Math.round((p2.getX() - ((Point2D)pStart).getX()) / (double)tf.getTileSize(zoom) + 0.5));
            dyt = (int)Math.abs(Math.round((p2.getY() - ((Point2D)pStart).getY()) / (double)tf.getTileSize(zoom) + 0.5));
            if (dxt < 1) {
                dxt = 1;
            }
            if (dyt < 1) {
                dyt = 1;
            }
            this.countTile += dxt * dyt;
            ++zoom;
        }
        System.out.println("Count tile = " + this.countTile);
        this.stateTask.setMaxProgress(Integer.valueOf(this.countTile));
        this.stateTask.setCurrent(Integer.valueOf(0));
        this.stateTask.setState(StateTask.run);
        ((PanelContext)((ViewerContext)this.fieldButtonAction.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("stateTask");
        zoom = tf.getInfo().getMinimumZoomLevel();
        while (zoom <= tf.getInfo().getMaximumZoomLevel()) {
            p1 = null;
            p2 = null;
            dxt = 0;
            dyt = 0;
            xt = 0L;
            yt = 0L;
            p1 = GeoUtil.getBitmapCoordinate((double)gpLT.getLatitude(), (double)gpLT.getLongitude(), (int)zoom, (TileFactoryInfo)tf.getInfo());
            p2 = GeoUtil.getBitmapCoordinate((double)gpRB.getLatitude(), (double)gpRB.getLongitude(), (int)zoom, (TileFactoryInfo)tf.getInfo());
            xt = (int)(p1.getX() / (double)tf.getTileSize(zoom));
            yt = (int)(p1.getY() / (double)tf.getTileSize(zoom));
            pStart = new Point2D.Double((long)tf.getInfo().getTileSize(zoom) * xt, (long)tf.getInfo().getTileSize(zoom) * yt);
            dxt = (int)Math.abs(Math.round((p2.getX() - ((Point2D)pStart).getX()) / (double)tf.getTileSize(zoom) + 0.5));
            dyt = (int)Math.abs(Math.round((p2.getY() - ((Point2D)pStart).getY()) / (double)tf.getTileSize(zoom) + 0.5));
            if (dxt < 1) {
                dxt = 1;
            }
            if (dyt < 1) {
                dyt = 1;
            }
            int i = 0;
            while (i < dxt) {
                int j = 0;
                while (j < dyt) {
                    Tile tile = tf.getTile((int)xt + i, (int)yt + j, zoom);
                    ++this.currentTile;
                    this.stateTask.setCurrent(Integer.valueOf(this.currentTile));
                    ((PanelContext)((ViewerContext)this.fieldButtonAction.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("stateTask");
                    int time = 300;
                    while (!tile.isLoaded()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (--time != 0) continue;
                        System.out.println("Time out.");
                        return;
                    }
                    ++j;
                }
                ++i;
            }
            ++zoom;
        }
        ((ViewerContext)this.getFieldButtonAction().getContext()).getPresentator().getViewer().getFactory().runMessageEx((Object)new InfoMessage("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430"), new BeanViewerAction[]{new MessageOKButton()});
        this.stateTask.setState(StateTask.stop);
        ((PanelContext)((ViewerContext)this.fieldButtonAction.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("stateTask");
    }

    @ListField(fields={@Field(title="\u041f\u0440\u043e\u0446\u0435\u0441\u0441 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438", propertiesLayout="Split1/h/l/0.2:1/fillx, h 700//#newline#", order=20, viewer={ViewerStateProgressBar.class})})
    public StateTask getStateTask() {
        return this.stateTask;
    }
}

