/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jxmapviewer.JXMapKit;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.AbstractTileFactory;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileCache;
import org.jxmapviewer.viewer.TileFactory;
import ru.blok.common.client.application.MainFrame;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.blok.vms.ui.HelpUtils;
import ru.blok.vms.ui.mapviewer.MapValue;
import ru.blok.vms.ui.mapviewer.ScalePainter;
import ru.blok.vms.ui.mapviewer.cache.TileCacheFile;
import ru.blok.vms.ui.mapviewer.imap.IMapViewer;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MultiPainter;
import ru.blok.vms.ui.mapviewer.ui.DefaultProvider;
import ru.blok.vms.ui.mapviewer.ui.MapPropertiesUI;
import ru.blok.vms.ui.mapviewer.ui.ProviderInfo;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public class MapViewer
extends FieldViewer<JComponent>
implements SwingItem,
IMapViewer {
    protected JComponent main;
    public JXMapKit map;
    private AbstractTileFactory tf;
    protected MapValue value;
    public Double[] coord;
    DefaultProvider provider;
    protected MultiPainter<JXMapViewer> painter;
    public static String templConvertLatLon = "De.9999";
    JPanel p;
    JLabel st;
    JLabel latlon;
    GeoPosition geozoom;
    protected MapPropertiesUI propertiesUI = null;
    private ProviderInfo info = null;
    private HashMap<Integer, Object[]> metMilOnZoomM;
    static double[] dlonOfZoom = null;

    public MapViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.init();
    }

    protected void addPanelBttn(JPanel p2) {
    }

    protected void mouseMovedN(MouseEvent e) {
        double x = this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - (double)(this.map.getMainMap().getWidth() / 2);
        double y = this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - (double)(this.map.getMainMap().getHeight() / 2);
        Point2D.Double pClick = new Point2D.Double(x, y);
        this.geozoom = this.map.getMainMap().getTileFactory().pixelToGeo((Point2D)pClick, this.map.getMainMap().getZoom());
    }

    protected void mouseWheelMovedN(MouseWheelEvent e) {
        this.map.setCenterPosition(this.geozoom);
    }

    protected void init() {
        JButton b;
        this.painter = new MultiPainter();
        this.coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)MainFrame.keyPage));
        this.map = new JXMapKit();
        this.map.setAddressLocationShown(false);
        this.map.getMiniMap().setVisible(false);
        this.map.getMainMap().addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                MapViewer.this.mouseMovedN(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
        this.map.getMainMap().addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                MapViewer.this.mouseWheelMovedN(e);
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (MapViewer.this.value == null) {
                    MapViewer.this.value = new MapValue(MapViewer.this.coord[0], MapViewer.this.coord[1], MapViewer.this.coord[2].intValue());
                } else {
                    MapViewer.this.value.setLat(MapViewer.this.map.getMainMap().getCenterPosition().getLatitude());
                    MapViewer.this.value.setLon(MapViewer.this.map.getMainMap().getCenterPosition().getLongitude());
                    MapViewer.this.value.setZoom(MapViewer.this.map.getMainMap().getZoom());
                }
                MapViewer.this.map.setAddressLocation(new GeoPosition(MapViewer.this.value.getLat(), MapViewer.this.value.getLon()));
                MapViewer.this.map.setZoom(MapViewer.this.value.getZoom());
            }
        }));
        this.map.setPreferredSize(new Dimension(800, 600));
        this.main = new JPanel(new BorderLayout());
        this.main.add((Component)this.map, "Center");
        JPanel p2 = new JPanel((LayoutManager)new MigLayout("fillx,ins 0"));
        JPanel p3 = new JPanel((LayoutManager)new MigLayout("ins 0"));
        this.addPanelBttn(p3);
        this.p = new JPanel((LayoutManager)new MigLayout(" ins 0"));
        if (this.canGoToData()) {
            b = new JButton(new ImageIcon(MapViewer.class.getResource("/data/icons/zoom.png")));
            b.setToolTipText("\u041e\u043f\u0442\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u043c\u0430\u0441\u0448\u0442\u0430\u0431 \u043a\u0430\u0440\u0442\u044b");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MapViewer.this.zoomToTracks();
                }
            });
            p3.add(b);
        }
        b = new JButton(new ImageIcon(MapViewer.class.getResource("/data/icons/map_delete.png")));
        b.setToolTipText("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u0430\u0440\u0442\u0443 \u0434\u043b\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043c\u0430\u0441\u0448\u0442\u0430\u0431\u0430");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapViewer.this.clearCache(MapViewer.this.map.getMainMap().getZoom());
                GeoPosition gp = MapViewer.this.map.getMainMap().getCenterPosition();
                int zoom = MapViewer.this.map.getMainMap().getZoom();
                MapViewer.this.setTileFactory();
                MapViewer.this.map.getMainMap().setCenterPosition(gp);
                MapViewer.this.map.getMainMap().setZoom(zoom);
                MapViewer.this.map.getMainMap().repaint();
            }
        });
        p3.add(b);
        this.latlon = new JLabel();
        p3.add(this.latlon);
        this.st = new JLabel();
        p3.add(this.st);
        p2.add(p3);
        this.p = this.addCopyRightInfo(this.p, this.st, "", "", "", "");
        p2.add((Component)this.p, "align right");
        this.main.add((Component)p2, "South");
        this.map.getMainMap().setOverlayPainter(this.painter);
        ScalePainter pp = new ScalePainter();
        this.painter.addPainter(pp);
        pp.setMapViewer(this);
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                double x = MapViewer.this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - (double)(MapViewer.this.map.getMainMap().getWidth() / 2);
                double y = MapViewer.this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - (double)(MapViewer.this.map.getMainMap().getHeight() / 2);
                GeoPosition gp = MapViewer.this.map.getMainMap().getTileFactory().pixelToGeo((Point2D)new Point2D.Double(x, y), MapViewer.this.map.getMainMap().getZoom());
                MapViewer.this.mouseClickedOnMap(x, y, gp, e);
            }
        });
    }

    protected void mouseClickedOnMap(double x, double y, GeoPosition gp, MouseEvent e) {
        this.latlon.setText(" \u0428: " + HelpUtils.convertLatLon(gp.getLatitude(), this.getTemplConvertLatLon()) + "  \u0414: " + HelpUtils.convertLatLon(gp.getLongitude(), this.getTemplConvertLatLon()));
    }

    private JPanel addCopyRightInfo(JPanel p, final JLabel st, String copyright, final String copyrightURL, String extDesc, final String extDescURL) {
        if ((copyright == null || copyright.trim().equals("")) && (extDesc == null || extDesc.trim().equals(""))) {
            return p;
        }
        p.add(new JLabel(" "));
        JLabel l = new JLabel();
        if (extDesc != null && !extDesc.trim().equals("")) {
            if (extDescURL != null && !extDescURL.trim().equals("")) {
                l = new JLabel("<html><a href=\"" + extDescURL + "\">" + extDesc + "</a></html>");
                l.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        try {
                            Desktop.getDesktop().browse(new URI(extDescURL));
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                        st.setText("<html><font size=-2>" + extDescURL + "</font>");
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        super.mouseExited(e);
                        st.setText("");
                    }
                });
            } else {
                l = new JLabel(extDesc);
            }
            p.add(l);
        }
        p.add(new JLabel(" "));
        if (copyright != null && !copyright.trim().equals("")) {
            if (copyrightURL != null && !copyrightURL.trim().equals("")) {
                l = new JLabel("<html><a href=\"" + copyrightURL + "\">" + copyright + "</a></html>");
                l.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        try {
                            Desktop.getDesktop().browse(new URI(copyrightURL));
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                        st.setText("<html><font size=-2>" + copyrightURL + "</font>");
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        super.mouseExited(e);
                        st.setText("");
                    }
                });
            } else {
                l = new JLabel(copyright);
            }
            p.add(l);
        }
        return p;
    }

    public void setKey(String key) {
        super.setKey(key);
        if (this.propertiesUI == null) {
            this.setUIProperties(this.getUIProperties());
        }
    }

    public JComponent getComponent(boolean arg0, boolean arg1) {
        return this.main;
    }

    public Object getValue() {
        return this.value;
    }

    public void setChangeValueAction(BeanViewerAction<ViewerContext> arg0) {
    }

    public int getShape() {
        return 1;
    }

    public void setEditable(boolean arg0) {
    }

    public void setValue(Object arg0) {
        this.value = arg0 == null ? this.getNewInstance(this.coord[0], this.coord[1], this.coord[2].intValue()) : (MapValue)arg0;
        this.map.setZoom(this.value.getZoom());
        this.map.setAddressLocation(new GeoPosition(this.value.getLat(), this.value.getLon()));
    }

    protected MapValue getNewInstance(double lat, double lon, int zoom) {
        return new MapValue(this.coord[0], this.coord[1], this.coord[2].intValue());
    }

    @Override
    public Object getUIProperties() {
        if (this.propertiesUI == null) {
            this.propertiesUI = new MapPropertiesUI();
            this.propertiesUI.setProvidersInfo(DefaultProvider.getDefaultProviderInfo());
        }
        return this.propertiesUI;
    }

    public Class<?> getUIPropertiesClass() {
        return MapPropertiesUI.class;
    }

    private void setTileFactory() {
        this.tf = this.provider.getTileFactory();
        this.map.setTileFactory((TileFactory)this.tf);
        if (this.propertiesUI.getWithCache()) {
            this.tf.setTileCache((TileCache)new TileCacheFile("data/TileCacheFile/"));
        } else {
            this.tf.setTileCache(new TileCache());
        }
    }

    public void setUIProperties(Object viewerProperty) {
        if (viewerProperty != null) {
            try {
                this.propertiesUI = (MapPropertiesUI)viewerProperty;
                if (!(this.propertiesUI.getProvidersInfo() == null || this.info != null && this.info.equals(this.propertiesUI.getProvidersInfo()))) {
                    Object val = this.getValue();
                    this.provider = new DefaultProvider(this.propertiesUI.getProvidersInfo());
                    this.info = this.propertiesUI.getProvidersInfo();
                    this.setTileFactory();
                    this.setMetMilOnZoomM(this.info.getMapOnZoom());
                    this.setValue(val);
                    this.p.removeAll();
                    this.st.setText("");
                    this.addCopyRightInfo(this.p, this.st, this.info.getCopyright(), this.info.getCopyrightURL(), this.info.getExtDesc(), this.info.getExtDescURL());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public HashMap<Integer, Object[]> getMetMilOnZoomM() {
        return this.metMilOnZoomM;
    }

    @Override
    public void setMetMilOnZoomM(HashMap<Integer, Object[]> metMilOnZoomM) {
        this.metMilOnZoomM = metMilOnZoomM;
    }

    private void initdLon() {
        dlonOfZoom = new double[this.tf.getInfo().getTotalMapZoom() + 1];
        int k = 1;
        int z = this.tf.getInfo().getTotalMapZoom();
        while (z >= 0) {
            MapViewer.dlonOfZoom[z] = 360.0 / (double)k;
            k *= 2;
            --z;
        }
    }

    @Override
    public int getZoom(Double[] dd) {
        Double dlat = dd[1] - dd[0];
        Double dlon = dd[3] - dd[2];
        int z = this.tf.getInfo().getMinimumZoomLevel() - 1;
        if (dlonOfZoom == null) {
            this.initdLon();
        }
        if (dlon > dlat) {
            double k = this.map.getSize().getWidth() / (double)this.tf.getInfo().getTileSize(0);
            dlon = dlon / k;
            while (dlonOfZoom[z] < dlon && z < this.tf.getInfo().getMaximumZoomLevel()) {
                ++z;
            }
            if (++z < ((MapPropertiesUI)this.getUIProperties()).getMaxzoom()) {
                z = ((MapPropertiesUI)this.getUIProperties()).getMaxzoom();
            }
            return z;
        }
        double k = this.map.getSize().getHeight() / (double)this.tf.getInfo().getTileSize(0);
        dlat = dlat / k;
        while (dlonOfZoom[z] < dlat && z < this.tf.getInfo().getMaximumZoomLevel()) {
            ++z;
        }
        if (++z < ((MapPropertiesUI)this.getUIProperties()).getMaxzoom()) {
            z = ((MapPropertiesUI)this.getUIProperties()).getMaxzoom();
        }
        return z;
    }

    @Override
    public void zoomToTracks(Double[] dd) {
        if (dd != null) {
            this.map.setCenterPosition(new GeoPosition((dd[0] + dd[1]) / 2.0, (dd[2] + dd[3]) / 2.0));
            this.map.setZoom(this.getZoom(dd));
        }
    }

    @Override
    public void zoomToTracks() {
        Double[] dd = this.getMinMax();
        this.zoomToTracks(dd);
    }

    protected boolean canGoToData() {
        return false;
    }

    protected Double[] getMinMax() {
        return null;
    }

    protected void clearCache(int zoom) {
        String url = this.provider.getUriZoom(zoom);
        if (this.tf.getTileCache() instanceof TileCacheFile) {
            try {
                ((TileCacheFile)this.tf.getTileCache()).clearCache(new URI(url));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getTemplConvertLatLon() {
        return templConvertLatLon;
    }

    @Override
    public void setTemplConvertLatLon(String templConvertLatLon) {
        MapViewer.templConvertLatLon = templConvertLatLon;
    }

    @Override
    public int getZoomValue() {
        return this.map.getMainMap().getZoom();
    }

    @Override
    public void setCenterPosition(double[] latlon) {
        GeoPosition gp = new GeoPosition(latlon[0], latlon[1]);
        this.map.setCenterPosition(gp);
    }

    @Override
    public void setZoomValue(int zoom) {
        this.map.getMainMap().setZoom(zoom);
    }

    public void repaint() {
        this.map.repaint();
    }

    @Override
    public double[] getCenterPosition() {
        return new double[]{this.map.getCenterPosition().getLatitude(), this.map.getCenterPosition().getLongitude()};
    }

    @Override
    public void addListener(final BeanViewerAction bva, final int countClick, final boolean wCtrl) {
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == countClick && e.isControlDown() == wCtrl) {
                    bva.actionPerformed((Object)e);
                }
            }
        });
    }

    @Override
    public double[] getCenterMap() {
        return new double[]{this.map.getMainMap().getCenter().getX(), this.map.getMainMap().getCenter().getY()};
    }

    @Override
    public int getWidthMap() {
        return this.map.getMainMap().getWidth();
    }

    @Override
    public int getHeightMap() {
        return this.map.getMainMap().getHeight();
    }

    @Override
    public double[] pixelToGeo(double[] xy) {
        GeoPosition gp = this.map.getMainMap().getTileFactory().pixelToGeo((Point2D)new Point2D.Double(xy[0], xy[1]), this.map.getMainMap().getZoom());
        return new double[]{gp.getLatitude(), gp.getLongitude()};
    }

    @Override
    public double[] geoToPixel(double[] latlon) {
        Point2D p = this.map.getMainMap().getTileFactory().geoToPixel(new GeoPosition(latlon), this.map.getMainMap().getZoom());
        return new double[]{p.getX(), p.getY()};
    }
}

