/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.HashMap;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;

public class ScalePainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    public static HashMap<Integer, Double> maps = new HashMap();
    public static Stroke defaultStroke;
    private MapViewer viewer;

    static {
        maps.put(0, 111.32);
        maps.put(15, 107.551);
        maps.put(30, 96.486);
        maps.put(45, 78.847);
        maps.put(60, 55.8);
        maps.put(75, 28.902);
        maps.put(90, 0.0);
        defaultStroke = new BasicStroke(1.5f, 1, 1);
    }

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        int zoom = map.getZoom();
        if (this.viewer != null && this.viewer.getMetMilOnZoomM() != null) {
            Rectangle viewportBounds = map.getViewportBounds();
            Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
            int tileSize = map.getTileFactory().getTileSize(zoom);
            Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
            double vpx = viewportBounds.getX();
            while (vpx < 0.0) {
                vpx += sizeInPixels.getWidth();
            }
            while (vpx > sizeInPixels.getWidth()) {
                vpx -= sizeInPixels.getWidth();
            }
            int x = 10;
            int y = 30;
            Point p = new Point(x + (int)vpx, y + (int)viewportBounds.getY());
            GeoPosition gp = map.getTileFactory().pixelToGeo((Point2D)p, zoom);
            Object[] oo = this.viewer.getMetMilOnZoomM().get(zoom);
            GeoPosition[] gg = this.calcGeopozition(gp, (Double)oo[0], (Double)oo[1]);
            GeoPosition g2 = gg[0];
            Point2D p2 = map.getTileFactory().geoToPixel(g2, zoom);
            double d = p2.getX() - ((Point2D)p).getX();
            int d1 = (int)d;
            GeoPosition g3 = gg[1];
            Point2D p3 = map.getTileFactory().geoToPixel(g3, zoom);
            double d3 = p3.getX() - ((Point2D)p).getX();
            int d4 = (int)d3;
            g.translate(x, y);
            this.paint(g, zoom, d1, d4, (String)oo[2], (String)oo[3]);
            g.translate(-x, -y);
        }
    }

    private GeoPosition[] calcGeopozition(GeoPosition gp, double m, double mil) {
        double km = ScalePainter.calcKmOmDegree(gp.getLatitude());
        double mm = m / (1000.0 * km);
        double mi = mil / (3280.84 * km);
        GeoPosition gp1 = new GeoPosition(gp.getLatitude(), gp.getLongitude() + mm);
        GeoPosition gp2 = new GeoPosition(gp.getLatitude(), gp.getLongitude() + mi);
        return new GeoPosition[]{gp1, gp2};
    }

    public static double calcKmOmDegree(Double latit) {
        double lat = Math.abs(latit);
        int i = 0;
        while ((double)i < lat) {
            i += 15;
        }
        int k = i - 15;
        double k1 = Math.abs((double)k - lat) / 15.0;
        double k2 = Math.abs((double)i - lat) / 15.0;
        double km = maps.get(i) * k1 + maps.get(k) * k2;
        return km;
    }

    private void paint(Graphics2D g, int zoom, int d1, int d4, String s1, String s2) {
        g.setColor(Color.BLACK);
        g.setStroke(defaultStroke);
        g.drawLine(0, -15, 0, 0);
        g.drawLine(0, 0, d1, 0);
        g.drawLine(d1, -15, d1, 0);
        Font f = g.getFont();
        g.setFont(new Font(f.getFontName(), f.getStyle(), f.getSize() - 2));
        g.drawString(s1, 3, -2);
        g.setFont(f);
    }

    public void setMapViewer(MapViewer mv) {
        this.viewer = mv;
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }
}

