/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.cache;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.imageio.ImageIO;
import org.jxmapviewer.viewer.TileCache;
import ru.infor.common.SysProperties;

public class TileCacheFile
extends TileCache {
    private String cachePrefix = null;

    private void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        String[] ff = file.list();
        if (ff != null && ff.length > 0) {
            String[] stringArray = ff;
            int n = ff.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                this.deleteFile(new File(String.valueOf(file.getPath()) + File.separator + f));
                ++n2;
            }
        }
        file.delete();
    }

    public void clearCache(URI uri) {
        File f = this.getFile(uri);
        this.deleteFile(f);
    }

    public TileCacheFile(String cachePrefix) {
        String cacheDataFolder = SysProperties.getProperty((String)"cache.data.folder", (String)"");
        if (!cacheDataFolder.trim().equals("")) {
            cacheDataFolder = String.valueOf(cacheDataFolder) + File.separator;
        }
        this.cachePrefix = String.valueOf(cacheDataFolder) + cachePrefix;
    }

    private File getFile(URI uri) {
        String filename = String.valueOf(this.cachePrefix) + uri.getHost() + "/" + uri.getPath().replaceAll(":", "_") + (uri.getQuery() == null ? "" : "/" + uri.getQuery().replaceAll("=", "").replaceAll("&", "/").replaceAll(":", "_"));
        return new File(filename);
    }

    public BufferedImage get(URI uri) throws IOException {
        File f = this.getFile(uri);
        if (f.exists()) {
            BufferedImage img = ImageIO.read(f);
            return img;
        }
        return null;
    }

    public void needMoreMemory() {
    }

    public void put(URI uri, byte[] arg1, BufferedImage img) {
        System.out.println(uri);
        File f = this.getFile(uri);
        try {
            if (!f.exists()) {
                f.mkdirs();
            }
            ImageIO.write((RenderedImage)img, "png", f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

