/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.GpsEventListener;
import ru.blok.vms.ui.mapviewer.MapValue;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.imap.IMapViewerWithOneTrack;
import ru.blok.vms.ui.mapviewer.imap.IMapViewerWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.NodeType;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.Track;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.TrackNDData;
import ru.blok.vms.ui.tracks.trackinrealtimelite.TrackInRealTimeLite;
import ru.blok.vms.ui.tracks.trackinrealtimelite.TrackInRealTimeLiteBus;
import ru.blok.vms.ui.tracks.trackinrealtimelite.busnew.TrackInRealTimeLiteBusNew;
import ru.blok.vms.ui.tracks.trackinrealtimelite.withuitransport.TrackInRealTimeLiteImageFromCrewWithAngle;
import ru.blok.vms.ui.tracks.tracksmp.MapPropertiesUItrackSMP;
import ru.blok.vms.ui.tracks.tracksmp.TrackInRealTimeSMP;
import ru.blok.vms.ui.tracks.trackwithzones.TrackInRealTimeWithZones;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.ws.objects.vms.TransportUI;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.NDData;
import ru.infor.ws.objects.vms.entities.NavigationDevice;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.Transport2WatchAreaLink;
import ru.infor.ws.objects.vms.entities.ext.RouteExt;
import ru.infor.ws.objects.vms.entities.ext.TransportExt;

public class MapValueWithTrack
implements GpsEventListener,
IMapValue {
    public IMapViewerWithTrack mapViewerWithTrack;
    private MapValue mapValue;
    private boolean showHint = false;
    List<TrackNDData> tracksdata = new ArrayList<TrackNDData>();
    List<Track> tracks = new ArrayList<Track>();
    private TypeMapObject typeMapObject;
    String infoOnGPSDevice;
    Long[] listZoneID;
    private Long selectTrack = null;
    int typeFlag = 0;
    private Integer radius;
    private Integer typeZone;
    private Object main;
    private List<Long> selected = null;
    public static int SINGLE_MODE = 0;
    public static int MANY_MODE = 1;
    private int mode = SINGLE_MODE;
    private List<RouteExt> routes = new ArrayList<RouteExt>();
    Object trackInRealTime2;

    public Object getMain() {
        return this.main;
    }

    public void setMain(Object main) {
        this.main = main;
    }

    public Integer getTypeZone() {
        return this.typeZone;
    }

    public void setTypeZone(Integer typeZone) {
        this.typeZone = typeZone;
    }

    public Integer getRadius() {
        return this.radius;
    }

    public void setRadius(Integer radius) {
        this.radius = radius;
    }

    public int getTypeFlag() {
        return this.typeFlag;
    }

    public void setTypeFlag(int typeFlag) {
        this.typeFlag = typeFlag;
    }

    public Long getSelectTrack() {
        return this.selectTrack;
    }

    public void setSelectTrack(Long selectTrack) {
        this.selectTrack = selectTrack;
    }

    public Long[] getListZoneID() {
        return this.listZoneID;
    }

    public void setListZoneID(Long[] listZoneID) {
        this.listZoneID = listZoneID;
    }

    public MapValueWithTrack() {
    }

    public String getInfoOnGPSDevice() {
        return this.infoOnGPSDevice;
    }

    public void setInfoOnGPSDevice(String infoOnGPSDevice) {
        this.infoOnGPSDevice = infoOnGPSDevice;
    }

    public TypeMapObject getTypeMapObject() {
        return this.typeMapObject;
    }

    public void setTypeMapObject(TypeMapObject typeMapObject) {
        this.typeMapObject = typeMapObject;
    }

    public boolean isShowHint() {
        return this.showHint;
    }

    public void setShowHint(boolean showHint) {
        this.showHint = showHint;
    }

    public MapValue getMapValue() {
        return this.mapValue;
    }

    public void setMapValue(MapValue mapValue) {
        this.mapValue = mapValue;
    }

    public MapValueWithTrack(double lat, double lon, int zoom, TypeMapObject tMO) {
        this.mapValue = new MapValue(lat, lon, zoom);
        this.typeMapObject = tMO;
    }

    public List<TrackNDData> getTracksNDData() {
        return this.tracksdata;
    }

    public void setTracksNDData(List<TrackNDData> tracksdata) {
        this.tracksdata = tracksdata;
    }

    @Override
    public void event(long id, AbstractNDData data) {
        this.event(id, data, false, Color.RED, false);
    }

    public TrackNDData getTrackNDData(long id) {
        int i = 0;
        while (i < this.getTracksNDData().size()) {
            TrackNDData t = this.getTracksNDData().get(i);
            if (t.getId() == id) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public void deletedTrackNDDataNegative() {
        ArrayList<TrackNDData> del = new ArrayList<TrackNDData>();
        int i = 0;
        while (i < this.getTracksNDData().size()) {
            TrackNDData t = this.getTracksNDData().get(i);
            if (t.getId() < 0L) {
                del.add(t);
            }
            ++i;
        }
        for (TrackNDData d : del) {
            this.tracksdata.remove(d);
        }
    }

    public void event(long id, AbstractNDData data, boolean onlyCurrent, Color color, boolean realTime) {
        TrackNDData tt = this.getTrackNDDataCreate(id, onlyCurrent, null, this.infoOnGPSDevice, null, color, realTime);
        tt.addNode(data);
        if (!onlyCurrent) {
            tt.setCurrent(tt.getNodes().size() - 1);
        }
        if (this.mapViewerWithTrack != null) {
            this.mapViewerWithTrack.change();
        }
        if (this.mapValue == null && data != null) {
            this.init(new double[]{data.getLat(), data.getLon()});
        }
    }

    public synchronized TrackNDData getTrackNDDataCreate(long id, boolean onlyCurrent, Double northAngle, String infoOnGPSDevice, NodeType nodeType, Color color, boolean realTime) {
        return this.getTrackNDDataCreate(id, onlyCurrent, northAngle, infoOnGPSDevice, nodeType, color, realTime, true);
    }

    public synchronized TrackNDData getTrackNDDataCreate(long id, boolean onlyCurrent, Double northAngle, String infoOnGPSDevice, NodeType nodeType, Color color, boolean realTime, boolean changeVisible) {
        TrackNDData tt = null;
        int i = 0;
        while (i < this.getTracksNDData().size()) {
            TrackNDData t = this.getTracksNDData().get(i);
            if (t != null && t.getId() == id) {
                tt = t;
                if (tt.isOnlyCurrent() != onlyCurrent) {
                    t.setOnlyCurrent(onlyCurrent);
                }
                if (changeVisible) {
                    t.setVisible(true);
                }
                if (color != null) {
                    t.setParameter("Color", color);
                    t.setParameter("ColorSelected", color);
                    if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeLite) {
                        t.setParameter("ShowStatus", true);
                    }
                }
            }
            ++i;
        }
        if (tt == null) {
            TrackNDData t = new TrackNDData(this);
            t.setOnlyCurrent(onlyCurrent);
            t.setId(id, infoOnGPSDevice);
            if (color == null) {
                t.setParameter("Color", Color.RED);
            } else {
                t.setParameter("Color", color);
                if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeLite) {
                    t.setParameter("ShowStatus", true);
                }
            }
            t.setParameter("ColorSelected", color);
            this.tracksdata.add(t);
            tt = t;
        }
        tt.setNorthAngleLast(northAngle);
        return tt;
    }

    public int getZoomValue() {
        return this.mapViewerWithTrack.getZoomValue();
    }

    public double[] getCenterPosition() {
        return this.mapViewerWithTrack.getCenterPosition();
    }

    public void setCenterPosition(double[] latlon) {
        if (this.mapValue != null) {
            this.mapValue.setLat(latlon[0]);
            this.mapValue.setLon(latlon[1]);
        }
        if (this.mapViewerWithTrack != null) {
            this.mapViewerWithTrack.setCenterPosition(latlon);
        }
    }

    public void setZoomValue(int zoom) {
        if (this.mapValue != null) {
            this.mapValue.setZoom(zoom);
        }
        if (this.mapViewerWithTrack != null) {
            this.mapViewerWithTrack.setZoomValue(zoom);
        }
    }

    public void event(long id, AbstractNDData data, boolean onlyCurrent, Double northAngle, String infoOnGPSDevice, NodeType nodeType, Color color, boolean realtime) {
        TrackNDData tt = this.getTrackNDDataCreate(id, onlyCurrent, northAngle, infoOnGPSDevice, nodeType, color, realtime);
        this.event(tt, data);
    }

    public void event(TrackNDData tt, AbstractNDData data) {
        tt.addNode(data);
        if (this.mapViewerWithTrack != null) {
            this.mapViewerWithTrack.change();
        }
        if (this.mapValue == null && data != null) {
            this.init(new double[]{data.getLat(), data.getLon()});
        }
    }

    private void init(double[] latlon) {
        int z = 5;
        if (this.mapViewerWithTrack != null) {
            z = this.mapViewerWithTrack.getZoomValue();
        }
        this.setMapValue(new MapValue(latlon[0], latlon[1], z));
        if (this.mapViewerWithTrack != null) {
            this.mapViewerWithTrack.setCenterPosition(latlon);
        }
    }

    public void init(Long tId) {
        this.mode = SINGLE_MODE;
        this.setSelectTrack(tId);
        double[] latlon = null;
        for (TrackNDData t : this.getTracksNDData()) {
            if (!t.isVisible() || tId == null || t.getId() != tId.longValue()) continue;
            NDData data = (NDData)t.getNodes().get(t.getNodes().size() - 1);
            latlon = new double[]{data.getLat(), data.getLon()};
        }
        if (latlon != null) {
            this.init(latlon);
        } else if (this.mapViewerWithTrack != null) {
            this.mapViewerWithTrack.change();
        }
    }

    public List<Long> getSelected() {
        return this.selected;
    }

    public void setSelected(List<Long> selected) {
        this.mode = MANY_MODE;
        this.selected = selected;
        if (this.mapViewerWithTrack != null) {
            this.mapViewerWithTrack.change();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void eventAll(long id, List<AbstractNDData> list, int begin, int end, boolean onlyCurrent, Double northAngle) {
        this.eventAll(id, list, begin, end, onlyCurrent, northAngle, NodeType.DEFAULT, Color.RED);
    }

    public synchronized void eventAll(long id, List<AbstractNDData> list, int begin, int end, boolean onlyCurrent, Double northAngle, NodeType nodeType, Color color) {
        TrackNDData tt = this.getTrackNDDataCreate(id, onlyCurrent, northAngle, this.infoOnGPSDevice, nodeType, color, false);
        AbstractNDData nd = null;
        ArrayList<AbstractNDData> d = new ArrayList<AbstractNDData>();
        if (begin == 0 && end == list.size() - 1) {
            d.addAll(list);
        } else {
            int i = begin;
            while (i <= end) {
                d.add(list.get(i));
                ++i;
            }
        }
        if (d.size() > 0) {
            nd = (AbstractNDData)d.get(d.size() - 1);
        }
        tt.setNodes(d);
        if (this.mapViewerWithTrack != null) {
            this.mapViewerWithTrack.change();
        }
        if (this.mapValue == null && nd != null) {
            this.init(new double[]{nd.getLat(), nd.getLon()});
        }
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    public void setTracks(List<Track> tracks) {
        this.tracks = tracks;
    }

    public void event(long id, double[] latlon, Date dateNode, boolean onlyCurrent, Double northAngle) {
        this.event(id, latlon, dateNode, onlyCurrent, northAngle, this.getInfoOnGPSDevice());
    }

    public void event(long id, double[] latlon, Date dateNode, boolean onlyCurrent, Double northAngle, String infoOnGPSDevice) {
        this.event(id, latlon, dateNode, onlyCurrent, northAngle, infoOnGPSDevice, NodeType.DEFAULT);
    }

    public void event(long id, double[] latlon, Date dateNode, boolean onlyCurrent, Double northAngle, String infoOnGPSDevice, NodeType nodeType) {
        this.event(id, latlon, dateNode, onlyCurrent, northAngle, infoOnGPSDevice, nodeType, Color.RED);
    }

    public void event(long id, double[] latlon, Date dateNode, boolean onlyCurrent, Double northAngle, String infoOnGPSDevice, NodeType nodeType, Color color) {
        Track tt = null;
        int i = 0;
        while (i < this.getTracks().size()) {
            Track t = this.getTracks().get(i);
            if (t.getId() == id) {
                t.addNode(latlon[0], latlon[1], dateNode, northAngle, nodeType);
                tt = t;
            }
            ++i;
        }
        if (tt == null) {
            Track t = new Track(this);
            t.setOnlyCurrent(onlyCurrent);
            t.setId(id, infoOnGPSDevice);
            t.addNode(latlon[0], latlon[1], dateNode, northAngle, nodeType);
            t.setParameter("Color", color);
            this.tracks.add(t);
        }
        if (this.mapViewerWithTrack != null) {
            this.mapViewerWithTrack.change();
        }
        if (this.mapValue == null && latlon != null) {
            this.init(latlon);
        }
    }

    public void clear() {
        this.tracks.clear();
        this.tracksdata.clear();
        if (this.mapViewerWithTrack != null && this.mapViewerWithTrack instanceof IMapViewerWithOneTrack) {
            ((IMapViewerWithOneTrack)this.mapViewerWithTrack).clearMisc();
        }
    }

    public List<RouteExt> getRoutes() {
        return this.routes;
    }

    public void setRoute(Route r) {
        this.routes.clear();
        this.routes.add((RouteExt)r);
    }

    public Object getTrackInRealTime2() {
        return this.trackInRealTime2;
    }

    public void setTrackInRealTime2(Object trackInRealTime2) {
        this.trackInRealTime2 = trackInRealTime2;
    }

    public Long getLongTime(String name) {
        if (this.getTrackInRealTime2() instanceof TrackInRealTimeLiteImageFromCrewWithAngle) {
            MapPropertiesUItrackSMP p = (MapPropertiesUItrackSMP)this.mapViewerWithTrack.getUIProperties();
            if ("TimeGreen".equals(name)) {
                return (long)(p.getCountMinuteToGreen() * 60) * 1000L;
            }
            if ("TimeYellow".equals(name)) {
                return (long)(p.getCountMinuteToYellow() * 60) * 1000L;
            }
        }
        return null;
    }

    public String[] tudedHint(String[] hint, TrackNDData tt) {
        if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeWithZones && ((TrackInRealTimeWithZones)((Object)this.getTrackInRealTime2())).getLinks() != null) {
            ArrayList<String> list = new ArrayList<String>();
            Object[] objectArray = ((TrackInRealTimeWithZones)((Object)this.getTrackInRealTime2())).getLinks();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Transport2WatchAreaLink t = (Transport2WatchAreaLink)o;
                NavigationDevice device = ((TrackInRealTimeWithZones)((Object)this.getTrackInRealTime2())).getDevices().getDID(t.getTransport().getId(), false);
                if (device != null && device.getId().longValue() == tt.getId()) {
                    list.add("\u0417\u043e\u043d\u0430: " + t.getArea().getName());
                }
                ++n2;
            }
            String[] h = Arrays.copyOf(hint, hint.length + list.size());
            int i = 0;
            while (i < list.size()) {
                h[i + hint.length] = (String)list.get(i);
                ++i;
            }
            return h;
        }
        if (this.getTrackInRealTime2() != null && (this.getTrackInRealTime2() instanceof TrackInRealTimeSMP || this.getTrackInRealTime2() instanceof TrackInRealTimeLite)) {
            TransportExt t = null;
            AbstractNDData d = tt.getNodes().get(tt.getNodes().size() - 1);
            NavigationDevice dd = null;
            if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeSMP) {
                t = ((TrackInRealTimeSMP)((Object)this.getTrackInRealTime2())).getDevices().getTransportByDeviceId(tt.getId());
                if (tt.getId() > 0L) {
                    dd = ((TrackInRealTimeSMP)((Object)this.getTrackInRealTime2())).getDevices().getDID(tt.getId(), true);
                }
            } else if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeLite) {
                t = ((TrackInRealTimeLite)((Object)this.getTrackInRealTime2())).getDevices().getTransportByDeviceId(tt.getId());
            }
            if (t != null && t.isTracking()) {
                Object p = this.mapViewerWithTrack.getUIProperties();
                if (p instanceof MapPropertiesUItrackSMP) {
                    hint = ((MapPropertiesUItrackSMP)p).tunedHint(t, (NDData)d, dd);
                } else {
                    hint = new String[3];
                    hint[0] = t.getNameSMP();
                    hint[1] = "\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435: " + t.getStateIcon().getHint();
                    String st = "";
                    if (t.getTransportStatus() != null && t.getTransportStatus().getDescription() != null) {
                        st = t.getTransportStatus().getDescription();
                    }
                    hint[2] = "\u0421\u0442\u0430\u0442\u0443\u0441: " + st;
                }
            } else {
                hint = new String[]{};
            }
        } else if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeLiteImageFromCrewWithAngle) {
            TransportUI t = null;
            AbstractNDData d = tt.getNodes().get(tt.getNodes().size() - 1);
            t = ((TrackInRealTimeLiteImageFromCrewWithAngle)this.getTrackInRealTime2()).getDevices().getTransportByDId(tt.getId());
            if (t != null) {
                Object p = this.mapViewerWithTrack.getUIProperties();
                if (p instanceof MapPropertiesUItrackSMP) {
                    hint = ((MapPropertiesUItrackSMP)p).tunedHint(t, (NDData)d);
                }
            } else {
                hint = new String[]{};
            }
        }
        return hint;
    }

    public String showGNMap(TrackNDData tt) {
        Object p = this.mapViewerWithTrack.getUIProperties();
        if (p instanceof MapPropertiesUItrackSMP && ((MapPropertiesUItrackSMP)p).isShowGosNomerReal()) {
            TransportExt t = null;
            System.out.println(this.getTrackInRealTime2());
            if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeSMP) {
                t = ((TrackInRealTimeSMP)((Object)this.getTrackInRealTime2())).getDevices().getTransportByDeviceId(tt.getId());
                return t.getRegNum() == null ? "" : t.getRegNum();
            }
            if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeLiteImageFromCrewWithAngle) {
                TransportUI t1 = ((TrackInRealTimeLiteImageFromCrewWithAngle)this.getTrackInRealTime2()).getDevices().getTransportByDId(tt.getId());
                if (t1 != null) {
                    if (t1.getTracking() == null) {
                        t1.setTracking(Boolean.valueOf(false));
                    }
                    return t1.getRegNum() == null ? "" : t1.getRegNum();
                }
            } else if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeLite) {
                t = ((TrackInRealTimeLite)((Object)this.getTrackInRealTime2())).getDevices().getTransportByDeviceId(tt.getId());
                return t.getRegNum() == null ? "" : t.getRegNum();
            }
        }
        return null;
    }

    public String[] tudedHintGP(TrackNDData tt) {
        String[] hint = null;
        if (this.getTrackInRealTime2() != null && (this.getTrackInRealTime2() instanceof TrackInRealTimeSMP || this.getTrackInRealTime2() instanceof TrackInRealTimeLite)) {
            Object p;
            Object point = this.getGPSPoint(tt);
            if (tt != null && (p = this.mapViewerWithTrack.getUIProperties()) instanceof MapPropertiesUItrackSMP) {
                hint = ((MapPropertiesUItrackSMP)p).tunedHintGP(point);
            }
        }
        return hint;
    }

    public NodeType getNodeType(TrackNDData tt) {
        if (this.trackInRealTime2 instanceof TrackInRealTimeLiteImageFromCrewWithAngle) {
            return NodeType.STATE;
        }
        return null;
    }

    public boolean isShowHint(TrackNDData tt) {
        if (tt.getId() < 0L) {
            return false;
        }
        TransportExt t = null;
        if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeSMP) {
            t = ((TrackInRealTimeSMP)((Object)this.getTrackInRealTime2())).getDevices().getTransportByDeviceId(tt.getId());
        } else if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeLiteImageFromCrewWithAngle) {
            TransportUI t1 = ((TrackInRealTimeLiteImageFromCrewWithAngle)this.getTrackInRealTime2()).getDevices().getTransportByDId(tt.getId());
            if (t1 != null) {
                if (t1.getTracking() == null) {
                    t1.setTracking(Boolean.valueOf(false));
                }
                return t1.getTracking();
            }
        } else if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeLite) {
            t = ((TrackInRealTimeLite)((Object)this.getTrackInRealTime2())).getDevices().getTransportByDeviceId(tt.getId());
        }
        if (t != null) {
            return t.isTracking();
        }
        return this.isShowHint();
    }

    public Object getGPSPoint(TrackNDData tt) {
        TransportExt t;
        if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeSMP) {
            t = null;
            t = ((TrackInRealTimeSMP)((Object)this.getTrackInRealTime2())).getDevices().getTransportByDeviceId(tt.getId());
            if (t != null && t.isTracking()) {
                return ((TrackInRealTimeSMP)((Object)this.getTrackInRealTime2())).mapGeop.get(t.getId());
            }
        }
        if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeLite) {
            t = null;
            t = ((TrackInRealTimeLite)((Object)this.getTrackInRealTime2())).getDevices().getTransportByDeviceId(tt.getId());
            if (t != null && t.isTracking()) {
                return ((TrackInRealTimeLite)((Object)this.getTrackInRealTime2())).mapGeopCurrent.get(t.getId());
            }
        }
        return null;
    }

    public Route getRoute(TrackNDData tt) {
        if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeLiteBus) {
            TransportExt t = null;
            t = ((TrackInRealTimeLite)((Object)this.getTrackInRealTime2())).getDevices().getTransportByDeviceId(tt.getId());
            if (t != null && t.isTracking()) {
                return t.getRoute2();
            }
        }
        return null;
    }

    public Route getRouteColor(TrackNDData tt) {
        if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeLiteBusNew) {
            return ((TrackInRealTimeLiteBusNew)this.getTrackInRealTime2()).getRouteFromDevice(tt.getId());
        }
        return null;
    }

    public void setFlag(GeoPosition gp) {
        if (this.getTrackInRealTime2() != null && this.getTrackInRealTime2() instanceof TrackInRealTimeSMP) {
            ((TrackInRealTimeSMP)((Object)this.getTrackInRealTime2())).setFlag(gp, (PanelContext)this.mapViewerWithTrack.getViewerContext().getParentContext());
        }
    }

    public static enum TypeMapObject {
        FLAG,
        OBSTANCLE,
        INFO,
        NEAR_ADRESS,
        CHECKPOINT;

    }
}

