/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapPropertiesUItrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapViewerWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RectanglePainter;
import ru.blok.vms.ui.mapviewer.ui.DefaultProvider;
import ru.infor.beanviewer.core.UIFactory;

public class MapViewerWithRectangle
extends MapViewerWithTrack {
    MapValueWithTrack mapValueWithTrack;
    RectanglePainter<JXMapViewer> rectanglePainter;
    private int state = 0;
    private Point2D p1;
    private Point2D p2;
    GeoPosition gp1 = null;
    GeoPosition gp2 = null;

    public MapViewerWithRectangle(UIFactory<JComponent> factory) {
        super(factory);
    }

    private synchronized int getState() {
        return this.state;
    }

    private synchronized void setState(int state) {
        this.state = state;
    }

    public GeoPosition getPoint1() {
        return this.gp1;
    }

    public GeoPosition getPoint2() {
        return this.gp2;
    }

    @Override
    protected void init() {
        super.init();
        this.rectanglePainter = new RectanglePainter();
        this.painter.addPainter(this.rectanglePainter);
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && e.isControlDown()) {
                    double x = MapViewerWithRectangle.this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - (double)(MapViewerWithRectangle.this.map.getMainMap().getWidth() / 2);
                    double y = MapViewerWithRectangle.this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - (double)(MapViewerWithRectangle.this.map.getMainMap().getHeight() / 2);
                    GeoPosition gp = MapViewerWithRectangle.this.map.getMainMap().getTileFactory().pixelToGeo((Point2D)new Point2D.Double(x, y), MapViewerWithRectangle.this.map.getMainMap().getZoom());
                    if (MapViewerWithRectangle.this.getState() == 0) {
                        MapViewerWithRectangle.this.gp1 = new GeoPosition(gp.getLatitude(), gp.getLongitude());
                        MapViewerWithRectangle.this.gp2 = null;
                        MapViewerWithRectangle.this.rectanglePainter.setPoint2(null);
                        MapViewerWithRectangle.this.setState(1);
                    } else if (MapViewerWithRectangle.this.getState() == 1) {
                        MapViewerWithRectangle.this.gp2 = new GeoPosition(gp.getLatitude(), gp.getLongitude());
                        MapViewerWithRectangle.this.rectanglePainter.setPoint1(MapViewerWithRectangle.this.gp1);
                        MapViewerWithRectangle.this.rectanglePainter.setPoint2(MapViewerWithRectangle.this.gp2);
                        MapViewerWithRectangle.this.setState(0);
                    }
                }
            }
        });
        this.initRepaint();
    }

    @Override
    public void change() {
        this.repaint();
    }

    @Override
    protected void initRepaint() {
    }

    @Override
    public Object getUIProperties() {
        if (this.propertiesUI == null) {
            this.propertiesUI = new MapPropertiesUItrack();
            this.propertiesUI.setProvidersInfo(DefaultProvider.getDefaultProviderInfo());
        }
        return this.propertiesUI;
    }

    @Override
    public void repaint() {
        this.map.getMainMap().repaint();
    }

    @Override
    public Class<?> getUIPropertiesClass() {
        return MapPropertiesUItrack.class;
    }
}

