/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import ru.blok.vms.ui.mapviewer.MapValue;
import ru.blok.vms.ui.mapviewer.MapViewer;
import ru.blok.vms.ui.mapviewer.imap.IMapViewerWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapPropertiesUItrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.TrackNDData;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.NodePainterData;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RegionPainter;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RoutePainter;
import ru.blok.vms.ui.mapviewer.ui.DefaultProvider;
import ru.blok.vms.ui.tracks.TrackInRealTimeCommon;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.ws.objects.vms.AdressNearPointParam;
import ru.infor.ws.objects.vms.entities.AbstractNDData;

public class MapViewerWithTrack
extends MapViewer
implements IMapViewerWithTrack {
    RegionPainter regionPainter;
    RoutePainter routePainter;
    protected MapValueWithTrack mapValueWithTrack;
    protected MapViewPainter<JXMapViewer> wpp;
    private boolean change = false;
    AdressNearPointParam param;

    public MapViewerWithTrack(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    public void setValue(Object arg0) {
        if (arg0 != null) {
            TrackNDData t;
            this.mapValueWithTrack = (MapValueWithTrack)arg0;
            this.mapValueWithTrack.mapViewerWithTrack = this;
            if (this.mapValueWithTrack.getMapValue() == null && this.mapValueWithTrack.getTracksNDData() != null && this.mapValueWithTrack.getTracksNDData().size() > 0 && (t = this.mapValueWithTrack.getTracksNDData().get(0)).getNodes() != null && t.getNodes().size() > 0) {
                AbstractNDData n = t.getNodes().get(0);
                int z = 5;
                if (t.getParameter("zoom") != null) {
                    z = (Integer)t.getParameter("zoom");
                }
                this.mapValueWithTrack.setMapValue(new MapValue(n.getLat(), n.getLon(), z));
            }
            super.setValue(this.mapValueWithTrack.getMapValue());
            this.wpp.setValue(this.mapValueWithTrack);
            Object o = ((PanelContext)this.getViewerContext().getParentContext()).getObject();
            if (o instanceof TrackInRealTimeCommon) {
                this.mapValueWithTrack.setShowHint(((TrackInRealTimeCommon)((Object)o)).isShowHint());
                this.mapValueWithTrack.setInfoOnGPSDevice(((TrackInRealTimeCommon)((Object)o)).getInfoOnGPSDevice());
            }
        }
        this.regionPainter.setValue((MapValueWithTrack)this.getValue());
        this.routePainter.setValue((MapValueWithTrack)this.getValue());
    }

    @Override
    public Object getValue() {
        if (this.mapValueWithTrack != null && this.mapValueWithTrack.getMapValue() != null) {
            this.mapValueWithTrack.getMapValue().setLat(this.map.getMainMap().getCenterPosition().getLatitude());
            this.mapValueWithTrack.getMapValue().setLon(this.map.getMainMap().getCenterPosition().getLongitude());
            this.mapValueWithTrack.getMapValue().setZoom(this.map.getMainMap().getZoom());
        }
        return this.mapValueWithTrack;
    }

    @Override
    public void change() {
        this.change = true;
    }

    protected MapViewPainter<JXMapViewer> getPainter() {
        return new NodePainterData<JXMapViewer>();
    }

    @Override
    protected void init() {
        super.init();
        this.wpp = this.getPainter();
        this.routePainter = new RoutePainter();
        this.painter.addPainter(this.routePainter, 0);
        this.regionPainter = new RegionPainter();
        this.painter.addPainter(this.regionPainter);
        this.painter.addPainter(this.wpp);
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MapViewerWithTrack.this.map.getMainMap().repaint();
            }
        });
        this.initRepaint();
    }

    protected void initRepaint() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        if (MapViewerWithTrack.this.change) {
                            MapViewerWithTrack.this.repaint();
                            MapViewerWithTrack.this.change = false;
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }).start();
    }

    @Override
    public Object getUIProperties() {
        if (this.propertiesUI == null) {
            this.propertiesUI = new MapPropertiesUItrack();
            this.propertiesUI.setProvidersInfo(DefaultProvider.getDefaultProviderInfo());
        }
        return this.propertiesUI;
    }

    @Override
    public Class<?> getUIPropertiesClass() {
        return MapPropertiesUItrack.class;
    }

    @Override
    protected Double[] getMinMax() {
        Double minLat = null;
        Double maxLat = null;
        Double minLon = null;
        Double maxLon = null;
        for (TrackNDData t : this.mapValueWithTrack.getTracksNDData()) {
            if (!t.isVisible() || t.getNodes().size() <= 0) continue;
            AbstractNDData d = t.getNodes().get(t.getNodes().size() - 1);
            if (minLat == null || d.getLat() < minLat) {
                minLat = d.getLat();
            }
            if (maxLat == null || d.getLat() > maxLat) {
                maxLat = d.getLat();
            }
            if (minLon == null || d.getLon() < minLon) {
                minLon = d.getLon();
            }
            if (maxLon != null && !(d.getLon() > maxLon)) continue;
            maxLon = d.getLon();
        }
        if (minLat == null) {
            return null;
        }
        return new Double[]{minLat, maxLat, minLon, maxLon};
    }

    public AdressNearPointParam getParam() {
        return this.param;
    }

    public void setParam(AdressNearPointParam param) {
        this.param = param;
    }

    @Override
    protected boolean canGoToData() {
        return true;
    }
}

