/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.Calendar;
import java.util.Date;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.NodeType;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.Primitive;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.PrimitiveForView;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.Track;

public class Node
extends Primitive {
    double lat;
    double lon;
    Date date;
    private Track track;
    Double northAngle;
    private NodeType type = NodeType.DEFAULT;

    public NodeType getType() {
        return this.type;
    }

    public void setType(NodeType type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof Node && ((Node)obj).getTrack().equals(this.track) && ((Node)obj).getLat() == this.lat && ((Node)obj).getLon() == this.lon;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public Track getTrack() {
        return this.track;
    }

    public Double getNorthAngle() {
        return this.northAngle;
    }

    public void setNorthAngle(Double northAngle) {
        this.northAngle = northAngle;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Node(Track track) {
        this.track = track;
    }

    public PrimitiveForView Tuned(boolean select) {
        PrimitiveForView forView = new PrimitiveForView(defaultStroke, (Color)this.track.getParameter("Color"), (Color)this.track.getParameter("Color"), null);
        if (select) {
            forView.setStroke(new BasicStroke(5.0f, 1, 1));
        }
        if (this.track.isOnlyCurrent()) {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(12, -20);
            if (this.getDate().before(c.getTime())) {
                forView.setColorLine(Color.GRAY);
            }
        }
        if (this.track.getNodes().indexOf(this) == this.track.getNodes().size() - 1) {
            forView.setShowArrow(true);
            this.setParameter("name", this.track.getHints()[0]);
            forView.setShowHint(this.getTrack().getMapValueWithTrack().isShowHint());
            this.setParameter("hint", this.track.getHints());
            forView.setColorPixel(Color.BLACK);
        }
        return forView;
    }
}

