/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.Node;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.NodeType;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.Primitive;
import ru.infor.client.soap.proxy.vms.NavigationDeviceWSProxy;
import ru.infor.ws.objects.vms.DeviceInfoParams;
import ru.infor.ws.objects.vms.entities.NavigationDevice;

public class Track
extends Primitive {
    NavigationDeviceWSProxy proxy = (NavigationDeviceWSProxy)CurrentProxyFactory.getProxy(NavigationDevice.class);
    long id;
    private List<Node> nodes = new ArrayList<Node>();
    private MapValueWithTrack mapValueWithTrack;
    private boolean onlyCurrent;
    private String[] hints;

    public long getId() {
        return this.id;
    }

    public MapValueWithTrack getMapValueWithTrack() {
        return this.mapValueWithTrack;
    }

    public Track(MapValueWithTrack mapValueWithTrack) {
        this.mapValueWithTrack = mapValueWithTrack;
    }

    public boolean isOnlyCurrent() {
        return this.onlyCurrent;
    }

    public void setOnlyCurrent(boolean onlyCurrent) {
        this.onlyCurrent = onlyCurrent;
    }

    public String[] getHints() {
        return this.hints;
    }

    public void setId(long id) {
        this.setId(id, "");
    }

    public void setId(long id, String infoindex) {
        this.id = id;
        DeviceInfoParams p = new DeviceInfoParams();
        p.setDeviceIdList(new Long[]{id});
        p.setDate(new Date());
        String s = this.proxy.getInfoByParams(InitializedVariable.context, p);
        String[] h = s.split(";");
        if (h.length > 1) {
            ArrayList<String> l = new ArrayList<String>();
            int i = 0;
            while (i < h.length) {
                if (h[i] != null && !"".equals(h[i]) && this.isWriteInfo(i, infoindex)) {
                    l.add(h[i]);
                }
                ++i;
            }
            this.hints = l == null || l.size() == 0 ? new String[]{h[0]} : l.toArray(new String[0]);
        } else {
            this.hints = h;
        }
        this.setParameter("Color", defaultColor);
    }

    private boolean isWriteInfo(int i, String infoindex) {
        if (infoindex == null || "".equals(infoindex.trim())) {
            return true;
        }
        return "1".equals(infoindex.substring(i, i + 1));
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public void addNode(double lat, double lon, Date d, Double northAngle) {
        this.addNode(lat, lon, d, northAngle, NodeType.DEFAULT);
    }

    public void addNode(double lat, double lon, Date d, Double northAngle, NodeType nodeType) {
        Node n = new Node(this);
        n.setLat(lat);
        n.setLon(lon);
        n.setDate(d);
        n.setType(nodeType);
        n.setNorthAngle(northAngle);
        if (this.onlyCurrent) {
            this.nodes.clear();
        }
        if (!this.nodes.contains(n)) {
            this.nodes.add(n);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof Track && ((Track)obj).getId() == this.id;
    }
}

