/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack;

import java.awt.Color;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.postgis.Geometry;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.NodeType;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.Primitive;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.PrimitiveForView;
import ru.infor.client.soap.proxy.vms.NavigationDeviceWSProxy;
import ru.infor.ws.objects.vms.DeviceInfoParams;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.NavigationDevice;
import ru.infor.ws.objects.vms.entities.Route;

public class TrackNDData
extends Primitive {
    NavigationDeviceWSProxy proxy = (NavigationDeviceWSProxy)CurrentProxyFactory.getProxy(NavigationDevice.class);
    long id;
    private MapValueWithTrack mapValueWithTrack;
    private boolean onlyCurrent;
    private boolean realTime;
    private String[] hints;
    private Double northAngleLast;
    private Integer[] selectedPath;
    private Integer[] selectedPoint;
    private List<AbstractNDData> nodes = new ArrayList<AbstractNDData>();
    private Integer current = null;
    private Image image;
    boolean visible = true;
    private String label;
    private List<Geometry> listGeometry;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Integer getCurrent() {
        return this.current;
    }

    public void setCurrent(Integer current) {
        this.current = current;
    }

    public Integer[] getSelectedPoint() {
        return this.selectedPoint;
    }

    public void setSelectedPoint(Integer[] selectedPoint) {
        this.selectedPath = null;
        this.selectedPoint = selectedPoint;
    }

    public Integer[] getSelectedPath() {
        return this.selectedPath;
    }

    public void setSelected(Integer[] selectedPath) {
        this.selectedPoint = null;
        this.selectedPath = selectedPath;
    }

    public void setSelected(Integer[] selectedPath, Integer[] selectedPoint) {
        this.selectedPath = selectedPath;
        this.selectedPoint = selectedPoint;
    }

    public Double getNorthAngleLast() {
        return this.northAngleLast;
    }

    public void setNorthAngleLast(Double northAngleLast) {
        this.northAngleLast = northAngleLast;
    }

    public long getId() {
        return this.id;
    }

    public MapValueWithTrack getMapValueWithTrack() {
        return this.mapValueWithTrack;
    }

    public TrackNDData(MapValueWithTrack mapValueWithTrack) {
        this.mapValueWithTrack = mapValueWithTrack;
    }

    public boolean isOnlyCurrent() {
        return this.onlyCurrent;
    }

    public void setOnlyCurrent(boolean onlyCurrent) {
        this.onlyCurrent = onlyCurrent;
    }

    public boolean isRealTime() {
        return this.realTime;
    }

    public void setRealTime(boolean realTime) {
        this.realTime = realTime;
    }

    public String[] getHints() {
        return this.hints;
    }

    public void setHints(String[] hints) {
        this.hints = hints;
    }

    public void setId(long id) {
        this.setId(id, "");
    }

    public void setId(long id, String infoindex) {
        this.id = id;
        DeviceInfoParams p = new DeviceInfoParams();
        p.setDeviceIdList(new Long[]{id});
        p.setDate(new Date());
        String s = this.proxy.getInfoByParams(InitializedVariable.context, p);
        String[] h = s.split(";");
        if (h.length > 1) {
            ArrayList<String> l = new ArrayList<String>();
            int i = 0;
            while (i < h.length) {
                if (h[i] != null && !"".equals(h[i]) && this.isWriteInfo(i, infoindex)) {
                    l.add(h[i]);
                }
                ++i;
            }
            this.hints = l == null || l.size() == 0 ? new String[]{h[0]} : l.toArray(new String[0]);
        } else {
            this.hints = h;
        }
        this.setParameter("Color", defaultColor);
        this.setParameter("ColorSelected", defaultColorSelected);
    }

    private boolean isWriteInfo(int i, String infoindex) {
        if (infoindex == null || "".equals(infoindex.trim())) {
            return true;
        }
        if (i >= infoindex.length()) {
            return false;
        }
        return "1".equals(infoindex.substring(i, i + 1));
    }

    public List<AbstractNDData> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<AbstractNDData> nodes) {
        this.nodes = nodes;
    }

    public void addNode(AbstractNDData n) {
        if (this.onlyCurrent) {
            this.nodes.clear();
        }
        if (!this.nodes.contains(n)) {
            this.nodes.add(n);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof TrackNDData && ((TrackNDData)obj).getId() == this.id;
    }

    public boolean isSelect() {
        if (this.mapValueWithTrack.getMode() == MapValueWithTrack.SINGLE_MODE) {
            return this.mapValueWithTrack != null && this.mapValueWithTrack.getSelectTrack() != null && this.id == this.mapValueWithTrack.getSelectTrack();
        }
        return this.mapValueWithTrack.getSelected() != null && this.mapValueWithTrack.getSelected().contains(this.id);
    }

    public PrimitiveForView TunedNode(AbstractNDData data, boolean last, boolean selected) {
        PrimitiveForView forView = new PrimitiveForView(selected ? defaultStrokeSelected : defaultStroke, selected ? (Color)this.getParameter("ColorSelected") : (Color)this.getParameter("Color"), selected ? (Color)this.getParameter("ColorSelected") : (Color)this.getParameter("Color"), null);
        forView.setColorPixel(Color.BLACK);
        if (this.isRealTime()) {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(10, -2);
            if (data.getCreatedDateTime().before(c.getTime())) {
                forView.setColorLine(Color.GRAY);
            }
        }
        forView.setSelect(this.isSelect());
        if (last) {
            forView.setShowArrow(true);
            if (this.getHints() != null && this.getHints().length > 0) {
                this.setParameter("name", this.getHints()[0]);
            }
            forView.setShowHint(this.mapValueWithTrack.isShowHint(this));
            this.setParameter("hint", this.mapValueWithTrack.tudedHint(this.getHints(), this));
            this.setLabel(this.mapValueWithTrack.showGNMap(this));
            this.setParameter("hintGP", this.mapValueWithTrack.tudedHintGP(this));
            this.setParameter("northAngleLast", this.getNorthAngleLast());
            forView.setColorPixel(Color.BLACK);
            NodeType t = this.mapValueWithTrack.getNodeType(this);
            if (t == null) {
                forView.setType(selected ? NodeType.BIG : NodeType.DEFAULT);
            } else {
                forView.setType(t);
            }
            this.setParameter("image", this.getImage());
        }
        return forView;
    }

    public Object getGPSPoint() {
        if (this.mapValueWithTrack != null) {
            return this.mapValueWithTrack.getGPSPoint(this);
        }
        return null;
    }

    public Route getRoute() {
        if (this.mapValueWithTrack != null) {
            return this.mapValueWithTrack.getRoute(this);
        }
        return null;
    }

    public Route getRouteColor() {
        if (this.mapValueWithTrack != null) {
            return this.mapValueWithTrack.getRouteColor(this);
        }
        return null;
    }

    @Override
    public Object getParameter(String name) {
        if ("TimeGreen".equals(name) || "TimeYellow".equals(name)) {
            return this.mapValueWithTrack.getLongTime(name);
        }
        return super.getParameter(name);
    }

    public List<Geometry> getListGeometry() {
        return this.listGeometry;
    }

    public void setListGeometry(List<Geometry> listGeometry) {
        this.listGeometry = listGeometry;
    }
}

