/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;

public class IconPainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    List<IconOnMap> listIcons = new ArrayList<IconOnMap>();

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        for (IconOnMap m : this.listIcons) {
            Point2D point = map.getTileFactory().geoToPixel(m.getPoint(), map.getZoom());
            if (!vp2.contains(point)) continue;
            int x = (int)(point.getX() - ((RectangularShape)vp2).getX());
            int y = (int)(point.getY() - ((RectangularShape)vp2).getY());
            if (m.color != null) {
                Color c = new Color(m.color);
                Color c2 = c.darker().darker();
                int r = m.d / 2;
                g.setColor(c);
                g.fillOval(x - r, y - r, m.d, m.d);
                g.setColor(c2);
                g.drawOval(x - r, y - r, m.d, m.d);
                continue;
            }
            Image img1 = m.im;
            try {
                if (img1 == null) {
                    if (m.getImage().startsWith("http")) {
                        img1 = ImageIO.read(new URL(m.getImage()));
                    }
                    if (img1 == null) {
                        URL url = ((Object)((Object)this)).getClass().getResource(m.getImage());
                        img1 = url != null ? ImageIO.read(url) : ImageIO.read(new File(m.getImage()));
                    }
                    m.im = img1;
                }
                if (img1 == null) continue;
                g.drawImage(img1, x - img1.getWidth(null) / 2, y - img1.getHeight(null) / 2, (ImageObserver)map);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List<IconOnMap> getListIcons() {
        return this.listIcons;
    }

    public void addIconOnMap(IconOnMap m) {
        this.listIcons.add(m);
    }

    public void removeIconOnMap(IconOnMap m) {
        this.listIcons.remove(m);
    }

    public static boolean include(Point2D pPark, Point2D pClick, IconOnMap tt) {
        Point2D.Double p2 = new Point2D.Double(pClick.getX() - pPark.getX(), pClick.getY() - pPark.getY());
        if (tt.d != null) {
            return Math.abs(((Point2D)p2).getX()) <= (double)(tt.d / 2) && Math.abs(((Point2D)p2).getY()) <= (double)(tt.d / 2);
        }
        return tt.im != null && Math.abs(((Point2D)p2).getX()) <= (double)(tt.im.getWidth(null) / 2) && Math.abs(((Point2D)p2).getY()) <= (double)(tt.im.getHeight(null) / 2);
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }

    public static class IconOnMap {
        String image;
        GeoPosition point;
        Image im;
        Object obj;
        Integer color;
        Integer d;

        public Integer getColor() {
            return this.color;
        }

        public void setColor(Integer color) {
            this.color = color;
        }

        public Integer getD() {
            return this.d;
        }

        public void setD(Integer d) {
            this.d = d;
        }

        public Object getObj() {
            return this.obj;
        }

        public void setObj(Object obj) {
            this.obj = obj;
        }

        public IconOnMap(String image, GeoPosition point) {
            this.image = image;
            this.point = point;
        }

        public String getImage() {
            return this.image;
        }

        public void setImage(String image) {
            this.image = image;
        }

        public GeoPosition getPoint() {
            return this.point;
        }

        public void setPoint(GeoPosition point) {
            this.point = point;
        }
    }
}

