/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.Node;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.NodeType;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.PrimitiveForView;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.Track;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;

public class NodePainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    private List<Track> tracks;

    public NodePainter() {
        this.setAntialiasing(true);
        this.setCacheable(false);
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    public void setTracks(List<Track> tracks) {
        this.tracks = tracks;
    }

    @Override
    public synchronized void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Track trackLast = null;
        if (this.getTracks() != null) {
            int j = 0;
            while (j < this.getTracks().size()) {
                Track t = this.getTracks().get(j);
                if (t.getMapValueWithTrack() != null && t.getMapValueWithTrack().getSelectTrack() != null && t.getId() == t.getMapValueWithTrack().getSelectTrack().longValue()) {
                    trackLast = t;
                } else if (!t.getNodes().isEmpty()) {
                    int s = t.getNodes().size();
                    int i = 0;
                    while (i < s - 1) {
                        this.paint(t.getNodes().get(i), t.getNodes().get(i + 1), map, g, vp2, vp3, false);
                        ++i;
                    }
                    this.paint(t.getNodes().get(s - 1), null, map, g, vp2, vp3, false);
                }
                ++j;
            }
        }
        if (trackLast != null && !trackLast.getNodes().isEmpty()) {
            int s = trackLast.getNodes().size();
            int i = 0;
            while (i < s - 1) {
                this.paint(trackLast.getNodes().get(i), trackLast.getNodes().get(i + 1), map, g, vp2, vp3, true);
                ++i;
            }
            this.paint(trackLast.getNodes().get(s - 1), null, map, g, vp2, vp3, true);
        }
    }

    protected void paint(Node from, Node to, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, boolean select) {
        PrimitiveForView view = from.Tuned(select);
        Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(from.getLat(), from.getLon()), map.getZoom());
        if (to != null) {
            Color w;
            Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(to.getLat(), to.getLon()), map.getZoom());
            if (vp2.contains(point) || vp2.contains(pointFrom)) {
                g.setStroke(view.getStroke());
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                w = new Color(view.getColorLine().getRed(), view.getColorLine().getGreen(), view.getColorLine().getBlue());
                g.setColor(w);
                g.drawLine((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()), (int)(pointFrom.getX() - vp2.getX()), (int)(pointFrom.getY() - vp2.getY()));
            }
            if (vp3.contains(point) || vp3.contains(pointFrom)) {
                g.setStroke(view.getStroke());
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                w = new Color(view.getColorLine().getRed(), view.getColorLine().getGreen(), view.getColorLine().getBlue());
                g.setColor(w);
                g.drawLine((int)(point.getX() - vp3.getX()), (int)(point.getY() - vp3.getY()), (int)(pointFrom.getX() - vp3.getX()), (int)(pointFrom.getY() - vp3.getY()));
            }
        }
        if (from.getType().equals((Object)NodeType.FLAG)) {
            g.setStroke(view.getStroke());
            int x = (int)(pointFrom.getX() - vp2.getX());
            int y = (int)(pointFrom.getY() - vp2.getY());
            g.translate(x, y);
            this.paintFlag(g, view, from);
            g.translate(-x, -y);
        } else if (view.isShowArrow()) {
            g.setStroke(view.getStroke());
            int x = (int)(pointFrom.getX() - vp2.getX());
            int y = (int)(pointFrom.getY() - vp2.getY());
            g.translate(x, y);
            this.paintS(g, view, from);
            g.translate(-x, -y);
        }
        if (view.isShowHint()) {
            g.setStroke(view.getStroke());
            if (vp2.contains(pointFrom)) {
                int x = (int)(pointFrom.getX() - vp2.getX());
                int y = (int)(pointFrom.getY() - vp2.getY());
                g.translate(x, y);
                this.paint(g, view, from);
                g.translate(-x, -y);
            }
            if (vp3.contains(pointFrom)) {
                int x = (int)(pointFrom.getX() - vp3.getX());
                int y = (int)(pointFrom.getY() - vp3.getY());
                g.translate(x, y);
                this.paint(g, view, from);
                g.translate(-x, -y);
            }
        }
    }

    protected void paintS(Graphics2D g, PrimitiveForView view, Node point) {
        String n = (String)point.getParameter("");
        if (point.getNorthAngle() == null || point.getNorthAngle() < 0.0) {
            if (point.getType().equals((Object)NodeType.SMALL)) {
                g.setColor(this.getColorPoint(view, point));
                g.fillOval(-1, -1, 1, 1);
            } else {
                g.setColor(this.getColorPoint(view, point));
                g.fillOval(-7, -7, 15, 15);
            }
        } else {
            g.rotate(Math.toRadians(point.getNorthAngle() + 180.0));
            Polygon p = new Polygon();
            p.addPoint(0, 15);
            p.addPoint(-5, 10);
            p.addPoint(-5, -5);
            p.addPoint(0, 0);
            p.addPoint(5, -5);
            p.addPoint(5, 10);
            g.setColor(view.getColorPixel());
            g.drawPolygon(p);
            g.setColor(this.getColorPoint(view, point));
            g.fillPolygon(p);
            g.rotate(-Math.toRadians(point.getNorthAngle() + 180.0));
            g.setColor(view.getColorPixel());
            if (n != null) {
                int c = n.length() * 7 / 2;
                g.drawString(n, -c, 3);
            }
        }
    }

    public void paintFlag(Graphics2D g, PrimitiveForView view, Node point) {
        Polygon p = new Polygon();
        p.addPoint(0, -15);
        p.addPoint(-15, -15);
        p.addPoint(-15, -25);
        p.addPoint(1, -25);
        p.addPoint(1, 0);
        g.setColor(view.getColorPixel());
        g.drawPolygon(p);
        g.setColor(this.getColorPoint(view, point));
        g.fillPolygon(p);
        g.setColor(view.getColorPixel());
    }

    protected Color getColorPoint(PrimitiveForView view, Node point) {
        return view.getColorLine();
    }

    protected Color getColorPointForHint(PrimitiveForView view, Node point) {
        Color w = new Color(view.getColorLine().getRed(), view.getColorLine().getGreen(), view.getColorLine().getBlue(), 80);
        return w;
    }

    private void paint(Graphics2D g, PrimitiveForView view, Node point) {
        String[] hint = (String[])point.getParameter("hint");
        FontMetrics f = g.getFontMetrics();
        int h = f.getHeight();
        g.setColor(this.getColorPointForHint(view, point));
        int l = hint.length;
        int w = 0;
        int i = 0;
        while (i < l) {
            int w1 = f.stringWidth(hint[i]);
            if (w1 > w) {
                w = w1;
            }
            ++i;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(-w + w / 2, -h * l - 20, w + 10, h * l + 3);
        Polygon p = new Polygon();
        p.addPoint((int)bounds.getMinX(), (int)bounds.getMinY());
        p.addPoint((int)bounds.getMinX(), (int)bounds.getMaxY());
        p.addPoint((int)(bounds.getMinX() + ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
        p.addPoint(0, 0);
        p.addPoint((int)(bounds.getMinX() + 2.0 * ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
        p.addPoint((int)bounds.getMaxX(), (int)bounds.getMaxY());
        p.addPoint((int)bounds.getMaxX(), (int)bounds.getMinY());
        g.fillPolygon(p);
        g.setColor(view.getColorPixel());
        g.drawPolygon(p);
        int i2 = 0;
        while (i2 < l) {
            g.drawString(hint[i2], (int)bounds.getMinX() + 5, (int)bounds.getMinY() + h + i2 * h);
            ++i2;
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.setTracks(((MapValueWithTrack)mapValueWithTrack).getTracks());
    }
}

