/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.ImageObserver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.Geometry;
import org.postgis.MultiPolygon;
import org.postgis.Polygon;
import ru.blok.vms.calltransport.ui.SoundItem;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.NodeType;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.Primitive;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.PrimitiveForView;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.datatrack.TrackNDData;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.NodePainterDataTraclAll;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RoutePainter;
import ru.blok.vms.ui.police.operationalinformation.Routes;
import ru.blok.vms.ui.tracks.trackinrealtimelite.busnew.TrackInRealTimeLiteBusNew;
import ru.blok.vms.ui.tracks.trackinrealtimelite.withuitransport.TrackInRealTimeLiteImageFromCrewWithAngle;
import ru.blok.vms.ui.tracks.tracksmp.MapPropertiesUItrackSMP;
import ru.infor.gpx.Trkpt;
import ru.infor.ws.objects.draw.entities.TrackLineUI;
import ru.infor.ws.objects.draw.entities.TrackUI;
import ru.infor.ws.objects.vms.NavigationPoint;
import ru.infor.ws.objects.vms.Transport2GPSPointUI;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.Route;
import ru.infor.ws.objects.vms.entities.Transport2GPSPoint;

public class NodePainterData<T extends JXMapViewer>
extends MapViewPainter<T> {
    MapValueWithTrack value;
    NodePainterDataTraclAll traclAll = new NodePainterDataTraclAll();
    public List<Trkpt> listTrkpts;
    public List<SoundItem> soundItems;
    protected static double accuracyOfPaint = 8.0;
    protected HashMap<TrackNDData, HashMap<Integer, java.awt.Polygon>> mapV = new HashMap();

    public NodePainterData() {
        this.setAntialiasing(true);
        this.setCacheable(false);
    }

    public List<TrackNDData> getTracks() {
        return this.value.getTracksNDData();
    }

    public Integer include(TrackNDData d, Point2D pClick) {
        HashMap<Integer, java.awt.Polygon> lp = this.mapV.get(d);
        if (lp != null) {
            for (Integer i : lp.keySet()) {
                java.awt.Polygon p = lp.get(i);
                if (p == null || !p.contains(pClick)) continue;
                return i;
            }
        }
        return null;
    }

    @Override
    public synchronized void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        TrackNDData trackLast = null;
        if (this.getTracks() != null) {
            int j = 0;
            while (j < this.getTracks().size()) {
                TrackNDData t = this.getTracks().get(j);
                if (t.isVisible()) {
                    if (t.getMapValueWithTrack() != null && t.getMapValueWithTrack().getSelectTrack() != null && t.getId() == t.getMapValueWithTrack().getSelectTrack().longValue()) {
                        trackLast = t;
                    } else {
                        this.paintTrack(t, map, g, vp2, vp3);
                    }
                }
                ++j;
            }
        }
        if (trackLast != null) {
            this.paintTrack(trackLast, map, g, vp2, vp3);
        }
    }

    protected void paintTrack(TrackNDData t, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        HashMap<Integer, java.awt.Polygon> lp = new HashMap<Integer, java.awt.Polygon>();
        if (!t.getNodes().isEmpty()) {
            int s = t.getNodes().size();
            PrimitiveForView view = t.TunedNode(t.getNodes().get(0), false, false);
            PrimitiveForView viewSelP = t.TunedNode(t.getNodes().get(0), true, true);
            Integer[] sel = t.getSelectedPath();
            int selb = -1;
            int sele = -1;
            ArrayList<Integer> selPoint = new ArrayList<Integer>();
            if (sel != null) {
                selb = sel[0];
                sele = sel[1];
            }
            if (t.getSelectedPoint() != null) {
                Integer[] integerArray = t.getSelectedPoint();
                int n = integerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer i = integerArray[n2];
                    selPoint.add(i);
                    ++n2;
                }
            }
            int from = 0;
            Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(t.getNodes().get(from).getLat().doubleValue(), t.getNodes().get(from).getLon().doubleValue()), map.getZoom());
            if (selPoint.contains(from) && t.getId() > 0L) {
                this.paintPoint(t.getNodes().get(from), map, g, vp2, vp3, t, viewSelP);
            }
            if (s > 1) {
                TrackUI trUI = new TrackUI();
                trUI.setShowLine(Integer.valueOf(1));
                trUI.setShowPoint(Integer.valueOf(0));
                TrackLineUI lUI = new TrackLineUI();
                lUI.setColorLine(Integer.valueOf(view.getColorLine().getRGB()));
                lUI.setWidth(Float.valueOf(2.0f));
                lUI.setOpaque(Integer.valueOf(255));
                trUI.setLineUI(lUI);
                this.traclAll.paintpath(t, g, vp2, vp3, from, s, (JXMapViewer)map, pointFrom, selb, sele, (List<Integer>)selPoint, lp, trUI);
            }
            from = s - 1;
            Route r = t.getRoute();
            if (r != null && r.getAreaRouteGeom() != null) {
                try {
                    this.paintRoute(r, map, g, vp2, t, viewSelP);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            Object pp = t.getGPSPoint();
            if (from >= selb && from <= sele) {
                view = t.TunedNode(t.getNodes().get(from), true, true);
                this.paintPoint(t.getNodes().get(from), map, g, vp2, vp3, t, view);
                if (pp != null) {
                    this.paintGP(pp, map, g, vp2, vp3, t, view);
                }
            } else {
                view = t.TunedNode(t.getNodes().get(from), true, false);
                if (t.getId() > 0L) {
                    this.paintPoint(t.getNodes().get(from), map, g, vp2, vp3, t, view);
                }
                if (pp != null) {
                    this.paintGP(pp, map, g, vp2, vp3, t, view);
                }
            }
            g.setStroke(Primitive.defaultStroke);
            if (t.getCurrent() != null && t.getNodes().size() > t.getCurrent()) {
                this.paintFlag(t.getNodes().get(t.getCurrent()), map, g, vp2, vp3);
            }
        }
        this.mapV.put(t, lp);
    }

    public static java.awt.Polygon getPolygonGP() {
        java.awt.Polygon p = new java.awt.Polygon();
        p.addPoint(17, -15);
        p.addPoint(0, 15);
        p.addPoint(-17, -15);
        return p;
    }

    public static Object[] getPolygonGPHint(String[] hint, FontMetrics f) {
        int h = f.getHeight();
        int l = hint.length;
        int w = 0;
        int i = 0;
        while (i < l) {
            int w1 = f.stringWidth(hint[i]);
            if (w1 > w) {
                w = w1;
            }
            ++i;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(-w + w / 2, -h * l - 20, w + 10, h * l + 3);
        java.awt.Polygon p = new java.awt.Polygon();
        p.addPoint((int)bounds.getMinX(), (int)bounds.getMinY());
        p.addPoint((int)bounds.getMinX() - w / 12, (int)(bounds.getMinY() + bounds.getMaxY()) / 2);
        p.addPoint((int)bounds.getMinX(), (int)bounds.getMaxY());
        p.addPoint((int)(bounds.getMinX() + ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
        p.addPoint(0, 0);
        p.addPoint((int)(bounds.getMinX() + 2.0 * ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
        p.addPoint((int)bounds.getMaxX(), (int)bounds.getMaxY());
        p.addPoint((int)bounds.getMaxX() + w / 12, (int)(bounds.getMinY() + bounds.getMaxY()) / 2);
        p.addPoint((int)bounds.getMaxX(), (int)bounds.getMinY());
        return new Object[]{p, bounds, l, h};
    }

    protected void paintRoute(Route r, T map, Graphics2D g, Rectangle2D vp2, TrackNDData t, PrimitiveForView view) throws SQLException {
        if (r != null && r.getAreaRouteGeom() != null) {
            Object currentPolygon = null;
            currentPolygon = r.getAreaRouteGeom().contains("MULTIPOLYGON") ? new MultiPolygon(r.getAreaRouteGeom()) : new Polygon(r.getAreaRouteGeom());
            RoutePainter.paintPolygon((Geometry)currentPolygon, map, g, vp2, Color.RED, 150);
        }
    }

    protected void paintGP(Object pointGP, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, TrackNDData t, PrimitiveForView view) {
        if (pointGP != null && (pointGP instanceof Transport2GPSPoint && ((Transport2GPSPoint)pointGP).getLat() != null || pointGP instanceof Transport2GPSPointUI && ((Transport2GPSPointUI)pointGP).getLat() != null)) {
            Point2D point = null;
            point = pointGP instanceof Transport2GPSPoint ? map.getTileFactory().geoToPixel(new GeoPosition(((Transport2GPSPoint)pointGP).getLat().doubleValue(), ((Transport2GPSPoint)pointGP).getLon().doubleValue()), map.getZoom()) : map.getTileFactory().geoToPixel(new GeoPosition(((Transport2GPSPointUI)pointGP).getLat().doubleValue(), ((Transport2GPSPointUI)pointGP).getLon().doubleValue()), map.getZoom());
            int x = (int)(point.getX() - vp2.getX());
            int y = (int)(point.getY() - vp2.getY());
            g.translate(x, y);
            java.awt.Polygon p = NodePainterData.getPolygonGP();
            if (t.isSelect()) {
                g.setColor(Color.WHITE);
                g.fillPolygon(p);
                g.setColor((Color)t.getParameter("Color"));
                g.setStroke(Primitive.defaultStrokeSelected2);
                g.drawPolygon(p);
            } else {
                Color c = Color.WHITE;
                Color w = new Color(c.getRed(), c.getGreen(), c.getBlue(), 80);
                g.setColor(w);
                g.fillPolygon(p);
                g.setColor((Color)t.getParameter("Color"));
                g.setStroke(Primitive.defaultStroke);
                g.drawPolygon(p);
            }
            g.translate(-x, -y);
            AbstractNDData from = t.getNodes().get(t.getNodes().size() - 1);
            GeoPosition f = new GeoPosition(from.getLat().doubleValue(), from.getLon().doubleValue());
            GeoPosition to = pointGP instanceof Transport2GPSPoint ? new GeoPosition(((Transport2GPSPoint)pointGP).getLat().doubleValue(), ((Transport2GPSPoint)pointGP).getLon().doubleValue()) : new GeoPosition(((Transport2GPSPointUI)pointGP).getLat().doubleValue(), ((Transport2GPSPointUI)pointGP).getLon().doubleValue());
            NavigationPoint[] pp = Routes.caclPath(f, to);
            if (pp == null || pp.length == 0) {
                Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(from.getLat().doubleValue(), from.getLon().doubleValue()), map.getZoom());
                int xf = (int)(pointFrom.getX() - vp2.getX());
                int yf = (int)(pointFrom.getY() - vp2.getY());
                g.setStroke(Primitive.defaultStrokeP);
                g.drawLine(x, y, xf, yf);
                Double angle = this.getAngle(pointFrom, point);
                g.translate(x, y);
                g.rotate(angle);
                java.awt.Polygon p1 = new java.awt.Polygon();
                p1.addPoint(0, 0);
                p1.addPoint(7, 15);
                p1.addPoint(0, 8);
                p1.addPoint(-7, 15);
                p1.addPoint(0, 0);
                g.fillPolygon(p1);
                g.rotate(-angle.doubleValue());
                this.paintHintGP(g, view, t);
                g.translate(-x, -y);
            } else {
                int[] xPoints = new int[pp.length];
                int[] yPoints = new int[pp.length];
                int i = 0;
                while (i < pp.length) {
                    GeoPosition pt = new GeoPosition(pp[i].getLat().doubleValue(), pp[i].getLon().doubleValue());
                    Point2D p2 = map.getTileFactory().geoToPixel(pt, map.getZoom());
                    int xf = (int)(p2.getX() - vp2.getX());
                    int yf = (int)(p2.getY() - vp2.getY());
                    xPoints[i] = xf;
                    yPoints[i] = yf;
                    ++i;
                }
                g.drawPolyline(xPoints, yPoints, pp.length);
                g.translate(x, y);
                this.paintHintGP(g, view, t);
                g.translate(-x, -y);
            }
        }
    }

    private void paintHintGP(Graphics2D g, PrimitiveForView view, TrackNDData t) {
        String[] hint = (String[])t.getParameter("hintGP");
        Object[] o = NodePainterData.getPolygonGPHint(hint, g.getFontMetrics());
        g.setColor(this.getColorPointForHint(view, null, null));
        g.setColor(this.getColorPointForHint(view, null, null));
        java.awt.Polygon p = (java.awt.Polygon)o[0];
        g.fillPolygon(p);
        Rectangle2D bounds = (Rectangle2D)o[1];
        int l = (Integer)o[2];
        int h = (Integer)o[3];
        Stroke s = g.getStroke();
        if (view.isSelect()) {
            g.setStroke(new BasicStroke(2.0f));
        }
        g.setColor(view.getColorPixel());
        g.drawPolygon(p);
        g.setStroke(s);
        int i = 0;
        while (i < l) {
            g.drawString(hint[i], (int)bounds.getMinX() + 5, (int)bounds.getMinY() + h + i * h);
            ++i;
        }
    }

    private Double getAngle(Point2D pointFrom, Point2D point) {
        Double angle = null;
        Double len = Math.sqrt((point.getY() - pointFrom.getY()) * (point.getY() - pointFrom.getY()) + (point.getX() - pointFrom.getX()) * (point.getX() - pointFrom.getX()));
        if (len > 1.0E-10) {
            angle = Math.asin((point.getY() - pointFrom.getY()) / len);
            angle = 1.5707963267948966 - angle;
            angle = point.getX() - pointFrom.getX() > 0.0 ? Double.valueOf(Math.PI - angle) : Double.valueOf(angle + Math.PI);
        }
        return angle;
    }

    protected void paintPoint(AbstractNDData from, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, TrackNDData t, PrimitiveForView view) {
        int y;
        int x;
        Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(from.getLat().doubleValue(), from.getLon().doubleValue()), map.getZoom());
        if (view.isShowArrow()) {
            x = (int)(pointFrom.getX() - vp2.getX());
            y = (int)(pointFrom.getY() - vp2.getY());
            g.translate(x, y);
            this.paintS(g, view, from, t, map);
            g.translate(-x, -y);
        }
        if (view.isShowHint()) {
            x = (int)(pointFrom.getX() - vp2.getX());
            y = (int)(pointFrom.getY() - vp2.getY());
            g.translate(x, y);
            this.paint(g, view, from, t);
            g.translate(-x, -y);
        }
    }

    protected void paintS(Graphics2D g, PrimitiveForView view, AbstractNDData point, TrackNDData t, T map) {
        String n = t.getLabel();
        Double northAngleLast = (Double)t.getParameter("northAngleLast");
        Image img1 = (Image)t.getParameter("image");
        boolean ss = false;
        if (t.getParameter("ShowStatus") != null) {
            ss = (Boolean)t.getParameter("ShowStatus");
        }
        g.setStroke(Primitive.defaultStroke);
        if (northAngleLast == null || northAngleLast < 0.0) {
            if (img1 != null) {
                int imwidth = img1.getWidth(null);
                int imheight = img1.getHeight(null);
                g.drawImage(img1, 0 - imwidth / 2, 0 - imheight / 2, (ImageObserver)map);
                if (ss) {
                    g.setColor(this.getColorPoint(view, point));
                    g.fillRect(0 - imwidth / 2, 0 + imheight / 2 + 2, imwidth, 4);
                }
            } else {
                if (NodeType.SMALL.equals(t.getParameter("typeNode"))) {
                    g.setColor(this.getColorPoint(view, point));
                    g.fillOval(-1, -1, 1, 1);
                    if (t.isSelect()) {
                        g.setColor(this.getColorPoint(view, point).brighter().brighter());
                        g.drawOval(-1, -1, 1, 1);
                    }
                } else if (NodeType.STATE.equals((Object)view.getType())) {
                    Color col = this.getColorPoint(view, point, t);
                    g.setColor(Color.WHITE);
                    int s = 9;
                    g.fillOval(-s, -s, s * 2, s * 2);
                    g.setColor(col);
                    g.drawOval(-s, -s, s * 2, s * 2);
                    g.drawLine(-s / 3, -s + s / 3, -s / 3, s - s / 3);
                    int s2 = 6;
                    g.drawArc(-s / 3 - s2, -s + s / 3, s2 * 2, s2, -90, 180);
                } else if (NodeType.BIG.equals((Object)view.getType())) {
                    g.setColor(this.getColorPoint(view, point));
                    g.fillOval(-9, -9, 18, 18);
                    if (t.isSelect()) {
                        g.setColor(this.getColorPoint(view, point).darker().darker());
                        g.drawOval(-9, -9, 18, 18);
                    }
                } else {
                    g.setColor(this.getColorPoint(view, point));
                    g.fillOval(-7, -7, 15, 15);
                    if (t.isSelect()) {
                        g.setColor(this.getColorPoint(view, point).darker().darker());
                        g.drawOval(-7, -7, 15, 15);
                    }
                }
                if (ss) {
                    g.setColor(this.getColorPoint(view, point));
                    g.fillRect(-10, 12, 20, 4);
                }
            }
        } else {
            int k = 180;
            if (img1 != null) {
                k = 0;
            }
            g.rotate(Math.toRadians(northAngleLast + (double)k));
            if (img1 != null) {
                int imwidth = img1.getWidth(null);
                int imheight = img1.getHeight(null);
                g.drawImage(img1, 0 - imwidth / 2, 0 - imheight / 2, (ImageObserver)map);
            } else {
                java.awt.Polygon p = new java.awt.Polygon();
                Color c = this.getColorPoint(view, point, t);
                if (NodeType.STATE.equals((Object)view.getType())) {
                    p.addPoint(0, 15);
                    p.addPoint(-7, -5);
                    p.addPoint(0, 0);
                    p.addPoint(7, -5);
                    g.setColor(c);
                    g.fillPolygon(p);
                    g.setColor(c.darker());
                    java.awt.Polygon pp = new java.awt.Polygon();
                    pp.addPoint(7, -5);
                    pp.addPoint(0, 0);
                    pp.addPoint(0, 10);
                    g.fillPolygon(pp);
                } else {
                    p.addPoint(0, 15);
                    p.addPoint(-5, 10);
                    p.addPoint(-5, -5);
                    p.addPoint(0, 0);
                    p.addPoint(5, -5);
                    p.addPoint(5, 10);
                    g.setColor(c);
                    g.fillPolygon(p);
                }
                g.setColor(c);
                if (t.isSelect()) {
                    g.setColor(c.darker().darker());
                }
                g.drawPolygon(p);
            }
            g.rotate(-Math.toRadians(northAngleLast + (double)k));
            if (ss) {
                if (img1 == null) {
                    g.setColor(this.getColorPoint(view, point));
                    g.fillRect(-10, 12, 20, 4);
                } else {
                    g.setColor(this.getColorPoint(view, point));
                    int imwidth = img1.getWidth(null);
                    int imheight = img1.getHeight(null);
                    g.fillRect(0 - imwidth / 2, 0 + imheight / 2 + 2, imwidth, 4);
                }
            }
        }
        g.setColor(view.getColorPixel());
        if (n != null) {
            int w = g.getFontMetrics().stringWidth(n);
            int h = g.getFontMetrics().getHeight();
            g.drawString(n, -w + w / 5, -h + h / 5);
        }
    }

    public void paintFlag(AbstractNDData current, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(current.getLat().doubleValue(), current.getLon().doubleValue()), map.getZoom());
        int x = (int)(pointFrom.getX() - vp2.getX());
        int y = (int)(pointFrom.getY() - vp2.getY());
        g.translate(x, y);
        this.paintFlag(g);
        g.translate(-x, -y);
    }

    public void paintFlag(Graphics2D g) {
        java.awt.Polygon p = new java.awt.Polygon();
        p.addPoint(0, 0);
        p.addPoint(0, -25);
        p.addPoint(10, -20);
        p.addPoint(0, -15);
        g.setColor(Color.BLUE);
        g.drawPolygon(p);
        g.fillPolygon(p);
    }

    protected Color getColorPoint(PrimitiveForView view, AbstractNDData point) {
        return view.getColorLine();
    }

    protected Color getColorPoint(PrimitiveForView view, AbstractNDData point, TrackNDData t) {
        if (NodeType.STATE.equals((Object)view.getType())) {
            boolean fromRoute = false;
            Object o = this.value.getTrackInRealTime2();
            if (o != null && o instanceof TrackInRealTimeLiteBusNew) {
                fromRoute = ((TrackInRealTimeLiteBusNew)o).isColorFromRoute();
            }
            if (fromRoute) {
                Route r = t.getRouteColor();
                if (r != null && r.getColor() != null) {
                    return new Color(r.getColor());
                }
                Object o1 = this.value.mapViewerWithTrack.getUIProperties();
                if (o1 instanceof MapPropertiesUItrackSMP) {
                    Color c = new Color(((MapPropertiesUItrackSMP)o1).getColorRoute());
                    return c;
                }
                return Color.RED;
            }
            Long diff = new Date().getTime() - point.getCreatedDateTime().getTime();
            Long green = (Long)t.getParameter("TimeGreen");
            if (diff < green) {
                return Color.GREEN;
            }
            Long yellow = (Long)t.getParameter("TimeYellow");
            if (diff < yellow) {
                return Color.YELLOW;
            }
            return Color.red;
        }
        return view.getColorLine();
    }

    protected Color getColorPointForHint(PrimitiveForView view, AbstractNDData point, MapValueWithTrack v) {
        if (v != null && v.getTrackInRealTime2() != null && v.getTrackInRealTime2() instanceof TrackInRealTimeLiteImageFromCrewWithAngle) {
            return Color.WHITE;
        }
        if (view.isSelect()) {
            Color w = view.getColorLine().brighter().brighter();
            return w;
        }
        Color w = new Color(view.getColorLine().getRed(), view.getColorLine().getGreen(), view.getColorLine().getBlue(), 80);
        return w;
    }

    public static Object[] getPolygonForHint(String[] hint, FontMetrics f) {
        int h = f.getHeight();
        int l = hint.length;
        if (l > 0) {
            int w = 0;
            int i = 0;
            while (i < l) {
                int w1 = f.stringWidth(hint[i]);
                if (w1 > w) {
                    w = w1;
                }
                ++i;
            }
            Rectangle2D.Double bounds = new Rectangle2D.Double(-w + w / 2, -h * l - 20, w + 10, h * l + 3);
            java.awt.Polygon p = new java.awt.Polygon();
            p.addPoint((int)bounds.getMinX(), (int)bounds.getMinY());
            p.addPoint((int)bounds.getMinX(), (int)bounds.getMaxY());
            p.addPoint((int)(bounds.getMinX() + ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
            p.addPoint(0, 0);
            p.addPoint((int)(bounds.getMinX() + 2.0 * ((RectangularShape)bounds).getWidth() / 3.0), (int)bounds.getMaxY());
            p.addPoint((int)bounds.getMaxX(), (int)bounds.getMaxY());
            p.addPoint((int)bounds.getMaxX(), (int)bounds.getMinY());
            return new Object[]{p, bounds};
        }
        return null;
    }

    private void paint(Graphics2D g, PrimitiveForView view, AbstractNDData point, TrackNDData t) {
        String[] hint = (String[])t.getParameter("hint");
        g.setColor(this.getColorPointForHint(view, point, t.getMapValueWithTrack()));
        FontMetrics f = g.getFontMetrics();
        Object[] pp = NodePainterData.getPolygonForHint(hint, f);
        int h = f.getHeight();
        int l = hint.length;
        if (pp != null) {
            java.awt.Polygon p = (java.awt.Polygon)pp[0];
            Rectangle2D bounds = (Rectangle2D)pp[1];
            g.fillPolygon(p);
            Stroke s = g.getStroke();
            if (view.isSelect()) {
                g.setStroke(new BasicStroke(2.0f));
            }
            g.setColor(view.getColorPixel());
            g.drawPolygon(p);
            g.setStroke(s);
            int i = 0;
            while (i < l) {
                g.drawString(hint[i], (int)bounds.getMinX() + 5, (int)bounds.getMinY() + h + i * h);
                ++i;
            }
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.value = (MapValueWithTrack)mapValueWithTrack;
    }
}

