/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.MapValueWithTrack;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.RoutePainter;
import ru.blok.vms.ui.tracks.TrackAllTs;

public class NodePainterDataTAll<T extends JXMapViewer>
extends MapViewPainter<T> {
    MapValueWithTrack value;
    GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
    public static Stroke defaultStroke = new BasicStroke(2.0f, 1, 1);
    public static Stroke defaultStrokeSelect = new BasicStroke(6.0f, 1, 1);
    protected HashMap<TrackAllTs.Data, Polygon> mapV = new HashMap();

    @Override
    public synchronized void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        TrackAllTs t = (TrackAllTs)((Object)this.value.getTrackInRealTime2());
        this.mapV.clear();
        TrackAllTs.Data sel = null;
        for (TrackAllTs.Data d : t.getListData()) {
            if (d.equals(t.getSelected())) {
                sel = d;
                continue;
            }
            this.paint(d, map, g, vp2, vp3, false);
        }
        if (sel != null) {
            this.paint(sel, map, g, vp2, vp3, true);
        }
    }

    protected void paint(TrackAllTs.Data d, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, boolean select) {
        if (d.getGeom() != null) {
            Geometry simplifyedGeometry = DouglasPeuckerSimplifier.simplify((Geometry)d.getGeom(), (double)RoutePainter.getScale(map, vp2));
            int i = 0;
            while (i < simplifyedGeometry.getNumGeometries()) {
                Geometry gg = simplifyedGeometry.getGeometryN(i);
                int l = gg.getCoordinates().length;
                Coordinate[] coord = new Coordinate[l];
                int[] x = new int[l];
                int[] y = new int[l];
                int j = 0;
                while (j < l) {
                    Point2D cp = map.getTileFactory().geoToPixel(new GeoPosition(gg.getCoordinates()[j].y, gg.getCoordinates()[j].x), map.getZoom());
                    x[j] = (int)(cp.getX() - vp2.getX());
                    y[j] = (int)(cp.getY() - vp2.getY());
                    coord[j] = new Coordinate((double)x[j], (double)y[j]);
                    ++j;
                }
                g.setColor(d.getColor());
                g.setStroke(select ? defaultStrokeSelect : defaultStroke);
                g.drawPolyline(x, y, l);
                this.initPol(coord, d);
                ++i;
            }
        }
    }

    private void initPol(final Coordinate[] coord, final TrackAllTs.Data d) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LineString ll = NodePainterDataTAll.this.geometryFactory.createLineString(coord);
                Geometry g = ll.buffer(3.0);
                if (g.getNumGeometries() > 0) {
                    Geometry gg = g.getGeometryN(0);
                    int l = gg.getCoordinates().length;
                    int[] x = new int[l];
                    int[] y = new int[l];
                    int j = 0;
                    while (j < l) {
                        x[j] = (int)gg.getCoordinates()[j].x;
                        y[j] = (int)gg.getCoordinates()[j].y;
                        ++j;
                    }
                    Polygon p = new Polygon(x, y, l);
                    NodePainterDataTAll.this.mapV.put(d, p);
                }
            }
        }).start();
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.value = (MapValueWithTrack)mapValueWithTrack;
    }

    public boolean include(TrackAllTs.Data d, Point2D pClick) {
        Polygon p = this.mapV.get(d);
        if (p != null) {
            return p.contains(pClick);
        }
        return false;
    }
}

